<?php
class dcm_google extends dcm_abstract {
    public function __construct() {
        parent::__construct();
        $this->load->model ( 'images_core' );
        $this->load->model ( 'mlanguages' );
    }

    function get_google_categories_ids(){
       return  $this->db->select('id as category_id')->get('categories')->result_array();
    }

    function get_cetegories_data($property_id){
        $return_data = array();
        $global_lang = $this->hotelix_config->get_record("global_language", "int");
        $external_category_image = $this->images_core->get_external_category_image_value();
        $language_data = $this->mlanguages->get_language_data();

        if($external_category_image){
            $tbl_category_images_name = "category_images_registry";
        }else{
            $tbl_category_images_name = "categories_images";
        }



        $sql = "SELECT categories.id as category_id, categories.name as category_name, categories.shortname as category_shortname,
        categories.add_places, internationalfields.name as intern_type, categories.comment as category_comment,
        internationalfields.language_id as intern_lang_code, internationalfields.value as intern_value,
        $tbl_category_images_name.id_position as foto_id_position, descriptionlanguages.is_active as lang_active,
        fototags.name as foto_tag_name, fototags.id as foto_tag_id
        FROM categories
        LEFT JOIN internationalfields ON internationalfields.table_id = categories.id AND internationalfields.table_type = 'category'
        LEFT JOIN descriptionlanguages ON descriptionlanguages.code = internationalfields.language_id
        LEFT JOIN $tbl_category_images_name ON $tbl_category_images_name.category_id = categories.id
        LEFT JOIN category_fototags ON category_fototags.category_id = categories.id
        AND category_fototags.foto_id = $tbl_category_images_name.id
        LEFT JOIN fototags ON fototags.id = category_fototags.tag_id
        WHERE categories.web_booking = 1 AND categories.property_id = $property_id";
        //echo $sql;
        //die();
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $return_data[$row->category_id]['category_id'] = $row->category_id;
                //$return_data[$row->category_id]['foto_id_position'] = $row->foto_id_position;
                $return_data[$row->category_id]['max_number_of_occupants'] = $row->add_places;
                $return_data[$row->category_id]['photos'][$row->foto_id_position]['photo_location'] = "";
                if($row->foto_tag_id != NULL){
                    $return_data[$row->category_id]['photos'][$row->foto_id_position]['photo_captions'][$row->foto_tag_id]['text'] = htmlspecialchars($row->foto_tag_name);
                    $return_data[$row->category_id]['photos'][$row->foto_id_position]['photo_captions'][$row->foto_tag_id]['language'] = 'en';
                }
//                 if ($row->foto_tag_name != "") {
//                     if (isset($return_data[$row->category_id]['photos'][$row->foto_id_position]['text'])) {
//                         $return_data[$row->category_id]['photos'][$row->foto_id_position]['text'] .= htmlspecialchars($row->foto_tag_name) . ", ";
//                     } else {
//                         $return_data[$row->category_id]['photos'][$row->foto_id_position]['text'] = htmlspecialchars($row->foto_tag_name);
//                     }
//                 }
                //$return_data[$row->category_id]['photos'][$row->foto_id_position]['text'] = htmlspecialchars($row->foto_tag_name);
                $return_data[$row->category_id]['photos'][$row->foto_id_position]['language'] = 'en';
                
                if ($row->lang_active == 1) {
                    switch ($row->intern_type) {
                        case 'international_name':
                            if ($row->intern_value != "") {
                                $return_data[$row->category_id]['room_names'][$row->intern_lang_code]['room_name'] = htmlspecialchars($row->intern_value);
                                $return_data[$row->category_id]['room_names'][$row->intern_lang_code]['language_code'] = $language_data[$row->intern_lang_code]['lang_short_name'];
                            } else {
                                $return_data[$row->category_id]['room_names'][$global_lang]['room_name'] = htmlspecialchars($row->category_name);
                                $return_data[$row->category_id]['room_names'][$global_lang]['language_code'] = $language_data[$global_lang]['lang_short_name'];
                            }
                            break;
                        case 'international_comment':
                            if ($row->intern_value != "") {
                                $return_data[$row->category_id]['room_descriptions'][$row->intern_lang_code]['text'] = htmlspecialchars($row->intern_value);
                                $return_data[$row->category_id]['room_descriptions'][$row->intern_lang_code]['language_code'] = $language_data[$row->intern_lang_code]['lang_short_name'];
                            } else {
                                $return_data[$row->category_id]['room_descriptions'][$global_lang]['text'] = htmlspecialchars($row->category_comment);
                                $return_data[$row->category_id]['room_descriptions'][$global_lang]['language_code'] = $language_data[$global_lang]['lang_short_name'];
                            }
                            break;
                    }
                }
            }

            //echo "<pre>";
            //print_r($return_data);
            //die();

            foreach ($return_data as $category_id => $cell) {
                foreach ($cell['photos'] as $foto_id_position => $cell2) {
                    $foto_data = array();
                    $foto_data['category_id'] = $category_id;
                    $foto_data['id_position'] = $foto_id_position;
                    $foto_url = $this->images_core->get_category_img_url($foto_data);

                    $return_data[$category_id]['photos'][$foto_id_position]['photo_location'] = $foto_url;
                    
                    if (isset($return_data[$category_id]['photos'][$foto_id_position]['photo_captions'])) {
                        foreach ($return_data[$category_id]['photos'][$foto_id_position]['photo_captions'] as $tag_id => $tag_cell) {
                            if (isset($return_data[$category_id]['photos'][$foto_id_position]['tags_names'])) {
                                $return_data[$category_id]['photos'][$foto_id_position]['tags_names'] .= $tag_cell['text'] . ", ";
                            } else {
                                $return_data[$category_id]['photos'][$foto_id_position]['tags_names'] = $tag_cell['text'] . ", ";
                            }
                        }
                        
                         $return_data[$category_id]['photos'][$foto_id_position]['tags_names'] = substr($return_data[$category_id]['photos'][$foto_id_position]['tags_names'], 0, -2);
                    }else{
                        $return_data[$category_id]['photos'][$foto_id_position]['tags_names'] = "";
                    }
                }
                // $return_data[$category_id]['photo_captions'] = $foto_tags;
            }
            
            //echo "<pre>";
            //print_r($return_data);
            //die();
        }
        return $return_data;

    }

    function get_rates_data($property_id){
        $return_data = array();
        $global_lang = $this->hotelix_config->get_record("global_language", "int");
        $language_data = $this->mlanguages->get_language_data();
        //$google_categories = $this->get_google_categories_ids();
        $property_check_in_time = $this->db->select('check_in_time')->get_where('property_information', array('id'=>$property_id))->row()->check_in_time;

        $sql = "SELECT rate.id as rate_id, categories.id as category_id, ratetocategory.onlinebook, rate.caption as rate_name,
        internationalfields.name as intern_type,
        internationalfields.language_id as intern_lang_code, internationalfields.value as intern_value,
        descriptionlanguages.is_active as lang_active,
        cp.penalty_ar, cp.deadline_days, rate.meal_policy_id
        FROM rate
        INNER JOIN onlinerates ON rate.id = onlinerates.rateid
        LEFT JOIN ratetocategory ON ratetocategory.rate_id = rate.id 
        LEFT JOIN categories ON categories.id = ratetocategory.category_id AND categories.web_booking = 1 AND categories.is_active = 1
        LEFT JOIN internationalfields ON internationalfields.table_id = rate.id AND internationalfields.table_type = 'rate'
        LEFT JOIN descriptionlanguages ON descriptionlanguages.code = internationalfields.language_id
        LEFT JOIN global_hotelix_common.dc_cancelationpolicy_list as cp ON
        cp.id = rate.cancellation_policy_id";
        //         echo $sql;
        //         die();
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $return_data[$row->rate_id]['rate_id'] = $row->rate_id;
                $meal_policy_id = (int)$row->meal_policy_id;
                $return_data[$row->rate_id]['breakfast_included'] = 0;
                if($meal_policy_id != 1 && $meal_policy_id != 0){
                    $return_data[$row->rate_id]['breakfast_included'] = 1;
                }
                $return_data[$row->rate_id]['internet_included'] = 1;
                $return_data[$row->rate_id]['parking_included'] = 1;

                if($row->penalty_ar == 0){
                    $return_data[$row->rate_id]['refund_available'] = 1;
                    $return_data[$row->rate_id]['refund_data'] = ' refundable_until_days="'.$row->deadline_days.'" refundable_until_time="'.$property_check_in_time.':00"';
                }else{
                    $return_data[$row->rate_id]['refund_available'] = 0;
                    $return_data[$row->rate_id]['refund_data'] = '';
                }

                if($row->onlinebook == 1){
                    if($row->category_id > 0){
                        $return_data[$row->rate_id]['allowable_room_ids'][$row->category_id]['room_id'] = $row->category_id;
                    }
                }
                
//                 foreach($google_categories as $cell){
//                     if($row->onlinebook == 1){
//                         $return_data[$row->rate_id]['allowable_room_ids'][$cell['category_id']]['room_id'] = $cell['category_id'];
//                     }
//                 }

                if ($row->lang_active == 1) {
                    switch ($row->intern_type) {
                        case 'international_name':
                            if ($row->intern_value != "") {
                                $return_data[$row->rate_id]['package_names'][$row->intern_lang_code]['rate_name'] = htmlspecialchars($row->intern_value);
                                $return_data[$row->rate_id]['package_names'][$row->intern_lang_code]['language_code'] = $language_data[$row->intern_lang_code]['lang_short_name'];
                            } else {
                                $return_data[$row->rate_id]['package_names'][$global_lang]['rate_name'] = htmlspecialchars($row->rate_name);
                                $return_data[$row->rate_id]['package_names'][$global_lang]['language_code'] = $language_data[$global_lang]['lang_short_name'];
                            }
                            break;
                        case 'international_description':
                            if ($row->intern_value != "") {
                                $return_data[$row->rate_id]['package_descriptions'][$row->intern_lang_code]['text'] = htmlspecialchars($row->intern_value);
                                $return_data[$row->rate_id]['package_descriptions'][$row->intern_lang_code]['language_code'] = $language_data[$row->intern_lang_code]['lang_short_name'];
                            } else {
                                $return_data[$row->rate_id]['package_descriptions'][$global_lang]['text'] = "";
                                $return_data[$row->rate_id]['package_descriptions'][$global_lang]['language_code'] = $language_data[$global_lang]['lang_short_name'];
                            }
                            break;
                    }
                }
            }
        }
//         echo "<pre>";
//         print_r($return_data);
//         die();
        return $return_data;
    }

    function get_transaction_data(){
        $hms_id = $this->config->item('hotel_id');

        $data = array();
        $data['timestamp'] = date('c');
        $data['message_id'] = md5(strtotime('now'));
        $data['partner_account_name'] = 'otelms_ari';
        $data['property_action'] = 'overlay';

        $active_properties = $this->db->select('prop_id')->get_where('global_hotelix.dc_ggl_hotels', array('active' => 1, 'hms_id' => $hms_id))->result_array();
        $prop_count = count($active_properties);
        $c_i = 1;
        $active_properties_str = " WHERE id IN ( ";
        foreach ($active_properties as $prop_cell) {
            if ($prop_count == $c_i) {
                $active_properties_str .= $prop_cell['prop_id'] . " )";
            } else {
                $active_properties_str .= $prop_cell['prop_id'] . ",";
            }
            $c_i ++;
        }

        $property_ids = $this->db->query("SELECT id FROM property_information $active_properties_str ORDER BY id ASC")->result_array();
//         echo "<pre>";
//         print_r($property_ids);
//         die();
        $property_data = array();
        foreach($property_ids as $cell){
            $property_id = $cell['id'];
            $property_categories_data = $this->get_cetegories_data($property_id);
            if (count($property_categories_data) > 0) {
                $property_data[$property_id]['room_data'] = $this->get_cetegories_data($property_id);
                $property_data[$property_id]['hotel_id'] = $this->config->item('hotel_id') . "_" . $property_id;
                $property_data[$property_id]['package_data'] = $this->get_rates_data($property_id);
            }
        }
        $data['property_data'] = $property_data;

        //echo "<pre>";
        //print_r($data);
        //die();
        return $data;
    }

    function save_sync_log($data){
        $this->db->insert('dc_google_sync_log', $data);
    }

    public function update_activity_hotels_feed($activity = 0) {

        $prop_id = $this->db->select('id')->get('property_information')->row();//get smollest prop id
        if ($prop_id){
            $prop_id = $prop_id->id;
            $feed_tbl = "`global_hotelix`.`dc_ggl_hotels`";
            $hms_id = $this->config->item('hotel_id');
            $where_arr = array('hms_id' => $hms_id);
            $ins_or_upd_arr = $this->get_prop_data_for_feed(array('hotel_id' => $hms_id, 'prop_id' => $prop_id));
            $ins_or_upd_arr['active'] = $activity;

            $hotel_prop_exist_in_tbl = $this->db->select('prop_id')->get_where($feed_tbl, $where_arr)->row();

            if ($hotel_prop_exist_in_tbl) {
                if ($activity == 1){
                    $where_arr['prop_id'] = $prop_id;
                }else {
                    $ins_or_upd_arr = array();
                    $ins_or_upd_arr['active'] = $activity;
                }
                $this->db->update($feed_tbl, $ins_or_upd_arr, $where_arr);
            }else{
                $this->db->insert($feed_tbl, $ins_or_upd_arr);
            }
        }
    }

    public function get_prop_data_for_feed($params)//'hotel_id', 'prop_id' IS MANDATORY!!
    {
        if (!isset($params['host']) && !isset($params['dbname'])) {
            $hotel = $this->db->select('id, db_name, host')->get_where('visitka.config', array('id'=>$params['hotel_id']))->row();
        }else {
            $hotel = (object) array('host' => $params['host'], 'db_name' => $params['dbname']);
        }
        $prop_info_tbl = "property_information";
        $countries_tbl = "global_fms_base.dict_country";

        $sql = "SELECT t1.id, t1.property_type, t1.property_name_lat AS name, t1.street_lat as street, t1.city_lat as city, t1.state_lat as state, t1.post_code AS postal_code,
        t2.id_2ch AS country, t1.gps_coordinates, t1.reception_phone AS phone, t1.web_address AS url, t1.email
        FROM $prop_info_tbl AS t1
        JOIN $countries_tbl AS t2 ON t2.id = t1.country
        WHERE t1.id = ". $params['prop_id'];
        $prop = $this->db->query($sql)->row();
        $ins_arr = array();
        if($prop){
            $ins_arr = array(
                'hms_id' => $params['hotel_id'],
                'host' => $hotel->host,
                'dbname' => $hotel->db_name
            );
            $gps_coordinates = explode(',', $prop->gps_coordinates);
            if (count($gps_coordinates) == 2) {
                list ($latitude, $longitude) = $gps_coordinates;
            } else {
                $latitude = $longitude = '';
            }
            $ins_arr['prop_id'] = $prop->id;
            //$ins_arr['property_type'] = $prop->property_type;
            $ins_arr['partner_id'] = $hotel->id . "_" . $prop->id;
            $ins_arr['name'] = $prop->name;
            $ins_arr['street'] = $prop->street;
            $ins_arr['city'] = $prop->city;
            $ins_arr['state'] = $prop->state;
            $ins_arr['postal_code'] = $prop->postal_code;
            $ins_arr['country'] = $prop->country;
            $ins_arr['phone'] = $prop->phone;
            $ins_arr['url'] = $prop->url; // https://booking-$hotel->host
            $ins_arr['email'] = $prop->email;
            $ins_arr['latitude'] = (string) $latitude;
            $ins_arr['longitude'] = (string) $longitude;
            $ins_arr['active'] = 1;
        }
        return $ins_arr;
    }
}
?>