<?php

class dcm_cron_lastchanged extends CI_model {
	
	function __construct() {
		parent::__construct ();
		
		if (isset($GLOBALS['cron_last_changed'])) {
		
		} else {
		
		$this->load->model ( 'loger' );
		$this->load->model ( 'images_core' );
		$this->load->model ( 'mlanguages' );
		$this->load->model ( 'hotelix_config' );
		$this->load->model ( 'group_res_model' );
		}
	}
	
	// from frontdesk.php
	function dc_cfg_tables_names($dc_id = 0){
	    $tables = array();
	    $tables[1]["cfg_table"] = "dc_booking_xml_cfg";
	    $tables[2]["cfg_table"] = "dc_ostrovok_xml_cfg";
	    $tables[3]["cfg_table"] = "dc_expedia_xml_cfg";
	    $tables[4]["cfg_table"] = "dc_hostelsclub_xml_cfg";
	    $tables[5]["cfg_table"] = "dc_agoda_xml_cfg";
	    $tables[6]["cfg_table"] = "dc_hotel_inn_xml_cfg";
	    $tables[7]["cfg_table"] = "dc_oktogo_xml_cfg";
	    $tables[8]["cfg_table"] = "dc_hostelworld_xml_cfg";
	    $tables[9]["cfg_table"] = "dc_101otel_xml_cfg";
	    $tables[11]["cfg_table"] = "dc_hrs_xml_cfg";
	    $tables[12]["cfg_table"] = "dc_vashotel_xml_cfg";
	    $tables[13]["cfg_table"] = "dc_bronevik_xml_cfg";
	    $tables[14]["cfg_table"] = "dc_hotels24_xml_cfg";
	    $tables[15]["cfg_table"] = "dc_ozon_xml_cfg";
	    $tables[16]["cfg_table"] = "dc_tripadvisor_xml_cfg";
	    $tables[17]["cfg_table"] = "dc_hotelbook_xml_cfg";
	    $tables[18]["cfg_table"] = "dc_eholiday_xml_cfg";
	    $tables[19]["cfg_table"] = "dc_dobovo_xml_cfg";
	    $tables[20]["cfg_table"] = "dc_dorms_xml_cfg";
	    $tables[21]["cfg_table"] = "dc_cbooking_xml_cfg";
	    $tables[22]["cfg_table"] = "dc_airbnb_xml_cfg";
	    $tables[23]["cfg_table"] = "dc_roomp_xml_cfg";
	    $tables[24]["cfg_table"] = "dc_axis_travel_xml_cfg";
	    $tables[25]["cfg_table"] = "dc_onetwotrip_xml_cfg";
	    $tables[26]["cfg_table"] = "dc_tvil_xml_cfg";
	    $tables[27]["cfg_table"] = "dc_academ_service_xml_cfg";
	
	    if($dc_id == 0){
	        return $tables;
	    }else{
	        if(isset($tables[$dc_id])){
	            $dc_cfg_table_name = $tables[$dc_id]["cfg_table"];
	            return $dc_cfg_table_name;
	        }else{
	            return "";
	        }
	    }
	}
	
	// from frontdesk.php
	function get_dc_general_update_value($dc_id){
	    $general_update = 0;
	    $dc_cfg_table_name = $this->dc_cfg_tables_names($dc_id);
	
	    if($dc_cfg_table_name != ""){
	        $sql = "SELECT int_value FROM ".$dc_cfg_table_name." WHERE name LIKE 'general_update'";
	        $query = $this->db->query ( $sql );
	        if ($query->num_rows () > 0) {
	            $row = $query->row ();
	            $general_update = $row->int_value;
	        }
	    }
	
	    return $general_update;
	}
	
	// from frontdesk.php
	function timezone_set() {
	    $sql = "SELECT str_value FROM hotelix_config WHERE name LIKE 'timezone'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        if ($row->str_value != '') {
	            if ($row->str_value == "Europe/Yekaterinburg") {
	                $timezone = "Asia/Yekaterinburg";
	            } else {
	                $timezone = $row->str_value;
	            }
	            date_default_timezone_set ( $timezone );
	        }
	    } else {
	    }
	}
	
	// from dc_cron.php
	function dc_log_semafor_update($db_name) {
	    $hotel_id = 0;
	    $sql = "SELECT * FROM visitka.config WHERE db_name LIKE '$db_name'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () != 0) {
	        $row = $query->row ();
	        $hotel_id = $row->id;
	    }
	    $query = $this->db->query ( "INSERT /* $db_name */ INTO global_hotelix.dc_log_semafor (hotelid, updatetime) VALUES (" . $hotel_id . ", " . time () . ") ON DUPLICATE KEY UPDATE updatetime=" . time () );
	}
	
	// from dc_cron.php
	function dc_save_error($dc_id, $body, $db_name = "", $warning = 0) {
	    $hotel_id = 0;
	    $sql = "SELECT * FROM visitka.config WHERE db_name LIKE '$db_name'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () != 0) {
	        $row = $query->row ();
	        $hotel_id = $row->id;
	    }
	    $query = $this->db->query ( "INSERT INTO dc_log_errors (dc_id, time, body, warning) VALUES(" . $dc_id . ", " . time () . ", '" . addslashes ( $body ) . "', $warning)" );
	    $query = $this->db->query ( "INSERT INTO  global_hotelix.dc_log_errors (dc_id,hotel_id, time, body, warning) VALUES(" . $dc_id . ", " . $hotel_id . ", " . time () . ", '" . addslashes ( $body ) . "', $warning)" );
	}
	
	// from dc_model.php
	function get_datein_dateout_dc_log($type_service, $last_id = 0) {
	    $intdate_today = round ( time () / 86400 ) - 1;
	    $intdate_today = floor ( time () / 86400 );
	
	    $now_date = date ( "Y-m-d" );
	    list ( $year, $month, $day ) = explode ( "-", $now_date );
	    $intdate_today = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	
	    $intdatein = 0;
	    $intdateout = 0;
	
	    $last_id_str = "";
	    if ($last_id != 0) {
	        $last_id_str = " AND dc_log.id <= " . $last_id . " ";
	    }
	
	    $sql = "SELECT MAX( intdate ) AS intdateout, MIN( intdate ) AS intdatein
FROM  dc_log
WHERE  dc_log.intdate >= " . $intdate_today . " AND dc_log.dc_id = " . $type_service . $last_id_str;
	
	    // echo $sql;
	    // die();
	
	    /*
	     * $query = $this->db->query ( "SELECT MAX( deskofdays.intdate ) AS intdateout, MIN( deskofdays.intdate ) AS intdatein FROM `rooms` INNER JOIN categories ON categories.id = rooms.category_id INNER JOIN deskofdays ON deskofdays.room_id = rooms.id INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate WHERE dc_log.intdate >= " . $intdate_today . " AND dc_log.dc_id = " . $type_service );
	     */
	    $query = $this->db->query ( "SELECT MAX( intdate ) AS intdateout, MIN( intdate ) AS intdatein
FROM  dc_log
WHERE  dc_log.intdate >= " . $intdate_today . " AND dc_log.dc_id = " . $type_service . $last_id_str );
	
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $intdatein = $row->intdatein;
	        $intdateout = $row->intdateout;
	    }
	    $data = array (
	        "intdatein" => $intdatein,
	        "intdateout" => $intdateout
	    );
	    return $data;
	}
	
	// from dc_model.php
	function get_datein_dateout_dc_log_rate($type_service) {
	    $intdatein = 0;
	    $intdateout = 0;
	
	    $query = $this->db->query ( "SELECT MAX( intdate ) AS intdateout, MIN( intdate ) AS intdatein
FROM  dc_log_rate
WHERE  dc_log_rate.dc_id = " . $type_service );
	
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $intdatein = $row->intdatein;
	        $intdateout = $row->intdateout;
	    }
	    $data = array (
	        "intdatein" => $intdatein,
	        "intdateout" => $intdateout
	    );
	    return $data;
	}
	
	// from dc_model.php
	function get_datein_dateout_dc_log_yieldprice($type_service) {
	    $intdatein = 0;
	    $intdateout = 0;
	
	    $query = $this->db->query ( "SELECT MAX( intdate ) AS intdateout, MIN( intdate ) AS intdatein
FROM  dc_log_yieldprice
WHERE  dc_log_yieldprice.dc_id = " . $type_service );
	
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $intdatein = $row->intdatein;
	        $intdateout = $row->intdateout;
	    }
	    $data = array (
	        "intdatein" => $intdatein,
	        "intdateout" => $intdateout
	    );
	    return $data;
	}
	
	// from dc_model.php
	function get_overbooking_origincat($intdatein, $intdateout) {
	    $query = $this->db->query ( "SELECT value FROM hotelix_config WHERE name LIKE 'overbooking_category_id'" );
	
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $overbookcatid = $row->value;
	    }
	
	    $overbooking_reservations_array = array ();
	    $sql = "SELECT deskofreservation.origin_categoryid,  deskofdays.intdate, count(1) as obc  FROM deskofdays
		INNER JOIN deskofreservation ON deskofreservation.id=deskofdays.reservation_id
		INNER JOIN rooms ON rooms.id=deskofdays.room_id
		WHERE origin_categoryid <> 0 AND intdate >= " . $intdatein . " AND intdate <= " . $intdateout . "
			AND rooms.category_id = $overbookcatid AND deskofreservation.cancel <> 1 AND deskofreservation.deleted <> 1 group by origin_categoryid, deskofdays.intdate";
	    // echo $sql . "<br>";
	    // die();
	    $query = $this->db->query ( $sql );
	    foreach ( $query->result () as $row ) {
	        $overbooking_reservations_array [$row->origin_categoryid] [$row->intdate] = $row->obc;
	    }
	    return $overbooking_reservations_array;
	}
	
	// from dc_model.php
	function dc_log_data_errors_update($datein, $dateout, $dc_id, $dc_category_id){
	
	    list ( $year, $month, $day ) = explode ( "-", $datein );
	    $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	    list ( $year, $month, $day ) = explode ( "-", $dateout );
	    $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	
	    $intdatetoday = round ( gmmktime ( 0, 0, 0, date ( "m" ), date ( "d" ), date ( "Y" ) ) / 86400 );
	    $limit_array = $this->frontdesk->get_dc_log_limit_array();
	
	    $general_update_eholiday = 0;
	    $query = $this->db->query ( "SELECT int_value FROM dc_eholiday_xml_cfg WHERE name LIKE 'general_update'" );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $general_update_eholiday = $row->int_value;
	    }
	
	    if($general_update_eholiday == 1){
	        $dc_list[18] = 1;
	    }
	    $time = time();
	
	    switch ($dc_id) {
	        case 18 :
	
	            $dc_eholiday_rooms2hms = array ();
	            if ($general_update_eholiday == 1) {
	                $sql = "SELECT dc_room_id, category_id FROM dc_eholiday_rooms_link";
	                $query = $this->db->query ( $sql );
	                if ($query->num_rows () > 0) {
	                    foreach ( $query->result () as $row ) {
	                        $dc_eholiday_rooms2hms [$row->dc_room_id] = $row->category_id;
	                    }
	                }
	            }
	            for($i = $intdatein; $i <= $intdateout; $i ++) {
	                if ($dc_category_id != 0) {
	                    if ($i >= ($intdatetoday - 1) && $i < ($intdatetoday + $limit_array [18])) {
	                        if ($general_update_eholiday == 1) {
	                            if (isset ( $dc_eholiday_rooms2hms [$dc_category_id] )) {
	                                $query = $this->db->query ( "INSERT INTO dc_log (categoryid, intdate, count, dc_id, time) VALUES (" . $dc_eholiday_rooms2hms [$dc_category_id] . ", " . $i . ", 1, 18, $time) ON DUPLICATE KEY UPDATE count=count+1, time=$time" );
	                            }
	                        }
	                    }
	                }
	            }
	
	            break;
	    }
	}
	
	// from dc_model.php use only in expedia
	function get_date_array_dc_log($type_service, $last_id = 0) {
	    $array_date = array ();
	    $intdate_today = round ( time () / 86400 ) - 1;
	    $intdate_today = floor ( time () / 86400 );
	
	    $now_date = date ( "Y-m-d" );
	    list ( $year, $month, $day ) = explode ( "-", $now_date );
	    $intdate_today = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	
	    $intdatein = 0;
	    $intdateout = 0;
	
	    $last_id_str = "";
	    if ($last_id != 0) {
	        $last_id_str = " AND dc_log.id <= " . $last_id . " ";
	    }
	
	    $sql = "SELECT intdate FROM  dc_log
WHERE  dc_log.intdate >= " . $intdate_today . " AND dc_log.dc_id = " . $type_service . $last_id_str;
	
	    $query = $this->db->query ( "SELECT intdate FROM  dc_log
WHERE  dc_log.intdate >= " . $intdate_today . " AND dc_log.dc_id = " . $type_service . $last_id_str );
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $array_date [$row->intdate] = $row->intdate;
	        }
	    }
	
	    return $array_date;
	}
	
	// from dc_model.php
	function cron_dc_save_error($dbname, $dc_id, $body) {
	    $hotel_id = 0;
	
	    $sql = "SELECT * FROM visitka.config WHERE db_name LIKE '$dbname'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () != 0) {
	        $row = $query->row ();
	        $hotel_id = $row->id;
	    }
	    $query = $this->db->query ( "INSERT INTO dc_log_errors (dc_id, time, body) VALUES(" . $dc_id . ", " . time () . ", '" . addslashes ( $body ) . "')" );
	    $query = $this->db->query ( "INSERT INTO  global_hotelix.dc_log_errors (dc_id,hotel_id, time, body) VALUES(" . $dc_id . ", " . $hotel_id . ", " . time () . ", '" . addslashes ( $body ) . "')" );
	}
	
	// from frontdesk.php
	function dc_currency($arg) {
	    return number_format ( $arg, 2, '.', '' );
	}
}
?>