<?php
class Database_mdl extends CI_Model {
	function __construct() {
		parent::__construct ();
		$this->load->dbutil();
	}
	
	public function set_active_database($params = array('hms_id' => null, 'db_name' => null)) {
	    $active_database_setted = false;
	    $db_name = false;
	    if (!is_null($params['hms_id'])) {
	        $db_name = $this->get_dbname_from_visitka_by_hmsid($params['hms_id']);
	    } elseif (!is_null($params['db_name'])) {
	        $db_name = $params['db_name'];
	    }
	    
	    if ($db_name) {
	        if ($this->set_database_by_dbname($db_name)) {
	            $active_database_setted = true;
	        }
	    }
	    return $active_database_setted;
	}
	
	private function set_database_by_dbname($db_name = NULL) {
	    $success = false;
	    if ($this->dbutil->database_exists($db_name))
	    {
	        $this->db->database = $db_name;
	        $success = true;
	    }
	    return $success;
	}
	
	private function get_dbname_from_visitka_by_hmsid($hms_id = NULL) {
	    $db_name = '';
	    if (!is_null($hms_id))
	    {
	        $query_db_name = $this->db->select('db_name')->get_where('visitka.config', array('id' => $hms_id))->row();
	        if ($query_db_name) {
	            $db_name = $query_db_name->db_name;
	        }
	    }
	    return $db_name != '' ? $db_name : false;
	}
}