<?php

class PersonNew
{
//     public $ID;
//     public $GUID;
//     public $Surname;
//     public $Name;
//     public $Middlename;
//     public $SurnameLat;
//     public $NameLat;
//     public $MiddlenameLat;
//     public $Gender;
//     public $Arrival;
//     public $Departure;
//     public $Birthday;
//     public $Citizenship;
//     public $Organization;
//     public $DocType;
//     public $DocTypeWord;
//     public $DocSerial;
//     public $DocNumber;
//     public $DocIssueDate;
//     public $DocValidDate;
//     public $DocIssuePlace;
//     public $DocIssueDepartament;
//     public $BirthCountry;
//     public $BirthRegion;
//     public $BirthCity;
//     public $BirthArea;
//     public $BirthSettlement;
//     public $FIAS;
//     public $Region;
//     public $Area;
//     public $City;
//     public $Settlement;
//     public $Street;
//     public $House;
//     public $Housing;
//     public $Building;
//     public $Flat;
//     public $Profession;
//     public $EntrancePurpose;
//     public $Room;
//     public $Representative;
//     public $ResortFee;
//     public $StayDate;
//     public $AddressDate;
//     public $PrevAddressRegion;
//     public $PrevAddressArea;
//     public $PrevAddressCity;
//     public $PrevAddressSettlement;
//     public $PrevAddressStreet;
//     public $PrevAddressHouse;
//     public $PrevAddressHousing;
//     public $PrevAddressBuilding;
//     public $PrevAddressFlat;
//     public $DocDecisionNumber;
//     public $DocDecisionDate;
//     public $Documents;
//     public $RepresentativePerson;
//     public $DocumentPhoto;
//     public $DocumentPhotoType;

    public function __construct($data = ['guest_id' => '', 'res_id' => '', 'debug' => false])
    {
//         if ($data['guest_id'] != '' && $data['res_id'] != '') {
//             $this->make_props_data((object)$data);
//         }

//         if ($data['debug']) {

        $guest_db_data = $this->get_all_guest2res_data((object) $data);
        $guest_is_child = false;
        if ($guest_db_data->representative_id) {
            $guest_is_child = true;
            $representative_person_db_data = $this->get_representative_person_db_data($guest_db_data->representative_id);
        }
        if (in_array($guest_db_data->citizenship_code, $this->get_classes_by_citizenship())) {
            $class_name = "Person{$guest_db_data->citizenship_code}";
            $guest = new $class_name($guest_db_data);
        } else {
            $guest = new PersonForeign($guest_db_data);
        }
        if ($guest_is_child) {
            switch ($guest_db_data->citizenship_code) {
                    case 'RUS':
                        $guest->RepresentativePerson = new RepresentativePersonRUS($representative_person_db_data);
                    break;

                    default:
                        $guest->RepresentativePerson = new RepresentativePersonForeign($representative_person_db_data);
                    break;
                }
        }
        foreach ($guest as $prop_name => $prop_val) {
            $this->$prop_name = $prop_val;
        }

//             echo "<pre>";
//             print_r($guest_db_data);
//             print_r($guest);
//             die("DIED by A Department at FmssClasses.php __construct() on 7 нояб. 2022 г. 10:23:50");
//         }
    }

    private function get_classes_by_citizenship()
    {
        return ['RUS', 'BLR'];
    }

    private function get_all_guest2res_data($data)
    {
        $tbl_guests = Fmss_mdl::$tbl_guests;
        $tbl_reservations = Fmss_mdl::$tbl_reservations;
        $tbl_res_details = Fmss_mdl::$tbl_res_details;
        $sql_where_arr = [
            "$tbl_res_details.guest_id" => $data->guest_id,
            "$tbl_res_details.reservation_id" => $data->res_id,
        ];
        $controller = &CI_Controller::get_instance();
        $query_row = $controller->db->select("

            $tbl_guests.*,
            $tbl_guests.firstname,
            $tbl_guests.lastname,
            $tbl_guests.middlename,
            $tbl_guests.firstname_lat,
            $tbl_guests.lastname_lat,
            $tbl_guests.middlename_lat,
            $tbl_guests.gender,
            $tbl_guests.dob,
            $tbl_guests.citizenship_code,
            $tbl_guests.doc_type,
            $tbl_guests.doc_precode,
            $tbl_guests.passportid,
            $tbl_guests.doc_date_open,
            $tbl_guests.doc_date_till,
            $tbl_guests.passportissuedby,
            $tbl_guests.country_code,
            $tbl_guests.pob_state,
            $tbl_guests.pob_district,
            $tbl_guests.pob_city,
            $tbl_guests.state,
            $tbl_guests.city,
            $tbl_guests.address,
            $tbl_guests.addrbuilding,
            $tbl_guests.addrhousing,
            $tbl_guests.addrhousing,
            $tbl_guests.addrapt,
            $tbl_guests.profession,
            $tbl_guests.pob_registration_date,
            $tbl_guests.addrapt
            ")
            ->select("
            $tbl_reservations.datein,
            $tbl_reservations.dateout
            ")
            ->select("
            $tbl_res_details.*,
            $tbl_res_details.fias AS FIAS,
            ")
            ->from($tbl_res_details)
            ->join($tbl_guests, "$tbl_guests.id = $tbl_res_details.guest_id")
            ->join($tbl_reservations, "$tbl_reservations.id = $tbl_res_details.reservation_id")
            ->where($sql_where_arr)
            ->get()->row();

        return $query_row;
    }

    private function get_representative_person_db_data($guest_id)
    {
        $tbl_guests = Fmss_mdl::$tbl_guests;
        $sql_where_arr = [
            "$tbl_guests.id" => $guest_id,
        ];
        $controller = &CI_Controller::get_instance();
        $query_row = $controller->db->select("

            $tbl_guests.*,
            $tbl_guests.firstname,
            $tbl_guests.lastname,
            $tbl_guests.middlename,
            $tbl_guests.firstname_lat,
            $tbl_guests.lastname_lat,
            $tbl_guests.middlename_lat,
            $tbl_guests.gender,
            $tbl_guests.dob,
            $tbl_guests.citizenship_code,
            $tbl_guests.doc_type,
            $tbl_guests.doc_precode,
            $tbl_guests.passportid,
            $tbl_guests.doc_date_open,
            $tbl_guests.doc_date_till,
            $tbl_guests.passportissuedby,
            $tbl_guests.country_code,
            $tbl_guests.pob_state,
            $tbl_guests.pob_district,
            $tbl_guests.pob_city,
            $tbl_guests.state,
            $tbl_guests.city,
            $tbl_guests.address,
            $tbl_guests.addrbuilding,
            $tbl_guests.addrhousing,
            $tbl_guests.addrhousing,
            $tbl_guests.addrapt,
            $tbl_guests.profession,
            $tbl_guests.pob_registration_date,
            $tbl_guests.addrapt
            ")
            ->from($tbl_guests)
            ->where($sql_where_arr)
            ->get()->row();

        return $query_row;
    }

    private function make_props_data($data)
    {
        $tbl_guests = Fmss_mdl::$tbl_guests;
        $tbl_reservations = Fmss_mdl::$tbl_reservations;
        $tbl_res_details = Fmss_mdl::$tbl_res_details;
        $sql_where_arr = [
            "$tbl_res_details.guest_id" => $data->guest_id,
            "$tbl_res_details.reservation_id" => $data->res_id,
        ];
        $controller = &CI_Controller::get_instance();
        $query_row = $controller->db->select("

$tbl_guests.*,

            $tbl_guests.firstname AS Name,
            $tbl_guests.lastname AS Surname,
            $tbl_guests.middlename AS Middlename,
            $tbl_guests.firstname_lat AS NameLat,
            $tbl_guests.lastname_lat AS SurnameLat,
            $tbl_guests.middlename_lat AS MiddlenameLat,
            $tbl_guests.gender AS Gender,
            $tbl_guests.dob AS Birthday,
            $tbl_guests.citizenship_code AS Citizenship,
            $tbl_guests.doc_type AS DocType,
            $tbl_guests.doc_precode AS DocSerial,
            $tbl_guests.passportid AS DocNumber,
            $tbl_guests.doc_date_open AS DocIssueDate,
            $tbl_guests.doc_date_till AS DocValidDate,
            $tbl_guests.passportissuedby AS DocIssuePlace,
            $tbl_guests.country_code AS BirthCountry,
            $tbl_guests.pob_state AS BirthRegion,
            $tbl_guests.pob_district AS BirthArea,
            $tbl_guests.pob_city AS BirthCity,
            $tbl_guests.pob_city AS BirthSettlement,
            $tbl_guests.state AS Region,
            $tbl_guests.state AS Area,
            $tbl_guests.city AS City,
            $tbl_guests.city AS Settlement,
            $tbl_guests.address AS Street,
            $tbl_guests.addrbuilding AS House,
            $tbl_guests.addrhousing AS Housing,
            $tbl_guests.addrhousing AS Building,
            $tbl_guests.addrapt AS Flat,
            $tbl_guests.profession AS Profession,
            $tbl_guests.pob_registration_date AS AddressDate,
            $tbl_guests.addrapt AS Room

            ")
            ->select("
                $tbl_reservations.datein AS Arrival,
                $tbl_reservations.dateout AS Departure
            ")
            ->select("
                $tbl_res_details.*,
                $tbl_res_details.fias AS FIAS,
            ")
            ->from($tbl_res_details)
            ->join($tbl_guests, "$tbl_guests.id = $tbl_res_details.guest_id")
            ->join($tbl_reservations, "$tbl_reservations.id = $tbl_res_details.reservation_id")
            ->where($sql_where_arr)
            ->get()->row();

        $query_row->GUID = $data->guest_id.'-'.$data->res_id;
        $query_row->Gender = $query_row->Gender == 1 ? 'M' : 'F';
        $query_row->BirthCity = ($query_row->Citizenship == 'RUS') ? $query_row->BirthCity : 'Отсутствует';

        foreach ($this as $prop_name => $value) {
            if (isset($query_row->{$prop_name})) {
                $this->{$prop_name} = trim($query_row->{$prop_name});
            } else {
                unset($this->{$prop_name});
            }
        }
    }
}

class RepresentativePerson
{
    public $Surname;
    public $Name;
    public $Middlename;
    public $SurnameLat;
    public $NameLat;
    public $MiddlenameLat;
    public $Gender;
    public $Birthday;
    public $Citizenship;
    public $BirthCountry;
    public $BirthRegion;
    public $BirthCity;
    public $BirthArea;
    public $BirthSettlement;
    public $DocType;
    public $Serial;
    public $Number;
    public $Issued;
    public $ValidFrom;
    public $ValidTo;
    public $AuthorityText;
    public $Authority;
    public $DocDecisionNumber;
    public $DocDecisionDate;
    public $RelationType;

    public function __construct()
    {
        //parent::__construct ();
    }
}

class RepresentativePersonBase
{
    public function __construct($guest_db_data)
    {
        $this->make_props($guest_db_data);
    }

    private function make_props($guest_db_data)
    {
        $prop_dependencies = $this->get_this_props_dependencies_set();
        foreach ($prop_dependencies as $prop_name => $prop_set) {
            if (isset($guest_db_data->{$prop_set['db_fild']})) {
                $this->$prop_name = $guest_db_data->{$prop_set['db_fild']};
                if (isset($prop_set['replacement'])) {
                    $this->$prop_name = $prop_set['replacement'][$this->$prop_name];
                }
            }
        }
    }

    private function get_this_props_dependencies_set()
    {
        $props_set = [
            'Surname' => [
                'db_fild' => 'lastname',
                'required' => true,
            ],
            'Name' => [
                'db_fild' => 'firstname',
                'required' => true,
            ],
            'Middlename' => [
                'db_fild' => 'middlename',
                'required' => true,
            ],
            'Gender' => [
                'db_fild' => 'gender',
                'required' => true,
                'replacement' => ['F', 'M'],
            ],
            'Birthday' => [
                'db_fild' => 'dob',
                'required' => true,
            ],
            'Citizenship' => [
                'db_fild' => 'citizenship_code',
                'required' => true,
            ],
            'BirthCountry' => [
                'db_fild' => 'country_code',
                'required' => false,
            ],
            'BirthRegion' => [
                'db_fild' => 'pob_state',
                'required' => false,
            ],
            'BirthCity' => [
                'db_fild' => 'pob_city',
                'required' => false,
            ],
            'BirthArea' => [
                'db_fild' => 'pob_district',
                'required' => false,
            ],
            'BirthSettlement' => [
                'db_fild' => 'pob_city',
                'required' => false,
            ],
            'DocType' => [
                'db_fild' => 'doc_type',
                'required' => true,
            ],
            'Serial' => [
                'db_fild' => 'doc_precode',
                'required' => true,
            ],
            'Number' => [
                'db_fild' => 'passportid',
                'required' => true,
            ],
            'Issued' => [
                'db_fild' => 'doc_date_open',
                'required' => true,
            ],
            'ValidFrom' => [
                'db_fild' => 'doc_date_open',
                'required' => true,
            ],
            'ValidTo' => [
                'db_fild' => 'doc_date_till',
                'required' => true,
            ],
            'Authority' => [
                'db_fild' => 'passportissuedby',
                'required' => false,
            ],
        ];

        return $props_set;
    }
}

class RepresentativePersonRUS extends RepresentativePersonBase
{
    public function __construct($guest_db_data)
    {
        $this->make_props($guest_db_data);
    }

    private function make_props($guest_db_data)
    {
        $prop_dependencies = $this->get_this_props_dependencies_set();
        foreach ($prop_dependencies as $prop_name => $prop_set) {
            if (isset($guest_db_data->{$prop_set['db_fild']})) {
                $this->$prop_name = $guest_db_data->{$prop_set['db_fild']};
                if (isset($prop_set['replacement'])) {
                    $this->$prop_name = $prop_set['replacement'][$this->$prop_name];
                }
            }
        }
    }

    private function get_this_props_dependencies_set()
    {
        $props_set = [
            'RelationType' => [
                'db_fild' => '', //справочник RelationType)">string<
                'required' => true,
            ],
        ];

        return $props_set;
    }
}

class RepresentativePersonForeign
{
    public function __construct($guest_db_data)
    {
        $this->make_props($guest_db_data);
    }

    private function make_props($guest_db_data)
    {
        $prop_dependencies = $this->get_this_props_dependencies_set();
        foreach ($prop_dependencies as $prop_name => $prop_set) {
            if (isset($guest_db_data->{$prop_set['db_fild']})) {
                $this->$prop_name = $guest_db_data->{$prop_set['db_fild']};
                if (isset($prop_set['replacement'])) {
                    $this->$prop_name = $prop_set['replacement'][$this->$prop_name];
                }
            }
        }
    }

    private function get_this_props_dependencies_set()
    {
        $props_set = [
            'SurnameLat' => [
                'db_fild' => 'lastname_lat',
                'required' => true,
            ],
            'NameLat' => [
                'db_fild' => 'firstname_lat',
                'required' => true,
            ],
            'MiddlenameLat' => [
                'db_fild' => 'middlename_lat',
                'required' => true,
            ],
        ];

        return $props_set;
    }
}

class PersonBase
{
    public function __construct($guest_db_data)
    {
        $this->make_props($guest_db_data);
    }

    private function make_props($guest_db_data)
    {
        $prop_dependencies = $this->get_this_props_dependencies_set();
        foreach ($prop_dependencies as $prop_name => $prop_set) {
            if (isset($guest_db_data->{$prop_set['db_fild']})) {
                $this->$prop_name = $guest_db_data->{$prop_set['db_fild']};
                if (isset($prop_set['replacement'])) {
                    $this->$prop_name = $prop_set['replacement'][$this->$prop_name];
                }
            }
        }
    }

    private function get_this_props_dependencies_set()
    {
        $props_set = [
            'ID' => [
                'db_fild' => '',
                'required' => false,
            ],
            'GUID' => [
                'db_fild' => '',
                'required' => false,
            ],
            'Surname' => [
                'db_fild' => 'lastname',
                'required' => true,
            ],
            'Name' => [
                'db_fild' => 'firstname',
                'required' => true,
            ],
            'Middlename' => [
                'db_fild' => 'middlename',
                'required' => true,
            ],
            'Gender' => [
                'db_fild' => 'gender',
                'required' => true,
                'replacement' => ['M', 'M', 'F'],
            ],
            'Arrival' => [
                'db_fild' => 'datein',
                'required' => true,
            ],
            'Departure' => [
                'db_fild' => 'dateout',
                'required' => true,
            ],
            'Birthday' => [
                'db_fild' => 'dob',
                'required' => true,
            ],
            'Citizenship' => [
                'db_fild' => 'citizenship_code',
                'required' => true,
            ],
            'DocType' => [
                'db_fild' => 'doc_type',
                'required' => true,
            ],
            'DocSerial' => [
                'db_fild' => 'doc_precode',
                'required' => true,
            ],
            'DocNumber' => [
                'db_fild' => 'passportid',
                'required' => true,
            ],
            'DocIssueDate' => [
                'db_fild' => 'doc_date_open',
                'required' => true,
            ],
            'DocValidDate' => [
                'db_fild' => 'doc_date_till',
                'required' => true,
            ],
            'DocIssuePlace' => [
                'db_fild' => 'passportissuedby',
                'required' => false,
            ],
            'BirthCountry' => [
                'db_fild' => 'country_code',
                'required' => false,
            ],
            'BirthRegion' => [
                'db_fild' => 'pob_state',
                'required' => false,
            ],
            'BirthCity' => [
                'db_fild' => 'pob_city',
                'required' => false,
            ],
            'BirthArea' => [
                'db_fild' => 'pob_district',
                'required' => false,
            ],
            'BirthSettlement' => [
                'db_fild' => 'pob_city',
                'required' => false,
            ],
            'Profession' => [
                'db_fild' => 'profession',
                'required' => false,
            ],
            'Room' => [
                'db_fild' => 'addrapt',
                'required' => false,
            ],
        ];

        return $props_set;
    }
}

class PersonRUS extends PersonBase
{
    public function __construct($guest_db_data)
    {
        parent::__construct($guest_db_data);
        $this->make_props($guest_db_data);
    }

    private function make_props($guest_db_data)
    {
        $prop_dependencies = $this->get_this_props_dependencies_set();
        foreach ($prop_dependencies as $prop_name => $prop_set) {
            if (isset($guest_db_data->{$prop_set['db_fild']})) {
                $this->$prop_name = $guest_db_data->{$prop_set['db_fild']};
                if (isset($prop_set['replacement'])) {
                    $this->$prop_name = $prop_set['replacement'][$this->$prop_name];
                }
            }
        }
        if (isset($this->FIAS)) {
            if ($this->FIAS != '') {
                $fias_substitute_filds = [
                    'Region',
                    'Area',
                    'City',
                    'Settlement',
                    'Street',
                    'House',
                    'Housing',
                    'Building',
                    'Flat',
                    'AddressDate',
                ];
                foreach ($fias_substitute_filds as $fild) {
                    unset($this->$fild);
                }
            } else {
                unset($this->FIAS);
            }
        }
    }

    private function get_this_props_dependencies_set()
    {
        $props_set = [
            'FIAS' => [
                'db_fild' => 'fias',
                'required' => false,
            ],
            'Region' => [
                'db_fild' => 'state',
                'required' => false,
            ],
            'Area' => [
                'db_fild' => 'state',
                'required' => false,
            ],
            'City' => [
                'db_fild' => 'city',
                'required' => false,
            ],
            'Settlement' => [
                'db_fild' => 'city',
                'required' => false,
            ],
            'Street' => [
                'db_fild' => 'address',
                'required' => false,
            ],
            'House' => [
                'db_fild' => 'addrbuilding',
                'required' => false,
            ],
            'Housing' => [
                'db_fild' => 'addrhousing',
                'required' => false,
            ],
            'Building' => [
                'db_fild' => 'addrhousing',
                'required' => false,
            ],
            'Flat' => [
                'db_fild' => 'addrapt',
                'required' => false,
            ],
            'AddressDate' => [
                'db_fild' => 'pob_registration_date',
                'required' => true,
            ],
        ];

        return $props_set;
    }
}

class PersonBLR extends PersonRUS
{
    public function __construct($guest_db_data)
    {
        parent::__construct($guest_db_data);
        $this->make_props($guest_db_data);
    }

    private function make_props($guest_db_data)
    {
        $this->BirthCity = 'Отсутствует';
    }
}

class PersonForeign extends PersonBase
{
    public function __construct($guest_db_data)
    {
        parent::__construct($guest_db_data);
        $this->make_props($guest_db_data);
    }

    private function make_props($guest_db_data)
    {
        $prop_dependencies = $this->get_this_props_dependencies_set();
        foreach ($prop_dependencies as $prop_name => $prop_set) {
            if (isset($guest_db_data->{$prop_set['db_fild']})) {
                $this->$prop_name = $guest_db_data->{$prop_set['db_fild']};
                if (isset($prop_set['replacement'])) {
                    $this->$prop_name = $prop_set['replacement'][$this->$prop_name];
                }
            }
        }
        $this->BirthCity = 'Отсутствует';
        $this->Documents = $this->make_documents($guest_db_data);
    }

    private function get_this_props_dependencies_set()
    {
        $props_set = [
            'SurnameLat' => [
                'db_fild' => 'lastname_lat',
                'required' => false,
            ],
            'NameLat' => [
                'db_fild' => 'firstname_lat',
                'required' => false,
            ],
            'MiddlenameLat' => [
                'db_fild' => 'middlename_lat',
                'required' => false,
            ],
            'EntrancePurpose' => [
                'db_fild' => 'visitpurpose',
                'required' => false,
            ],
            'StayDate' => [
                'db_fild' => 'datein',
                'required' => false,
            ],
            'PrevAddressRegion' => [
                'db_fild' => 'address_lastliving',
                'required' => false,
            ],
            'PrevAddressArea' => [
                'db_fild' => 'address_lastliving',
                'required' => false,
            ],
            'PrevAddressCity' => [
                'db_fild' => 'address_lastliving',
                'required' => false,
            ],
            'PrevAddressSettlement' => [
                'db_fild' => 'address_lastliving',
                'required' => false,
            ],
            'PrevAddressStreet' => [
                'db_fild' => 'address_lastliving',
                'required' => false,
            ],
            'PrevAddressHouse' => [
                'db_fild' => 'address_lastliving',
                'required' => false,
            ],
            'PrevAddressHousing' => [
                'db_fild' => 'address_lastliving',
                'required' => false,
            ],
            'PrevAddressBuilding' => [
                'db_fild' => 'address_lastliving',
                'required' => false,
            ],
            'PrevAddressFlat' => [
                'db_fild' => 'address_lastliving',
                'required' => true,
            ],
        ];

        return $props_set;
    }

    private function make_documents($guest_db_data)
    {
        $documents = [];
        if (isset($guest_db_data->migration_card_precode) && $guest_db_data->migration_card_precode != ''
            && isset($guest_db_data->migration_card_num) && $guest_db_data->migration_card_num != '') {
            $documents['DocumentNew'][] = new DocumentMigCard($guest_db_data);
        }
        switch ($guest_db_data->docResidence) {
            case '139356': // visa
                $documents['DocumentNew'][] = new DocumentVisa($guest_db_data);
                break;
            case '135709': // visa
                $documents['DocumentNew'][] = new DocumentResidencePermit($guest_db_data);
                break;
            case '139373': // visa
                $documents['DocumentNew'][] = new DocumentTempResidencePermit($guest_db_data);
                break;
        }

        return (object) $documents;
    }
}

class DocumentVisa
{
    public function __construct($guest_db_data)
    {
        $this->make_props($guest_db_data);
    }

    private function make_props($guest_db_data)
    {
        $this->DocType = '139356';
        $prop_dependencies = $this->get_this_props_dependencies_set();
        foreach ($prop_dependencies as $prop_name => $prop_set) {
            if (isset($guest_db_data->{$prop_set['db_fild']})) {
                $this->$prop_name = $guest_db_data->{$prop_set['db_fild']};
                if (isset($prop_set['replacement'])) {
                    $this->$prop_name = $prop_set['replacement'][$this->$prop_name];
                }
            }
        }
    }

    private function get_this_props_dependencies_set()
    {
        $props_set = [
            'Serial' => [
                'db_fild' => 'reg_visa_precode',
                'required' => false,
            ],
            'Number' => [
                'db_fild' => 'reg_visa_num',
                'required' => true,
            ],
            'Issued' => [
                'db_fild' => 'card_date_of_issue',
                'required' => true,
            ],
            'ValidFrom' => [
                'db_fild' => 'card_date_of_issue',
                'required' => true,
            ],
            'ValidTo' => [
                'db_fild' => 'reg_visa_date_till',
                'required' => true,
            ],
            'Category' => [
                'db_fild' => 'reg_visa_type',
                'required' => true,
            ],
            'StayDuration' => [
                'db_fild' => '',
                'required' => true,
            ],
            'Multiplicity' => [
                'db_fild' => 'visamultiplicity',
                'required' => true,
            ],
            'Identifier' => [
                'db_fild' => 'resdoc_identitifier',
                'required' => true,
            ],
            'EntryGoal' => [
                'db_fild' => 'goal_id',
                'required' => true,
            ],
        ];

        return $props_set;
    }
}

class DocumentResidencePermit
{
    public function __construct($guest_db_data)
    {
        $this->make_props($guest_db_data);
    }

    private function make_props($guest_db_data)
    {
        $this->DocType = '135709';
        $prop_dependencies = $this->get_this_props_dependencies_set();
        foreach ($prop_dependencies as $prop_name => $prop_set) {
            if (isset($guest_db_data->{$prop_set['db_fild']})) {
                $this->$prop_name = $guest_db_data->{$prop_set['db_fild']};
                if (isset($prop_set['replacement'])) {
                    $this->$prop_name = $prop_set['replacement'][$this->$prop_name];
                }
            }
        }
    }

    private function get_this_props_dependencies_set()
    {
        $props_set = [
            'Serial' => [
                'db_fild' => 'reg_visa_precode',
                'required' => false,
            ],
            'Number' => [
                'db_fild' => 'reg_visa_num',
                'required' => true,
            ],
            'Issued' => [
                'db_fild' => 'card_date_of_issue',
                'required' => true,
            ],
            'ValidFrom' => [
                'db_fild' => 'card_date_of_issue',
                'required' => true,
            ],
            'ValidTo' => [
                'db_fild' => 'reg_visa_date_till',
                'required' => true,
            ],
            'AuthorityText' => [
                'db_fild' => 'docResidence_authority',
                'required' => true,
            ],
//             'Authority' => array(
//                 'db_fild' => 'код формата xxx-xxx',
//                 'required' => true,
//             ),
            'DescisionNumber' => [
                'db_fild' => 'docResidence_decisionNumber',
                'required' => true,
            ],
            'DescisionDate' => [
                'db_fild' => 'docResidence_decisionDate',
                'required' => true,
            ],
        ];

        return $props_set;
    }
}

class DocumentTempResidencePermit
{
    public function __construct($guest_db_data)
    {
        $this->make_props($guest_db_data);
    }

    private function make_props($guest_db_data)
    {
        $this->DocType = '139373';
        $prop_dependencies = $this->get_this_props_dependencies_set();
        foreach ($prop_dependencies as $prop_name => $prop_set) {
            if (isset($guest_db_data->{$prop_set['db_fild']})) {
                $this->$prop_name = $guest_db_data->{$prop_set['db_fild']};
                if (isset($prop_set['replacement'])) {
                    $this->$prop_name = $prop_set['replacement'][$this->$prop_name];
                }
            }
        }
    }

    private function get_this_props_dependencies_set()
    {
        $props_set = [
            'Issued' => [
                'db_fild' => 'card_date_of_issue',
                'required' => true,
            ],
            'ValidTo' => [
                'db_fild' => 'reg_visa_date_till',
                'required' => true,
            ],
            'AuthorityText' => [
                'db_fild' => 'docResidence_authority',
                'required' => true,
            ],
            //             'Authority' => array(
                //                 'db_fild' => 'код формата xxx-xxx',
                //                 'required' => true,
                //             ),
            'DescisionNumber' => [
                'db_fild' => 'docResidence_decisionNumber',
                'required' => true,
            ],
            'DescisionDate' => [
                'db_fild' => 'docResidence_decisionDate',
                'required' => true,
            ],
        ];

        return $props_set;
    }
}

class DocumentMigCard
{
    public function __construct($guest_db_data)
    {
        $this->make_props($guest_db_data);
    }

    private function make_props($guest_db_data)
    {
        $this->DocType = '103022'; //????????
        $prop_dependencies = $this->get_this_props_dependencies_set();
        foreach ($prop_dependencies as $prop_name => $prop_set) {
            if (isset($guest_db_data->{$prop_set['db_fild']})) {
                $this->$prop_name = $guest_db_data->{$prop_set['db_fild']};
                if (isset($prop_set['replacement'])) {
                    $this->$prop_name = $prop_set['replacement'][$this->$prop_name];
                }
            }
        }
    }

    private function get_this_props_dependencies_set()
    {
        $props_set = [
            'Serial' => [
                'db_fild' => 'migration_card_precode',
                'required' => false,
            ],
            'Number' => [
                'db_fild' => 'migration_card_num',
                'required' => true,
            ],
            'KppCrossDate' => [
                'db_fild' => 'reg_date_in',
                'required' => true,
            ],
            'Issued' => [
                'db_fild' => 'reg_date_in',
                'required' => true,
            ],
            'KPP' => [
                'db_fild' => '', //officialorgan_kpp_code
                'required' => true,
            ],
            'ValidFrom' => [
                'db_fild' => 'reg_date_in',
                'required' => true,
            ],
            'ValidTo' => [
                'db_fild' => 'reg_date_out',
                'required' => true,
            ],
        ];

        return $props_set;
    }
}

// <ID comment="Идентификатор гражданина, необязателен">long</ID>
// <GUID comment="Строковый идентификатор гражданина, необязателен">string</GUID>
// <Surname comment="Фамилия на кириллице">string</Surname>
// <Name comment="Имя на кириллице">string</Name>
// <Middlename comment="Отчество на кириллице">string</Middlename>
// <SurnameLat comment="Фамилия на латинице">string</SurnameLat>
// <NameLat comment="Имя на латинице">string</NameLat>
// <MiddlenameLat comment="Отчество на латинице">string</MiddlenameLat>
// <Gender comment="Пол">string</Gender>
// <Arrival comment="Дата въезда в гостиницу, не больше текущей даты">dateTime</Arrival>
// <Departure comment="Дата выезда из гостиницы">dateTime</Departure>
// <Birthday comment="Дата рождения">dateTime</Birthday>
// <Citizenship comment="Гражданство(либо полнотекстовое название, либо код ISO‐3)">string</Citizenship>
// <Organization comment="Гостиница, к которой привязан гражданин, не указывается">string</Organization>
// <DocType comment="Тип ДУЛ, либо идентификатор, либо полнотекстовое название">string</DocType>
// <DocSerial comment="Серия ДУЛ">string</DocSerial>
// <DocNumber comment="Номер ДУЛ">string</DocNumber>
// <DocIssueDate comment="Дата выдачи ДУЛ">dateTime</DocIssueDate>
// <DocValidDate comment="Дата окончания ДУЛ">dateTime</DocValidDate>
// <DocIssuePlace comment="Орган выдачи ДУЛ, идентификатор или полнотекстовое название">string</DocIssuePlace>
// <BirthCountry comment="Страна рождения">string</BirthCountry>
// <BirthRegion comment="Регион рождения, необязателен">string</BirthRegion>
// <BirthArea comment="Район рождения, необязателен ">string</BirthArea>
// <BirthCity comment="Город рождения, необязателен">string</BirthCity>
// <BirthSettlement comment="Населенный пункт, необязателен">string</BirthSettlement>
// <FIAS comment="ФИАС код, необязателен"> string </FIAS >
// <Region comment="Регион прописки, название желательно без наименования(край, область и прочее), только для РГ, если не указан Фиас код">string</Region>
// <Area comment="Район прописки, название желательно без наименования(район), только для РГ, если не указан Фиас код">string</Area>
// <City comment="Город прописки, название желательно без наименования(город, село, аул и прочее), только для РГ, если не указан Фиас код">string</City>
// <Settlement comment="Населенный пункт прописки">string</Settlement>
// <Street comment="Улица прописки, название желательно без наименования(улица, проспект, микрорайон и прочее), только для РГ, если не указан Фиас код">string</Street>
// <House comment="Дом прописки, только сам номер, только для РГ">string</House>
// <Housing comment="Корпус прописки, только сам номер, только для РГ">string</Housing>
// <Building comment="Строение прописки, только сам номер, только для РГ">string</Building>
// <Flat comment="Квартира прописки, только сам номер, только для РГ">string</Flat>
// <Profession comment="Профессия, либо идентификатор, либо полнотекстовое название, необязательно">string</Profession>
// <Room comment="Комната, только сам номер, необязательно">string</Room>
// <ResortFee comment="Льготы курортного сбора, либо краткое содержание либо наименование льготы либо идентификатор">string</ResortFee>
// <EntrancePurpose comment="Цель въезда">string</EntrancePurpose>
// <AddressDate comment="Дата прописки, только для РГ. Обязательное поле">string</AddressDate>
// <StayDate comment="Дата въезда в РФ" "(устаревшее ‐Срок пребывания в РФ). Заполняется, если нет миграционной карты, только для ИГ">string</StayDate>
// <PrevAddressRegion comment="Регион адреса прошлого места пребывания, только для ИГ">string</PrevAddressRegion>
// <PrevAddressArea comment="Район адреса прошлого места пребывания, только для ИГ">string</PrevAddressArea>
// <PrevAddressCity comment="Город адреса прошлого места пребывания, только для ИГ">string</PrevAddressCity>
// <PrevAddressSettlement comment="Населенный пункт адреса прошлого места пребывания, только для ИГ">string</PrevAddressSettlement>
// <PrevAddressStreet comment="Улица адреса прошлого места пребывания, только для ИГ">string</PrevAddressStreet>
// <PrevAddressHouse comment="Дом адреса прошлого места пребывания, только для ИГ">string</PrevAddressHouse>
// <PrevAddressHousing comment="Корпус адреса прошлого места пребывания, только для ИГ">string</PrevAddressHousing>
// <PrevAddressBuilding comment="Строение адреса прошлого места пребывания, только для ИГ">string</PrevAddressBuilding>
// <PrevAddressFlat comment="Квартира адреса прошлого места пребывания, только для ИГ">string</PrevAddressFlat>
// <Documents comment="Список второстепенных документов гражданина, только для ИГ">
//     <Document>
//         <ID comment="Идентификатор документа, не используется">string</ID>
//         <DocType comment="Тип документа, только идентификатор типа документа из справочника фмс">string</DocType>
//         <Serial comment="Серия документа, если она есть">string</Serial>
//         <Number comment="Номер документа">string</Number>
//         <Issued comment="Дата выдачи">dateTime</Issued>
//         <ValidFrom comment="Дата начала действия">dateTime</ValidFrom>
//         <ValidTo comment="Дата окончания">dateTime</ValidTo>
//         <DocumentState comment="Статус документа(активен, неактивен, изъят и прочее), не используется">string</DocumentState>
//         <Category comment="Категория визы, только при типе документа ‐ Виза">string</Category>
//         <StayDuration comment="Кол‐во дней дествия документа, только для визы">string</StayDuration>
//         <Multiplicity comment="Кратность визы, только для визы">string</Multiplicity>
//         <Identifier comment="Идентификатор визы, только для визы">string</Identifier>
//         <EntryGoal comment="Цель въезда, для визы (справочник EntryGoals) или миграционной карты (справочник VisitPurposes)">string</EntryGoal>
//         <InvitationNumber comment="Неиспользуется">string</InvitationNumber>
//         <AuthorityText comment="Кем выдан документ, только для РВП или Вида на жительство, полнотектовое наименование">string</AuthorityText>
//         <Authority comment="Кем выдан документ, только для РВП или Вида на жительство, код формата xxx‐xxx">string</Authority>
//         <DescisionNumber comment="Номер принятия решения, только для РВП или Вида на жительство">string</DescisionNumber>
//         <KPP comment="Кпп въезда, только для Миграционной карты">string</KPP>
//         <DescisionDate comment="Дата выдачи разрешения, только для РВП или Вида на жительство">dateTime</DescisionDate>
//         <KppCrossDate comment="Дата въезда в РФ, только для МК">dateTime</KppCrossDate>
//     </Document>
// </Documents>
// <RepresentativePerson comment="Законный представитель на ИГ и РГ">
//     <Surname comment="Фамилия на кириллице">string</Surname>
//     <Name comment="Имя на кириллице">string</Name>
//     <Middlename comment="Отчество на кириллице">string</Middlename>
//     <SurnameLat comment="Фамилия на латинице, только для ИГ">string</SurnameLat>
//     <NameLat comment="Имя на латинице, только для ИГ">string</NameLat>
//     <MiddlenameLat comment="Отчество на латинице, только для ИГ">string</MiddlenameLat>
//     <Gender comment="Пол">string</Gender>
//     <Birthday comment="Дата рожждения">dateTime</Birthday>
//     <Citizenship comment="Гражданство(либо полнотекстовое название, либо код ISO‐3)">string</Citizenship>
//     <BirthCountry comment="Страна рождения">string</BirthCountry>
//     <BirthRegion comment="Регион рождения, необязателен">string</BirthRegion>
//     <BirthArea comment="Район прописки">string</BirthArea>
//     <BirthCity comment="Город рождения, необязателен">string</BirthCity>
//     <BirthSettlement comment="Населенный пункт">string</BirthSettlement>
//     <DocType comment="Тип ДУЛ, либо идентификатор, либо полнотекстовое название">string</DocType>
//     <Serial comment="Серия ДУЛ">string</Serial>
//     <Number comment="Номер ДУЛ">string</Number>
//     <Issued comment="Дата выдачи ДУЛ">string</Issued>
//     <ValidFrom comment="Дата действия ДУЛ">string</ValidFrom>
//     <ValidTo comment="Дата окончания ДУЛ">string</ValidTo>
//     <AuthorityText comment="Орган выдачи ДУЛ, полнотекстовое название">string</AuthorityText>
//     <Authority comment="Орган выдачи ДУЛ, идентификатор">string</Authority>
//     <RelationType comment="Тип законного представителя, только для РГ (справочник RelationType)">string</RelationType>
// </RepresentativePerson>
