<?php
require_once APPPATH . 'libraries/stripe-latest/vendor/autoload.php';

//require_once APPPATH . 'libraries/php_office/vendor/autoload.php';

//use PhpOffice\PhpWord;
//use PhpOffice\IOFactory;
//use PhpOffice\TemplateProcessor;

class vit_debug extends CI_Controller {
    public $stripe;

	public function __construct() {
		parent::__construct ();
        
        $this->load->model ( 'Authorization' );
        $this->Authorization->IsLogined();
        $this->load->model ( 'Access' );
        $this->load->model ( 'formsprinter_model_vit' );
    }

    private function dump( $wtf )
    {
        echo "<pre>";
        print_r( $wtf );
        die();
    }

    public function group_fpl_data()
    {
        $group_data = [
            'template_id' => 87,
            'template_location_type' => 'local',
            'group_reservations' => [
                '30262' => 1,
                '30263' => 2,
            ],
        ];
        
        $data = $this->formsprinter_model_vit->get_group_template( $group_data, 1 );
        $this->dump( $data );

    }

    private function get_secret_key( int $region_id): ?string
    {
        $query = $this->db->query("select account_id from global_hotelix.stripe_region2account where region_id=" . $region_id);
        if ($query->num_rows()) {
            $row = $query->row();
            $account_id = $row->account_id;
        } else {
            return null;
        }

        switch ($account_id) {
            case 1: // UK
                return "sk_live_iE2mMoPUDp3VxXlAbEjEnXA0";
                break;
            case 2: // US
                return "sk_live_ULSdkctCLcUFaOamwoEjKQIe";
                break;
            default:
                return "sk_test_D44UtbmH0yoFWIh8mj7q3Jcc";
                break;
        }

    }

    private function get_product_by_region_id( int $region_id) : ?string
    {
        $products = [
            1 => 'prod_GeD04MYuWNJBmc',
            2 => 'prod_ENohjHH8BGSgJR',
            3 => 'prod_ENpk6lg92rD6lu',
            4 => 'prod_EOtuoQ8ASVDAnu',
            5 => 'prod_EOuFy631FDsZx5',
            6 => 'prod_EOuLwkDY631kko',
            7 => 'prod_EOvU29LYUTmynD',
            8 => 'prod_EOwCEaOHer02MS',
            9 => 'prod_Eui3z6pWQI6Eqi',
            10 => 'prod_ENpr6bPI6SEjZM',
            11 => 'prod_EOZx3eMoIE18GH',
            12 => 'prod_EOa4WLnSEeJsqA',
            13 => 'prod_EOsLy1xVE5P4CM',
            14 => 'prod_EuiVmPsc8lHuVE',
            15 => 'prod_EOvokcO6wmiAcR',
            16 => 'prod_EOvtDnVYkQHqHL',
            17 => 'prod_EOw0QgBFCFjTTT',
            18 => 'prod_EOwL0aXF7XLOId',
        ];
        
        return $products[$region_id] ?? null;
    }

    public function parse_template()
    {

        $phpWord = new PhpWord();

        $pdf = $parser->parseFile('tmp/Compound template.pdf');

        $text = $pdf->getText();

        echo "<pre>";
        echo $text;
    }

    public function get_subscriptions( string $customer_id = 'cus_SqeYLfoL8HoY30' ): void
    {
        $stripe = new \Stripe\StripeClient('sk_test_D44UtbmH0yoFWIh8mj7q3Jcc');

        try{
            $subscriptions = $stripe->subscriptions->all( ['customer' => $customer_id] );
            $this->dump( $subscriptions );
        } catch( Exception $e) {
            $this->dump( $e->getMessage());
        }
    }

    public function get_rates()
    {
        $plans = [];

        $stripe = new \Stripe\StripeClient('sk_test_D44UtbmH0yoFWIh8mj7q3Jcc');

        try{
            $products = $stripe->products->all( ['created' => ['gt' => strtotime('2025-07-22')]] );
        } catch( Exception $e) {
            $this->dump( $e->getMessage());
        }

        foreach( $products['data'] as $product ){
            try{
                $plans = array_merge($plans, ($stripe->plans->all( [ 'product' => $product ] )['data'] ?? []));
            } catch( Exception $e) {
                echo "<br>";
                echo ( $e->getMessage());
                echo "<br>";
            }
        }
        $this->dump( $plans );
    }

    public function subscribe()
    {
        $stripe = new \Stripe\StripeClient('sk_test_D44UtbmH0yoFWIh8mj7q3Jcc');

        $customer = 'cus_SqeYLfoL8HoY30'; // test uah
        $price = 'price_1RppCeFtGkXaNdPMujUkzsho'; // 3 months

        try{
            $subscription = $stripe->subscriptions->create([
                'customer' => $customer,
                'currency' => 'uah',
                'billing_mode' => [
                    'type' => 'flexible'
                ],
                'items'    => [
                    [
                        'price' => $price,
                        'quantity' => 1,
                        'metadata' => [
                            'type' => 'main', // main, module, secondary, 
                        ],
                    ],
                ],
                'metadata' => [
                    'is_hms' => 1
                ]
            ]);
            $this->dump( $subscription );
        } catch( Exception $e ){
            $this->dump($e->getMessage());
        }

    }

    public function upsale()
    {
        $stripe = new \Stripe\StripeClient('sk_test_D44UtbmH0yoFWIh8mj7q3Jcc');

        $subscription = 'sub_1RuxJ2FtGkXaNdPMfbxXzAaC';
        $price = 'price_1RppRqFtGkXaNdPMsxk17Mrm';

        try{
            $subscriptionItem = $stripe->subscriptionItems->create([
                'subscription' => $subscription,
                'price' => $price,
                'proration_behavior' => 'always_invoice',
                'quantity' => 1,
                'metadata' => [
                    'type' => 'module'
                ]
            ]);
            $this->dump( $subscriptionItem );
        } catch( Exception $e ){
            $this->dump($e->getMessage());
        }

    }

    public function add_apart()
    {
        $stripe = new \Stripe\StripeClient('sk_test_D44UtbmH0yoFWIh8mj7q3Jcc');

        $subscription = 'sub_1RuxJ2FtGkXaNdPMfbxXzAaC';
        $price = 'price_1RuxPMFtGkXaNdPMbiKvqKFn';

        try{
            $subscriptionItem = $stripe->subscriptionItems->create([
                'subscription' => $subscription,
                'price' => $price,
                'proration_behavior' => 'always_invoice',
                'quantity' => 2,
                'metadata' => [
                    'type' => 'secondary'
                ]
            ]);
            $this->dump( $subscriptionItem );
        } catch( Exception $e ){
            $this->dump($e->getMessage());
        }


    }

    public function remove_module()
    {
        $stripe = new \Stripe\StripeClient('sk_test_D44UtbmH0yoFWIh8mj7q3Jcc');

        $customer_id = 'cus_SqeYLfoL8HoY30';

        try{
            $subscriptions = $stripe->subscriptions->all( ['customer' => $customer_id] );
        } catch( Exception $e) {
            $this->dump( $e->getMessage());
        }

        $current_items = [];
        $items = [];

        $subscriptionItem = 'si_SqfMBX9azhY5D4';

        foreach( $subscriptions['data'] as $s ){
           if( $s['status'] == 'active' && ( $s['metadata']['is_hms'] ?? false ) ){
                foreach( $s['items']['data'] as $si ){
                    if( $si == $subscriptionItem ){
                        $end_date = $si['current_period_end'];
                        $current_items[] = [
                            'price' => $si['price']['id'],
                            'quantity' => $si['quantity']
                        ];
                        continue;
                    }

                    $items[] = [
                        'price' => $si['price']['id'],
                        'quantity' => $si['quantity']
                    ];
                }
                $subscriptionId = $s['id'];
                break;
           }
        }

        $schedule = [
            'customer' => $customer_id,
            'start_date' => $start_date ?? time(),
            'end_behavior' => 'release',
            'from_subscription' => $subscriptionId,
            'phases' => [
                [
                    'items' => $items
                ],
            ],
        ];

        try{

            $subscriptionSchedule = $stripe->subscriptionSchedules->create($schedule);
            $this->dump( $subscriptionSchedule );

        } catch( Exception $e ) {
            $this->dump( $e->getMessage() );
        }
    }

    public function get_schedules()
    {
        $stripe = new \Stripe\StripeClient('sk_test_D44UtbmH0yoFWIh8mj7q3Jcc');

        try{
            $subscriptionSchedules = $stripe->subscriptionSchedules->all(['customer' => 'cus_SqeYLfoL8HoY30']);
            $this->dump( $subscriptionSchedules );
        } catch( Exception $e ){
            $this->dump( $e->getMessage() );
        } 
        
    }

}