<?php 
class Stripe_personal extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('frontdesk');
		$this->load->model('Stripe');
	}


	function payment_form($currency = "") {
		$data = array(
			"currency" => $currency
		);
		$this->load->library('parser');
		$this->load->view('stripe_personal_payment_form_view.php', $data);
	}
	
	function payment_form_3ds($currency = "") {
		$data = array(
				"currency" => $currency
		);
		$this->load->library('parser');
		$this->load->view('stripe_personal_payment_form_3ds_view.php', $data);
	}
	
	function payment_form_3ds_post($stripe_account)
	{
		//echo "<pre>";
		//print_r($_POST);
		//die();
		$host = $_SERVER ["HTTP_HOST"];
		//echo "https://".$host."/stripe_personal/create_charge_3ds";
		// require_once(APPPATH.'libraries/stripe/Stripe.php');
		require_once (APPPATH . 'libraries/stripe/init.php');
	
		switch ($stripe_account) {
			case "us":
				$stripe = $this->Stripe->get_param_hms_billing();
				break;
			case "uk":
				$stripe = $this->Stripe->get_param_hms_billing_uk();
				break;
			default:
				die("Bill error");
				break;
		}
	
		\Stripe\Stripe::setApiKey($stripe['secret_key']);
	
		$amount = $_POST['amount'];
		$currency = $_POST['currency'];
		$hotel_id = 92;
		
		
		$source = \Stripe\Source::create(array(
				"amount" => $amount,
				"currency" => $currency,
				"type" => "three_d_secure",
				"three_d_secure" => array(
						"card" => $_POST['stripeSource'],
				),
				"redirect" => array(
						"return_url" => "https://".$host."/stripe_personal/create_charge_3ds"
				),
		));
		header("Location: ".$source->redirect->url);
		die();
		//redirect($source->redirect->url);
	}
	
	function create_charge_3ds() {
		echo "<pre>";
		print_r($_POST);
		echo "-----";
		print_r($_GET);
		//die();
		
		require_once (APPPATH . 'libraries/stripe/init.php');
	
		switch ($stripe_account) {
			case "us":
				$stripe = $this->Stripe->get_param_hms_billing();
				break;
			case "uk":
				$stripe = $this->Stripe->get_param_hms_billing_uk();
				break;
			default:
				die("Bill error");
				break;
		}
	
		\Stripe\Stripe::setApiKey($stripe['secret_key']);
		
		$amount = 21;
		$currency = "eur";
		$hotel_id = 92;
		$order__id = 4567;
		$invoice = $hotel_id . "-" . time();
		
		$charge = \Stripe\Charge::create(array(
				'amount' => $amount * 100,
				'currency' => $currency,
				'description' => "hms-" . $invoice,
				'metadata' => array(
						'order_id' => $order__id
				),
				'source' => $this->input->get('source'),
				//'capture' => false,
				'statement_descriptor' => 'Custom descriptor'
		));
		
		$LastResponse = $charge->getLastResponse();
		$response = $LastResponse->json;
		print_r($response);
		die();
		
		
		if ($response["paid"] == 1) {
			/*
			 * ========= CAPTURE CHARGE ========
			*
			*/
				
			$charge_capture = \Stripe\Charge::retrieve($response["id"]);
			$charge_capture->capture();
				
			$LastResponse_capture = $charge_capture->getLastResponse();
			$response_capture = $LastResponse_capture->json;
			//print_r($response_capture);
			//die();
				
			//==========================================================
				
			$hotel_id = $this->config->item('hotel_id');
			$db3 = $this->load->database('db3', TRUE);
			$sql = "INSERT INTO test.billingdoc (hmsID, doctype, amount, ref, currency, datetime)
			VALUES('" . $hotel_id . "', '2', '" . $response["amount"] / 100 . "', '" . $response["id"] . "',
			'" . $response["currency"] . "', '" . date("Y-m-d H:i:s") . "')";
			// echo $sql;
			$query = $db3->query($sql);
			$billingdoc_id = $db3->insert_id();
			$sql = "INSERT INTO test.log (`user_id`, `time`, `billingdoc_id`, `operation`) VALUES('0', '" . date("Y-m-d H:i:s") . "', '" . $billingdoc_id . "',
				'new')";
		
			$query = $db3->query($sql);
		
			die("<meta http-equiv='refresh' content='0;url=/stripe_personal/response_page_ok'>");
		} else {
			//echo "<pre>";
			//print_r($_POST);
		
			//echo "Payment error";
		
			//print_r($response);
			$response_str = json_encode($response);
			$newdata = array (
					'stripe_pay_response' => $response_str
			);
			$this->session->set_userdata ( $newdata );
			die("<meta http-equiv='refresh' content='0;url=/stripe_personal/response_page_fail'>");
		}
	}
	
	function payment_form_post ($stripe_account){
		echo "<pre>";
		print_r($_POST);
		// require_once(APPPATH.'libraries/stripe/Stripe.php');
		require_once (APPPATH . 'libraries/stripe/init.php');
	
		switch ($stripe_account) {
			case "us":
				$stripe = $this->Stripe->get_param_hms_billing();
				break;
			case "uk":
				$stripe = $this->Stripe->get_param_hms_billing_uk();
				break;
			default:
				die("Bill error");
				break;
		}
	
		\Stripe\Stripe::setApiKey($stripe['secret_key']);
	
		/*
		 *
		* $customer = \Stripe\Stripe_Customer::create(array(
				* 'email' => $_POST['stripeEmail'],
				* 'card' => $_POST['stripeToken']
				* ));
		*
		* $charge = \Stripe\Stripe_Charge::create(array(
				* 'customer' => $customer->id,
				* 'amount' => 2000,
				* 'currency' => 'uah'
				* ));
		*
		*/
		// $post = $this->input->post($_POST, true);
		$amount = $_POST['amount'];
		$currency = $_POST['currency'];

		 
		$hotel_id = 92;
	
		$invoice = $hotel_id . "-" . time();
		$charge = \Stripe\Charge::create(array(
				'amount' => $amount * 100,
				'currency' => $currency,
				'description' => "hms-" . $invoice,
				'metadata' => array(
						'order_id' => $invoice
				),
				'source' => $_POST['stripeToken'],
				'capture' => false,
				'statement_descriptor' => 'Custom descriptor',
				'metadata' => array('order_id' => "6735")
		));
		
		//
		//echo "++";
		$LastResponse = $charge->getLastResponse();
		$response = $LastResponse->json;
		print_r($response);
		die();
		
		
		if ($response["paid"] == 1) {
			/*
			 * ========= CAPTURE CHARGE ========
			 * 
			 */
			
			$charge_capture = \Stripe\Charge::retrieve($response["id"]);
			$charge_capture->capture();
			
			$LastResponse_capture = $charge_capture->getLastResponse();
			$response_capture = $LastResponse_capture->json;
			//print_r($response_capture);
			//die();
			
			//==========================================================
			
			$hotel_id = $this->config->item('hotel_id');
			$db3 = $this->load->database('db3', TRUE);
			$sql = "INSERT INTO test.billingdoc (hmsID, doctype, amount, ref, currency, datetime)
			VALUES('" . $hotel_id . "', '2', '" . $response["amount"] / 100 . "', '" . $response["id"] . "',
			'" . $response["currency"] . "', '" . date("Y-m-d H:i:s") . "')";
			// echo $sql;
			$query = $db3->query($sql);
			$billingdoc_id = $db3->insert_id();
			$sql = "INSERT INTO test.log (`user_id`, `time`, `billingdoc_id`, `operation`) VALUES('0', '" . date("Y-m-d H:i:s") . "', '" . $billingdoc_id . "',
				'new')";
	
			$query = $db3->query($sql);
	
			die("<meta http-equiv='refresh' content='0;url=/stripe_personal/response_page_ok'>");
		} else {
			//echo "<pre>";
			//print_r($_POST);
	
			//echo "Payment error";
	
			//print_r($response);
			$response_str = json_encode($response);
			$newdata = array (
					'stripe_pay_response' => $response_str
			);
			$this->session->set_userdata ( $newdata );
			die("<meta http-equiv='refresh' content='0;url=/stripe_personal/response_page_fail'>");
		}
	}
	
	function response_page_ok(){
		$data = array(
				
		);
		$this->load->library('parser');
		$this->load->view('stripe_personal_response_page_ok_view.php', $data);
	}
	
	function response_page_fail(){
		$data = array(
		
		);
		$this->load->library('parser');
		$this->load->view('stripe_personal_response_page_fail_view.php', $data);
	}
}
?>