<?php
require_once (APPPATH . 'libraries/stripe/init.php');
class Stripe_cron extends CI_Controller {
    public function __construct() {
        parent::__construct ();
        $this->load->model ( 'hotelix_config' );
        $this->load->model ( 'frontdesk' );
        $this->load->model ( 'stripe_billing_m' );
        $this->load->model ( 'hms_routing_m' );
        $this->stripe = new \Stripe\Stripe();
        $this->customer = new \Stripe\Customer();
    }

    function state_old ($db_name = "") {
        if ($db_name != ""){
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);
            $hms_id = 0;
            $host = "";
            $sql = "SELECT id, host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hms_id = $row->id;
                $host = $row->host;
            }
        }else{
            $hms_id = $this->config->item('hotel_id');
            $host = $this->config->item('host_name');
        }
        $trial_period = 30;
        $registration_date = $this->hotelix_config->get_record("registration_date");
        if ($registration_date == ""){
            $registration_date = $this->db->select('time')->get_where('visitka.users', array('site_address' => $host))->row()->time;
            $this->hotelix_config->set_record("registration_date", $registration_date);
        }
        $is_trial = ((strtotime("$registration_date + $trial_period day") - strtotime("now")) > 0) ? true : false;
        if ($is_trial){
            $this->hotelix_config->set_record("hms_allowed", 1, 'int');
            echo "hms_allowed = 1 <br> reg date: ", $registration_date, '<br>';
        }else{
            $this->hotelix_config->set_record("hms_route", "stripe_rate");
            echo "hms_allowed = 0 <br> reg date: ", $registration_date, '<br>';
            $stripe_region_id = $this->hotelix_config->get_record("stripe_region_id", 'int');
            if ($stripe_region_id == 0){
                $hotel_country = $this->frontdesk->get_visitka_id_country_3c($hms_id);
                $stripe_region_id = $this->db->select('region_id')->
                get_where('global_fms_base.dict_country', array('id' => $hotel_country))->row()->region_id;
                if ($stripe_region_id == 0){
                    $stripe_region_id = 17;//internstional Market
                }

                $this->hotelix_config->set_record("stripe_region_id", $stripe_region_id,  'int');
            }
            // 			$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
            // 			if ($stripe_billing_customer_id == ""){
            // 				$this->stripe_billing_m->create_customer(array('hms_id'=>$hms_id, 'host'=>$host));
            // 			}
            // 			$stripe_subscription_id = $this->hotelix_config->get_record("stripe_subscription_id");
            // 			if ($stripe_subscription_id != ""){
            // 				$this->hotelix_config->set_record("hms_allowed", 1, 'int');
            // 				echo "hms_allowed = 1 <br> reg stripe_subscription_id: ", $stripe_subscription_id;
            // 			}else{
            // 				$this->hotelix_config->set_record("hms_allowed", 0, 'int');
            // 				$this->hotelix_config->set_record("hms_route", "stripe_rate");
            // 				echo "hms_allowed = 0 <br> reg stripe_subscription_id: ", $stripe_subscription_id;
            // 			}
        }
        echo "<br><br>";
    }

    function state2 ($db_name = "", $docmc = 0) {

        $hotel_country = "???";

        if ($db_name != ""){
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);
            $hms_id = 0;
            $host = "";
            $sql = "SELECT id, host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hms_id = $row->id;
                $host = $row->host;
            }
        }else{
            $hms_id = $this->config->item('hotel_id');
            $host = $this->config->item('host_name');
        }
        $trial_period = 30;




        $registration_date = $this->hotelix_config->get_record("registration_date");
        if ($registration_date == ""){
            $registration_date = $this->db->select('time')->get_where('visitka.users', array('site_address' => $host))->row()->time;
            $this->hotelix_config->set_record("registration_date", $registration_date);
        }
        $is_trial = ((strtotime("$registration_date + $trial_period day") - strtotime("now")) > 0) ? true : false;
        if ($is_trial){
            $this->hotelix_config->set_record("hms_allowed", 1, 'int');
            //echo "hms_allowed = 1 <br> reg date: ", $registration_date, '<br>';
            echo "hms_id=" . $hms_id . " on trial" . "\n\n";
        }else{
            //echo "hms_allowed = 0 <br> reg date: ", $registration_date, '<br>';

            $stripe_region_id = $this->hotelix_config->get_record("stripe_region_id", 'int');
            if ($stripe_region_id == 0){
                $hotel_country = $this->frontdesk->get_visitka_id_country_3c($hms_id);
                $stripe_region_id = $this->db->select('region_id')->
                get_where('global_fms_base.dict_country', array('id' => $hotel_country))->row()->region_id;
                if ($stripe_region_id == 0){
                    $stripe_region_id = 17;//internstional Market
                }

                $this->hotelix_config->set_record("stripe_region_id", $stripe_region_id,  'int');
            }
            echo "sr_id=" . $stripe_region_id . " - hc=" . $hotel_country  . "\n\n";
            if ($docmc == 0) return ;
            if ($stripe_region_id == 17) {
                echo "sr_id=" . $stripe_region_id . " - UNDEFINED REGIONID\n\n";
                return ;
            }
            $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
            if ($stripe_billing_customer_id == ""){
                $this->stripe_billing_m->create_customer(array('hms_id'=>$hms_id, 'host'=>$host));
            }
            $stripe_subscription_id = $this->hotelix_config->get_record("stripe_subscription_id");
            if ($stripe_subscription_id != ""){
                $this->hotelix_config->set_record("hms_allowed", 1, 'int');
                //echo "hms_allowed = 1 <br> reg stripe_subscription_id: ", $stripe_subscription_id;
            }else{
                $this->hotelix_config->set_record("hms_allowed", 0, 'int');
                $this->hotelix_config->set_record("hms_route", "stripe_rate");
                //echo "hms_allowed = 0 <br> reg stripe_subscription_id: ", $stripe_subscription_id;
            }
        }

        $this->hotelix_config->set_record("lock_till_open", "2019-05-15");
        $this->hotelix_config->set_record("hms_billing_version", 2, "int");
        $this->hotelix_config->set_record("custom_debug", "hmsc2=true");

        //echo "<br><br>";
    }
    function set_property_params ($db_name = "") {
        if ($db_name != ""){
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);
            $hms_id = 0;
            $host = "";
            $sql = "SELECT id, host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hms_id = $row->id;
                $host = $row->host;
            }
        }else{
            $hms_id = $this->config->item('hotel_id');
            $host = $this->config->item('host_name');
        }
        $global_tbl_name = "`global_hotelix`.`stripe_billing_hms_ids`";
        $params_row = $this->db->get_where($global_tbl_name, array('hms_id'=>$hms_id))->row();
        if (!empty($params_row)){
            $this->hotelix_config->set_record("hms_property_count4stripe", $params_row->count, "int");
            $this->hotelix_config->set_record("hms_property_type4stripe", $params_row->type_id, "int");
            echo $hms_id, ' - ', $db_name, ' : prop_type_id - ', $params_row->type_id, '; count_apart - ',$params_row->count, '/n/n';
        }else{
            echo $hms_id, ' - ', $db_name, ' : NOT FOUND in',$global_tbl_name,' /n/n';
        }
    }
    function set_locktillopen ($db_name = "", $docmc = 0) {

        $hotel_country = "???";

        if ($db_name != ""){
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);
            $hms_id = 0;
            $host = "";
            $sql = "SELECT id, host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hms_id = $row->id;
                $host = $row->host;
            }
        }else{
            $hms_id = $this->config->item('hotel_id');
            $host = $this->config->item('host_name');
        }
        $trial_period = 30;


        $hms_allowed = $this->hotelix_config->get_record("hms_allowed", 'int');
        if ($hms_allowed == 0) {
            if ($docmc == 1) {
                $this->hotelix_config->set_record("lock_till_open", "2019-05-20");
                echo "done\n";
            } else {
                echo "\n\n";
                echo "some";
                echo "\n\n";
            }
        }


        //echo "<br><br>";
    }

    function store_hms_allow2db ($db_name = "", $docmc = 0) {

        $hotel_country = "???";

        if ($db_name != ""){
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);
            $hms_id = 0;
            $host = "";
            $sql = "SELECT id, host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hms_id = $row->id;
                $host = $row->host;
            }
        }else{
            $hms_id = $this->config->item('hotel_id');
            $host = $this->config->item('host_name');
        }
        $trial_period = 30;


        $hms_allowed = $this->hotelix_config->get_record("hms_allowed", 'int');
        $hms_billing_version = $this->hotelix_config->get_record("hms_billing_version", "int");
        $this->db->query("update global_hotelix.stripe_billing_hms_ids set hms_allowed = " . $hms_allowed . " where hms_id=" . $hms_id);
        $this->db->query("update global_hotelix.stripe_billing_hms_ids set hms_billing_version = " . $hms_billing_version . " where hms_id=" . $hms_id);
        echo $hms_allowed . " - " . $hms_billing_version . "\n";


        //echo "<br><br>";
    }

    function state ($db_name = "local", $temp_expand_lock_days = "") {
        $data = array();
        //21.06.19 дія для розширення часу блокування тих хто не проплатив вчасно, теоретично викинути при відсутності потреби через 1-2 місяці
        if ($temp_expand_lock_days != ""){
            $data['temp_expand_lock_days'] = (int)$temp_expand_lock_days;
        }
        if ($db_name != "local"){
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);
            $hms_id = 0;
            $host = "";
            $sql = "SELECT id, host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $data['hms_id'] = $row->id;
                $data['host_name'] = $row->host;
            }
            $this->config->set_item('hotel_id', $data['hms_id']);
        }
        if ($this->hotelix_config->get_record("hms_billing_version", "int") == 2){//#tasks/15069760
            $this->hotelix_config->set_record("lock_status",  0, "int");
        }
        echo $this->hms_routing_m->check_states_set_routing($data);
        echo "\n";
    }

    function update_visitka_bill_version($db_name = ""){
        if ($db_name != ""){
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);
            $hms_id = 0;
            $sql = "SELECT id, host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hms_id = $row->id;

                $hms_billing_version = $this->hotelix_config->get_record("hms_billing_version", "int");

                // save in visitka.config
                $this->db->update('visitka.config', array('hms_billing_version'=>$hms_billing_version), array('id'=>$hms_id));
            }
        }
    }

    function update_bill_version($db_name) {
        $config = array();
        $config['hostname'] = $this->config->item('visitka_host');
        $config['username'] = $this->config->item('visitka_user');
        $config['password'] = $this->config->item('visitka_pass');
        $config['database'] = $db_name;
        $config['dbdriver'] = "mysqli";
        $config['dbprefix'] = "";
        $config['pconnect'] = FALSE;
        $config['db_debug'] = TRUE;
        $config['cache_on'] = FALSE;
        $config['cachedir'] = "";
        $config['char_set'] = "utf8";
        $config['dbcollat'] = "utf8_general_ci";
        $this->db = $this->load->database($config, true);
        $hms_id = 0;
        $host = "";
        $sql = "SELECT id, host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hms_id = $row->id;
            $host = $row->host;
        }

        $hms_billing_version = $this->hotelix_config->get_record("hms_billing_version", "int");
        $this->db->query("update visitka.config set hms_billing_version=" . $hms_billing_version . " where id=" . $hms_id);
        echo $hms_id . " -> " . $hms_billing_version . "\n";

    }

    function set_coupon ($db_name = "local") {
        if (!in_array($db_name, array("local", ""))){
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);
            $hms_id = 0;
            $host = "";
            $sql = "SELECT id, host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hms_id = $row->id;
                $host = $row->host;
            }
            $this->config->set_item('hotel_id', $hms_id);

        }else{
            $hms_id = $this->config->item('hotel_id');
            $host = $this->config->item('host_name');
        }
        $tbl_name = "`global_hotelix_stripe`.`coupon4customers`";
        $record = $this->db->get_where($tbl_name, array('hms_id' => $hms_id))->result_array();
        if (!empty($record)){
            $this->hotelix_config->set_record("hms_billing_version",  2, "int");

            $lock_till_open_date = date("Y-m-d", strtotime("+ 3 days"));
            $this->hotelix_config->set_record("lock_till_open",  $lock_till_open_date);

            $secret_key = $this->stripe_billing_m->get_secret_key();

            echo "\n\n" . $secret_key . "\n\n";
            $this->stripe->setApiKey($secret_key);
            $customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
            if($customer_id != ""){
                $response = $this->customer->update($customer_id, array('coupon' => $record[0]['coupon']));
                $customer = $response->__toArray(true);
            }else {
                $this->stripe_billing_m->create_customer(array('hms_id'=>$hms_id, 'host'=>$host, 'coupon' => $record[0]['coupon']));
            }
            //Витирати з таблиці ті записи для яких купон проставлено щоб по другому колу не ставити?
        }
        else {
            echo $hms_id . " NOT IN " . $tbl_name . "\n";
        }
    }

    function make_acts ($db_name = "local", $past_days = 1, $debug = "") {// to trunc table "stripe_acts" debug mast be 'trunc_acts_tbl'
        if (!in_array($db_name, array("local", ""))){
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);
            $hms_id = 0;
            $host = "";
            $sql = "SELECT id, host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hms_id = $row->id;
                $host = $row->host;
            }
            $this->config->set_item('hotel_id', $hms_id);
        }else{
            $hms_id = $this->config->item('hotel_id');
            $host = $this->config->item('host_name');
        }
        $data = array('past_days' => $past_days, 'debug' => $debug);
        $res_arr = $this->stripe_billing_m->make_act_by_cron($data);
        if (!empty($res_arr)){
            echo "$hms_id $host ACTS WAS INSERTED TO `stripe_acts`: \n";
            print_r($res_arr);
            echo "/n";
        }else {
            echo "$hms_id $host NOTING WAS INSERTED TO `stripe_acts` \n";
        }
    }

    function ajustment_08_19($debug="") {//корегування по таблиці ехель
        // 		$tbl = '`global_hotelix_stripe`.`ajustment4customers2`';
        $tbl = '`global_hotelix_analitycs`.`ajustment4customers2`';
        $hotels_list = $this->db->get($tbl)->result();
        $config = array();
        $config['hostname'] = $this->config->item('visitka_host');
        $config['username'] = $this->config->item('visitka_user');
        $config['password'] = $this->config->item('visitka_pass');
        $config['dbdriver'] = "mysqli";
        $config['dbprefix'] = "";
        $config['pconnect'] = FALSE;
        $config['db_debug'] = TRUE;
        $config['cache_on'] = FALSE;
        $config['cachedir'] = "";
        $config['char_set'] = "utf8";
        $config['dbcollat'] = "utf8_general_ci";

        echo "<pre>";
        foreach ($hotels_list as $hotel) {
            $vis_data = $this->db->select('db_name, host, id_country_3c, hms_billing_version')->get_where('visitka.config', array('id'=>$hotel->hms_id))->row();
            $db_name = $vis_data->db_name;
            $vis_country = $vis_data->id_country_3c;
            $vis_host = $vis_data->host;
            $vis_billing_version = $vis_data->hms_billing_version;
            $config['database'] = $db_name;
            $this->db = $this->load->database($config, true);
            $this->config->set_item('hotel_id', $hotel->hms_id);
            $region_id = $this->hotelix_config->get_record("stripe_region_id", "int");
            $customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
            $subscription_id = $this->hotelix_config->get_record("stripe_subscription_id", "str");
            $hms_billing_version = $this->hotelix_config->get_record("hms_billing_version", "int");
            if ($debug != "nodebug"){
                echo $hotel->hms_id, " - bill_ver: $hms_billing_version<>$vis_billing_version", " - ", $hotel->country, "<>", $vis_country, " - reg_id:", $region_id, " - ", $customer_id, " - ", $subscription_id, "<br>";
            }
            if ($debug == "nodebug"){
                //===== updating hms_billing_version to val=2 in visitka and local hotelix_config START ====
                $update_visitka_arr = array (
                    'hms_billing_version' => 2,
                );
                $this->db->update('visitka.config', $update_visitka_arr, array('id'=>$hotel->hms_id));
                $this->hotelix_config->set_record("hms_billing_version", 2, "int");
                echo $hotel->hms_id, " WAS UPDATED: hotelix_config->hms_billing_version=2 and visitka.config->hms_billing_version=2 <br>";
                //===== updating hms_billing_version to val=2 in visitka and local hotelix_config FINAL ====
                $coupon = $hotel->coupon;
                if (empty($customer_id)){
                    $secret_key = $this->stripe_billing_m->get_secret_key();
                    $this->stripe->setApiKey($secret_key);
                    $param = array('hms_id'=>$hotel->hms_id, 'host'=>$vis_host);
                    if ($coupon != "" && $coupon != 'fFbW7rl0'){
                        $param['coupon']=$coupon;
                    }
                    $customer_arr = $this->stripe_billing_m->create_customer($param);
                    if (isset($customer_arr['id'])){
                        $update_hotelix_config_arr = array (
                            array (
                                'name' => 'stripe_billing_customer_id',
                                'str_value' => $customer_arr['id']
                            ),
                            array (
                                'name' => 'stripe_region_id',
                                'value' => $this->stripe_billing_m->get_property_region_id_for_plans($vis_country)
                            ),
                            array (
                                'name' => 'stripe_billing_offline',
                                'value' => ($hotel->billing == 1) ? 1 : 0
                            ),
                            array (
                                'name' => 'hms_allowed',
                                'value' => 0
                            ),
                            array (
                                'name' => 'lock_till_open',
                                'str_value' => '2019-08-09'
                            )
                        );
                        $this->db->update_batch('hotelix_config', $update_hotelix_config_arr, 'name');
                        echo "CUSTOMER WAS CREATED: ", $customer_arr['id'], "WITH DATA: <br>";
                        print_r($param);
                        echo "hotelix_config WAS UPDATED: <br>";
                        print_r($update_hotelix_config_arr);
                    }
                }else{//is customer
                    $billing_offline = ($hotel->billing == 1) ? 1 : 0;
                    $this->hotelix_config->set_record("stripe_billing_offline", $billing_offline, "int");
                    echo "hotelix_config WAS UPDATED: stripe_billing_offline=$billing_offline <br>";
                    // 					if ($coupon != ""){
                    // 						$secret_key = $this->stripe_billing_m->get_secret_key();
                    // 						$this->stripe->setApiKey($secret_key);
                    // 						$customer_obj = $this->customer->update($customer_id, array('coupon'=>$coupon));
                    // 						$customer_arr = $customer_obj->__toArray(true);
                    // 						echo "CUSTOMER WAS UPDATED: ", $customer_arr['id'], "WITH DATA: <br>";
                    // 						print_r(array('coupon'=>$coupon));
                    // 					}
                }
            }
        }
    }

    function clear_test_customers_ajustment_08_19($debug="") {//корегування курчавих кастомерів після корегування)))) попали в ТЕСТ режим
        // 		$tbl = '`global_hotelix_stripe`.`ajustment4customers2`';
        $tbl = '`global_hotelix_analitycs`.`TEMP_TBL`';
        $hotels_list = $this->db->get($tbl)->result();
        $config = array();
        $config['hostname'] = $this->config->item('visitka_host');
        $config['username'] = $this->config->item('visitka_user');
        $config['password'] = $this->config->item('visitka_pass');
        $config['dbdriver'] = "mysqli";
        $config['dbprefix'] = "";
        $config['pconnect'] = FALSE;
        $config['db_debug'] = TRUE;
        $config['cache_on'] = FALSE;
        $config['cachedir'] = "";
        $config['char_set'] = "utf8";
        $config['dbcollat'] = "utf8_general_ci";

        echo "<pre>";
        foreach ($hotels_list as $hotel) {
            $vis_data = $this->db->select('db_name, host, id_country_3c, hms_billing_version')->get_where('visitka.config', array('id'=>$hotel->hms_id))->row();
            $db_name = $vis_data->db_name;
            $config['database'] = $db_name;
            $this->db = $this->load->database($config, true);
            $this->config->set_item('hotel_id', $hotel->hms_id);

            echo "<br>", $hotel->hms_id, "CUS WAS: ", $this->hotelix_config->get_record("stripe_billing_customer_id", "str");

            if ($debug == "nodebug"){
                $this->hotelix_config->set_record("stripe_billing_customer_id", "", "str");
            }
            echo "    CUS IS: ", $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
        }
    }

    function fix_subscription ($db_name = "") {
        if ($db_name != ""){
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);
            $hms_id = 0;
            $host = "";
            $sql = "SELECT id, host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hms_id = $row->id;
                $host = $row->host;
            }
        }else{
            $hms_id = $this->config->item('hotel_id');
            $host = $this->config->item('host_name');
        }
        $customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
        $sub_id = $this->hotelix_config->get_record("stripe_subscription_id");
        if (!empty($customer_id) && empty($sub_id)){
            $secret_key = $this->stripe_billing_m->get_secret_key();
            $this->stripe->setApiKey($secret_key);
            $customer_data = $this->customer->retrieve($customer_id)->__toArray(true);
            foreach ($customer_data['subscriptions']['data'] as $sub_data) {
                if(isset($sub_data['metadata']['is_main']) && $sub_data['metadata']['is_main'] == 1 ){
                    $sub_id = $sub_data['id'];
                    $this->hotelix_config->set_record("stripe_subscription_id", $sub_id, "str");
                    echo "$hms_id $host IS CUSTOMER $customer_id AND SUBSCRIPTION WAS FIXED: $sub_id\n";
                }
            }
            if (empty($sub_id)){
                echo "$hms_id $host CUSTOMER: $customer_id NOTHING TO FIX WITH SUBSCRIPTION\n";
            }
        }else{
            echo "$hms_id $host NOTHING TO FIX WITH SUBSCRIPTION\n";
        }
    }

    public function check_subscription_quantity($db_name = '') {
        if ($db_name != ""){
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);
            $hms_id = 0;
            $host = "";
            $sql = "SELECT id, host, id_country_3c FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
            $query_row = $this->db->query($sql)->row();
            if ($query_row) {
                $hms_id = $query_row->id;
                $host = $query_row->host;
                $country = $query_row->id_country_3c;
            }
        }else{
            $hms_id = $this->config->item('hotel_id');
            $host = $this->config->item('host_name');
        }
        $customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
        $sub_id = $this->hotelix_config->get_record("stripe_subscription_id");

        $account_id = 0;
        if ($customer_id != '' && $sub_id != '') {
            if (php_sapi_name() === 'cli') {
                $region_id = $this->stripe_billing_m->get_property_region_id_for_plans($country);
                $query_row = $this->db->select('account_id')->get_where('global_hotelix.stripe_region2account', ['region_id' => $region_id])->row();
                if ($query_row) {
                    $account_id = $query_row->account_id;
                }
            }
            $secret_key = $this->stripe_billing_m->get_secret_key($account_id);
            $this->stripe->setApiKey($secret_key);



            $sub = new \Stripe\Subscription();
            $sub = $sub->retrieve( $sub_id );
            $has_tiers = (isset($sub->plan->tiers) && !is_null($sub->plan->tiers)) ? true : false;
            if ($has_tiers) {
                $price_count = $this->hotelix_config->get_record("hms_property_count4stripe", "int");
                $price_count = $price_count != 0 ? $price_count : 1;
                if ($price_count != $sub->quantity) {
                    $sub->quantity = $price_count;
                    $sub->prorate = true;
                    $sub->save();
                    $this->create_quantity_proration_invoice($customer_id, $account_id);
                    echo "proration " . $price_count . " - " . $sub->quantity;
                } else {
                    echo $price_count . " - " . $sub->quantity;
                }
            }else {
                echo 'Plan has no tiers';
            }
        } else {
            echo "fail";
        }

    }

    public function create_quantity_proration_invoice($customer_id = '', $account_id = 0) {
        $secret_key = $this->stripe_billing_m->get_secret_key($account_id);
        $this->stripe->setApiKey($secret_key);
        $customer_id = $customer_id != '' ? $customer_id : $this->hotelix_config->get_record("stripe_billing_customer_id");
        $invoice_item = new \Stripe\InvoiceItem();
        $invoice_items = $invoice_item->all([
            'customer' => $customer_id,
            'pending' => true
        ]);
        $inv_sum = 0;
        foreach ($invoice_items['data'] as $item) {
            $inv_sum += $item['amount'];
        }
        if ($inv_sum > 0) {
            $invoice = new \Stripe\Invoice();
            $inv = $invoice->create([
                'customer' => $customer_id,
                'description' => 'Additional apartment',
                'pending_invoice_items_behavior' => 'include',
                'collection_method' => 'send_invoice', 'days_until_due' => 7]);
            // collection_method - need from customer, days_until_due only if send_invoice !!!

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.stripe.com/v1/invoices/' . $inv->id . '/finalize');
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_USERPWD, $secret_key . ": ");
            curl_setopt($ch, CURLOPT_POST, true);
            $buffer = curl_exec($ch);
            curl_close($ch);
            echo $buffer;
        }
    }

    public function finalize_invoice($invoice_id = '') {
        if ($invoice_id == "") {
            return;
        }
        $secret_key = $this->stripe_billing_m->get_secret_key();
        $this->stripe->setApiKey($secret_key);
        $customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");




        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.stripe.com/v1/invoices/' . $invoice_id . '/finalize');
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_USERPWD, $secret_key . ": ");
        curl_setopt($ch, CURLOPT_POST, true);
        $buffer = curl_exec($ch);
        curl_close($ch);
        echo $buffer;

    }

    public function collect_subscriptions_with_expired_invoices($db_name = '') {
        if ($db_name != ""){
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);
            $hms_id = 0;
            $sql = "SELECT id, host, id_country_3c FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
            $query_row = $this->db->query($sql)->row();
            if ($query_row) {
                $hms_id = $query_row->id;
                $country = $query_row->id_country_3c;
            }
        }else{
            $hms_id = $this->config->item('hotel_id');
        }
        $customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
        $sub_id = $this->hotelix_config->get_record("stripe_subscription_id");
        if ($customer_id != '' && $sub_id != '') {
            $account_id = 0;
            $tbl = 'global_hotelix_stripe.subscriptions_with_expired_invoices';
            $limit_expired_days = 30;
            $created_timestamp = strtotime("now - $limit_expired_days days");
            if (php_sapi_name() === 'cli') {
                $region_id = $this->stripe_billing_m->get_property_region_id_for_plans($country);
                $query_row = $this->db->select('account_id')->get_where('global_hotelix.stripe_region2account', ['region_id' => $region_id])->row();
                if ($query_row) {
                    $account_id = $query_row->account_id;
                }
            }
            $secret_key = $this->stripe_billing_m->get_secret_key($account_id);
            $this->stripe->setApiKey($secret_key);
            $invoice = new \Stripe\Invoice();
            $expired_invoices = $invoice->all([
                'customer' => $customer_id,
                'status' => 'open',
                "created" => [
                    "lte" => $created_timestamp
                ]
            ])->__toArray();

            if (isset($expired_invoices['data']) && count($expired_invoices['data'])) {
                $this->db->delete($tbl, ['hms_id' => $hms_id]);
                $this->db->insert($tbl, [
                    'hms_id' => $hms_id,
                    'db_name' => $db_name,
                    'invoices_body' => json_encode($expired_invoices)
                ]);
                echo "EXPIRED HMS = $hms_id, customer = '$customer_id' and subscription = '$sub_id'<br>\n";
            }else {
                //NO EXPIRED INVOICES
                $this->db->delete($tbl, ['hms_id' => $hms_id]);
                echo "DELETED FROM EXPIRERS HMS = $hms_id, customer = '$customer_id' and subscription = '$sub_id'<br>\n";
            }

        } else {
            echo "fail, $hms_id has customer = '$customer_id' and subscription = '$sub_id'<br>\n";
        }

    }
    
    public function state_3($db_name = '') {
        if ($db_name != ""){
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);
             
            $hms_id = 0;
            $sql = "SELECT id, host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
            $query_row = $this->db->query($sql)->row();
            if ($query_row) {
                $hms_id = $query_row->id;
            }
    
            $lock_till_open = $this->hotelix_config->get_record("lock_till_open");
            $hms_allowed = $this->hotelix_config->get_record("hms_allowed", "int");
    
            $data = array(
                'lock_till_open' => $lock_till_open,
                'hms_allowed' => $hms_allowed
            );
    
            $this->db->where('id', $hms_id);
            $this->db->update('visitka.config', $data);
    
    
        }
    }
    

}