<?php
use Stripe\ApiOperations\Retrieve;
//error_reporting(E_ALL);
class Stripe_concept2 extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->model('stripe_billing_m2');
        $this->load->model('loger_admin');
        $this->load->model('mlanguages');
        $this->load->model('frontdesk');
        $this->load->model('frontdesk_c2');
        $this->load->model('htmltpl');
        $this->load->model('releases');
        $this->load->model('Authorization');
        $this->load->model('appex');
        $this->load->model('mandarin_pay');
        $this->Authorization->IsLogined();
        $this->stripe = new \Stripe\Stripe();
        $this->customer = new \Stripe\Customer();
        $this->charge = new \Stripe\Charge();
        $this->invoice = new \Stripe\Invoice();
        $this->invoice_item = new \Stripe\InvoiceItem();
        $this->plan = new \Stripe\Plan();
        $this->subscription = new \Stripe\Subscription();
        $this->subscription_item = new \Stripe\SubscriptionItem();
        $this->payment_method = new \Stripe\PaymentMethod();
        $this->payment_intent = new \Stripe\PaymentIntent();
    }
    
    public function set_test_mode() {
        $test_mode = false;
        if ($_SESSION['user']['login'] && $_SESSION['user']['login'] == 'support@otelms.com') {
            if ($this->session->userdata('global_debug') && $_SERVER['HTTP_HOST'] == 'amironova.otelms.com') {
                $test_mode = true;
                error_reporting(E_ALL);
            }
        }
        return $test_mode;
    }
    
    function pdf_invoice( $invoice_id, $country_marker="" ){
        if(in_array($country_marker, ['BLR', 'ABH'])){
            $country_marker = 'RUS';
        }
        $special_countries_arr = array('RUS', 'UKR');
        $is_hotel_country_in_specials = false;
        if(in_array($country_marker, $special_countries_arr)){
            $is_hotel_country_in_specials = true;
        }
        $euro_countries_arr = ["ALB","AUT","BEL","BGR","CHE","CZE","DEU","DNK","EST","FIN","FRA","GRC","HRV","HUN","IRL","ITA","LTU","LVA","MNE","PRT","ROU","SVN","SWE"];
        $is_hotel_country_in_euro_countries = false;
        if(in_array($country_marker, $euro_countries_arr)){
            $is_hotel_country_in_euro_countries = true;
        }
        $secret_key = $this->stripe_billing_m2->get_secret_key();
        $this->stripe->setApiKey($secret_key);
        $invoice_obj = $this->invoice->retrieve($invoice_id);
        $invoice = $invoice_obj->__toArray(true);
        // 		$payment_intent = $this->payment_intent->retrieve($invoice['payment_intent'])->__toArray(true);
        // 		$payment_method = $this->payment_method->retrieve($payment_intent['payment_method'])->__toArray(true);
        $customer_id = $invoice['customer'];
        $customer_obj = $this->customer->retrieve($customer_id);
        $customer = $customer_obj->__toArray(true);
        $p_data = array(
            'legal_name' => '',
            'addrLine1' => '',
            'addrLine2' => '',
            'city' => '',
            'state' => '',
            'postcode' => '',
            'DOC_INN' => ''
        );
        $p_address_data = [
            'addrLine1',
            'addrLine2',
            'city',
            'state',
            'postcode'
        ];
        $tbl_1 = "partners";
        $sql = "SELECT $tbl_1.name as legal_name, $tbl_1.addrLine1, $tbl_1.addrLine2, $tbl_1.city, $tbl_1.state, $tbl_1.postcode, $tbl_1.DOC_INN
        FROM $tbl_1
        ORDER BY isdefault DESC";
        $partner = $this->db->query($sql)->row();
        if(!empty($partner)){
            foreach ($partner as $fild => $val) {
                if (!empty($val)){
                    $p_data[$fild] = $val;
                }
            }
        }
        $data = array();
        $data['hms_id'] 		= $this->config->item('hotel_id');
        $data['number'] 		= $invoice['number'];
        $data['currency'] 		= strtoupper($invoice['currency']);
        $data['amount_due'] 	= number_format($invoice['amount_due']/100, 2, '.',',');
        $data['date'] 			= ($invoice['due_date'] != null) ? date('F d, Y', $invoice['due_date']) : date('F d, Y', $invoice['date']);
        $data['date'] 			= ($is_hotel_country_in_specials)? date('d.m.Y', $invoice['date']) : date('F d, Y', $invoice['date']);
        $data['description'] 	= $customer['description'];
        $data['legal_name']     = $p_data['legal_name'];
        $data['address']        = "";
        foreach ($p_address_data as $addr_fild) {
            if (!empty($p_data[$addr_fild])){
                $data['address'] .= $p_data[$addr_fild]."<br>";
            }
        }
        $data['DOC_INN'] = $p_data['DOC_INN'];
        $data['tax_type'] 		= $customer['tax_info']['type'];
        $data['tax_id'] 		= $customer['tax_info']['tax_id'];
        if (!empty($invoice['discount'])){
            $data['discount']		= $invoice['discount']['coupon']['percent_off'] != null ?
            $invoice['discount']['coupon']['percent_off'] ." %" : $data['currency']." ".number_format($invoice['discount']['coupon']['amount_off']/100, 2, '.',',');
            $data['discount_hide']	= "";
        }else{
            $data['discount']		= '0.00 %';
            $data['discount_hide']	= 'style="display:none;"';
        }
        $data['subtotal'] 		= number_format($invoice['subtotal']/100, 2, '.', ',');
        $data['total'] 		= number_format($invoice['total']/100, 2, '.', ',');
        $data['tax_percent'] 	= $invoice['tax_percent'] != null ? number_format($invoice['tax_percent']/100, 2, '.', ',') : '0.00';
        $data['tax'] 			= $invoice['tax'] != null ? number_format($invoice['tax']/100, 2, '.', ',') : '0.00';
        $data['tax_hide']		= ($invoice['tax'] != null || $invoice['tax_percent'] != null) ? "" : 'style="display:none;"';
        $data['applied_balance']= number_format(($invoice['starting_balance']-$invoice['ending_balance'])/100, 2, '.', ',');
        $clt_from = 'From';
        $clt_to = 'to';
        switch ($country_marker) {
            case 'ESP':
                $clt_from = $this->mlanguages->getdictionaryword('ajax_window_price', "spa", 'caption_mr_from');
                $clt_to = $this->mlanguages->getdictionaryword('reviews_rlist', "spa", 'caption_to');
                break;
                //             case 'POL':
                //                 $clt_from = $this->mlanguages->getdictionaryword('ajax_window_price', "pol", 'caption_mr_from');
                //                 $clt_to = $this->mlanguages->getdictionaryword('reviews_rlist', "pol", 'caption_to');
                //                 break;
        }
        foreach( $invoice['lines']['data'] as $k => $v ){
            $i = $k+ 1;
            $data['invoice_lines'][$k]['counter'] 		= $i;
            $data['invoice_lines'][$k]['quantity'] 		= $v['quantity'];
            $clt_month_name_period_start = date('F', $v['period']['start']);
            $clt_month_name_period_end = date('F', $v['period']['end']);
            switch ($country_marker) {
                case 'ESP':
                    $clt_month_name_period_start = $this->mlanguages->getdictionaryword('mlw', "spa", 'mlw_month_'.strtolower($clt_month_name_period_start));
                    $clt_month_name_period_end = $this->mlanguages->getdictionaryword('mlw', "spa", 'mlw_month_'.strtolower($clt_month_name_period_end));
                    break;
                    //                 case 'POL':
                    //                     $clt_month_name_period_start = $this->mlanguages->getdictionaryword('mlw', "pol", 'mlw_month_'.strtolower(date('F', $v['period']['start'])));
                    //                     $clt_month_name_period_end = $this->mlanguages->getdictionaryword('mlw', "pol", 'mlw_month_'.strtolower(date('F', $v['period']['end'])));
                    //                     break;
            }
            $data['invoice_lines'][$k]['details'] 		= $v['description'].
            '<br/>(<b>'.$clt_from.'</b> ' . $clt_month_name_period_start.date(' d, Y', $v['period']['start']). ' <b>'.$clt_to.'</b> ' . $clt_month_name_period_end.date(' d, Y', $v['period']['end']) . ')';
            $data['invoice_lines'][$k]['price'] 		= number_format($v['amount']/$v['quantity']/100, 2, '.', ',');
            $data['invoice_lines'][$k]['summ']			 = number_format($v['amount']/100, 2, '.', ',');
            $data['invoice_lines_special_country'] = array();
            if($is_hotel_country_in_specials){
                $data['invoice_lines_special_country'][0]['datefrom'] = date('d.m.Y', $v['period']['start']);
                $data['invoice_lines_special_country'][0]['dateto'] = date('d.m.Y', $v['period']['end']);
                $month_count = round(($v['period']['end']-$v['period']['start'])/2678400);
                $data['invoice_lines_special_country'][0]['month_count'] = $month_count;
                $data['invoice_lines_special_country'][0]['price_amount'] = round($invoice['amount_due']/(100 *  $month_count) ,2);
            }
        }
        if ($country_marker == 'debug'){
            echo "<pre>";
            print_r($customer);
            print_r($invoice);
            print_r($data);
            die("DIED by A Department on stripe_concept2.php pdf_invoice() at 14 апр. 2020 г. 11:24:32");
        }
        $template_file = 'pdf_invoice.html';
        if($is_hotel_country_in_specials){
            $template_file = "pdf_invoice_".strtolower($country_marker).".html";
            switch ($country_marker) {
                case "RUS":
                    $spelling_lang = 'ru';
                    $agast_date = '2022-06-01';
                    $invoice_date = date('Y-m-d', $invoice['date']);
                    if ($invoice_date > $agast_date) {
                        $template_file = "pdf_invoice_".strtolower($country_marker)."_agast.html";
                    }
                    break;
                case "UKR":
                    $spelling_lang = 'ua';
                    break;
                default:
                    $spelling_lang = 'ru';
                    break;
            }
            $data['applied_balance_str'] = $this->frontdesk->num2str($invoice['amount_due']/100, $spelling_lang);
        } elseif ($invoice['collection_method'] == 'send_invoice') {
            if ($is_hotel_country_in_euro_countries) {
                $template_file = "pdf_invoice_euro.html";
            }else{
                if (in_array($country_marker, array('POL', 'ESP'))){
                    $template_file = "pdf_invoice_" . strtolower($country_marker) . ".html";
                }
            }
        }
        $template = $this->parser->parse("/templates/stripe_concept2/$template_file", $data, true);
        $this->load->library('m_pdf');
        $this->m_pdf->pdf->WriteHTML($template);
        $this->m_pdf->pdf->Output(' ','I');
    }
    
    public function pdf_act($invoice_number = '', $country = '') {
        
        $country = strtolower($country);
        $supported_countries = ['ukr', 'rus'];
        $tbl_acts = "stripe_acts";
        $agast_file_name_apendix = '';
        $act = $this->db->get_where($tbl_acts, ['act_number'=> "A-$invoice_number"])->row();
        if (in_array($country, $supported_countries) && $act){
            $act = json_decode($act->data);
            switch ($country) {
                case "ukr":
                    $spelling_lang = 'ua';
                    $currency = 'ГРН';
                    break;
                default:
                    $spelling_lang = 'ru';
                    $currency = 'RUB';
                    $agast_date = '2022-06-01';
                    if ($act->act_date > $agast_date) {
                        $agast_file_name_apendix = '_agast';
                    }
                    break;
            }
            $act->count = 1;
            $act->units = 'шт.';
            $act->currency = $currency;
            $act->price = $act->amount;
            $spelling_amount = str_replace(',', '', $act->amount);
            $act->spelling_amount_str = $this->frontdesk->num2str($spelling_amount, $spelling_lang);
            $act->hms_id = $this->config->item('hotel_id');
            $registration_date = $this->hotelix_config->get_record("registration_date");
            if ($registration_date == ""){
                $host = $_SERVER["HTTP_HOST"];
                $registration_date = $this->db->select('time')->get_where('visitka.users', array('site_address' => $host))->row()->time;
                $this->hotelix_config->set_record("registration_date", $registration_date);
            }
            $act->hms_registration_date = date('Y-m-d', strtotime($registration_date));
            $template = $this->parser->parse("/templates/stripe_concept2/pdf_act_$country$agast_file_name_apendix.html", $act, true);
            $this->load->library('m_pdf');
            $this->m_pdf->pdf->WriteHTML($template);
            $this->m_pdf->pdf->Output(' ','I');
        }else{
            die ( "<meta http-equiv='refresh' content='0; url=/stripe_concept2/invoices'>" );
        }
    }
    
    function pdf_charge( $charge_id ){
        $secret_key = $this->stripe_billing_m2->get_secret_key();
        $this->stripe->setApiKey($secret_key);
        //=======наразі буде виводитись інвойс, з часом треба допиляти STR
        $charge_obj = $this->charge->retrieve($charge_id);
        $charge = $charge_obj->__toArray(true);
        $invoice_id = $charge['invoice'];
        //=======наразі буде виводитись інвойс, з часом треба допиляти FIN
        $invoice_obj = $this->invoice->retrieve($invoice_id);
        $invoice = $invoice_obj->__toArray(true);
        $customer_id = $invoice['customer'];
        $customer_obj = $this->customer->retrieve($customer_id);
        $customer = $customer_obj->__toArray(true);
        $data = array();
        $data['number'] 		= $invoice['number'];
        $data['currency'] 		= strtoupper($invoice['currency']);
        $data['amount_due'] 	= number_format($invoice['amount_due']/100, 2, '.',',');
        $data['date'] 			= (null != $invoice['due_date']) ? date('F d, Y', $invoice['due_date']) : date('F d, Y', $invoice['date']);
        $data['description'] 	= $customer['description'];
        $data['hms_id'] 		= isset($customer['metadata']['hms_id']) ? $customer['metadata']['hms_id'] : null;
        $data['addr_line_1'] 	= $customer['shipping']['address']['line1']	. (null != $customer['shipping']['address']['line1']) ? ',' : '';
        $data['addr_line_2'] 	= $customer['shipping']['address']['line2'];
        $data['city'] 			= $customer['shipping']['address']['city'];
        $data['tax_type'] 		= $customer['tax_info']['type'];
        $data['tax_id'] 		= $customer['tax_info']['tax_id'];
        $data['discount']		= $invoice['discount']['coupon']['percent_off'] != null ? $invoice['discount']['coupon']['percent_off'] ."%" : '';
        $data['subtotal'] 		= number_format($invoice['subtotal']/100, 2, '.', ',');
        $data['tax_percent'] 	= $invoice['tax_percent'] != null ? number_format($invoice['tax_percent']/100, 2, '.', ',') : '0.00';
        $data['tax'] 			= $invoice['tax'] != null ? number_format($invoice['tax']/100, 2, '.', ',') : '0.00';;
        foreach( $invoice['lines']['data'] as $k => $v ){
            $i = $k+ 1;
            $data['invoice_lines'][$k]['counter'] 		= $i;
            $data['invoice_lines'][$k]['quantity'] 		= $v['quantity'];
            $data['invoice_lines'][$k]['details'] 		= $v['plan']['nickname']
            . '<br/>(<b>From</b> ' . date('F d, Y', $v['period']['start'])
            . ' <b>to</b> ' . date('F d, Y', $v['period']['end']) . ')';
            $data['invoice_lines'][$k]['price'] 		= number_format($v['amount']/$v['quantity']/100, 2, '.', ',');
            $data['invoice_lines'][$k]['summ']			 = number_format($v['amount']/100, 2, '.', ',');
        }
        $template = $this->parser->parse('/templates/stripe_concept2/pdf_invoice.html', $data, true);
        $this->load->library('m_pdf');
        $this->m_pdf->pdf->WriteHTML($template);
        $this->m_pdf->pdf->Output(' ','I');
    }
    
    function basic_data() {
        $data = array();
        $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
        $data['stripe_billing_customer_id'] = $stripe_billing_customer_id;
        $this->load->library ( 'parser' );
        $this->load->view ( 'stripe_concept2/basic_data_view.php', $data );
    }
    function basic_data_post() {
        $post = $_POST;
        $this->frontdesk_c2->stripe_save_basic_data($post);
        die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept2/basic_data'>" );
    }
    function summary() {
        $this->hms_routing_m2->check_states_set_routing();
        if (isset ( $_POST ["card_error"] ) && !empty($_POST ["card_error"])) {
            $this->session->set_userdata(array("header_msg_text"=>"{".$_POST ["card_error"]."}"));
        }
        $data = array();
        $this->load->library ( 'parser' );
        $this->load->view ( 'stripe_concept2/summary_view.php', $data );
    }
    function plans($debug_now_time = '') {//TEMP for debuging change now time
        $this->hms_routing_m2->check_states_set_routing();
        $data = array();
        //TEMP for debuging change now time
        $data['debug_now_time'] = $debug_now_time;
        
        $this->load->library ( 'parser' );
        $this->load->view ( 'stripe_concept2/plans_view.php', $data );
    }
    
    public function ajax_get_plans_tmplt () {
        $post = $_POST;
        $mcount = 1;
        if(isset($post["mcount"])){
            $mcount = $post["mcount"];
        }
        
        $company=$this->releases->get_company();
        
        $plans = $this->stripe_billing_m2->get_db_plans_data_by_month_count ($mcount);
        $descriptions = $this->stripe_billing_m2->get_plans_descriptions_by_levels();
        foreach( $descriptions as $k => $v ){
            $i = -1;
            foreach( $v as $descr ){
                
                if( $descr['bold_class'] != '' ){
                    $i++;
                    $new_desc[$k][$i]['service'] = $descr['clt'];
                    $new_desc[$k][$i]['collapse'] = $k . '-collapse-' . $i;
                    $new_desc[$k][$i]['service_id'] = "$k-$i";
                    $new_desc[$k][$i]['service'] = $descr['clt'];
                    if( $descr['clt'] == '{clt_billing_fd}'){
                        $new_desc[$i]['service'] = "PMS " . $company['name'];
                    }
                    $new_desc[$k][$i]['subservices'] = [];
                    $new_desc[$k][$i]['icon'] = '';
                } else {
                    $new_desc[$k][$i]['subservices'][] = $descr;
                    $new_desc[$k][$i]['icon'] = '<i class="fa fa-caret-down" aria-hidden="true"></i>';
                }
            }
        }
        if ($this->session->userdata('global_debug')){
            foreach ($plans as &$plan) {
                $plan['descriptions'] = $new_desc[$plan['level']];
            }
        } else {
            foreach ($plans as &$plan) {
                $plan['descriptions'] = $descriptions[$plan['level']];
                $plan['pms_name_clt'] = "PMS " . $company['name'];
            }
        }
        unset($plan);
        $data = ['plans' => $plans];
        $this->mlanguages->getdictionary("stripe_plans", "", $data);
        if ($this->session->userdata('global_debug')){
            $tmplt = $this->parser->parse ( 'templates/stripe_concept2/plans_tmplts/tmplt_vit.html', $data, TRUE);
        } else {
            $tmplt = $this->parser->parse ( 'templates/stripe_concept2/plans_tmplts/tmplt_v1.html', $data, TRUE);
        }
        
        echo $tmplt;
    }
    
    function plans_post() {
        echo "<pre>";
        print_r($_POST['tariff_range']);
        
    }
    function manage_payment_methods() {
        $data = array();
        $this->load->library ( 'parser' );
        $this->load->view ( 'stripe_concept2/manage_payment_methods_view.php', $data );
    }
    function add_pay_method() {
        //========================= нема кастомера, створюєм СТАРТ ===========================
        $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
        if ($stripe_billing_customer_id == ""){
            //========================= перевірка прав на зміну плану, тільки адмін може СТАРТ ==========================================
            $id_user = $_SESSION['user']['id'];
            $isAdministrator = $this->db->select('isAdministrator')->get_where('users', array('id'=>$id_user))->row()->isAdministrator;
            if ($isAdministrator != 1){
                die ( "<meta http-equiv='refresh' content='0; url=/errors_c2/view_error/18'>" );
            }
            //========================= перевірка прав на зміну плану, тільки адмін може ФІНІШ ==========================================
            $hms_id = $this->config->item('hotel_id');
            $host = $this->config->item('host_name');
            $this->stripe_billing_m2->create_customer(array('hms_id'=>$hms_id, 'host'=>$host));
        }
        //========================= нема кастомера, створюєм ФІНІШ ===========================
        if ($this->input->post () == null) {
            echo "NULL, NO STRIPE TOKEN";
        } else {
            $this->stripe_billing_m2->add_new_pay_method_to_customer($this->input->post('new_pm_id'));
            die ( "<meta http-equiv='refresh' content='0; url=/stripe_concept2/manage_payment_methods'>" );
        }
    }
    function charges($page = 1) {
        $data = array();
        if (isset($_POST['date_range'])){
            $newdata = array ('stripe_charges_date_range' => $_POST['date_range']);
            $this->session->set_userdata ( $newdata );
        }
        if (isset ( $_POST ["lines_per_page"] )) {
            $lines_per_page = $_POST ["lines_per_page"];
            $newdata = array ('stripe_charges_lines_per_page' => $lines_per_page);
            $this->session->set_userdata ( $newdata );
        }
        if (isset ( $_POST ["goto_page"] )) {
            $page = $_POST ["goto_page"];
        }
        $data["current_page"] = $page;
        $this->load->library ( 'parser' );
        $this->load->view ( 'stripe_concept2/charges_view.php', $data );
    }
    function invoices($page = 1, $from_msg_routing = "") {
        if (isset ( $_POST ["card_error"] ) && !empty($_POST ["card_error"])) {
            $this->session->set_userdata(array("header_msg_text"=>"{".$_POST ["card_error"]."}"));
        }
        $this->hms_routing_m2->check_states_set_routing();
        $data = array();
        if (isset($_POST['date_range'])){
            $newdata = array ('stripe_invoices_date_range' => $_POST['date_range']);
            $this->session->set_userdata ( $newdata );
        }
        if (isset($_POST['status_selector'])){
            $newdata = array ('stripe_invoices_selected_status' => $_POST['status_selector']);
            $this->session->set_userdata ( $newdata );
        }
        if (isset ( $_POST ["lines_per_page"] )) {
            $lines_per_page = $_POST ["lines_per_page"];
            $newdata = array ('stripe_invoices_lines_per_page' => $lines_per_page);
            $this->session->set_userdata ( $newdata );
        }
        if (isset ( $_POST ["goto_page"] )) {
            $page = $_POST ["goto_page"];
        }
        $data["current_page"] = $page;
        $data["from_msg_routing"] = $from_msg_routing;
        $this->load->library ( 'parser' );
        $this->load->view ( 'stripe_concept2/invoices_view.php', $data );
    }
    function pay_invoice($id) {
        $this->stripe_billing_m2->pay_invoice($id);
        die ( "<meta http-equiv='refresh' content='0; url=/stripe_concept2/invoices'>" );
    }
    function create_customer() {
        $this->stripe_billing_m2->create_customer();
    }
    
    function set_subscription_plan(){
        $this->hms_routing_m2->check_states_set_routing();
        $post_data = $this->input->post();
        //========================= перевірка прав на зміну плану, тільки адмін може СТАРТ ==========================================
        $id_user = $_SESSION['user']['id'];
        $isAdministrator = $this->db->select('isAdministrator')->get_where('users', array('id'=>$id_user))->row()->isAdministrator;
        if ($isAdministrator != 1){
            die ( "<meta http-equiv='refresh' content='0; url=/errors_c2/view_error/18'>" );
        }
        //========================= перевірка прав на зміну плану, тільки адмін може ФІНІШ ==========================================
        //========================= нема кастомера, створюєм СТАРТ ===========================
        $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
        if ($stripe_billing_customer_id == ""){
            $hms_id = $this->config->item('hotel_id');
            $host = $this->config->item('host_name');
            $this->stripe_billing_m2->create_customer(array('hms_id'=>$hms_id, 'host'=>$host));
        }
        //========================= нема кастомера, створюєм ФІНІШ ===========================
        //================ аналіз і формування блоку білінгу, початковий єтап СТАРТ =======================
        $billing_arr = array();
        $expired_days = $this->hotelix_config->get_global_hotelix_record("stripe_opened_invoices_expired_days", 'int');
        $days_until_due = $expired_days + 1;
        if ($post_data['charge_type'] == "send_invoice"){
            $billing_arr = array (
                'days_until_due' => $days_until_due,
                'billing' => 'send_invoice'
            );
        } else {//перший раз завжди знімаємо чардж
            if ($post_data['card_id'] == ""){
                $this->stripe_billing_m2->add_new_pay_method_to_customer($post_data['new_pm_id']);
                $billing_arr['default_payment_method'] = $post_data['new_pm_id'];
            } else {
                $billing_arr['default_payment_method'] = $post_data['card_id'];
            }
            $billing_arr['billing'] = 'charge_automatically';
        }
        //================ аналіз і формування блоку білінгу, початковий єтап  ФІНІШ =======================
        $new_plan_id = $post_data['plan_id'];
        $prorate = true;//($post_data['price'] > $post_data['current_plan_amount']) ? true : false;//Завжди перераховуємо 09.10.2019
        $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
        $secret_key = $this->stripe_billing_m2->get_secret_key();
        $this->stripe->setApiKey($secret_key);
        if (isset($billing_arr['default_payment_method'])){
            $this->customer->update($stripe_billing_customer_id, array('invoice_settings' => array('default_payment_method'=>$billing_arr['default_payment_method'])));
        }
        $customer_obj = $this->customer->retrieve($stripe_billing_customer_id);
        $customer_arr = $customer_obj->__toArray(true);
        $subscription_id_to_change = "";
        $old_plan_id_for_log = "";
        $main_subscription_info = [];
        foreach ($customer_arr['subscriptions']['data'] as $subscription) {
            if (isset($subscription['metadata']['is_main']) && $subscription['metadata']['is_main'] == 1){
                $subscription_id_to_change = $subscription ['id'];
                // 	    		$subscription_item_to_change = $subscription['items']['data'][0]['id'];
                $old_plan_id_for_log = $subscription['items']['data'][0]['plan']['id'];
                $main_subscription_info = $subscription;
            }
        }
        $property_arr = $this->stripe_billing_m2->get_property_type_id_arr_for_plans();
        $has_tiers = $post_data['has_tiers'];
        $quantity = ($has_tiers == 0 && $property_arr['type_id'] == 2) ? 1 : $property_arr['price_count'];
        $set_new_plan_success_flag = false;
        if ($subscription_id_to_change != ""){ // підписка мейн є, змінюємо її
            //$prorate = true;
            $init_sub_arr = array (
                'plan' => $new_plan_id,
                //'prorate' => $prorate,
                'quantity' => $quantity,
                'payment_behavior'	=> 'allow_incomplete',
                'billing_cycle_anchor' => 'now',
                'proration_behavior' => 'always_invoice',
            );
            $init_sub_arr = array_merge($init_sub_arr, $billing_arr);
            if ($this->releases->stripe_hybrid_props_types()) {
                $plans_data = json_decode(base64_decode($post_data['hibryd']), true);
                $plans_ids = array_keys($plans_data);
                $init_sub_arr['items'] = [];
                foreach ($main_subscription_info['items']['data'] as $item) {
                    if (in_array($item['plan']['id'], $plans_ids) && $item['quantity'] == $plans_data[$item['plan']['id']]['quantity']) {
                        unset($plans_data[$item['plan']['id']]);
                    }else {
                        $init_sub_arr['items'][] = [
                            'id' => $item['id'],
                            'deleted' => true
                        ];
                    }
                }
                
                foreach ($plans_data as $plan) {
                    $init_sub_arr['items'][] = [
                        'plan' => $plan['plan_id'],
                        'quantity' => $plan['quantity']
                    ];
                }
                
                //$init_sub_arr['prorate'] = $prorate;
                unset($init_sub_arr['plan']);
                unset($init_sub_arr['quantity']);
            }
//             echo '<pre>';
//             print_r($init_sub_arr);
//             die("Died by Andrew at stripe_concept2.php on 10 квіт. 2023 р.  21:17:37");
            try {
                $response_sub_update = $this->subscription->update ( $subscription_id_to_change,  $init_sub_arr);
                $result = $response_sub_update->__toArray(true);
                
                /* // ---
                $data = array();
                $data['name'] = "subs";
                $data['request'] = $subscription_id_to_change . json_encode($init_sub_arr);
                $data['response'] =  json_encode($result);
                $this->db->insert('debug', $data);
                // --- */
                
            } catch ( \Stripe\Error\Card $e ) {
                // 				$body = $e->getJsonBody();
                // 				$error = count($body['error']);
                $this->session->set_userdata ( array('header_msg' => 110) );
                // зроблена реакція на ось цю помилку, викинеться разове перекладене повідомлення Your card was declined.
                // 	Стосується і випадку нижче, створення підписки. В ідеалі помилки можуть бути різними, наразі повідомлення одне.
                // 				[code] => card_declined
                // 				[decline_code] => generic_decline
                // 				[doc_url] => https://stripe.com/docs/error-codes/card-declined
                // 				[message] => Your card was declined.
                // 				[type] => card_error
                
            } catch (\Stripe\Error\InvalidRequest $e) {
                $body = $e->getJsonBody();
                $err  = $body['error'];
                $error_text = $err['message']. '<br>Update Subscription '. $subscription_id_to_change .' With Data:<br><pre>'. print_r($init_sub_arr, true).'</pre>';
                $this->session->set_userdata ( array('error_page_message' => $error_text) );
                die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/0/'>" );
            }
            
            /* if ($prorate && $property_arr['type_id'] == 1) {
            
            try {
            $resp_inv = $invoice = $this->invoice->create( array(
            'customer' 			=> $stripe_billing_customer_id,
            'billing' 			=> 'charge_automatically',
            //'days_until_due' 	=> 1,
            'auto_advance'		=> true
            ));
            } catch (\Stripe\Error\Card $e) {
            $this->session->set_userdata ( array('header_msg' => 110) );
            }
            catch (\Stripe\Error\InvalidRequest $e) {
            $body = $e->getJsonBody();
            $err  = $body['error'];
            $error_text = $err['message'];
            $this->session->set_userdata ( array('error_page_message' => $error_text) );
            die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/0/'>" );
            }
            } */
        }else{//підписка мейн не є, ствоюємо її
            $init_sub_arr = array (
                "customer" => $stripe_billing_customer_id,
                'items' => array (array ('plan' => $new_plan_id, 'quantity' => $quantity)),
                'metadata' => array ('is_main' => 1),
                'payment_behavior'	=> 'allow_incomplete'
            );
            $init_sub_arr = array_merge($init_sub_arr, $billing_arr);
            if ($this->releases->stripe_hybrid_props_types()) {
                $init_sub_arr['items'] = [];
                $plans = json_decode(base64_decode($post_data['hibryd']));
                //$plans = explode(',', $new_plan_id);
                foreach ($plans as $plan) {
                    array_push($init_sub_arr['items'], ['plan' => $plan->plan_id, 'quantity' => $plan->quantity]);
                }
            }
            try {
                $response_sub_update = $this->subscription->create ( $init_sub_arr );
                $result = $response_sub_update->__toArray(true);
            } catch ( \Stripe\Error\Card $e ) {
                // 	    		$body = $e->getJsonBody();
                // 	    		$error = count($body['error']);
                $this->session->set_userdata ( array('header_msg' => 110) );
            } catch (\Stripe\Error\InvalidRequest $e) {
                $body = $e->getJsonBody();
                $err  = $body['error'];
                $error_text = $err['message']. '<br>Create Subscription With Data:<br><pre>'. print_r($init_sub_arr, true).'</pre>';
                $this->session->set_userdata ( array('error_page_message' => $error_text) );
                die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/0/'>" );
            }
        }
        
        $this->hotelix_config->set_record("stripe_sub_current_period_start", $result['current_period_start'], 'int');
        $this->hotelix_config->set_record("stripe_sub_current_period_end", $result['current_period_end'], 'int');
        
        if (isset($result["id"]) && $result["id"] != "") {//успішно створена або успішно оновлена мейн підписка
            $set_new_plan_success_flag = true;
            $plan_level = isset($result['plan']['metadata']['level']) ? $result['plan']['metadata']['level'] : 'udefined';
            $this->hotelix_config->set_record("hms_allowed", 1, "int");
            $this->hotelix_config->set_record("stripe_plan_id", $new_plan_id);
            $this->hotelix_config->set_record("stripe_plan_level", $plan_level);
            //$this->hotelix_config->set_record("hms_route", "", "str");
            $this->hotelix_config->set_record("stripe_subscription_id", $result["id"]);
            //================ встановлення білінгу відповідно вибраного і апдейт мейн підписки СТАРТ =======================
            if ($post_data['charge_type'] == "charge_automatically" && !isset($post_data['auto_charge'])){
                $init_sub_arr = array (
                    'days_until_due' => $days_until_due,
                    'billing' => 'send_invoice'
                );
                try {
                    $response_sub_update = $this->subscription->update ( $result["id"],  $init_sub_arr);
                    $result = $response_sub_update->__toArray(true);
                } catch ( \Stripe\Error\Card $e ) {
                    $this->session->set_userdata ( array('header_msg' => 110) );
                }
            } else {//залишаємо автоматичний
            }
        }
        //================ встановлення білінгу відповідно вибраного і апдейт мейн підписки ФІНІШ =======================
        //=================== логування зміни плану СТАРТ ===========================
        if ($set_new_plan_success_flag){
            $data_1 = $data_2 = array();
            $data_1 ['plan_id'] = $old_plan_id_for_log;
            $data_2 ['plan_id'] = $new_plan_id;
            $this->loger_admin->SaveLog($data_1, $data_2, "loger_admin", 0, "", "save", "", 16);
        }
        //=================== логування зміни плану ФІНІШ ===========================
        //=================== встановлення.скасування МОНОСТАТУСУ при потребі СТАРТ ===================
        if (isset($post_data['is_mono']) && $post_data['is_mono'] == 2){
            $this->frontdesk_c2->toggle_hotelstate_mono_active();
            $this->frontdesk_c2->set_hms_billing_mono(); // встановлення моно режиму
        }else{
            $this->frontdesk_c2->toggle_hotelstate_mono_active(false);
            $this->frontdesk_c2->unset_hms_billing_mono(); // вимикання моно режиму
        }
        // 	function toggle_hotelstate_mono_active($toggle_to_mono = true)
        //=================== встановлення.скасування МОНОСТАТУСУ при потребі ФІНІШ ===================
        die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept2/summary'>" );
    }
    
    function set_primary_pay_method(){
        $primary_pay_method = $_POST['card_id'];
        $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
        $subscription_id = $this->hotelix_config->get_record("stripe_subscription_id", "str");
        $secret_key = $this->stripe_billing_m2->get_secret_key();
        $this->stripe->setApiKey($secret_key);
        $this->customer->update($stripe_billing_customer_id, ['invoice_settings' => ['default_payment_method' => $primary_pay_method]]);//$customer_obj->invoice_settings->default_payment_method
        $this->subscription->update($subscription_id, array('default_payment_method' => $primary_pay_method));
        
        //         echo "<pre>";
        //         print_r($this->subscription->retrieve($subscription_id));
        //         die("DIED by A Department at stripe_concept2.php set_primary_pay_method() on 26 мар. 2021 г. 12:12:51");
        die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept2/manage_payment_methods'>" );
    }
    function delete_pay_method(){
        $pay_method = $_POST['card_id'];
        $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
        $secret_key = $this->stripe_billing_m2->get_secret_key();
        $this->stripe->setApiKey($secret_key);
        $payment_method = $this->payment_method->retrieve($pay_method);
        $payment_method->detach();
        // 		$customer_obj = $this->customer->retrieve($stripe_billing_customer_id);
        // 		$customer_obj->sources->retrieve($pay_method)->delete();
        die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept2/manage_payment_methods'>" );
    }
    function ajax_get_prices(){
        $post = $_POST;
        $return_array = array();
        $mcount = 1;
        if(isset($post["mcount"])){
            $mcount = $post["mcount"];
        }
        $return_array = $this->stripe_billing_m2->get_db_plans_data_by_month_count ($mcount);
        echo json_encode($return_array);
    }
    function save_stripe_workshop_settings(){
        $this->stripe_billing_m2->save_stripe_workshop_settings($_POST);
        die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v'>" );
    }
    function save_stripe_billing_offline(){
        $this->stripe_billing_m2->save_stripe_billing_offline($_POST);
        die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v'>" );
    }
    function save_hms_billing_version(){
        $hms_id = $this->config->item("hotel_id");
        
        $this->stripe_billing_m2->save_hms_billing_version($_POST);
        
        $this->db->update('visitka.config', array('hms_billing_version'=>$data['hms_billing_version']), array('id'=>$hms_id));
        
        die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v'>" );
    }
    function save_lock_till_open(){
        if (isset($_POST['lock_till_open']) && $_POST['lock_till_open'] != ""){
            $this->stripe_billing_m2->save_lock_till_open($_POST);
        }
        die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v'>" );
    }
    function save_hms_property_type4stripe(){
        $this->stripe_billing_m2->save_hms_property_type4stripe($_POST);
        die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v'>" );
    }
    function save_hms_property_count4stripe(){
        $this->stripe_billing_m2->save_hms_property_count4stripe($_POST);
        die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v'>" );
    }
    function change_hotel_country_and_region(){
        if (isset($_POST['hotel_country_id']) && $_POST['hotel_country_id'] != ""){
            $country_id = strtoupper($_POST['hotel_country_id']);
            $hms_id = $this->config->item('hotel_id');
            $region_id = $this->db->select('region_id')->get_where('global_fms_base.dict_country', array('id'=>$country_id))->row();
            if(!empty($region_id)){
                $region_id = $region_id->region_id;
                $this->db->update('visitka.config', array('id_country_3c'=>$country_id), array('id'=>$hms_id));
                $this->hotelix_config->set_record("stripe_region_id", $region_id, 'int');
            }
        }
        die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v'>" );
    }
    
    function set_charge_mode_post($auto_charge) {
        switch ($auto_charge) {
            case "on":
                $update_arr['billing'] = 'charge_automatically';
                $update_arr['days_until_due'] = null;
                break;
            case "off":
                $update_arr['billing'] = 'send_invoice';
                $update_arr['days_until_due'] = 3;
                //$expired_days = $this->hotelix_config->get_global_hotelix_record("stripe_opened_invoices_expired_days", 'int');
                //це теж значення? ВИЯСНИТИ!!!
                break;
            default:
                $update_arr['billing'] = 'charge_automatically';
                $update_arr['days_until_due'] = null;
        }
        $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
        $secret_key = $this->stripe_billing_m2->get_secret_key();
        $this->stripe->setApiKey($secret_key);
        $customer_obj = $this->customer->retrieve($stripe_billing_customer_id);
        $customer = $customer_obj->__toArray(true);
        if (isset($customer['subscriptions'])) {
            foreach ($customer['subscriptions']['data'] as $id=>$sub_data) {
                if (isset($sub_data['metadata']['is_main']) && isset($sub_data['plan']) && $sub_data['metadata']['is_main'] == 1) {
                    $is_ok = true;
                    $main_sub_data = $sub_data;
                    break;
                }
            }
        }
        if ($is_ok){
            $this->subscription->update( $main_sub_data['id'], $update_arr );
        }
        die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept2/summary'>" );
    }
    
    function pay_debts () {
        $opened_invoices = $this->stripe_billing_m2->get_opened_invoices();
        // 		$secret_key = $this->stripe_billing_m2->get_secret_key();
        // 		$this->stripe->setApiKey($secret_key);
        foreach ($opened_invoices as $opened_invoice) {
            $this->stripe_billing_m2->pay_invoice($opened_invoice['id']);
        }
        die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept2/summary'>" );
    }
    
    function charge_once_form() {
        $this->load->view ( 'stripe_concept2/charge_once_form_view.php');
    }
    function charge_once_form_post() {
        $amount = $_POST['amount'] * 100;
        $currency = strtolower($_POST['currency']);
        $customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
        if( $customer_id == ""){
            echo "<pre>NO CUSNOMER<br>";
            die ('<br>DIED by A Development Department of HMS IT TEAM<br>10.07.2019  18:14:57 <br>stripe_concept.php');
            
        }
        $secret_key = $this->stripe_billing_m2->get_secret_key();
        $this->stripe->setApiKey ( $secret_key );
        $this->invoice_item->create ( array (
            'customer' => $customer_id,
            'amount' => $amount,
            'currency' => $currency,
            'description' => 'Test payment ' . date ( 'Y-m-d H:i:s' )
        ) );
        $invoice = $this->invoice->create ( array (
            'customer' => $customer_id,
            'auto_advance' => true,
            'collection_method' => 'charge_automatically',
        ) );
        $invoice_arr = $invoice->__toArray(true);
        echo '<pre>';
        print_r($invoice_arr);
    }
    
    function deactivate_prolongation() {
        $pass = isset($_POST['slingpass']) ? $_POST['slingpass'] : "";
        $pass = md5(trim(stripslashes(htmlspecialchars($pass))));
        if ($_SESSION['user']['password'] != $pass){
            $this->session->set_userdata('header_msg_text', $this->mlanguages->getdictionaryword("login", $lang = "", "caption_errnote2"));
            die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept2/summary'>" );
        }
        if ($_SESSION['user']['isadministrator'] != 1){
            $this->session->set_userdata('header_msg_text', $this->mlanguages->getdictionaryword("errors_freeerror", $lang = "", "mlw_nopermissions"));
            die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept2/summary'>" );
        }
        $this->set_charge_mode_post('off');
    }
    function add_pi_pay_method() {
        $post = $this->input->post();
        $die_url = '/stripe_concept2/summary';
        if (isset($post["charge_type"]) && $post["charge_type"] == 'send_invoice') {
            $secret_key = $this->stripe_billing_m2->get_secret_key();
            $this->stripe->setApiKey($secret_key);
            $intent = $this->payment_intent->retrieve($post['pi_id']);
            $invoce = $this->invoice->retrieve($intent->invoice);
            $billing_arr = array (
                'days_until_due' => 1,
                'billing' => 'send_invoice'
            );
            $this->subscription->update ( $invoce->subscription,  $billing_arr);
        } else {
            if (isset($post["card_error"]) && ! empty($post["card_error"])) {
                $this->session->set_userdata(array(
                    "header_msg_text" => "{" . $post["card_error"] . "}"
                ));
            } else {
                $secret_key = $this->stripe_billing_m2->get_secret_key();
                $this->stripe->setApiKey($secret_key);
                $this->payment_intent->update($post['pi_id'], array(
                    'payment_method' => ! empty($post['new_pm_id']) ? $post['new_pm_id'] : $post['card_id']
                ));
            }
        }
        die ( "<meta http-equiv='refresh' content='0;url=$die_url'>" );
    }
    
    public function debug_customer_view() {
        if ($this->session->userdata('global_debug')) {
            $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
            $secret_key = $this->stripe_billing_m2->get_secret_key();
            $this->stripe->setApiKey($secret_key);
            $customer_obj = $this->customer->retrieve($stripe_billing_customer_id);
            $customer = $customer_obj->__toArray(true);
            echo '<pre>';
            print_r($customer);
            die("Died by Andrew at stripe_concept2.php on 10 квіт. 2023 р.  12:16:41");
        }else {
            $die_url = '/stripe_concept2/plans';
            die ( "<meta http-equiv='refresh' content='0;url=$die_url'>" );
        }
    }
    
    public function get_stripe_info() {
        $info = $this->stripe_billing_m2->get_stripe_info();
        echo '<pre>';
        print_r($info);
        die("Died by Andrew at stripe_concept2.php on 24 трав. 2023 р.  16:13:00");
    }
}