<?php
require_once (APPPATH . 'libraries/stripe/init.php');
class Stripe_concept extends CI_Controller {

	public function __construct()
       {
            parent::__construct();
            $this->load->model('stripe_billing_m');
            $this->load->model('loger_admin');
            $this->load->model('mlanguages');
            $this->load->model('htmltpl');
            $this->load->model('frontdesk');
            $this->load->model('frontdesk_c2');
            $this->load->model('Authorization');
            $this->load->model ('hms_routing_m');
            $this->Authorization->IsLogined();
            $this->stripe = new \Stripe\Stripe();
            $this->customer = new \Stripe\Customer();
            $this->charge = new \Stripe\Charge();
            $this->invoice = new \Stripe\Invoice();
            $this->invoice_item = new \Stripe\InvoiceItem();
            $this->plan = new \Stripe\Plan();
            $this->subscription = new \Stripe\Subscription();
            $this->subscription_item = new \Stripe\SubscriptionItem();
	}
	function index() {
	}
function pdf_invoice( $invoice_id ){
		$secret_key = $this->stripe_billing_m->get_secret_key();
		$this->stripe->setApiKey($secret_key);
		$invoice_obj = $this->invoice->retrieve($invoice_id);
		$invoice = $invoice_obj->__toArray(true);
		$customer_id = $invoice['customer'];
		$customer_obj = $this->customer->retrieve($customer_id);
		$customer = $customer_obj->__toArray(true);
		$p_data = array (
				'legal_name' => '-',
				'addrLine1' => '-',
				'addrLine2' => '-',
				'city' => '-',
				'state' => '-',
				'postcode' => '-'
		);
		$tbl_1 = "partners";
		$sql = "SELECT $tbl_1.name as legal_name, $tbl_1.addrLine1, $tbl_1.addrLine2, $tbl_1.city, $tbl_1.state, $tbl_1.postcode
		FROM $tbl_1
		ORDER BY isdefault DESC";
		$partner = $this->db->query($sql)->row();
		if(!empty($partner)){
			foreach ($partner as $fild => $val) {
				if (!empty($val)){
					$p_data[$fild] = $val;
					}
			}
		}
		$data = array();
		$data['number'] 		= $invoice['number'];
		$data['currency'] 		= strtoupper($invoice['currency']);
		$data['amount_due'] 	= number_format($invoice['amount_due']/100, 2, '.',',');
		$data['date'] 			= (null != $invoice['due_date']) ? date('F d, Y', $invoice['due_date']) : date('F d, Y', $invoice['date']);
		$data['description'] 	= $customer['description'];
		$data['legal_name'] = $p_data['legal_name'];
		$data['address'] = $p_data['addrLine1']."<br>".$p_data['addrLine2']."<br>".$p_data['city']."<br>".$p_data['state']."<br>".$p_data['postcode'];
// 		$data['hms_id'] 		= isset($customer['metadata']['hms_id']) ? $customer['metadata']['hms_id'] : null;
// 		$data['addr_line_1'] 	= $customer['shipping']['address']['line1']	. (null != $customer['shipping']['address']['line1']) ? ',' : '';
// 		$data['addr_line_2'] 	= $customer['shipping']['address']['line2'];
// 		$data['city'] 			= $customer['shipping']['address']['city'];
		$data['tax_type'] 		= $customer['tax_info']['type'];
		$data['tax_id'] 		= $customer['tax_info']['tax_id'];
		$data['discount']		= $invoice['discount']['coupon']['percent_off'] != null ? $invoice['discount']['coupon']['percent_off'] ." %" : '0.00 %';
		$data['discount_hide']	= $invoice['discount']['coupon']['percent_off'] != null ? "" : 'style="display:none;"';
		$data['subtotal'] 		= number_format($invoice['subtotal']/100, 2, '.', ',');
		$data['tax_percent'] 	= $invoice['tax_percent'] != null ? number_format($invoice['tax_percent']/100, 2, '.', ',') : '0.00';
		$data['tax'] 			= $invoice['tax'] != null ? number_format($invoice['tax']/100, 2, '.', ',') : '0.00';
		$data['tax_hide']		= ($invoice['tax'] != null || $invoice['tax_percent'] != null) ? "" : 'style="display:none;"';
		$data['applied_balance']= number_format(($invoice['starting_balance']-$invoice['ending_balance'])/100, 2, '.', ',');
		foreach( $invoice['lines']['data'] as $k => $v ){
			$i = $k+ 1;
			$data['invoice_lines'][$k]['counter'] 		= $i;
			$data['invoice_lines'][$k]['quantity'] 		= $v['quantity'];
			$data['invoice_lines'][$k]['details'] 		= $v['description']. '<br/>(<b>From</b> ' . date('F d, Y', $v['period']['start']). ' <b>to</b> ' . date('F d, Y', $v['period']['end']) . ')';//$v['plan']['nickname']
			$data['invoice_lines'][$k]['price'] 		= number_format($v['amount']/$v['quantity']/100, 2, '.', ',');
			$data['invoice_lines'][$k]['summ']			 = number_format($v['amount']/100, 2, '.', ',');
		}
		$template = $this->parser->parse('/templates/stripe_concept/pdf_invoice.html', $data, true);
		$this->load->library('m_pdf');
		$this->m_pdf->pdf->WriteHTML($template);
		$this->m_pdf->pdf->Output(' ','I');
	}
	function pdf_act($invoice_number = ""){
		if ($invoice_number != ""){
			$tbl_acts = "stripe_acts";
			$act = $this->db->get_where($tbl_acts, array('act_number' => "A-$invoice_number"))->row();
			if (!empty($act)){
				$act = json_decode($act->data, true);
				$template = $this->parser->parse('/templates/stripe_concept/pdf_act.html', $act, true);
				$this->load->library('m_pdf');
				$this->m_pdf->pdf->WriteHTML($template);
				$this->m_pdf->pdf->Output(' ','I');
			} else {
				die ( "<meta http-equiv='refresh' content='0; url=/stripe_concept/invoices'>" );
			}
		}else{
			die ( "<meta http-equiv='refresh' content='0; url=/stripe_concept/invoices'>" );
		}
	}
	function pdf_charge( $charge_id ){
		$secret_key = $this->stripe_billing_m->get_secret_key();
		$this->stripe->setApiKey($secret_key);
		//=======наразі буде виводитись інвойс, з часом треба допиляти STR
		$charge_obj = $this->charge->retrieve($charge_id);
		$charge = $charge_obj->__toArray(true);
		$invoice_id = $charge['invoice'];
		//=======наразі буде виводитись інвойс, з часом треба допиляти FIN
		$invoice_obj = $this->invoice->retrieve($invoice_id);
		$invoice = $invoice_obj->__toArray(true);
		$customer_id = $invoice['customer'];
		$customer_obj = $this->customer->retrieve($customer_id);
		$customer = $customer_obj->__toArray(true);
		$data = array();
		$data['number'] 		= $invoice['number'];
		$data['currency'] 		= strtoupper($invoice['currency']);
		$data['amount_due'] 	= number_format($invoice['amount_due']/100, 2, '.',',');
		$data['date'] 			= (null != $invoice['due_date']) ? date('F d, Y', $invoice['due_date']) : date('F d, Y', $invoice['date']);
		$data['description'] 	= $customer['description'];
		$data['hms_id'] 		= isset($customer['metadata']['hms_id']) ? $customer['metadata']['hms_id'] : null;
		$data['addr_line_1'] 	= $customer['shipping']['address']['line1']	. (null != $customer['shipping']['address']['line1']) ? ',' : '';
		$data['addr_line_2'] 	= $customer['shipping']['address']['line2'];
		$data['city'] 			= $customer['shipping']['address']['city'];
		$data['tax_type'] 		= $customer['tax_info']['type'];
		$data['tax_id'] 		= $customer['tax_info']['tax_id'];
		$data['discount']		= $invoice['discount']['coupon']['percent_off'] != null ? $invoice['discount']['coupon']['percent_off'] ."%" : '';
		$data['subtotal'] 		= number_format($invoice['subtotal']/100, 2, '.', ',');
		$data['tax_percent'] 	= $invoice['tax_percent'] != null ? number_format($invoice['tax_percent']/100, 2, '.', ',') : '0.00';
		$data['tax'] 			= $invoice['tax'] != null ? number_format($invoice['tax']/100, 2, '.', ',') : '0.00';;
		foreach( $invoice['lines']['data'] as $k => $v ){
			$i = $k+ 1;
			$data['invoice_lines'][$k]['counter'] 		= $i;
			$data['invoice_lines'][$k]['quantity'] 		= $v['quantity'];
			$data['invoice_lines'][$k]['details'] 		= $v['plan']['nickname']
			. '<br/>(<b>From</b> ' . date('F d, Y', $v['period']['start'])
			. ' <b>to</b> ' . date('F d, Y', $v['period']['end']) . ')';
			$data['invoice_lines'][$k]['price'] 		= number_format($v['amount']/$v['quantity']/100, 2, '.', ',');
			$data['invoice_lines'][$k]['summ']			 = number_format($v['amount']/100, 2, '.', ',');
		}
		$template = $this->parser->parse('/templates/stripe_concept/pdf_invoice.html', $data, true);
		$this->load->library('m_pdf');
		$this->m_pdf->pdf->WriteHTML($template);
		$this->m_pdf->pdf->Output(' ','I');
	}

	function basic_data() {
		$data = array();
		$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
		$data['stripe_billing_customer_id'] = $stripe_billing_customer_id;
		$this->load->library ( 'parser' );
		$this->load->view ( 'stripe_concept/basic_data_view.php', $data );
	}
	function basic_data_post() {
	    $post = $_POST;
	    $this->frontdesk_c2->stripe_save_basic_data($post);
	    die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept/basic_data'>" );
	}
	function summary() {
		$data = array();
		$this->load->library ( 'parser' );
		$this->load->view ( 'stripe_concept/summary_view.php', $data );
	}
	function plans($debug_now_time = '') {//TEMP for debuging change now time
		$data = array();
		
		//TEMP for debuging change now time
		$data['debug_now_time'] = $debug_now_time;
		
		$this->load->library ( 'parser' );
		$this->load->view ( 'stripe_concept/plans_view.php', $data );
	}
	function plans_post() {
		echo "<pre>";
		print_r($_POST['tariff_range']);

	}
	function manage_payment_methods() {
		$data = array();
		$this->load->library ( 'parser' );
		$this->load->view ( 'stripe_concept/manage_payment_methods_view.php', $data );
	}
	function add_pay_method() {
//========================= нема кастомера, створюєм СТАРТ ===========================
		$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
		if ($stripe_billing_customer_id == ""){
			//========================= перевірка прав на зміну плану, тільки адмін може СТАРТ ==========================================
			$id_user = $_SESSION['user']['id'];
			$isAdministrator = $this->db->select('isAdministrator')->get_where('users', array('id'=>$id_user))->row()->isAdministrator;
			if ($isAdministrator != 1){
				die ( "<meta http-equiv='refresh' content='0; url=/errors_c2/view_error/18'>" );
			}
			//========================= перевірка прав на зміну плану, тільки адмін може ФІНІШ ==========================================
			$hms_id = $this->config->item('hotel_id');
			$host = $this->config->item('host_name');
			$this->stripe_billing_m->create_customer(array('hms_id'=>$hms_id, 'host'=>$host));
		}
//========================= нема кастомера, створюєм ФІНІШ ===========================
		if ($this->input->post () == null) {
			echo "NULL, NO STRIPE TOKEN";
		} else {
			$this->stripe_billing_m->add_pay_method($this->input->post('stripeToken'));
			die ( "<meta http-equiv='refresh' content='0; url=/stripe_concept/manage_payment_methods'>" );
		}
	}
	function charges($page = 1) {
		$data = array();
		if (isset($_POST['date_range'])){
			$newdata = array ('stripe_charges_date_range' => $_POST['date_range']);
			$this->session->set_userdata ( $newdata );
		}
		if (isset ( $_POST ["lines_per_page"] )) {
			$lines_per_page = $_POST ["lines_per_page"];
			$newdata = array ('stripe_charges_lines_per_page' => $lines_per_page);
			$this->session->set_userdata ( $newdata );
		}
		if (isset ( $_POST ["goto_page"] )) {
			$page = $_POST ["goto_page"];
		}
		$data["current_page"] = $page;
		$this->load->library ( 'parser' );
		$this->load->view ( 'stripe_concept/charges_view.php', $data );
	}
	
	function invoices($page = 1, $from_msg_routing = "") {
		$data = array();
		if (isset($_POST['date_range'])){
			$newdata = array ('stripe_invoices_date_range' => $_POST['date_range']);
			$this->session->set_userdata ( $newdata );
		}
		if (isset($_POST['status_selector'])){
			$newdata = array ('stripe_invoices_selected_status' => $_POST['status_selector']);
			$this->session->set_userdata ( $newdata );
		}
		if (isset ( $_POST ["lines_per_page"] )) {
			$lines_per_page = $_POST ["lines_per_page"];
			$newdata = array ('stripe_invoices_lines_per_page' => $lines_per_page);
			$this->session->set_userdata ( $newdata );
		}
		if (isset ( $_POST ["goto_page"] )) {
			$page = $_POST ["goto_page"];
		}
		$data["current_page"] = $page;
		$data["from_msg_routing"] = $from_msg_routing;
		$this->load->library ( 'parser' );
		$this->load->view ( 'stripe_concept/invoices_view.php', $data );
	}
	function pay_invoice($id) {
		$this->stripe_billing_m->pay_invoice($id);
		die ( "<meta http-equiv='refresh' content='0; url=/stripe_concept/invoices'>" );
	}
	function create_customer() {
		$this->stripe_billing_m->create_customer();
	}

	function set_subscription_plan(){
		$post_data = $_POST;
//========================= перевірка прав на зміну плану, тільки адмін може СТАРТ ==========================================
		$id_user = $_SESSION['user']['id'];
		$isAdministrator = $this->db->select('isAdministrator')->get_where('users', array('id'=>$id_user))->row()->isAdministrator;
		if ($isAdministrator != 1){
			die ( "<meta http-equiv='refresh' content='0; url=/errors_c2/view_error/18'>" );
		}
//========================= перевірка прав на зміну плану, тільки адмін може ФІНІШ ==========================================
//========================= нема кастомера, створюєм СТАРТ ===========================
		$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
		if ($stripe_billing_customer_id == ""){
			$hms_id = $this->config->item('hotel_id');
			$host = $this->config->item('host_name');
			$this->stripe_billing_m->create_customer(array('hms_id'=>$hms_id, 'host'=>$host));
		}
//========================= нема кастомера, створюєм ФІНІШ ===========================
//================ аналіз і формування блоку білінгу, початковий єтап СТАРТ =======================
		$billing_arr = array();
		$days_until_due = 3;
		if ($post_data['charge_type'] == "send_invoice"){
			$billing_arr = array (
					'days_until_due' => $days_until_due,
					'billing' => 'send_invoice'
			);
		} else {//перший раз завжди знімаємо чардж
			if ($post_data['card_id'] == ""){
				$billing_arr['default_source'] = $this->stripe_billing_m->add_pay_method($post_data['stripeToken']);
			} else {
				$billing_arr['default_source'] = $post_data['card_id'];
			}
			$billing_arr['billing'] = 'charge_automatically';
		}
//================ аналіз і формування блоку білінгу, початковий єтап  ФІНІШ =======================
	    $new_plan_id = $post_data['plan_id'];
	    $prorate = true;//($post_data['price'] > $post_data['current_plan_amount']) ? true : false;//Завжди перераховуємо 09.10.2019
	    $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
	    $secret_key = $this->stripe_billing_m->get_secret_key();
	    $this->stripe->setApiKey($secret_key);
	    $customer_obj = $this->customer->retrieve($stripe_billing_customer_id);
	    $customer_arr = $customer_obj->__toArray(true);
		$subscription_id_to_change = "";
		$old_plan_id_for_log = "";
	    foreach ($customer_arr['subscriptions']['data'] as $subscription) {
	    	if (isset($subscription['metadata']['is_main']) && $subscription['metadata']['is_main'] == 1){
	    		$subscription_id_to_change = $subscription ['id'];
// 	    		$subscription_item_to_change = $subscription['items']['data'][0]['id'];
	    		$old_plan_id_for_log = $subscription['items']['data'][0]['plan']['id'];
	    	}
	    }
	    $property_arr = $this->stripe_billing_m->get_property_type_id_arr_for_plans();
	    $quantity = $property_arr['price_count'];
	    $set_new_plan_success_flag = false;
	    if ($subscription_id_to_change != ""){ // підписка мейн є, змінюємо її
	        //$prorate = true;
	    	$init_sub_arr = array (
	    			'plan' => $new_plan_id,
	    			'prorate' => $prorate,
	    			'quantity' => $quantity,
	    	);
	    	$init_sub_arr = array_merge($init_sub_arr, $billing_arr);
			try {
				$response_sub_update = $this->subscription->update ( $subscription_id_to_change,  $init_sub_arr);
				$result = $response_sub_update->__toArray(true);
			} catch ( \Stripe\Error\Card $e ) {
// 				$body = $e->getJsonBody();
// 				$error = count($body['error']);
				$this->session->set_userdata ( array('header_msg' => 110) );
// зроблена реакція на ось цю помилку, викинеться разове перекладене повідомлення Your card was declined.
// 	Стосується і випадку нижче, створення підписки. В ідеалі помилки можуть бути різними, наразі повідомлення одне.
// 				[code] => card_declined
// 				[decline_code] => generic_decline
// 				[doc_url] => https://stripe.com/docs/error-codes/card-declined
// 				[message] => Your card was declined.
// 				[type] => card_error

			} catch (\Stripe\Error\InvalidRequest $e) {
				$body = $e->getJsonBody();
				$err  = $body['error'];
				$error_text = $err['message'];
				$this->session->set_userdata ( array('error_page_message' => $error_text) );
				die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/0/'>" );
			}

			if ($prorate && $property_arr['type_id'] ==1) {

			    try {
			        $resp_inv = $invoice = $this->invoice->create( array(
			            'customer' 			=> $stripe_billing_customer_id,
			            'billing' 			=> 'charge_automatically',
			            //'days_until_due' 	=> 1,
			            'auto_advance'		=> true
			        ));
			    } catch (\Stripe\Error\Card $e) {
			        $this->session->set_userdata ( array('header_msg' => 110) );
			    }


			}


	    }else{//підписка мейн не є, ствоюємо її
	    	$init_sub_arr = array (
	    			"customer" => $stripe_billing_customer_id,
	    			'items' => array (array ('plan' => $new_plan_id, 'quantity' => $quantity)),
	    			'metadata' => array ('is_main' => 1),
	    	);
	    	$init_sub_arr = array_merge($init_sub_arr, $billing_arr);
	    	try {
				$response_sub_update = $this->subscription->create ( $init_sub_arr );
		    	$result = $response_sub_update->__toArray(true);
	    	} catch ( \Stripe\Error\Card $e ) {
// 	    		$body = $e->getJsonBody();
// 	    		$error = count($body['error']);
	    		$this->session->set_userdata ( array('header_msg' => 110) );
	    	} catch (\Stripe\Error\InvalidRequest $e) {
				$body = $e->getJsonBody();
				$err  = $body['error'];
				$error_text = $err['message'];
				$this->session->set_userdata ( array('error_page_message' => $error_text) );
				die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/0/'>" );
			}
	    }
	    if (isset($result["id"]) && $result["id"] != "") {//успішно створена або успішно оновлена мейн підписка
	    	$set_new_plan_success_flag = true;
	    	$this->hotelix_config->set_record("hms_allowed", 1, "int");
	    	$this->hotelix_config->set_record("stripe_plan_id", $new_plan_id);
	    	//$this->hotelix_config->set_record("hms_route", "", "str");
	    	$this->hotelix_config->set_record("stripe_subscription_id", $result["id"]);
//================ встановлення білінгу відповідно вибраного і апдейт мейн підписки СТАРТ =======================
	    	if ($post_data['charge_type'] == "charge_automatically" && !isset($post_data['auto_charge'])){
	    		$init_sub_arr = array (
	    				'days_until_due' => $days_until_due,
	    				'billing' => 'send_invoice'
	    		);
	    		try {
	    			$response_sub_update = $this->subscription->update ( $result["id"],  $init_sub_arr);
	    			$result = $response_sub_update->__toArray(true);
	    		} catch ( \Stripe\Error\Card $e ) {
	    			$this->session->set_userdata ( array('header_msg' => 110) );
	    		}
	    	} else {//залишаємо автоматичний
	    	}
	    	$this->hms_routing_m->check_states_set_routing();
	    }
//================ встановлення білінгу відповідно вибраного і апдейт мейн підписки ФІНІШ =======================
//=================== логування зміни плану СТАРТ ===========================
		if ($set_new_plan_success_flag){
			$data_1 = $data_2 = array();
			$data_1 ['plan_id'] = $old_plan_id_for_log;
			$data_2 ['plan_id'] = $new_plan_id;
			$this->loger_admin->SaveLog($data_1, $data_2, "loger_admin", 0, "", "save", "", 16);
		}
//=================== логування зміни плану ФІНІШ ===========================
    	die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept/summary'>" );
	}
	function set_primary_pay_method(){
		$primary_pay_method = $_POST['card_id'];
		$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
		$secret_key = $this->stripe_billing_m->get_secret_key();
		$this->stripe->setApiKey($secret_key);
		$this->customer->update($stripe_billing_customer_id, array("default_source" => $primary_pay_method));
		die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept/manage_payment_methods'>" );
	}
	function delete_pay_method(){
		$pay_method = $_POST['card_id'];
		$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
		$secret_key = $this->stripe_billing_m->get_secret_key();
		$this->stripe->setApiKey($secret_key);
		$customer_obj = $this->customer->retrieve($stripe_billing_customer_id);
		$customer_obj->sources->retrieve($pay_method)->delete();
		die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept/manage_payment_methods'>" );
	}
	function ajax_get_prices(){
	    $post = $_POST;
	    $return_array = array();
	    $mcount = 1;
	    if(isset($post["mcount"])){
	        $mcount = $post["mcount"];
	    }
	    $return_array = $this->stripe_billing_m->get_db_plans_data_by_month_count ($mcount);
	    echo json_encode($return_array);
	}
	function save_stripe_workshop_settings(){
	    $this->stripe_billing_m->save_stripe_workshop_settings($_POST);
	    die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v'>" );
	}
	function save_stripe_billing_offline(){
		$this->stripe_billing_m->save_stripe_billing_offline($_POST);
		die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v'>" );
	}
	function save_hms_billing_version(){
	    $hms_id = $this->config->item("hotel_id");

		$this->stripe_billing_m->save_hms_billing_version($_POST);

		$this->db->update('visitka.config', array('hms_billing_version'=>$data['hms_billing_version']), array('id'=>$hms_id));

		die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v'>" );
	}
	function save_lock_till_open(){
		if (isset($_POST['lock_till_open']) && $_POST['lock_till_open'] != ""){
			$this->stripe_billing_m->save_lock_till_open($_POST);
		}
		die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v'>" );
	}
	function save_hms_property_type4stripe(){
		$this->stripe_billing_m->save_hms_property_type4stripe($_POST);
		die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v'>" );
	}
	function save_hms_property_count4stripe(){
		$this->stripe_billing_m->save_hms_property_count4stripe($_POST);
		die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v'>" );
	}
	function change_hotel_country_and_region(){
		if (isset($_POST['hotel_country_id']) && $_POST['hotel_country_id'] != ""){
			$country_id = strtoupper($_POST['hotel_country_id']);
			$hms_id = $this->config->item('hotel_id');
			$region_id = $this->db->select('region_id')->get_where('global_fms_base.dict_country', array('id'=>$country_id))->row();
			if(!empty($region_id)){
				$region_id = $region_id->region_id;
				$this->db->update('visitka.config', array('id_country_3c'=>$country_id), array('id'=>$hms_id));
				$this->hotelix_config->set_record("stripe_region_id", $region_id, 'int');
			}
		}
		die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v'>" );
	}

	function set_charge_mode_post($auto_charge) {
		switch ($auto_charge) {
			case "on":
				$update_arr['billing'] = 'charge_automatically';
				$update_arr['days_until_due'] = null;
				break;
			case "off":
				$update_arr['billing'] = 'send_invoice';
				$update_arr['days_until_due'] = 3;
				//$expired_days = $this->hotelix_config->get_global_hotelix_record("stripe_opened_invoices_expired_days", 'int');
				//це теж значення? ВИЯСНИТИ!!!
				break;
			default:
				$update_arr['billing'] = 'charge_automatically';
				$update_arr['days_until_due'] = null;
		}
	    $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
	    $secret_key = $this->stripe_billing_m->get_secret_key();
	    $this->stripe->setApiKey($secret_key);
	    $customer_obj = $this->customer->retrieve($stripe_billing_customer_id);
	    $customer = $customer_obj->__toArray(true);
	    if (isset($customer['subscriptions'])) {
	        foreach ($customer['subscriptions']['data'] as $id=>$sub_data) {
	            if (isset($sub_data['metadata']['is_main']) && isset($sub_data['plan']) && $sub_data['metadata']['is_main'] == 1) {
	                    $is_ok = true;
	                    $main_sub_data = $sub_data;
	                    break;
	            }
	        }
	    }
	    if ($is_ok){
	    	$this->subscription->update( $main_sub_data['id'], $update_arr );
	    }
	    die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept/summary'>" );
	}

	function pay_debts () {
		$opened_invoices = $this->stripe_billing_m->get_opened_invoices();
// 		$secret_key = $this->stripe_billing_m->get_secret_key();
// 		$this->stripe->setApiKey($secret_key);
		foreach ($opened_invoices as $opened_invoice) {
			$this->stripe_billing_m->pay_invoice($opened_invoice['id']);
		}
		die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept/summary'>" );
	}

	function charge_once_form() {
		$this->load->view ( 'stripe_concept/charge_once_form_view.php');
	}
	function charge_once_form_post() {
		$amount = $_POST['amount'] * 100;
		$currency = strtolower($_POST['currency']);
		$customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
		if( $customer_id == ""){
			echo "<pre>NO CUSNOMER<br>";
			die ('<br>DIED by A Development Department of HMS IT TEAM<br>10.07.2019  18:14:57 <br>stripe_concept.php');

		}
		$secret_key = $this->stripe_billing_m->get_secret_key();
		$this->stripe->setApiKey ( $secret_key );
		$this->invoice_item->create ( array (
				'customer' => $customer_id,
				'amount' => $amount,
				'currency' => $currency,
				'description' => 'Test payment ' . date ( 'Y-m-d H:i:s' )
		) );
		$invoice = $this->invoice->create ( array (
				'customer' => $customer_id,
				'auto_advance' => true,
				'collection_method' => 'charge_automatically',
		) );
		$invoice_arr = $invoice->__toArray(true);
		echo '<pre>';
		print_r($invoice_arr);
	}
	
	function deactivate_prolongation() {
		$pass = isset($_POST['slingpass']) ? $_POST['slingpass'] : "";
		$pass = md5(trim(stripslashes(htmlspecialchars($pass))));
		if ($_SESSION['user']['password'] != $pass){
			$this->session->set_userdata('header_msg_text', $this->mlanguages->getdictionaryword("login", $lang = "", "caption_errnote2"));
			die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept/summary'>" );
		}
		if ($_SESSION['user']['isadministrator'] != 1){
			$this->session->set_userdata('header_msg_text', $this->mlanguages->getdictionaryword("errors_freeerror", $lang = "", "mlw_nopermissions"));
			die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept/summary'>" );
		}
		$this->set_charge_mode_post('off');
	}
}
