﻿<?php
if (! defined ( 'BASEPATH' ))
	exit ( 'No direct script access allowed' );
class Pdf extends CI_Controller {
	public function __construct() {
		parent::__construct ();
		$this->load->model ( 'frontdesk' );
		$this->load->model ( 'Authorization' );
		$this->load->model ( 'fms_core' );
	}
	public function index() {
	}
	public function create_pdf_OLD($reservation_id = 0, $guest_id = 0) {
		$legalsystem = $this->frontdesk->getlegalsystem();
		$legalsystem_db = $this->frontdesk->getlegalsystem_db($legalsystem);
		
		$dict_documenttype_mass = $this->fms_core->get_dict_documenttype($legalsystem_db);
		$dict_visitpurpose_mass = $this->fms_core->get_dict_visitpurpose($legalsystem_db);
		//echo "<pre>";
		//print_r($_POST);
		//die();
		$doc_types_short = array();
		$doc_types_short["103012"]["short_name"] = "ИНПАСПОРТ";
		$doc_types_short["136359"]["short_name"] = "ДИППАСП ИН";
		$doc_types_short["135709"]["short_name"] = "ВИД НА ЖИТ";
		$doc_types_short["103014"]["short_name"] = "ИН СВИДРОЖД";
		$doc_types_short["102977"]["short_name"] = "СВИДВР УБЕЖ";
		$doc_types_short["102999"]["short_name"] = "УДОСТ СНГ";
		$doc_types_short["103010"]["short_name"] = "СЛУЖЕБ ПАСП";
		$doc_types_short["135710"]["short_name"] = "ВНЖ ЛБГ";
		$doc_types_short["135717"]["short_name"] = "РВП ЛБГ";
		$doc_types_short["103009"]["short_name"] = "НАЦ ЗГПАСП";
		$doc_types_short["136366"]["short_name"] = "ИНОЙ ДОК";
		$doc_types_short["139384"]["short_name"] = "УДОСТ КАЗАХ";
		$doc_types_short["139387"]["short_name"] = "ВНЖ ЛБГ БИО";
		$doc_types_short["139392"]["short_name"] = "ИНПАСПОРТ";
		$doc_types_short["139388"]["short_name"] = "РВП ЛБГ ШТ";
		
		$hotel_location = "";
		$sql = "SELECT language FROM `visitka`.config WHERE id = ".$this->config->item("hotel_id");
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$hotel_location = trim($row->language);
		}
		
		
		
		$doc_types = array ();
		$query = $this->db->query ( "SELECT * FROM doc_types" );
		foreach ( $query->result () as $row ) {
			$doc_types[$row->id]["name"] = $row->name;
		}
		
		if(isset($_POST["reservation_id"])){
			$reservation_id = $_POST["reservation_id"];
		}
		if(isset($_POST["guest_id"])){
			$guest_id = $_POST["guest_id"];
		}
		if(isset($_POST["guests"][0])){
			$guest_id = $_POST["guests"][0];
		}
		putenv ( 'LANG=en_US.UTF-8' );
		$this->load->library ( 'parser' );
		$this->load->helper ( 'file' );
		
		$file = "someOut.pdf";
		
		// див /var/www/pdfgen/application/FORPDF/FIELDS_REF.TXT що яке поле означає
		$data = array (
				'comb_24_2' => "Улица Улица Улица",
				'comb_1' => "Фамилия Фамилия",
				'comb_2' => "Отчество Отчество" 
		);
		
		$reservation_data = array ();
		if ($reservation_id != 0) {
			$reservation_data = $this->frontdesk->GetReservation ( $reservation_id );
			if (count ( $reservation_data ) == 0) {
				return "Error";
			}
		}
		
		$guest_data = array ();
		if ($guest_id != 0) {
			$guest_data = $this->frontdesk->GetGuest ( $guest_id );
			if (count ( $guest_data ) == 0) {
				return "Error";
			}
		}
		
		$data = array ();
		$data ["comb_1"] = $guest_data ["lastname"];
		$data ["comb_2"] = $guest_data ["firstname"] . " " . $guest_data ["middlename"];
		$data ["comb_3"] = $guest_data ["citizenship"];
		$dob_arr = explode ( "-", $guest_data ["dob"] );
		if($dob_arr [0] <> "00"){
			$data ["comb_4"] = $dob_arr [2];
			$data ["comb_5"] = $dob_arr [1];
			$data ["comb_6"] = $dob_arr [0];
		}
		switch ($guest_data ["gender"]) {
			case 1 :
				$data ["comb_61"] = "X";
				break;
			case 2 :
				$data ["comb_62"] = "X";
				break;
			default :
				break;
		}
		
		$data ["comb_7"] = $guest_data ["country"];
		$data ["comb_8"] = $guest_data ["pob_city"];
		
		$doc_type = "";
		if(isset($doc_types[$guest_data ["doc_type"]]["name"])){
			$doc_type = $doc_types[$guest_data ["doc_type"]]["name"];
		}
		if (isset($dict_documenttype_mass [$guest_data ["doc_type"]] ["id"])){
			if(isset($doc_types_short[$dict_documenttype_mass [$guest_data ["doc_type"]] ["id"]])){
				$doc_type = $doc_types_short[$dict_documenttype_mass [$guest_data ["doc_type"]] ["id"]]["short_name"];
			}else{
				$doc_type = $dict_documenttype_mass [$guest_data ["doc_type"]] ["name"];
			}
		}
		if($doc_type == ""){
			if($hotel_location == "rus"){
				$doc_type = $dict_documenttype_mass [103008] ["name"];
			}
		}
		if ($guest_data ["doc_type"] == 1) {
			$data ["comb_9"] = "Паспорт";
		}else{
			$data ["comb_9"] = $doc_type;
		}
		$data ["comb_10"] = $guest_data ["doc_precode"];
		$data ["comb_11"] = $guest_data ["passportid"];
		$doc_date_open_arr = explode ( "-", $guest_data ["doc_date_open"] );
		if($doc_date_open_arr [0] <> "00"){
			$data ["comb_12"] = $doc_date_open_arr [2];
			$data ["comb_13"] = $doc_date_open_arr [1];
			$data ["comb_14"] = $doc_date_open_arr [0];
		}
		
		$doc_date_till_arr = explode ( "-", $guest_data ["doc_date_till"] );
		if($doc_date_till_arr [0] <> "00"){
			$data ["comb_15"] = $doc_date_till_arr [2];
			$data ["comb_16"] = $doc_date_till_arr [1];
			$data ["comb_17"] = $doc_date_till_arr [0];
		}
		$data ["comb_18"] = $reservation_data ["reg_visa_precode"];
		$data ["comb_19"] = $reservation_data ["card_number"];
		
		$card_date_of_issue_arr = explode ( "-", $reservation_data ["card_date_of_issue"] );
		if ($card_date_of_issue_arr [0] != "00") {
			$data ["comb_20"] = $card_date_of_issue_arr [2];
			$data ["comb_21"] = $card_date_of_issue_arr [1];
			$data ["comb_24"] = $card_date_of_issue_arr [0];
		}
		
		$card_valid_time_arr = explode ( "-", $reservation_data ["card_valid_time"] );
		if ($card_valid_time_arr [0] != "00") {
			$data ["comb_22"] = $card_valid_time_arr [2];
			$data ["comb_23"] = $card_valid_time_arr [1];
			$data ["comb_25"] = $card_valid_time_arr [0];
		}
		
		$reg_date_in_arr = explode ( "-", $reservation_data ["reg_date_in"] );
		if ($reg_date_in_arr [0] != "00") {
			$data ["comb_28"] = $reg_date_in_arr [2];
			$data ["comb_29"] = $reg_date_in_arr [1];
			$data ["comb_30"] = $reg_date_in_arr [0];
		}

		$reg_date_out_arr = explode ( "-", $reservation_data ["reg_date_out"] );
		if ($reg_date_out_arr [0] != "00") {
			$data ["comb_31"] = $reg_date_out_arr [2];
			$data ["comb_32"] = $reg_date_out_arr [1];
			$data ["comb_33"] = $reg_date_out_arr [0];
			
			$data ["comb_58"] = $reg_date_out_arr [2];
			$data ["comb_59"] = $reg_date_out_arr [1];
			$data ["comb_60"] = $reg_date_out_arr [0];
		}

		
		//print_r($reg_date_out_arr);
		//die();
		
		
		
		
		$data ["comb_34"] = $reservation_data ["migration_card_precode"];
		$data ["comb_35"] = $reservation_data ["migration_card_num"];
		
		switch ($reservation_data ["visitpurpose"]) {
			case 139344 :
				$data ["comb_66"] = "X";
				break;
			case 139345 :
				$data ["comb_67"] = "X";
				break;
			case 139346 :
				$data ["comb_68"] = "X";
				break;
			case 139347 :
				$data ["comb_69"] = "X";
				break;
			case 139348 :
				$data ["comb_70"] = "X";
				break;
			case 139349 :
				$data ["comb_71"] = "X";
				break;
			case 139350 :
				$data ["comb_72"] = "X";
				break;
			case 139351 :
				$data ["comb_73"] = "X";
				break;
			case 139353 :
				$data ["comb_74"] = "X";
				break;
			default :
				break;
		}
		
		
		
		
		$data ["comb_41"] = $guest_data ["lastname"];
		$data ["comb_42"] = $guest_data ["firstname"] . " " . $guest_data ["middlename"];
		$data ["comb_43"] = $guest_data ["citizenship"];
		$data ["comb_44"] = $dob_arr [2];
		$data ["comb_45"] = $dob_arr [1];
		$data ["comb_46"] = $dob_arr [0];
		switch ($guest_data ["gender"]) {
			case 1 :
				$data ["comb_73"] = "X";
				break;
			case 2 :
				$data ["comb_74"] = "X";
				break;
			default :
				break;
		}
		
		$doc_type = "";
		if(isset($doc_types[$guest_data ["doc_type"]]["name"])){
			$doc_type = $doc_types[$guest_data ["doc_type"]]["name"];
		}
		if (isset($dict_documenttype_mass [$guest_data ["doc_type"]] ["id"])){
			//$doc_type = $dict_documenttype_mass [$guest_data ["doc_type"]] ["name"];
			if(isset($doc_types_short[$dict_documenttype_mass [$guest_data ["doc_type"]] ["id"]])){
				$doc_type = $doc_types_short[$dict_documenttype_mass [$guest_data ["doc_type"]] ["id"]]["short_name"];
			}else{
				$doc_type = $dict_documenttype_mass [$guest_data ["doc_type"]] ["name"];
			}
		}
		if($doc_type == ""){
			if($hotel_location == "rus"){
				$doc_type = $dict_documenttype_mass [103008] ["name"];
			}
		}
		if ($guest_data ["doc_type"] == 1) {
			$data ["comb_47"] = "Паспорт";
		}else{
			$data ["comb_47"] = $doc_type;
		}
		
		switch ($guest_data ["doc_type"]) {
			case 139356 :
				$data ["comb_63"] = "+";
				break;
			case 135709 :
				$data ["comb_64"] = "+";
				break;
			case 135710 :
				$data ["comb_64"] = "+";
				break;
			case 139387 :
				$data ["comb_64"] = "+";
				break;
			case 139385 :
				$data ["comb_64"] = "+";
				break;
			case 135717 :
				$data ["comb_65"] = "+";
				break;
			case 139373 :
				$data ["comb_65"] = "+";
				break;
			case 139388 :
				$data ["comb_65"] = "+";
				break;
		}
		
		$data ["comb_49"] = $guest_data ["doc_precode"];
		$data ["comb_48"] = $guest_data ["passportid"];
		
		
		
		$fms_account_mass = $this->fms_core->get_fms_account($reservation_data["partner"]);
		//print_r($fms_account_mass);
		//die();
		$data ["comb_1_2"] = $fms_account_mass["fms_hiloc_cityregion"];
		$data ["comb_2_2"] = $fms_account_mass["fms_hiloc_state"];
		$data ["comb_3_2"] = $fms_account_mass["fms_hiloc_city"];
		$data ["comb_4_2"] = $fms_account_mass["fms_hiloc_street"];
		$data ["comb_5_2"] = $fms_account_mass["fms_hiloc_objectnumber"];
		$data ["comb_6_2"] = "";//корпус
		$data ["comb_7_2"] = "";//Строение
		$data ["comb_8_2"] = "";//Квартира
		$data ["comb_9_2"] = "";//Тел
		
		$data ["comb_41_2"] = "V";
		$data ["comb_42_2"] = "";//Физ. лицо 
		$data ["comb_11_2"] = "";
		$data ["comb_12_2"] = "";
		$data ["comb_13_2"] = "";
		$data ["comb_14_2"] = "";
		$data ["comb_15_2"] = "";
		$data ["comb_16_2"] = "";
		$data ["comb_17_2"] = "";
		$data ["comb_18_2"] = "";
		$data ["comb_19_2"] = "";
		$data ["comb_20_2"] = "";
		$data ["comb_21_2"] = $fms_account_mass["fms_hiloc_cityregion"];
		$data ["comb_22_2"] = $fms_account_mass["fms_hiloc_state"];
		$data ["comb_23_2"] = $fms_account_mass["fms_hiloc_city"];
		$data ["comb_24_2"] = $fms_account_mass["fms_hiloc_street"];
		$data ["comb_25_2"] = "";
		$data ["comb_26_2"] = "";;
		$data ["comb_27_2"] = "";;
		$data ["comb_28_2"] = "";;
		$data ["comb_29_2"] = "";;
		$data ["comb_30_2"] = "";;
		$data ["comb_31_2"] = "";;
		$data ["comb_32_2"] = "";;
		$data ["comb_33_2"] = "";;
		if ($reg_date_out_arr [0] != "00") {
			$data ["comb_34_2"] = $reg_date_out_arr [2];
			$data ["comb_35_2"] = $reg_date_out_arr [1];
			$data ["comb_36_2"] = $reg_date_out_arr [0];
		}
		
		
		$data ["comb_37_2"] = "";;
		$data ["comb_38_2"] = "";;
		$data ["comb_43_2"] = "";;
		$data ["comb_44_2"] = "";;
		$data ["comb_45_2"] = "";;
		$data ["comb_46_2"] = "";;
		
		// тимчасовий файл з даними
		if (! write_file ( '/var/www/pdfgen/application/FORPDF/tmp/Data', $this->createFieldsInput ( $data ) )) {
			echo 'Unable to write the file';
		} else {
			// заповнюєм ПДФ тими даними
			exec ( 'java -jar /opt/pdfFill/pdfformfiller.jar /opt/pdfFill/uvedomlenie.pdf -f /var/www/pdfgen/application/FORPDF/tmp/Data /var/www/pdfgen/application/FORPDF/tmp/' . $file );
			
			// і на винос як треба
			header ( "Cache-Control: no-cache, must-revalidate" );
			header ( "Expires: Sat, 26 Jul 1997 05:00:00 GMT" );
			header ( 'Content-type: application/pdf' );
			header ( 'Content-Transfer-Encoding: application/octet-stream' );
			// header('Content-Disposition: attachment; filename="' . $file . '"');
			
			echo read_file ( '/var/www/pdfgen/application/FORPDF/tmp/' . $file );
			// delete_files('/var/www/pdfgen/application/FORPDF/tmp/');
		}
	}
	
	public function create_pdf($reservation_id = 0, $guest_id = 0) {
		$legalsystem = $this->frontdesk->getlegalsystem();
		$legalsystem_db = $this->frontdesk->getlegalsystem_db($legalsystem);
	
		$dict_documenttype_mass = $this->fms_core->get_dict_documenttype($legalsystem_db);
		$dict_visitpurpose_mass = $this->fms_core->get_dict_visitpurpose($legalsystem_db);
		//echo "<pre>";
		//print_r($_POST);
		//die();

		if(isset($_POST["reservation_id"])){
			$reservation_id = $_POST["reservation_id"];
		}
		if(isset($_POST["guest_id"])){
			$guest_id = $_POST["guest_id"];
		}
		if(isset($_POST["guests"][0])){
			$guest_id = $_POST["guests"][0];
		}
		
		putenv ( 'LANG=en_US.UTF-8' );
		$this->load->library ( 'parser' );
		$this->load->helper ( 'file' );
		
		$file = "someOut.pdf";
		
		$reservation_data = array ();
		if ($reservation_id != 0) {
			$reservation_data = $this->frontdesk->GetReservation ( $reservation_id );
			if (count ( $reservation_data ) == 0) {
				return "Error";
			}
		}
		
		$guest_data = array ();
		if ($guest_id != 0) {
			$guest_data = $this->frontdesk->GetGuest ( $guest_id );
			if (count ( $guest_data ) == 0) {
				return "Error";
			}
		}
		
		$fms_account_mass = $this->fms_core->get_fms_account($reservation_data["partner"]);
		$fms_user_mass = $this->fms_core->get_fms_user();
		
		$data = array();
		$data["guestid"] = $reservation_id."/".$guest_id;
		$data["lastname"] = mb_strtoupper($guest_data["lastname"]);
		$data["lastname#1"] = mb_strtoupper($guest_data["lastname"]);
		if(trim($guest_data["middlename"]) != ""){
			$data["name"] = mb_strtoupper($guest_data["firstname"]." ".$guest_data["middlename"]);
		}else{
			$data["name"] = mb_strtoupper($guest_data["firstname"]);
		}
		
		$data["name#1"] = $data["name"];
		
		$data["citizenship"] = mb_strtoupper($guest_data["citizenship"]);
		$data["citizenship#1"] = mb_strtoupper($guest_data["citizenship"]);
		
		$data["dateofbirth_day"] = "";
		$data["dateofbirth_month"] = "";
		$data["dateofbirth_year"] = "";
		
		$dob_arr = explode ( "-", $guest_data ["dob"] );
		if($dob_arr [0] <> "00" && $dob_arr [0] != ""){
			$data ["dateofbirth_day"] = $dob_arr [2];
			$data ["dateofbirth_month"] = $dob_arr [1];
			$data ["dateofbirth_year"] = $dob_arr [0];
		}
		$data["dateofbirth_day#1"] = $data["dateofbirth_day"];
		$data["dateofbirth_month#1"] = $data["dateofbirth_month"];
		$data["dateofbirth_year#1"] = $data["dateofbirth_year"];

		$data["male"] = "";
		$data["female"] = "";
		switch ($guest_data ["gender"]) {
			case 1 :
				$data ["male"] = "X";
				break;
			case 2 :
				$data ["female"] = "X";
				break;
			default :
				break;
		}
		$data["male#1"] = $data["male"];
		$data["female#1"] = $data["female"];
		
		$data["placeofbirth_state"] = mb_strtoupper($guest_data ["country"]);
		$data["placeofbirth_city"] = mb_strtoupper($guest_data ["city"]);

		switch ($guest_data ["doc_type"]) {
			case 103009 :
				$data ["typeofid"] = "НАЦ ЗГПАСП";
				break;
			case 135709 :
				$data ["typeofid"] = "ВИД НА ЖИТ";
				break;
			case 103012 :
				$data ["typeofid"] = "ИНПАСПОРТ";
				break;
			case 103014 :
				$data ["typeofid"] = "ИН СВИДРОЖД";
				break;
			case 136359 :
				$data ["typeofid"] = "ДИППАСП ИН";
				break;
			case 102977 :
				$data ["typeofid"] = "СВИДВР УБЕЖ";
				break;
			case 102999 :
				$data ["typeofid"] = "УДОСТ СНГ";
				break;
			case 103010 :
				$data ["typeofid"] = "СЛУЖЕБ ПАСП";
				break;
			case 135710 :
				$data ["typeofid"] = "ВНЖ ЛБГ";
				break;
			case 135717 :
				$data ["typeofid"] = "РВП ЛБГ";
				break;
			case 136366 :
				$data ["typeofid"] = "ИНОЙ ДОК";
				break;
			case 139384 :
				$data ["typeofid"] = "УДОСТ КАЗАХ";
				break;
			case 135710 :
				$data ["typeofid"] = "ВНЖ ЛБГ БИО";
				break;
			default:
				if(isset($dict_documenttype_mass[$guest_data ["doc_type"]])){
					$data ["typeofid"] = $dict_documenttype_mass[$guest_data ["doc_type"]]["name"];
				}else{
					$data ["typeofid"] = "";
				}
				break;
		}
		$data["typeofid#1"] = $data["typeofid"];
		
		$data["idserial"] = mb_strtoupper($guest_data ["doc_precode"]);
		$data["idserial#1"] = mb_strtoupper($data ["idserial"]);
		$data["idnumber"] = mb_strtoupper($guest_data ["passportid"]);
		$data["idnumber#1"] = mb_strtoupper($data ["idnumber"]);
		
		$data["idissue_day"] = "";
		$data["idissue_month"] = "";
		$data["idissue_year"] = "";
		
		$data["idvalidity_day"] = "";
		$data["idvalidity_month"] = "";
		$data["idvalidity_year"] = "";
		
		$doc_date_till_arr = explode ( "-", $guest_data ["doc_date_till"] );
		
		if($doc_date_till_arr [0] <> "00" && $doc_date_till_arr [0] != ""){
			$data ["idvalidity_day"] = $doc_date_till_arr [2];
			$data ["idvalidity_month"] = $doc_date_till_arr [1];
			$data ["idvalidity_year"] = $doc_date_till_arr [0];
		}
		
		$doc_date_open_arr = explode ( "-", $guest_data ["doc_date_open"] );
		
		if($doc_date_open_arr [0] <> "00" && $doc_date_open_arr [0] != ""){
			$data ["idissue_day"] = $doc_date_open_arr [2];
			$data ["idissue_month"] = $doc_date_open_arr [1];
			$data ["idissue_year"] = $doc_date_open_arr [0];
			
			
		}

		$data["visa"] = "";
		if($guest_data ["reg_visa_num"] != ""){
			$data["visa"] = "X";
		}
		
		$data["migrationdoc_serial"] = mb_strtoupper($reservation_data ["reg_visa_precode"]);
		$data["migrationdoc_number"] = mb_strtoupper($guest_data ["reg_visa_num"]);
		
		
		$data["migrationdoc_day"] = "";
		$data["migrationdoc_month"] = "";
		$data["migrationdoc_year"] = "";
		$card_date_of_issue_arr = explode ( "-", $reservation_data ["card_date_of_issue"] );
		if ($card_date_of_issue_arr [0] != "00" && $card_date_of_issue_arr [0] != "") {
			$data ["migrationdoc_day"] = $card_date_of_issue_arr [2];
			$data ["migrationdoc_month"] = $card_date_of_issue_arr [1];
			$data ["migrationdoc_year"] = $card_date_of_issue_arr [0];
		}
		
		$data["migrationdoc_validity_day"] = "";
		$data["migrationdoc_validity_month"] = "";
		$data["migrationdoc_validity_year"] = "";
		$reg_visa_date_till_arr = explode ( "-", $guest_data ["reg_visa_date_till"] );
		if ($reg_visa_date_till_arr [0] != "00" && $reg_visa_date_till_arr [0] != "") {
			$data ["migrationdoc_validity_day"] = $reg_visa_date_till_arr [2];
			$data ["migrationdoc_validity_month"] = $reg_visa_date_till_arr [1];
			$data ["migrationdoc_validity_year"] = $reg_visa_date_till_arr [0];
		}
		
		
		$data["service"] = "";
		$data["tourism"] = "";
		$data["business"] = "";
		$data["study"] = "";
		$data["work"] = "";
		$data["private"] = "";
		$data["transit"] = "";
		$data["humanitarian"] = "";
		$data["other"] = "";
		
		switch ($reservation_data ["visitpurpose"]) {
			case 139344 :
				$data ["service"] = "X";
				break;
			case 139345 :
				$data ["tourism"] = "X";
				break;
			case 139346 :
				$data ["business"] = "X";
				break;
			case 139347 :
				$data ["study"] = "X";
				break;
			case 139348 :
				$data ["work"] = "X";
				break;
			case 139349 :
				$data ["private"] = "X";
				break;
			case 139350 :
				$data ["transit"] = "X";
				break;
			case 139351 :
				$data ["humanitarian"] = "X";
				break;
			case 139353 :
				$data ["other"] = "X";
				break;
			default :
				break;
		}
		
		$data["entrydate_day"] = "";
		$data["entrydate_month"] = "";
		$data["entrydate_year"] = "";
		$reg_date_in_arr = explode ( "-", $reservation_data ["reg_date_in"] );
		if ($reg_date_in_arr [0] != "00" && $reg_date_in_arr [0] != "") {
			$data ["entrydate_day"] = $reg_date_in_arr [2];
			$data ["entrydate_month"] = $reg_date_in_arr [1];
			$data ["entrydate_year"] = $reg_date_in_arr [0];
		}
		
		$data["stayperiod_day"] = "";
		$data["stayperiod_month"] = "";
		$data["stayperiod_year"] = "";
		$reg_date_out_arr = explode ( "-", $reservation_data ["reg_date_out"] );
		if ($reg_date_out_arr [0] != "00" && $reg_date_out_arr [0] != "") {
			$data ["stayperiod_day"] = $reg_date_out_arr [2];
			$data ["stayperiod_month"] = $reg_date_out_arr [1];
			$data ["stayperiod_year"] = $reg_date_out_arr [0];
		}
		
		$data["migrationcard_serial"] = mb_strtoupper($reservation_data ["migration_card_precode"]);
		$data["migrationcard_number"] = mb_strtoupper($reservation_data ["migration_card_num"]);

		$data["region"] = mb_strtoupper($fms_account_mass["fms_hiloc_region"]);
		$data["area"] = mb_strtoupper($fms_account_mass["fms_hiloc_state"]);
		$data["sity"] = mb_strtoupper($fms_account_mass["fms_hiloc_city"]);
		$data["street"] = mb_strtoupper($fms_account_mass["fms_hiloc_street"]);
		$data["house"] = mb_strtoupper($fms_account_mass["fms_hiloc_objectnumber"]);
		
		$data["office_numb"] = $reservation_data["room_id"];
		
		$data["stayperiod_day#1"] = "";
		$data["stayperiod_month#1"] = "";
		$data["stayperiod_year#1"] = "";
		$dateout_arr = explode ( "-", $reservation_data ["dateout"] );
		if ($dateout_arr [0] != "00" && $dateout_arr [0] != "") {
			$data ["stayperiod_day#1"] = $dateout_arr [2];
			$data ["stayperiod_month#1"] = $dateout_arr [1];
			$data ["stayperiod_year#1"] = $dateout_arr [0];
		}
		
		
		$data["2region"] = mb_strtoupper($fms_account_mass["fms_hiloc_region"]);
		$data["2area"] = mb_strtoupper($fms_account_mass["fms_hiloc_state"]);
		$data["2sity"] = mb_strtoupper($fms_account_mass["fms_hiloc_city"]);
		$data["2street"] = mb_strtoupper($fms_account_mass["fms_hiloc_street"]);
		$data["2house"] = mb_strtoupper($fms_account_mass["fms_hiloc_objectnumber"]);
		
		$data["2office_numb"] = $reservation_data["room_id"];
		
		$data["3lastname"] = mb_strtoupper($fms_user_mass["lastname"]);
		$data["3name"] = mb_strtoupper($fms_user_mass["fullname"]." ".$fms_user_mass["middlename"]);
		
		$data["3dateofbirth_day"] = "";
		$data["3dateofbirth_month"] = "";
		$data["3dateofbirth_year"] = "";
		$fms_user_dob_arr = explode ( ".", $fms_user_mass ["dob"] );
		if ($fms_user_dob_arr [0] != "00" && $fms_user_dob_arr [0] != "") {
			$data ["3dateofbirth_year"] = $fms_user_dob_arr [2];
			$data ["3dateofbirth_month"] = $fms_user_dob_arr [1];
			$data ["3dateofbirth_day"] = $fms_user_dob_arr [0];
		}
		
		$data["3idserial"] = mb_strtoupper($fms_user_mass ["doc_precode"]);
		$data["3idnumber"] = mb_strtoupper($fms_user_mass ["passportid"]);
		
		$data["3idissue_day"] = "";
		$data["3idissue_month"] = "";
		$data["3idissue_year"] = "";
		$doc_date_open_arr = explode ( "-", $fms_user_mass ["doc_date_open"] );
		if ($doc_date_open_arr [0] != "00" && $doc_date_open_arr [0] != "") {
			$data ["3idissue_day"] = $doc_date_open_arr [2];
			$data ["3idissue_month"] = $doc_date_open_arr [1];
			$data ["3idissue_year"] = $doc_date_open_arr [0];
		}
		
		$data["3region"] = mb_strtoupper($fms_user_mass["region"]);
		$data["3area"] = mb_strtoupper($fms_user_mass["state"]);
		$data["3sity"] = mb_strtoupper($fms_user_mass["city"]);
		$data["3street"] = mb_strtoupper($fms_user_mass["address"]);
		$data["3house"] = mb_strtoupper($fms_user_mass["building"]);
		//$data["3housing"] = mb_strtoupper($fms_user_mass["building"]);
		//$data["3building"] = mb_strtoupper($fms_user_mass["building"]);
		$data["3office_numb"] = mb_strtoupper($fms_user_mass["apartment"]);
		
		$address = $fms_account_mass["fms_hi_region"]." Г ".$fms_account_mass["fms_hi_city"]." УЛ ".$fms_account_mass["fms_hi_street"]." Д ".$fms_account_mass["fms_hi_objectnumber"];
		//echo $address;
		$data["3address1"] = mb_strtoupper(mb_substr($address, 0, 24));
		$data["3address2"] = mb_strtoupper(mb_substr($address, 24));
		
		$data["3inn"] = mb_strtoupper($fms_account_mass["fms_hotel_inn"]);
		
		
		$data["4departure_day"] = "";
		$data["4departure_month"] = "";
		$data["4departure_year"] = "";
		$dateout_arr = explode ( "-", $reservation_data ["dateout"] );
		if ($dateout_arr [0] != "00" && $dateout_arr [0] != "") {
			//$data ["4departure_day"] = $dateout_arr [2];
			//$data ["4departure_month"] = $dateout_arr [1];
			//$data ["4departure_year"] = $dateout_arr [0];
		}
		
		$data["4lastname"] = mb_strtoupper($fms_user_mass["lastname"]);
		$data["4name"] = mb_strtoupper($fms_user_mass["fullname"]." ".$fms_user_mass["middlename"]);
		$data["quested"] = $guest_id;
		
		
		//$debug = 1;
		if ($this->session->userdata ( 'global_debug' ) == 1) {
			echo "<pre>";
			print_r($data);
			die();
		}
		//=========================================================================================
		// тимчасовий файл з даними
		if (! write_file ( '/var/www/pdfgen/application/FORPDF/tmp/Data', $this->createFieldsInput ( $data ) )) {
			echo 'Unable to write the file';
		} else {
			// заповнюєм ПДФ тими даними
			exec ( 'java -jar /opt/pdfFill/pdfformfiller.jar /opt/pdfFill/uvedomlenie2018.pdf -f /var/www/pdfgen/application/FORPDF/tmp/Data /var/www/pdfgen/application/FORPDF/tmp/' . $file );
				
			// і на винос як треба
			header ( "Cache-Control: no-cache, must-revalidate" );
			header ( "Expires: Sat, 26 Jul 1997 05:00:00 GMT" );
			header ( 'Content-type: application/pdf' );
			header ( 'Content-Transfer-Encoding: application/octet-stream' );
			// header('Content-Disposition: attachment; filename="' . $file . '"');
				
			echo read_file ( '/var/www/pdfgen/application/FORPDF/tmp/' . $file );
			// delete_files('/var/www/pdfgen/application/FORPDF/tmp/');
		}
	}
	
	public function create_bso_pdf_2($reservation_id = 0, $guest_id = 0) {
		
		$this->load->library ( 'tcpdf' );
		$pdf = new TCPDF ( 'P', PDF_UNIT, 'A4', true, 'UTF-8', false );
		
		// generate a simple PDF (for more info, see
		// http://fpdf.org/en/tutorial/)
		$pdf->AddPage ();
		
		$pdf->SetFont ( 'dejavusans', '', 9, '', true );
		
		
		$html = "";
		
		$data = array("reservation_id" => $reservation_id, "guest_id" => $guest_id);
		// print_r ( $data );
			
		$html = $this->load->view ( 'bso_pdf', $data, true );
		$pdf->writeHTML ( $html, true, false, true, false, '' );
			
		// die();
		header ( "Content-Type: application/pdf" );
		header ( "Pragma: public" );
		header ( "Expires: 0" );
		header ( "Cache-Control: must-revalidate, post-check=0, pre-check=0" );
		header ( "Cache-Control: private", false );
		header ( "Content-type: application/force-download" );
		header ( 'Content-Disposition: attachment; filename="bso.pdf";' );
		header ( "Content-Transfer-Encoding: binary" );
		// header("Content-Length: ".sstrlen($pdf));
		header ( "Content-Length: 1000000" );
		$pdf->Output ( 'bso.pdf', 'I' );
	}
	function create_bso_pdf_3($reservation_id = 0, $guest_id = 0, $payment_id = 0){
		header('Content-Type: text/html; charset=cp1251');
		require_once (BASEPATH . 'libraries/dompdf/dompdf_config.inc.php');
		$paper = DOMPDF_DEFAULT_PAPER_SIZE;
		$outfile = 'bso' . "" . '.pdf'; // Don't allow them to set the
		$options ['Attachment'] = 0; // on screen=0 as attach=1
		$orientation = "landscape";
		
		global $_dompdf_show_warnings, $_dompdf_debug, $_DOMPDF_DEBUG_TYPES;
		
		$sapi = php_sapi_name ();
		$dompdf = new DOMPDF ();
		
		$html = "";
		
		$data = array("reservation_id" => $reservation_id, "guest_id" => $guest_id, "payment_id" => $payment_id);
		// print_r ( $data );
			
		$html = $this->load->view ( 'bso_pdf', $data, true );
		
		$dompdf->load_html ( $html );
		$dompdf->set_paper ( $paper, $orientation );
		$dompdf->render ();
		
		if ($_dompdf_show_warnings) {
			global $_dompdf_warnings;
			foreach ( $_dompdf_warnings as $msg )
				echo $msg . "\n";
			echo $dompdf->get_canvas ()->get_cpdf ()->messages;
			flush ();
		}
		
		if (! headers_sent ()) {
			$dompdf->stream ( $outfile, $options );
		}
	}
	
	function vvv($reservation_id = 0, $guest_id = 0){
		require_once (BASEPATH . 'libraries/dompdf/dompdf_config.inc.php');
		$paper = DOMPDF_DEFAULT_PAPER_SIZE;
		$outfile = 'reservation' . $post ["reservation_id"] . '.pdf'; // Don't
		// allow
		// them to
		// set the
		// output
		// file
		$save_file = false; // Don't save the file
		$options ['Attachment'] = 0; // on screen=0 as attach=1
		
		$orientation = "portrait";
		
		global $_dompdf_show_warnings, $_dompdf_debug, $_DOMPDF_DEBUG_TYPES;
		
		$sapi = php_sapi_name ();
		// $options = array();
		$dompdf = new DOMPDF ();
		// =========================
		
		$data = array("reservation_id" => $reservation_id, "guest_id" => $guest_id);
		// print_r ( $data );
			
		$html = $this->load->view ( 'bso_pdf', $data, true );
		
		$dompdf->load_html ( $html );
		
		// $dompdf->set_base_path($base_path);
		
		$dompdf->set_paper ( $paper, $orientation );
		
		$dompdf->render ();
		
		if ($_dompdf_show_warnings) {
			global $_dompdf_warnings;
			foreach ( $_dompdf_warnings as $msg )
				echo $msg . "\n";
			echo $dompdf->get_canvas ()->get_cpdf ()->messages;
			flush ();
		}
		
		if (! headers_sent ()) {
			$dompdf->stream ( $outfile, $options );
		}
	}
	
	public function create_bso_pdf($reservation_id = 0, $guest_id = 0) {
		//print_r($_POST);
		//die();
		if(isset($_POST["reservation_id"])){
			$reservation_id = $_POST["reservation_id"];
		}
		if(isset($_POST["guest_id"])){
			$guest_id = $_POST["guest_id"];
		}
		putenv ( 'LANG=en_US.UTF-8' );
		$this->load->library ( 'parser' );
		$this->load->helper ( 'file' );
	
		$file = "BSO_convert.pdf";
	
		$reservation_data = array ();
		if ($reservation_id != 0) {
			$reservation_data = $this->frontdesk->GetReservation ( $reservation_id );
			if (count ( $reservation_data ) == 0) {
				return "Error";
			}
		}
	
		$guest_data = array ();
		if ($guest_id != 0) {
			$guest_data = $this->frontdesk->GetGuest ( $guest_id );
			if (count ( $guest_data ) == 0) {
				return "Error";
			}
		}
	
		$data = array();
		// тимчасовий файл з даними
		if (! write_file ( '/var/www/pdfgen/application/FORPDF/tmp/Data', $this->createFieldsInput ( $data ) )) {
			echo 'Unable to write the file';
		} else {
			// заповнюєм ПДФ тими даними
			exec ( 'java -jar /opt/pdfFill/pdfformfiller.jar /opt/pdfFill/uvedomlenie.pdf -f /var/www/pdfgen/application/FORPDF/tmp/Data /var/www/pdfgen/application/FORPDF/tmp/' . $file );
	
			// і на винос як треба
			header ( "Cache-Control: no-cache, must-revalidate" );
			header ( "Expires: Sat, 26 Jul 1997 05:00:00 GMT" );
			header ( 'Content-type: application/pdf' );
			header ( 'Content-Transfer-Encoding: application/octet-stream' );
			// header('Content-Disposition: attachment; filename="' . $file . '"');
	
			echo read_file ( '/var/www/pdfgen/application/FORPDF/tmp/' . $file );
			// delete_files('/var/www/pdfgen/application/FORPDF/tmp/');
		}
	}
	
	function createFieldsInput(array $fieldValues) {
		$data = "";
		foreach ( $fieldValues as $name => $value ) {
			$data .= $name . " " . $value . PHP_EOL;
		}
		
		return $data;
	}
}
