<?php
class Payments_c2 extends CI_Controller {

    public $rro_provider;
    public $rro_model_name;
    public $rro_isactive;

	public function __construct() {
		parent::__construct ();

		$this->load->model ( 'activity_log' );
		$this->load->model ( 'loger' );
		$this->load->model ( 'mlanguages' );
		$this->load->model ( 'frontdesk' );
		$this->load->model ( 'frontdesk_c2' );
		$this->load->model ( 'cc_model' );
		$this->load->model ( 'pay' );
		$this->load->model ( 'pay_c2' );
		$this->load->model ( 'dcm_payment' );
		$this->load->model ( 'htmltpl' );
		$this->load->model ( 'Authorization' );
		$this->load->model ( 'Access' );
		$this->load->model ( 'appex' );

		$this->Authorization->IsLogined ();
		$this->implement_rro_data();
		$this->load->model ($this->rro_model_name);
	}

	private function implement_rro_data() {
	    require_once ('application/controllers/rro.php');
	    $status = Rro::get_rro_module_status();
	    $model = Rro::get_rro_mdl_name();
	    $provider = Rro::get_active_rro_provider();
	    $this->rro_provider = $provider;
	    $this->rro_model_name = 'rro_mdl';//$model;
	    $this->rro_isactive = $status;
	    return true;
	}

	function stripe_simple_payment($res_id){
	    $pay_id = 0;
	    $virtual_cc_data = $this->dcm_payment->getvirtualcard($res_id);

	    $payment_deffered_id = 0;
	    $currency = "";
	    $amount = 0;
	    $sql = "SELECT pd.id as pd_id, pd.currency, pd.amount
                FROM tbl_CreditCards
                INNER JOIN payment_deffered as pd ON pd.tcc_id = tbl_CreditCards.id
                WHERE tbl_CreditCards.reservation_id = " . $res_id;
	    $query = $this->db->query($sql);
	    if ($query->num_rows() > 0) {
	        $row = $query->row();
	        $payment_deffered_id = $row->pd_id;
	        $currency = $row->currency;
	        $amount = number_format($amount / 10, 2, ".", "");
	    }

	    $cc_data = array();
	    $cc_data["cardnumber"] = $virtual_cc_data["cardnumber"];
	    $cc_data["cardholder"] = $virtual_cc_data["cardholder"];
	    $cc_data["cvc"] = $virtual_cc_data["cvc"];
	    $cc_data["active"] = 1;

	    $exp_date_arr = explode("/", $virtual_cc_data["exp_date"]);
	    if ($exp_date_arr[0] < 10) {
	        $cc_data["expmonth"] = "0" . $exp_date_arr[0];
	    } else {
	        $cc_data["expmonth"] = $exp_date_arr[0];
	    }
	    $cc_data["expyear"] = $exp_date_arr[1];
	    if ($cc_data["expyear"] > 2000) {
	        $cc_data["expyear"] = $cc_data["expyear"] - 2000;
	    }

	    $cc_data["amount"] = $amount;
	    $cc_data["currency"] = $currency;
	    $cc_data["hms_payment_id"] = $pay_id;
	    $cc_data["hms_res_id"] = $res_id;
	    $cc_data["number"] = $this->config->item('hotel_id') . "-" . $res_id . "-" . $pay_id;
	    // ====== STRIPE ========
	    $result = $this->Stripe->pay_request_VC($cc_data);
	}

	// payment without real pay
	function ajax_makevirtualcardpayment_not_real(){
	    //print_r($_POST);
	    $res_id = $_POST ["reservation_id"];
	    $this->dcm_payment->make_payment_with_pd($res_id);
	}

	// continue pay with payment_deffred
	function continue_pay($reservation_id, $pay_id){
	   $payment_deffered_id = $this->dcm_payment->get_peyment_deffered_id_by_resid($reservation_id);
	   $result = $this->dcm_payment->continue_payment_by_pay_id($reservation_id, $pay_id);

	   if (isset ( $result ['status'] )) {
	       switch ($result ['status']) {
	           case "authorise" :
	               $sql = "UPDATE  payment_deffered SET state = 1, payment_id = $pay_id WHERE id = " . $payment_deffered_id;
	               $query = $this->db->query ( $sql );
	               die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $reservation_id . "/1'>" );
	               break;
	           case "OK" :
	               $sql = "UPDATE  payment_deffered SET state = 1, payment_id = $pay_id WHERE id = " . $payment_deffered_id;
	               $query = $this->db->query ( $sql );

	               die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $reservation_id . "/1'>" );
	               break;
	           case "error" :

	               $html_data = array ();
	               $html_data ['errortext'] = $result ['errortext'];
	               $html_data ["header"] = $this->htmltpl->getHeader_new ();
	               $html_data ["reservation_id"] = $reservation_id;

	               $html_data ["landing_page_link"] = "/reservation_c2/folio/" . $reservation_id . "/1";
	               $this->mlanguages->getdictionary ( "errors_freeerror", "", $html_data );

	               echo $this->parser->parse ( 'templates/appex_error_view.html', $html_data, TRUE );

	               return;
	               break;
                case "wait":
                    $sql = "UPDATE  payment_deffered SET payment_id = $pay_id WHERE id = " . $payment_deffered_id;
                    $query = $this->db->query($sql);

                    $data = array();
                    $data['pay_id'] = $pay_id;
                    $this->load->library('parser');
                    $this->load->view('payments_appex_3ds_view.php', $data);
                    return;
                    break;
                default :
	               // print_r($result);
	               // die();
	               break;
	       }
	   }
	}

	function ajax_stripe_payment_vcc_update(){
	    //print_r($_POST);
	    $post = file_get_contents('php://input');
	    $post = json_decode($post, true);
	    // 	    echo "<pre>";
	    // 	    print_r($post);

	    $stripe_payments_id = 0;
	    $sql = "SELECT id FROM stripe_payments WHERE hms_payment_id = ".$post['hms_payment_id'];
	    //echo $sql;
	    $query = $this->db->query($sql);
	    if ($query->num_rows() > 0) {
	        $row = $query->row();
	        $stripe_payments_id = $row->id;
	    }
	    $payment_deffered_id = $this->dcm_payment->get_peyment_deffered_id_by_resid($post['hms_res_id']);

	    switch($post['stripe_status']){
	        case "succeeded":
	            $data = array();
	            $data['hms_payment_id'] = $post['hms_payment_id'];
	            $data['transID'] = 0;
	            $data['status'] = $post['stripe_status'];
	            $data['number'] = $post['number'];
	            $data['json'] = json_encode($post['response']);

	            if($stripe_payments_id > 0){
	                $this->db->where('id', $stripe_payments_id);
	                $this->db->update('stripe_payments', $data);
	            }else{
	                $this->db->insert('stripe_payments', $data);
	                $id = $this->db->insert_id();
	            }


	            $sql = "UPDATE  payment_deffered SET state = 1, payment_id = ".$post['hms_payment_id']." WHERE id = " . $payment_deffered_id;
	            $query = $this->db->query ( $sql );

	            break;
	        default:

	            break;
	    }
	    $result = array();
	    $result['message'] = $post['hms_payment_id']." ".$post['hms_res_id']." ".$post['stripe_status'];
	    echo json_encode($result);
	}

	function makevirtualcardpayment() {
// 		print_r($_POST);
// 		die();
		$res_id = $_POST ["res_id"];
		$id_partner = 0;
		$dc_id = 0;
		$sql = "SELECT id_partner, dc_id FROM deskofreservation WHERE id = " . $res_id;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row_array ();
			$id_partner = $row ["id_partner"];
			$dc_id = $row ["dc_id"];
		}

		$payment_type = 0;
		switch ($dc_id) {
			case 3 :
				$sql = "SELECT int_value FROM dc_expedia_xml_cfg WHERE name LIKE 'payment_type'";
				$query = $this->db->query ( $sql );
				if ($query->num_rows () > 0) {
					$row = $query->row_array ();
					$payment_type = $row ["int_value"];
				}
				break;
			case 1 :
				$sql = "SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'payment_type'";
				$query = $this->db->query ( $sql );
				if ($query->num_rows () > 0) {
					$row = $query->row_array ();
					$payment_type = $row ["int_value"];
				}
				break;
			default :
				$sql = "SELECT id FROM payment_types WHERE 1 ORDER by id ASC LIMIT 0,1";
				$query = $this->db->query ( $sql );
				if ($query->num_rows () > 0) {
					$row = $query->row_array ();
					$payment_type = $row ["id"];
				}
				break;
		}

		if($payment_type == 0){
			die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/49'>" );
		}

		$data = array ();
		$data ["res_id"] = $res_id;
		$data ["payment_type"] = $payment_type;
		$data ["payment_deffered_id"] = $_POST ["payment_deffered_id"];
		//$data ["amount"] = $service_main_amount;
		if(isset($_POST ["landing_page"])){
			$data ["landing_page"] = $_POST ["landing_page"];
		}else{
			$data ["landing_page"] = "folio";
		}
		$data ["id_partner"] = $id_partner;

		$result = $this->dcm_payment->makevirtualcardpayment ( $data );
//         print_r($result);
//         print_r($data);
//         die();
		$pay_id = (isset( $result ['pay_id'] )) ? $result ['pay_id'] : 0;
		if (isset ( $result ['status'] )) {
			switch ($result ['status']) {
				case "authorise" :
					$sql = "UPDATE  payment_deffered SET state = 1, payment_id = $pay_id WHERE id = " . $data ["payment_deffered_id"];
					$query = $this->db->query ( $sql );
					if (isset ( $data ["landing_page"] )) {
						switch ($data ["landing_page"]) {
							case "folio" :
								die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $data ["res_id"] . "/1'>" );
								break;
							case "master_c2_step3" :
								die ( "<meta http-equiv='refresh' content='0;url=/master_c2/step_3/" . $data ["res_id"] . "'>" );
								break;
							case "master_c2_checkout_step2" :
								die ( "<meta http-equiv='refresh' content='0;url=/master_c2/checkout_step_2/" . $data ["res_id"] . "'>" );
								break;
							case "master_c2_checkout_step3":
                                die("<meta http-equiv='refresh' content='0;url=/master_c2/checkout_step_3/" . $data["res_id"] . "'>");
                                break;
                            case "report_c2_virtual_cc_list":
                                die("<meta http-equiv='refresh' content='0;url=/reports_c2/virtual_cc_list/1'>");
                                break;

							default :
								die ( "<meta http-equiv='refresh' content='0;url=/reservations/ReservationViewForm/" . $data ["res_id"] . "'>" );
								break;
						}
					}
					break;
				case "OK" :
					$sql = "UPDATE  payment_deffered SET state = 1, payment_id = $pay_id WHERE id = " . $data ["payment_deffered_id"];
					$query = $this->db->query ( $sql );

					if (isset ( $data ["landing_page"] )) {
						switch ($data ["landing_page"]) {
							case "folio" :
								die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $data ["res_id"] . "/1'>" );
								break;
							case "master_c2_step3" :
								die ( "<meta http-equiv='refresh' content='0;url=/master_c2/step_3/" . $data ["res_id"] . "'>" );
								break;
							case "master_c2_checkout_step2" :
								die ( "<meta http-equiv='refresh' content='0;url=/master_c2/checkout_step_2/" . $data ["res_id"] . "'>" );
								break;
							case "master_c2_checkout_step3":
                                die("<meta http-equiv='refresh' content='0;url=/master_c2/checkout_step_3/" . $data["res_id"] . "'>");
                                break;
                            case "report_c2_virtual_cc_list":
                                die("<meta http-equiv='refresh' content='0;url=/reports_c2/virtual_cc_list/1'>");
                                break;

							default :
								die ( "<meta http-equiv='refresh' content='0;url=/reservations/ReservationViewForm/" . $data ["res_id"] . "'>" );
								break;
						}
					}
					break;
				case "error" :
					if(isset($result ['pay_id'])){
						$this->pay->DeletePayment ( $data ["res_id"], $result ['pay_id'], "", 1, $data ["landing_page"] );
					}

					$html_data = array ();
					$html_data ['errortext'] = $result ['errortext'];
					$html_data ["header"] = $this->htmltpl->getHeader_new ();
					$html_data ["reservation_id"] = $data ["res_id"];

					if (isset ( $data ["landing_page"] )) {
						switch ($data ["landing_page"]) {
							case "folio" :
								$html_data ["landing_page_link"] = "/reservation_c2/folio/" . $data ["res_id"] . "/1";
								break;
							case "master_c2_step3" :
								$html_data ["landing_page_link"] = "/master_c2/step_3/" . $data ["res_id"];

								break;
							case "master_c2_checkout_step2" :
								$html_data ["landing_page_link"] = "/master_c2/checkout_step_2/" . $data ["res_id"];
								break;
							case "master_c2_checkout_step3":
                                $html_data["landing_page_link"] = "/master_c2/checkout_step_3/" . $data["res_id"];
                                break;
                            case "report_c2_virtual_cc_list":
                                $html_data["landing_page_link"] = "/reports_c2/virtual_cc_list/1";
                                break;

							default :
								$html_data ["landing_page_link"] = "/reservation_c2/folio/" . $data ["res_id"] . "/1";
								break;
						}
					}
					$this->mlanguages->getdictionary ( "errors_freeerror", "", $html_data );

					echo $this->parser->parse ( 'templates/appex_error_view.html', $html_data, TRUE );

					return;
					break;
				case "wait" :
					//$this->pay->DeletePayment ( $data ["res_id"], $result ['pay_id'], "", 1, $data ["landing_page"] );
//                     echo "<pre>";
// 				    print_r($data);
//                     die();
				    $sql = "UPDATE  payment_deffered SET payment_id = $pay_id WHERE id = " . $data ["payment_deffered_id"];
				    $query = $this->db->query ( $sql );
					$html_data = array ();
					$html_data ['errortext'] = "???";
					$html_data ["header"] = $this->htmltpl->getHeader_new ();
					$html_data ["reservation_id"] = $data ["res_id"];
					if (isset ( $data ["landing_page"] )) {
						switch ($data ["landing_page"]) {
							case "folio" :
								//$html_data ["landing_page_link"] = "/reservation_c2/folio/" . $data ["res_id"] . "/1";

								if(isset($result ['pay_id'])){
								    $data = array ();
								    $data ['pay_id'] = $result ['pay_id'];
								    $this->load->library ( 'parser' );
								    $this->load->view ( 'payments_appex_3ds_view.php', $data );
								    return ;
								}

								break;
							case "master_c2_step3" :
								$html_data ["landing_page_link"] = "/master_c2/step_3/" . $data ["res_id"];

								break;
							case "master_c2_checkout_step2" :
								$html_data ["landing_page_link"] = "/master_c2/checkout_step_2/" . $data ["res_id"];
								break;
							case "master_c2_checkout_step3":
                                $html_data["landing_page_link"] = "/master_c2/checkout_step_3/" . $data["res_id"];
                                break;
                            case "report_c2_virtual_cc_list":
                                $html_data["landing_page_link"] = "/reports_c2/virtual_cc_list/1";
                                break;

							default :
								$html_data ["landing_page_link"] = "/reservation_c2/folio/" . $data ["res_id"] . "/1";
								break;
						}
					}
					$this->mlanguages->getdictionary ( "errors_freeerror", "", $html_data );

					echo $this->parser->parse ( 'templates/appex_error_view.html', $html_data, TRUE );

					return;
					break;
				default :
					// print_r($result);
					// die();
					break;
			}
		}
	}
	function ajax_payment_edit() {
		$this->activity_log->SaveLog ( 2 );
		// json_encode($_POST);
		$result = $this->htmltpl->GetPaymentFormEdit_c2 ( $_POST );
		echo $result;
	}

	function ajax_edit_cc() {
		$madal_data = array();
		$madal_data["guest_id"] = $_POST["reservations"][0]["guest_id"];
		$madal_data["reservation_id"] = $_POST["reservations"][0]["reservation_id"];
		$madal_data["cc_id"] = $_POST["reservations"][0]["cc_id"];
		$madal_data["landing_page"] = $_POST["reservations"][0]["landing_page"];
		$result = $this->htmltpl->get_modal_ajax_edit_cc_payment ( $madal_data );
		echo $result;
	}

	function payment_listdate($page= 1){
		$this->activity_log->SaveLog ( 1 );
		$post = $this->input->post();

	    if (isset ( $post ["isclosed"] )) {
            $this->session->set_userdata(array('payment_listdate_isclosed' => $post ["isclosed"]));
            $_SESSION['payment_listdate_isclosed'] = $post ["isclosed"];
		}
		if (isset ( $post ["user"] )) {
            $this->session->set_userdata(array('payment_listdate_user' => $post["user"]));
			$_SESSION['payment_listdate_user'] = $post ["user"];
		}
		if (isset ( $post ["search_guest"] )) {
			$search_guest = $post ["search_guest"];
			$newdata = array (
					'payment_listdate_guest' => $search_guest
			);
			$this->session->set_userdata ( $newdata );
			$_SESSION ["payment_listdate_guest"] = $search_guest;
		}
		if (isset ( $post ["sort_reservation_id"] )) {
			// die($post ["sort_pay_datein"]);
			$sort_reservation_id = $post ["sort_reservation_id"];
			$newdata = array (
					'sort_reservation_id' => $sort_reservation_id
			);
			$this->session->set_userdata ( $newdata );
		}
		if (isset ( $post ["sort_pay_createdate"] )) {
			$sort_pay_createdate = $post ["sort_pay_createdate"];
			$newdata = array (
					'sort_pay_createdate' => $sort_pay_createdate
			);
			$this->session->set_userdata ( $newdata );
		}

		if (isset ( $post ["date_filter"] )) {
			$date_filter = $post ["date_filter"];
			$newdata = array (
					'date_filter' => $date_filter
			);
			$this->session->set_userdata ( $newdata );
			$_SESSION ["date_filter"] = $date_filter;
		}
		if (isset ( $post ["date"] )) {
			$datein = $post ["date"];
			$newdata = array (
					'payment_listdate_date' => $datein
			);
			$this->session->set_userdata ( $newdata );
			$_SESSION ["payment_listdate_date"] = $datein;
		}

		if (isset ( $post ["type"] )) {
			$type = $post ["type"];
			$newdata = array (
					'payment_listdate_type_service' => $type
			);
			$this->session->set_userdata ( $newdata );
			$_SESSION ["payment_listdate_type_service"] = $type;
		}

		if (isset ( $post ["dealers"] )) {
			$dealers = $post ["dealers"];
			$newdata = array (
					'payment_listdate_dealers' => $dealers
			);
			$this->session->set_userdata ( $newdata );
			$_SESSION ["payment_listdate_dealers"] = $dealers;
		}

		if (isset ( $post ["partner"] )) {
			$partner = $post ["partner"];
			$newdata = array (
					'payment_listdate_partner' => $partner
			);
			$this->session->set_userdata ( $newdata );
			$_SESSION ["payment_listdate_partner"] = $partner;
		}

		if (isset ( $post ["payment_type"] )) {
			$payment_type = $post ["payment_type"];
			$newdata = array (
					'payment_listdate_payment_type' => $payment_type
			);
			$this->session->set_userdata ( $newdata );
			$_SESSION ["payment_listdate_payment_type"] = $payment_type;
		}
		if (isset ( $post ["room"] )) {
			$room = $post ["room"];
			$newdata = array (
					'payment_listdate_room' => $room
			);
			$this->session->set_userdata ( $newdata );
			$_SESSION ["payment_listdate_room"] = $room;
		}

		if (isset ( $post ["reservation_status"] )) {
			$reservation_status = $post ["reservation_status"];
			$newdata = array (
					'payment_listdate_reservation_status' => $reservation_status
			);
			$this->session->set_userdata ( $newdata );
			$_SESSION ["payment_listdate_reservation_status"] = $reservation_status;
		}
		if (isset ( $post ["category"] )) {
			$category = $post ["category"];
			$newdata = array (
					'payment_listdate_category' => $category
			);
			$this->session->set_userdata ( $newdata );
			$_SESSION ["payment_listdate_category"] = $category;
		}

		$data = array ();
		if (isset ( $post ["lines_per_page"] )) {
			$this->session->set_userdata ( array ('payment_listdate_lines_per_page' => $post ["lines_per_page"]) );
			$_SESSION['payment_listdate_lines_per_page'] = $post ["lines_per_page"];
		}

		$data["current_page"] = isset($post ["goto_page"]) ? $post ["goto_page"] : $page;
		$this->load->library('parser');
		$this->load->view('payments_c2_payment_listdate_view.php', $data);
	}

	function dealerbalance($quarter_year = 0, $quarter = 0, $quarter_month = 0) {
		$access = $this->Access->get_page_access("reportdealerbalane", "view");
		if($access <> 2){
			$this->activity_log->SaveLog ( 1 );
			if (isset ( $_POST ["date"] )) {
				$date = $_POST ["date"];
				$newdata = array (
						'dealerbalance_date_c2' => $date
				);
				$this->session->set_userdata ( $newdata );
			}
			if (isset ( $_POST ["status"] )) {
				$status = array();
				foreach ( $_POST ["status"] as $val ) {
					$status [$val] = $val;
				}
				$newdata = array (
						'dealerbalance_status_c2' => $status
				);
				$this->session->set_userdata ( $newdata );
			}
			$data = array ();
			$this->load->library ( 'parser' );
			$this->load->view ( 'payments_c2_dealerbalance_view.php', $data );
		}else{
			die ( "<meta http-equiv='refresh' content='0;url=/errors/FreeError/30'>" );
		}
	}
	function SaveCCPayment($reservation_id){

		$cc_data = array();
		$cc_data ["guest_id"] = $_POST ["guest_id"];
		$cc_data ["cardnumber"] = $_POST ["cardnumber"];
		$cc_data ["cardholder"] = $_POST ["cardholder"];
		$cc_data ["cvc"] = $_POST ["cvc"];
		$cc_data ["active"] = 1;
		$cc_data ["cardnumber"] = $_POST ["cardnumber"];

		$exp_date_arr = explode("/",$_POST ["exp_date"]);
		$cc_data ["expmonth"] = $exp_date_arr[0];
		$cc_data ["expyear"] = $exp_date_arr[1];

		$this->cc_model->save_cc($cc_data);

		switch($_POST["landing_page"]){
			case "folio":
				die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/".$reservation_id."/1'>" );
				break;
		}
	}

	function DeleteCCPayment() {
		$cc_id = $_POST ["cc_id"];

		$this->cc_model->delete_cc ( $cc_id );

		switch ($_POST ["landing_page"]) {
			case "folio" :
				die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $_POST ["reservation_id"] . "/1'>" );
				break;
		}
	}

	function UpdateCCPayment(){
		$cc_data = array();
		$cc_data ["cc_id"] = $_POST ["cc_id"];
		$cc_data ["guest_id"] = $_POST ["guest_id"];
		$cc_data ["cardnumber"] = $_POST ["cardnumber"];
		$cc_data ["cardholder"] = $_POST ["cardholder"];
		$cc_data ["cvc"] = $_POST ["cvc"];
		$cc_data ["active"] = 1;
		$cc_data ["cardnumber"] = $_POST ["cardnumber"];

		$exp_date_arr = explode("/",$_POST ["exp_date"]);

		$cc_data ["expmonth"] = $exp_date_arr[0];
		$cc_data ["expyear"] = $exp_date_arr[1];

		$this->cc_model->update_cc ( $cc_data );

		switch ($_POST ["landing_page"]) {
			case "folio" :
				die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $_POST ["reservation_id"] . "/1'>" );
				break;
		}
	}

	function ajax_add_cc_payment(){
		$guest_id = $_POST["reservations"][0]["guest_id"];
		$reservation_id = $_POST["reservations"][0]["reservation_id"];
		$landing_page = "";
		if(isset($_POST["reservations"][0]["landing_page"])){
			$landing_page = $_POST["reservations"][0]["landing_page"];
		}
		echo $this->htmltpl->get_modal_ajax_add_cc_payment($reservation_id, $guest_id, $landing_page);
	}

	function bulkpayment_delete() {
		// print_r ( $_POST );
		$post = $_POST;

		if (isset ( $post ["selected_payment"] )) {

			$checked_items = $post ['selected_payment'];

			$len = count ( $checked_items );
			if ($len > 0) {
				$select = " id IN (";
				for($i = 0; $i < $len; $i ++) {
					if ($i == ($len - 1)) {
						$select .= $checked_items [$i];
					} else {
						$select .= $checked_items [$i] . ", ";
					}
				}
				$select .= ") ";
				$reservation_array = array ();
				$sql = "SELECT id, reservation_id FROM payment WHERE " . $select;
				$query = $this->db->query ( $sql );

				if ($query->num_rows () > 0) {
					foreach ( $query->result () as $row ) {
						$reservation_array [$row->id] = $row->reservation_id;
					}
				}
				for($i = 0; $i < $len; $i ++) {
					$pay_id = $checked_items [$i];
					$res_id = $reservation_array [$pay_id];
					$this->pay->DeletePayment ( $res_id, $pay_id, "", 1 );
				}
				$newdata = array (
						'header_msg' => 15
				);

				$this->session->set_userdata ( $newdata );
			}
			die ( "<meta http-equiv='refresh' content='0;url=/payments_c2/payment_listdate/1'>" );
		} else {
			if (isset ( $post ["selected_reservation"] )) {
				$newdata = array (
						'header_msg' => 14
				);
			} else {
				$newdata = array (
						'header_msg' => 16
				);
			}

			$this->session->set_userdata ( $newdata );
			die ( "<meta http-equiv='refresh' content='0;url=/payments_c2/payment_listdate/1'>" );
		}
		die ();
	}

	function bulkpayment_closed() {
// 	    	    echo "<pre>";
// 	    	     print_r ( $_POST );
// 	    	     die();

	    $access_data = array('page_name' => 'payment_accept', 'type' => 'edit');
	    $this->Access->get_access($access_data);

	    $post = $_POST;

	    if (isset ( $post ["selected_payment"] )) {

	        $checked_items = $post ['selected_payment'];

	        $len = count ( $checked_items );
	        if ($len > 0) {
	            for($i = 0; $i < $len; $i ++) {
	                $pay_id = $checked_items [$i];

	                $this->pay->PaymentClosed ( $pay_id );
	            }

	            $newdata = array (
	                'header_msg' => 15
	            );

	            $this->session->set_userdata ( $newdata );
	        }

	    }elseif(isset ( $post ["selected_refunds"] )){
	        $checked_items = $post ['selected_refunds'];

	        $len = count ( $checked_items );
	        if ($len > 0) {
	            for($i = 0; $i < $len; $i ++) {
	                $refund_id = $checked_items [$i];

	                $this->pay->RefundClosed ( $refund_id );
	            }

	            $newdata = array (
	                'header_msg' => 15
	            );

	            $this->session->set_userdata ( $newdata );
	        }
	    }else {
	        if (isset ( $post ["selected_reservation"] )) {
	            $newdata = array (
	                'header_msg' => 14
	            );
	        } else {
	            $newdata = array (
	                'header_msg' => 16
	            );
	        }

	        $this->session->set_userdata ( $newdata );
	        //die ( "<meta http-equiv='refresh' content='0;url=/payments_c2/payment_listdate/1'>" );
	    }
	    die ( "<meta http-equiv='refresh' content='0;url=/payments_c2/payment_listdate/1'>" );
	}

	function SaveTestPayment($id) {// коли запрацює ajax_Save_KKM_Payment, цю лабуду стерти 21.05.21
// 	    echo "<pre>";
// 	    print_r($_POST);
// 	    die();
		$is_appex = $this->Appex->isenabled();
		$res = array();
		$_POST['is_wait'] = 0;
		if(isset($_POST["id_cc_p"]) && $is_appex){
			if($_POST["id_cc_p"] != 0){
				$_POST['is_wait'] = 1;
				$pay_id = $this->pay_c2->SavePayment ( $_POST, $id, 1);
			}else{
				$this->pay_c2->SavePayment ( $_POST, $id);
			}
		}else{
//========================= payment throuhg kkm start==========================================
			if (isset ( $_POST ["kkm_MethodCalculation"] )) {
				$pay_id = $this->pay_c2->SavePayment ( $_POST, $id, 1);
				$payment_data['id'] = $pay_id;
				echo json_encode ( $payment_data);
				return;
//========================= payment throuhg kkm end ==========================================
			}else{
				$this->pay_c2->SavePayment ( $_POST, $id);
			}
		}

		if (isset ( $_POST ["id_cc_p"] )  && $is_appex) {
			if ($_POST ["id_cc_p"] != 0) {
				$main_guest_id = $this->frontdesk_c2->get_main_guest_id ( $_POST ["reservation_id"] );
				$cc_data = array ();
				if ($_POST ["id_cc_p"] == "new") {
					$cc_data ["guest_id"] = $main_guest_id;
					$cc_data ["cardnumber"] = $_POST ["cardnumber"];
					$cc_data ["cardholder"] = $_POST ["cardholder"];
					$cc_data ["cvc"] = $_POST ["cvc"];
					$cc_data ["active"] = 1;
					$cc_data ["cardnumber"] = $_POST ["cardnumber"];

					$exp_date_arr = explode ( "/", $_POST ["exp_date"] );
					$cc_data ["expmonth"] = $exp_date_arr [0];
					$cc_data ["expyear"] = $exp_date_arr [1];
					$cc_id = $this->cc_model->save_cc ( $cc_data );
				} else {
					$cc_data = $this->cc_model->get_cc_data ( $_POST ["id_cc_p"] );
				}
				$cc_data ["amount"] = $_POST ["amount"];
				$cc_data ["hms_payment_id"] = $pay_id;
				$cc_data ["hms_res_id"] = $_POST ["reservation_id"];
				$cc_data ["number"] = $this->config->item ( 'hotel_id' ) . "-" . $_POST ["reservation_id"] . "-" . $pay_id;
				$result = $this->Appex->pay_request ( $cc_data );
				//
				//
				// die(1);
// 				print_r($result);
// 				die();
				switch ($result ['status']) {

					case "authorise" :
						if (isset ( $_POST ["landing_page"] )) {
							switch ($_POST ["landing_page"]) {
								case "folio" :
								    die("1111");
									die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $id . "/1'>" );
									break;
								case "master_c2_step3" :
									die ( "<meta http-equiv='refresh' content='0;url=/master_c2/step_3/" . $id . "/1'>" );
									break;
								case "master_c2_checkout_step2":
									die("<meta http-equiv='refresh' content='0;url=/master_c2/checkout_step_2/" . $id . "'>");
									break;
								case "master_c2_checkout_step3":
									$landing_page_link = "/master_c2/checkout_step_3/" . $id . "/1";
									die ( "<meta http-equiv='refresh' content='0;url=".$landing_page_link."'>" );
									break;
								default :
									die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $id . "/1'>" );
									break;
							}
						}
						break;
					case "OK" :
						if (isset ( $_POST ["landing_page"] )) {
							switch ($_POST ["landing_page"]) {
								case "folio" :
									die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $id . "/1'>" );
									break;
								case "master_c2_step3" :
									die ( "<meta http-equiv='refresh' content='0;url=/master_c2/step_3/" . $id . "/1'>" );
									break;
								case "master_c2_checkout_step2" :
									die ( "<meta http-equiv='refresh' content='0;url=/master_c2/checkout_step_2/" . $id . "'>" );
									break;
								case "master_c2_checkout_step3":
									$landing_page_link = "/master_c2/checkout_step_3/" . $id . "/1";
									die ( "<meta http-equiv='refresh' content='0;url=".$landing_page_link."'>" );
									break;
								default :
									die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $id . "/1'>" );
									break;
							}
						}
						break;
					case "error" :
						if (1==2) {
							echo "<pre>";
							print_r($result);
							print_r($_POST);
							die();
						}


						$this->pay_c2->DeletePayment ( $_POST ["reservation_id"], $pay_id, "", 1, $_POST ["landing_page"] );
						// die();
						$html_data = array ();

						if (isset ( $_POST ["landing_page"] )) {
							switch ($_POST ["landing_page"]) {
								case "folio" :
									$landing_page_link = "/reservation_c2/folio/" . $id . "/1";
									break;
								case "master_c2_step3" :
									$landing_page_link = "/master_c2/step_3/" . $id . "/1";
									break;
								case "master_c2_checkout_step2":
									$landing_page_link = "/master_c2/checkout_step_2/" . $id . "/1";
									break;
								case "master_c2_checkout_step3":
									$landing_page_link = "/master_c2/checkout_step_3/" . $id . "/1";
									break;
								default :
									$landing_page_link = "/reservation_c2/folio/" . $id . "/1";
									break;
							}
						}
						$html_data ['landing_page_link'] = $landing_page_link;
						$html_data ['errortext'] = $result ['errortext'];
						$html_data ["header"] = $this->htmltpl->getHeader_new ();
						$html_data ["reservation_id"] = $id;
						$this->mlanguages->getdictionary ( "errors_freeerror", "", $html_data );
						if (isset ( $_POST ["return_type"] )) {
							if ($_POST ["return_type"] <> "ajax_mode") {
								echo $this->parser->parse ( 'templates/appex_error_view.html', $html_data, TRUE );
							}else{
								$res ["result_html"] = $this->parser->parse ( 'templates/appex_error_view.html', $html_data, TRUE );
							}
						}else{
							echo $this->parser->parse ( 'templates/appex_error_view.html', $html_data, TRUE );
						}
						return ;
						// die();
						break;
					case "wait" :

						$data = array ();
						$data ['pay_id'] = $pay_id;
						$this->load->library ( 'parser' );
						$this->load->view ( 'payments_appex_3ds_view.php', $data );

						if (isset ( $_POST ["landing_page"] )) {
							if ($_POST ["landing_page"] === "folio") {
								//echo "wait CC";
								// die("<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $id . "/1'>");
							}
						}
						return ;
						break;
					default :
						// print_r($result);
						// die();
						break;
				}
			}
		}
		//echo $result['status'];
		if (isset ( $_POST ["return_type"] )) {
			if($_POST ["return_type"] == "ajax_mode"){

				$res_data = $this->frontdesk->GetReservation($_POST ["reservation_id"]);

				list ( $year, $month, $day ) = explode ( "-", $res_data ["datein"] );
				$intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

				$res ["ok"] = 1;
				$res ["room_id"] = $res_data ["room_id"];
				$res ["from"] = $intdatein;

				if ($_POST ["landing_page"] === "calendar_c2"){
					$res ['htmldiv'] = $this->livecalendar_dev->buildresdev_by_resid2 ( $_POST ["reservation_id"] );

					//$data2 = array();
					//$res ['htmldiv'] = $this->livecalendar_dev->buildresdev_new2 ( $data2 );
				}

				echo json_encode ( $res );
			}else{
				//die();
				if (isset ( $_POST ["landing_page"] )) {
					if ($_POST ["landing_page"] === "folio") {
						die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $id . "/1'>" );
					}
				}
			}
		}
	}

	function ajax_edit_refund(){
	    $post = $this->input->post();
	    $reservation_id = 'xhia';
	    $refund_id = $post["reservations"][0]["id"];
	    $landing_page = "";
	    if(isset($post["reservations"][0]["landing_page"])){
	        $landing_page = $post["reservations"][0]["landing_page"];
	    }
	    echo $this->htmltpl->get_modal_ajax_edit_refund_new($reservation_id, $refund_id, $landing_page);
	}

	function refunds_delete(){
	    $post = $this->input->post();
	    if (isset($post['selected_refunds'])) {
	        $msg = '';
	        foreach ($post['selected_refunds'] as $refund_id) {
	            $responce = $this->frontdesk->Delete_Refund_by_ID ( $refund_id);
	            if ($responce == 'refund_fiscalided'){
	                $msg .= "$refund_id {caption_kkm_check}!<br>";
	            }
	        }
	        if ($msg != ''){
	            $this->session->set_userdata(array('header_msg_text'=>$msg));
	        }
	    }
	    die ( "<meta http-equiv='refresh' content='0;url=/payments_c2/payment_listdate/1'>" );
	}

	public function ajax_Save_KKM_Payment() {
	    $post = $this->input->post();
	    $pay_id = $this->pay_c2->Insert_Payment ( $post );
        echo json_encode ( array('PaymentID'=>$pay_id));
	}

	public function Save_RRO_Payment() {
	    $post = $this->input->post();
// 	    Array
// 	    (
// 	        [landing_page] => folio
// 	        [return_type] => 0
// 	        [reservation_id] => 22277
// 	        [clear_pay] => 0
// 	        [set_manual_price] => 1
// 	        [description] =>
// 	        [KkmServerResponce] =>
// 	        [RegisterCheckStrings] =>
// 	        [is_kkm_module_active] => 0
// 	        [amount] => 304.00
// 	        [operationtime] => 2021-11-26
// 	        [id_partner] => 7
// 	        [type] => 12
// 	        [select_send_check_by] =>
// 	        [send_check_by] =>
//          [rro_print_check] => 1
//	        [rro_send_check_via_sms] => on
// 	        [cardnumber] =>
// 	        [exp_date] => 01/20
// 	        [cvc] => ***
// 	        [cardholder] =>
// 	        [main_guest_email] =>
// 	        [expiry] =>
// 	        )

	    $pay_id = $this->pay_c2->Insert_Payment ( $post );
	    $reservation_id = $post['reservation_id'];
        $data = array(
            'reservation_id' => $reservation_id,
            'id_partner' => $post['id_partner'],
            'pay_id' => $pay_id
        );

        $this->pay_c2->distribute_check_payment_items ( $data );

        if (isset($post['rro_print_check'])) {
            $rro_send_check_via_sms = isset($post['rro_send_check_via_sms']) ? 1 : 0;
            $this->hotelix_config->set_record ("rro_send_check_via_sms", $rro_send_check_via_sms, "int");
            $this->{$this->rro_model_name}->check_processing($data);
        }

        if (isset($post["id_cc_p"])) {
            $cc_id = 0;
            if ($post["id_cc_p"] != 0) {
                $cc_data = array();
                if ($post["id_cc_p"] == - 1) {
                    $cc_data["guest_id"] = $this->frontdesk_c2->get_main_guest_id($reservation_id);
                    $cc_data["cardnumber"] = $post["cardnumber"];
                    $cc_data["cardholder"] = $post["cardholder"];
                    $cc_data["cvc"] = $post["cvc"];
                    $cc_data["active"] = 1;
                    $cc_data["cardnumber"] = $post["cardnumber"];

                    $exp_date_arr = explode("/", $post["exp_date"]);
                    $cc_data["expmonth"] = $exp_date_arr[0];
                    $cc_data["expyear"] = $exp_date_arr[1];
                    $cc_id = $this->cc_model->save_cc($cc_data);
                } else {
                    $cc_id = $post["id_cc_p"];
                    $cc_data = $this->cc_model->get_cc_data($post["id_cc_p"]);
                }
            }
            if(isset($post['vPOS'])){
                $p2cc_data = array();
                $p2cc_data ['res_id'] = $reservation_id;
                $p2cc_data ['pay_id'] = $pay_id;
                $p2cc_data ['cc_id'] = $cc_id;
                $p2cc_data ['state'] = 0;
                $this->pay->save_payment2creditcard($p2cc_data);
            }
        }

        $landing_page = isset($post['landing_page']) ?  $post['landing_page'] : '';
        switch ($landing_page) {
            case "folio" :
                $landing_page_url = '/reservation_c2/folio';
                break;
            case "master_c2_step3" :
                $landing_page_url = '/master_c2/step_3';
                break;
            case "master_c2_checkout_step2" :
                $landing_page_url = '/master_c2/checkout_step_2';
                break;
            case "master_c2_checkout_step3" :
                $landing_page_url = '/master_c2/checkout_step_3';
                break;
            default:
                $landing_page_url = '/reservation_c2/folio';
                break;
        }
        die ( "<meta http-equiv='refresh' content='0;url=$landing_page_url/$reservation_id/1'>" );//
	}

	public function Save_RRO_Refund() {
	    $post = $this->input->post();

	    $data_for_refund = $post;
	    $data_for_refund['fiscal_provider'] = 3;//rro
	    $data_for_refund['res_id'] = $post['reservation_id'];
	    $data_for_refund['reason'] = '0';

	    $ref_id = $this->frontdesk->Insert_refund ($data_for_refund, 1);//1 - need_return

	    $this->pay_c2->update_wasrefunded_payment($post ['payid'], $ref_id);

	    $data_for_check_processing = array(
	        'reservation_id' => $post['reservation_id'],
	        'id_partner' => $post['id_partner'],
	        'ref_id' => $ref_id,
	        'pay_id' => $post ['payid'],
	        'pay_or_ref' => 1,//refund
	    );

	    $this->{$this->rro_model_name}->check_processing($data_for_check_processing);

	    die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $post['reservation_id'] . "/1'>" );//
	}

	public function fiscalize_RRO_Payment($pay_id) {
	    $payment_data = $this->db->select('id_partner, reservation_id')->get_where('payment', array('id'=>$pay_id))->row();
	    if ($payment_data) {
	        $data = array(
	            'reservation_id' => $payment_data->reservation_id,
	            'id_partner' => $payment_data->id_partner,
	            'pay_id' => $pay_id
	        );
	        $this->{$this->rro_model_name}->check_processing($data);
	    }
	    die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $payment_data->reservation_id . "/1'>" );
	}

	public function fiscalize_RRO_Refund($ref_id) {
	    $payment_data = $this->db->select('id as pay_id, id_partner, reservation_id')->get_where('payment', array('refund_id'=>$ref_id))->row();
	    if ($payment_data) {
	        $data = array(
	            'reservation_id' => $payment_data->reservation_id,
	            'id_partner' => $payment_data->id_partner,
	            'pay_id' => $payment_data->pay_id,
	            'ref_id' => $ref_id,
	            'pay_or_ref' => 1,
	        );
	        $this->{$this->rro_model_name}->check_processing($data);
	    }
	    die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $payment_data->reservation_id . "/1'>" );
	}

	public function ajax_fiscalize_RRO_Refund() {
	    $post = file_get_contents('php://input');
	    $post = json_decode($post);
	    $result = array();
	    $this->session->set_userdata ( array('header_msg_text'=>''));
	    if (isset($post->ref_id) && $post->ref_id != '') {
	        $ref_id = $post->ref_id;
	        $payment_data = $this->db->select('id as pay_id, id_partner, reservation_id')->get_where('payment', array('refund_id'=>$ref_id))->row();
	        if ($payment_data) {
	            $data = array(
	                'reservation_id' => $payment_data->reservation_id,
	                'id_partner' => $payment_data->id_partner,
	                'pay_id' => $payment_data->pay_id,
	                'ref_id' => $ref_id,
	                'pay_or_ref' => 1,
	            );
	            if ($this->{$this->rro_model_name}->check_processing($data)) {
	                $tbl = 'rro_checks';
	                $check_query = $this->db->select('id')->get_where($tbl, array('pay_or_ref_id'=>$ref_id, 'pay_or_ref' => 1))->row();
	                if ($check_query) {
	                    $check_id = $check_query->id;
	                    $title_tooltip = $this->mlanguages->getdictionaryword('rro','','{clt_print_check}');
	                    $result['html_txt'] =  '<span class="withtoggle" title="'.$title_tooltip.' ' . $check_id . '" data-toggle="tooltip" data-placement="top">
                                                <a href="/rro/print_html_receipt/' . $check_id . '" class="blue" target="_blank"><i class="fa fa-print"></i></a>
                                                <a href="/rro/print_pdf_receipt/' . $check_id . '" class="blue" target="_blank"><i class="fa fa-file-pdf-o"></i></a>
                                            </span>';
	                }else{
	                    $result['error'] = 'No check_id in rro_checks';
	                }
	            }else{
	                $error_msg = $this->session->userdata ('header_msg_text');
	                $this->session->set_userdata ( array('header_msg_text'=>''));
	                $result['error'] = $error_msg;
	            }
	        }else{
	            $result['error'] = 'No payment refunded by this ref_id!';
	        }
	    }else{
	        $result['error'] = 'Empty refund id!';
	    }
	    echo json_encode($result);
	}

	public function ajax_fiscalize_RRO_Payment() {
	    $post = file_get_contents('php://input');
	    $post = json_decode($post);
	    $result = array();
	    $this->session->set_userdata ( array('header_msg_text'=>''));
	    if (isset($post->pay_id) && $post->pay_id != '') {
	        $pay_id = $post->pay_id;
	        $payment_data = $this->db->select('id_partner, reservation_id')->get_where('payment', array('id'=>$pay_id))->row();
	        if ($payment_data) {
	            $data = array(
	                'reservation_id' => $payment_data->reservation_id,
	                'id_partner' => $payment_data->id_partner,
	                'pay_id' => $pay_id,
	            );
	            if ($this->{$this->rro_model_name}->check_processing($data)) {
	                $tbl = 'rro_checks';
	                $check_query = $this->db->select('id')->get_where($tbl, array('pay_or_ref_id'=>$pay_id, 'pay_or_ref' => 0))->row();
	                if ($check_query) {
	                    $check_id = $check_query->id;
	                    $title_tooltip = $this->mlanguages->getdictionaryword('rro','','{clt_print_check}');
	                    $result['html_txt'] =  '<span class="withtoggle" title="'.$title_tooltip.' ' . $check_id . '" data-toggle="tooltip" data-placement="top">
                                                <a href="/rro/print_html_receipt/' . $check_id . '" class="blue" target="_blank"><i class="fa fa-print"></i></a>
                                                <a href="/rro/print_pdf_receipt/' . $check_id . '" class="blue" target="_blank"><i class="fa fa-file-pdf-o"></i></a>
                                            </span>';
	                }else{
	                    $result['error'] = 'No check_id in rro_checks';
	                }
	            }else{
	                $error_msg = $this->session->userdata ('header_msg_text');
	                $this->session->set_userdata ( array('header_msg_text'=>''));
	                $result['error'] = $error_msg;
	            }
	        }else{
	            $result['error'] = "No payment with id = $pay_id !";
	        }
	    }else{
	        $result['error'] = 'Empty payment id!';
	    }
	    echo json_encode($result);
	}
}
?>