<?php

class Meal_plan_list extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('Authorization');
        $this->Authorization->IsLogined();

        $this->load->model('Access');
        $access_data = ['page_name' => 'grandreport', 'type' => 'view'];
        $this->Access->get_access($access_data);

        $this->load->model('mlanguages');
        $this->load->model('Xlsmodel');
        $this->load->model('htmltpl');
    }

    public function rlist($debug = false)
    {
        $filter_data = $this->input->post();

        if (isset($filter_data['date'])) {
            $date = $filter_data['date'];
            $this->session->set_userdata('meal_list_date', $date);
        } else {
            $date = $this->session->userdata('meal_list_date')
            ? $this->session->userdata('meal_list_date')
            : date('Y-m-d');
        }

        $sql = "SELECT dd.*, 
            dr.adults, dr.add_places, dr.baby_places, dr.addbedplace, dr.babyplace2,
            rate.meal_policy_id, rate.caption, 
            meal_policies.name AS policy_name, meal_policies.id AS meal_policy_id
        FROM deskofdays as dd
        JOIN deskofreservation AS dr ON dd.reservation_id = dr.id
        JOIN rate ON dr.price_type = rate.id
        JOIN rooms ON dr.room_id = rooms.id
        JOIN meal_policies ON rate.meal_policy_id = meal_policies.id
        WHERE dd.date = '$date'
        AND dd.reservation_id <> 0
        ";

        if (isset($filter_data['rates'])) {
            $filter_rates = $filter_data['rates'];
            $this->session->set_userdata('meal_list_rates', $filter_rates);
        } else {
            $filter_rates = $this->session->userdata('meal_list_rates')
            ? $this->session->userdata('meal_list_rates')
            : [];
        }

        if (isset($filter_data['policies'])) {
            $filter_policies = $filter_data['policies'];
            $this->session->set_userdata('meal_list_policies', $filter_policies);
        } else {
            $filter_policies = $this->session->userdata('meal_list_policies')
            ? $this->session->userdata('meal_list_policies')
            : [];
        }

        if (isset($filter_data['statuses'])) {
            $filter_statuses = $filter_data['statuses'];
            $this->session->set_userdata('meal_list_statuses', $filter_statuses);
        } else {
            $filter_statuses = $this->session->userdata('meal_list_statuses')
            ? $this->session->userdata('meal_list_statuses')
            : [];
        }

        if (isset($filter_data['categories'])) {
            $filter_categories = $filter_data['categories'];
            $this->session->set_userdata('meal_list_categories', $filter_categories);
        } else {
            $filter_categories = $this->session->userdata('meal_list_categories')
            ? $this->session->userdata('meal_list_categories')
            : [];
        }

        if (isset($filter_data['rooms'])) {
            $filter_rooms = $filter_data['rooms'];
            $this->session->set_userdata('meal_list_rooms', $filter_rooms);
        } else {
            $filter_rooms = $this->session->userdata('meal_list_rooms')
            ? $this->session->userdata('meal_list_rooms')
            : [];
        }

        if (!empty($filter_rates)) {
            $sql .= 'AND dr.price_type IN ('.implode(',', $filter_rates).')';
        }

        if (!empty($filter_statuses)) {
            $sql .= 'AND dr.status IN ('.implode(',', $filter_statuses).')';
        }

        if (!empty($filter_categories)) {
            $sql .= 'AND rooms.category_id IN ('.implode(',', $filter_categories).')';
        }

        if (!empty($filter_rooms)) {
            $sql .= 'AND dd.room_id IN ('.implode(',', $filter_rooms).')';
        }

        if (!empty($filter_policies)) {
            $sql .= 'AND meal_policies.id IN ('.implode(',', $filter_policies).')';
        }

        $data['days'] = $this->db->query($sql)->result_array();

        $data['filter_data']['date'] = $date;
        $data['filter_data']['statuses'] = $filter_statuses;
        $data['filter_data']['rates'] = $filter_rates;
        $data['filter_data']['categories'] = $filter_categories;
        $data['filter_data']['rooms'] = $filter_rooms;
        $data['filter_data']['policies'] = $filter_policies;

        if ($debug) {
            echo '<pre>';
            print_r($filter_data);
            print_r($data);
            exit();
        }

        $this->load->view('reports_c2/meal_plan_list_rlist_view', $data);
    }
}
