<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Dc_su_internal extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('Authorization');
        $this->Authorization->IsLogined('admin_access');

        $this->load->model('dcm_abstract');
        $this->load->model('dcm_su_api');

        if (!$this->session->userdata('global_debug')) {
            exit('ACCESS DENIED');
        }
    }

    public function mass_update()
    {
        exit();

        $table = 'global_hotelix.dc_su_channels';

        $channels = $this->db->get($table)->result_array();

        //echo '<pre>';
        //print_r($channels);
        //exit();

        foreach ($channels as $ch) {
            $update_data = ['country' => trim($ch['country'])];

            $this->db->where('id', $ch['id'])->set($update_data)->update($table);
        }
    }

    public function edit_channels($page = 1, $add = false): void
    {
        $ofset = ($page - 1) * 100;
        $next = $page + 1;

        $_SESSION['search_su_channel'] = $_POST['search_su_channel'] ?? $_SESSION['search_su_channel'] ?? '';
        $_SESSION['search_su_connector'] = $_POST['search_su_connector'] ?? $_SESSION['search_su_connector'] ?? '';
        $_SESSION['display'] = $_POST['display'] ?? $_SESSION['display'] ?? 'all';

        if (strlen($_SESSION['search_su_connector']) > 0 || strlen($_SESSION['search_su_channel']) > 0) {
            $limit = 10000;
            $ofset = 0;
        } else {
            $limit = 100;
        }

        if (strlen($_SESSION['search_su_connector']) > 0) {
            $channel_name = $_SESSION['search_su_connector'];
            $sql = "SELECT * FROM global_hotelix.dc_su_channels 
                WHERE
                    `connector` LIKE '%$channel_name%'
                    OR connect_2 LIKE '%$channel_name%'
                    OR connect_3 LIKE '%$channel_name%'
                    OR connect_4 LIKE '%$channel_name%'
                    OR connect_5 LIKE '%$channel_name%'";
            $channels = $this->db->query($sql)->result_array();
        } else {
            if ($_SESSION['display'] == '1') {
                $this->db->where('display', 0);
            } elseif ($_SESSION['display'] == '0') {
                $this->db->where('display', 1);
            }
            $channels = $this->db
                ->like('channel_name', $_SESSION['search_su_channel'], 'both')
                ->like('connector', $_SESSION['search_su_connector'], 'both')
                ->limit($limit, $ofset)
                ->get('global_hotelix.dc_su_channels')
                ->result_array();
        }

        echo '<form action="" method="post">';
        echo '<label>OTA name: </label>';
        echo '<input type="text" name="search_su_channel" value="'.$_SESSION['search_su_channel'].'"> ';
        echo ' <label>Connector name: </label>';
        echo '<input type="text" name="search_su_connector" value="'.$_SESSION['search_su_connector'].'"> ';
        echo ' <label>Hidden: </label>';
        echo '<select name="display"> ';
        echo '<option value="all" '.(isset($_SESSION['display']) && $_SESSION['display'] == 'all' ? 'selected' : '').'>All</option>';
        echo '<option value="0" '.(isset($_SESSION['display']) && $_SESSION['display'] == '0' ? 'selected' : '').'>No</option>';
        echo '<option value="1" '.(isset($_SESSION['display']) && $_SESSION['display'] == '1' ? 'selected' : '').'>Hidden only</option>';
        echo '</select> ';
        echo ' <button role="submit"> Search </button>';
        echo '</form>';

        if (empty($channels)) {
            return;
        }

        if ($add) {
            echo '<hr>';

            echo '<form action="/dc_su_internal/add_ota" method="post">';
            echo "<table style='border-collapse:collapse' width='500px' border='1'>";
            foreach ($channels[0] as $a => $b) {
                if ($a == 'id') {
                    continue;
                }
                echo "<tr><td><label for='$a'>$a</label><br>
                <input type='text' name='$a' value=''></td></tr>";
            }
            echo '<tr><td><button role="submit"> ADD OTA </button></td></tr></table>';
            echo '</form>';
        }

        echo "<table style='border-collapse:collapse' width='100%' border='1'><thead><tr>";
        foreach ($channels[0] as $a => $b) {
            $col_name = str_replace('_', ' ', $a);
            echo "<th>$col_name</th>";
        }
        
        
        echo '<th>Image</th>';
        echo '<th>Save</th>';
        echo '</tr></thead><tbody>';
        foreach ($channels as $k => $v) {
            echo '<form action="/dc_su_internal/update_channel_data" method="post" enctype="multipart/form-data">';
            echo '<tr>';
            echo '<input type="hidden" name="id" value="'.$v['id'].'">';
            foreach ($v as $ch => $td) {
                if ($ch == 'id') {
                    echo "<td>$td</td>";
                } elseif( $ch == 'encrypted_channel_code' ) {
                    echo '<td><textarea cols="7" rows="2" name="'.$ch.'">'.$td.'</textarea></td>';
                } elseif( $ch == 'channel_url') {
                    echo '<td>';
                    echo '<a href="//'.$td.'" target="_blank">'.$td.'</a><br>';
                    echo '<textarea cols="25" rows="2" name="'.$ch.'">'.$td.'</textarea></td>';
                } else {
                    echo '<td><input style="width:100%" type="text" name="'.$ch.'" value="'.$td.'"/></td>';
                }
            }
            
            echo '<td>';
            echo '<img src="/images/su_logo/su_logo_'.$v['id'].'.png" height="40">';
            echo '<br><input type="file" name="logo" accept="image/*">';
            echo '</td>';
            echo '<td><input type="submit" value="update"></td>';
            echo '</tr></form>';

        }
        echo '</tbody></table>';
        echo ($limit > 100 || strlen($_SESSION['search_su_channel']) > 0) ? '' : '<a href="/dc_su_internal/edit_channels/'.$next.'"> Next </a>';
    }

    public function update_channel_data(): void
    {
        if( isset($_FILES['logo']) && $_FILES['logo']['error'] == 0 ) {
            $file = $_FILES['logo'];
            $file_name = 'su_logo_'.$_POST['id'].'.png';
            $file_path = 'images/su_logo/'.$file_name;

            move_uploaded_file($file['tmp_name'], $file_path);
        }

        if (!null == $this->input->post()) {
            $data = $_POST;
            $id = $data['id'];
            unset($data['id']);
            $this->db->set($data)->where('id', $id)->update('global_hotelix.dc_su_channels');
        }

        echo "<meta http-equiv='refresh' content='0;url=/dc_su_internal/edit_channels'>";

        return;
    }

    public function add_ota()
    {
        if (!null == $this->input->post()) {
            $data = $_POST;
            $this->db->set($data)->insert('global_hotelix.dc_su_channels');
        }

        echo "<meta http-equiv='refresh' content='0;url=/dc_su_internal/edit_channels'>";
    }

    public function test(): void
    {
        echo '<pre>';
        echo '====== Properties ======<br>';
        echo '<br>---------- dc_su_api_properties_active ------------------<br>';
        print_r($this->db->get('dc_su_api_properties_active')->result_array());
        echo '<br>---------- dc_su_properties_link ------------------<br>';
        print_r($this->db->get('dc_su_properties_link')->result_array());
        echo '<br>---------- dc_su_xml_cfg ------------------<br>';
        print_r($this->db->get('dc_su_xml_cfg')->result_array());

        echo '<br>======== Rooms ===========<br>';
        echo '<br>---------- dc_su_api_categories_active ------------------<br>';
        print_r($this->db->get('dc_su_api_categories_active')->result_array());
        echo '<br>---------- dc_su_categories_strtoint ------------------<br>';
        print_r($this->db->get('dc_su_categories_strtoint')->result_array());
        echo '<br>---------- dc_su_room_categories ------------------<br>';
        print_r($this->db->get('dc_su_room_categories')->result_array());
        echo '<br>---------- dc_su_room_categories_link ------------------<br>';
        print_r($this->db->get('dc_su_room_categories_link')->result_array());
        echo '<br>---------- dc_su_occupancy ------------------<br>';
        print_r($this->db->get('dc_su_occupancy')->result_array());
        echo '<br>---------- dc_su_category2occupancy ------------------<br>';
        print_r($this->db->get('dc_su_category2occupancy')->result_array());

        echo '<br>============= Rates ===========<br>';
        echo '<br>---------- dc_su_api_rates_active ------------------<br>';
        print_r($this->db->get('dc_su_api_rates_active')->result_array());
        echo '<br>---------- dc_su_rates_strtoint ------------------<br>';
        print_r($this->db->get('dc_su_rates_strtoint')->result_array());
        echo '<br>---------- dc_su_rates ------------------<br>';
        print_r($this->db->get('dc_su_rates')->result_array());
        echo '<br>---------- dc_su_rate2category_link ------------------<br>';
        print_r($this->db->get('dc_su_rate2category_link')->result_array());
        echo '<br>---------- dc_su_restricts_link ------------------<br>';
        print_r($this->db->get('dc_su_restricts_link')->result_array());

        echo '<br>============= Contacts ===========<br>';
        print_r($this->db->get('dc_su_api_contacts_active')->result_array());

        echo '<br>============= Data ===========<br>';
        print_r($this->db->get('dc_su_data')->result_array());
    }

    public function update_ota_list()
    {
        //echo '<pre>';

        ini_set('auto_detect_line_endings', true);

        $i = 0;
        $keys = [];

        if (($handle = fopen('tmp/su_ota.csv', 'r')) !== false) {
            echo "NOT FOUND CHANNELS <br>";
            while (($data = fgetcsv($handle, 2000, ';')) !== false) {
               
                if ($i == 0) {
                    $keys = $data;
                    echo '<table border=1 style="border-collapse: collapse"><tr>';
                    foreach ($keys as $key) {
                        echo "<td>$key</td>";
                    }
                    echo '</tr>';
                    ++$i;
                    continue;
                }

                $locals = $this->db
                    ->like('channel_name', trim($data[1]), 'both')
                    ->get('global_hotelix.dc_su_channels')
                    ->result_array();
                if (count($locals) > 1) {
                    $shortest = -1;
                    foreach ($locals as $loc_name) {
                        $lev = levenshtein(trim($loc_name['channel_name']), trim($data[1]));

                        if ($lev == 0) {
                            $local = $loc_name;
                            $shortest = 0;
                            break;
                        }

                        if ($lev <= $shortest || $shortest < 0) {
                            // set the closest match, and shortest distance
                            $local = $loc_name;
                            $shortest = $lev;
                        }
                    }
                } else {
                    $local = $locals[0] ?? [];
                }

                if (empty($locals)) {
                    echo '<tr>';
                    foreach ($data as $v) {
                        echo "<td>$v</td>";
                    }
                    echo '</tr>';
                } else {
                    foreach ($keys as $k => $key) {
                        if (in_array($key, ['Salesforce_Name', 'Updated in Last Month', 'Channel_Type', 'Market', 'Priority', 'Monthly Visits', 'Active on Su '])) {
                            continue;
                        }
                        switch ($key) {
                            case 'OTASwitch Awareness':
                                $key = 'is_ota_switch';
                                break;
                            case 'Channel_Type':
                                $key = 'category';
                                break;
                            case 'Channel_Specialisation':
                                $key = 'property_type';
                                break;
                            case 'Group/Connector':
                                $key = 'connector';
                                break;
                            case '2Connect':
                                $key = 'connect_2';
                                break;
                            case '3Connect':
                                $key = 'connect_3';
                                break;
                            case '4Connect':
                                $key = 'connect_4';
                                break;
                            case '5Connect':
                                $key = 'connect_5';
                                break;
                            case 'Monthly Visits':
                                $key = 'monthly_visits';
                                break;
                            case 'URL':
                                $key = 'channel_url';
                                break;
                            default:
                                break;
                        }
                        $lk = strtolower($key);
                        if (
                            (
                                isset($local[$lk])
                                && (
                                    trim($local[$lk]) == trim($data[$k])
                                    || (trim($local[$lk]) == '' && trim($data[$k]) == '')
                                    || ($local[$lk] == 'ROIBOS' && trim($data[$k]) == 'Roibos (JP)')
                                    || ($local[$lk] == 'IOLX' && trim($data[$k]) == 'IOL X')
                                    || ($key == 'channel_url' && $data[$k] == 'Pending')
                                )
                            )
                            || (!isset($local[$lk]) && trim($data[$k]) == '')
                        ) {
                            continue;
                        }
                        $otas[$i]['channel'] = $data[1];
                        $otas[$i][$key] = [
                            'local' => $local[$lk] ?? null,
                            'su' => $data[$k],
                        ];
                    }
                }
                ++$i;
            }
            echo '</table>';
            echo '<br><br>';
            fclose($handle);
            //print_r($otas);
            //exit();
            echo '<table border=1 style="border-collapse: collapse"><tr>
            <th>#</th>
            <th>OTA name</th>
            <th>Column</th>
            <th>OtelMS</th>
            <th>SU</th>
            </tr>';

            $i = 1;
            foreach ($otas as $ota) {
                foreach ($ota as $k => $v) {
                    if ($k == 'channel') {
                        $channel = $v;
                    } else {
                        echo "<tr>
                        <td>{$i}</td>
                        <td>{$channel}</td>
                        <td>{$k}</td>
                        <td>{$v['local']}</td>
                        <td>{$v['su']}</td></tr>
                   ";
                        ++$i;
                    }
                }
            }

            echo '</table>';
        }
    }

    public function temp_sql_update()
    {
        exit();

        $table = 'global_hotelix.dc_su_channels';

        $where = [
            'connector' => 'Webbeds Group (DOTW)',
        ];

        $data = [
            'connector' => 'DOTW (Webbeds Group)',
        ];

        $this->db->where($where)->set($data)->update($table);

        //$this->db->where($where)->delete($table);
    }

    public function temp_sql_insert()
    {
        exit();

        $table = 'global_hotelix.dc_su_channels';

        $data = [
            'channel_name' => 'Synxis',
            'status' => 'Active',
            'property_type' => 'Hotel',
            'category' => 'CRS/IBE',
            'is_ota_switch' => 'Pending',
            'priority' => 3,
            'connection_type' => 'Direct',
            'connector' => 'Direct',
            'connect_2' => null,
            'connect_3' => null,
            'connect_4' => null,
            'connect_5' => null,
            'region' => 'AMERICAS',
            'country' => 'USA',
            'channel_url' => 'shrgroup.com',
            'monthly_visits' => null,
            'display' => 0,
        ];
        $this->db->set($data)->insert($table);
    }

    public function mapping_test($hotel_id, $channel)
    {
        $url = 'https://connect.su-api.com/SUAPI/jservice/widget/getWidgetAccessToken';

        $data = [
            'hotelid' => $hotel_id,
        ];

        if ($this->test_mode == 1) {
            $headers = [
                'Authorization: Basic '.$this->auth,
                'Content-Type: application/json',
            ];
        } else {
            $headers = [
                'Authorization: Basic '.$this->auth,
                'app-id: b3RlbG1zLnN1aXNzdS5jb20=',
                'Content-Type: application/json',
            ];
        }

        //array_push($headers, 'Content-Type: application/json');

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_USERAGENT, 'Otelms');

        $buffer = curl_exec($ch);
        $information = curl_getinfo($ch);

        curl_close($ch);

        $result = json_decode($buffer, true);
        echo '<pre>';
        print_r($result);
        exit();

        echo '<script src="https://static.otaswitch.com/JS/script.js"></script>';
        echo '<div id="app"></div>';
        echo '<script>
		const tmpScriptObj = {
			elementId: "app",
			type: "channel-Mapping",
			appId: "b3RlbG1zLnN1aXNzdS5jb20=",
			propertyId: "'.$result['Data']['proppmsid'].'",
			token: "'.$result['Data']['token_id'].'",
			channelCode: "Qa9Qwq4PF32srUVea3mYzzvBFiszeXK4aaQINYhXlm8",
			themeColor: {iconColor: "#03a9f4"}
		}
		loadScript(tmpScriptObj);
		</script>';
    }

    public function get_mappings_test($hotel_id)
    {
        $url = $this->url.'mappings';

        $data = [
            'hotelid' => $hotel_id,
            //'channelid' => $channel
        ];

        if ($this->test_mode == 1) {
            $headers = [
                'Authorization: Basic '.$this->auth,
                'Content-Type: application/json',
            ];
        } else {
            $headers = [
                'Authorization: Basic '.$this->auth,
                'app-id: b3RlbG1zLnN1aXNzdS5jb20=',
                'Content-Type: application/json',
            ];
        }

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_USERAGENT, 'Otelms');

        $buffer = curl_exec($ch);
        $information = curl_getinfo($ch);

        curl_close($ch);

        $result = json_decode($buffer, true);
        echo '<pre>';
        print_r([$information, $buffer, json_encode($data)]);
    }
}
