<?php defined('BASEPATH') or exit('No direct script access allowed');

class Dc_su_api extends CI_Controller
{
    public string $url;
    public string $auth;
    public bool $test_mode;
    public bool $debug;

    public function __construct()
    {
        parent::__construct();

        $this->load->model('Authorization');
        $this->Authorization->IsLogined('admin_access');

        $this->load->model('dcm_abstract');

        $this->load->model('htmltpl');

        /** ==== billing plan access start ========== */
        $data_access = ['module_name' => 'channel_manager'];
        $billing_plan_access = $this->Access->get_billing_plan_access($data_access);
        if ($billing_plan_access == 0) {
            exit("<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/52'>");
        }
        /** ==== billing plan access end ========== */
        
        $this->url = $this->config->item('su_prod_url');
        $this->auth = $this->config->item('su_prod_auth');
        $this->load->model('dcm_su_api');
        
        $this->dcm_su_api->migrate();

        $this->debug = (bool) $this->session->userdata('global_debug');
    }

    /**
     * properties.
     *
     * @uses dcm_su_api::get_properties_list
     * @uses dcm_su_api::get_su_properties
     * @uses config::item
     * @uses load::view dc_su_api/properties_view
     *
     * Displays html-page with properties
     * - Selects all remote properties
     * - Adds data to properies array against local properties
     * - Loads view to display
     */
    public function properties(): void
    {
        $properties = $this->dcm_su_api->get_properties_list();
        $services = $this->dcm_su_api->get_services();
        $hms_id = $this->config->item('hotel_id');

        $su_properties = $this->dcm_su_api->get_su_properties($hms_id);

        $su_prop_arr = [];
        $hms_id = $this->config->item('hotel_id');

        if (isset($su_properties['properties']) && !empty($su_properties['properties'])) {
            foreach ($su_properties['properties'] as $prop) {
                $su_prop_arr[$prop['propertyid']] = $prop;
                $su_prop_arr[$prop['propertyid']]['sync_status'] = $prop['status'] == 'Active'
                    ? '{clt_active}'
                    : '{clt_not_active}';
                $su_prop_arr[$prop['propertyid']]['property_su_check'] = false;
                $su_prop_arr[$prop['propertyid']]['need_sync'] =
                    '<span style="color:#e51c23"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i></span>';
                $su_prop_arr[$prop['propertyid']]['property_url'] = '#';
            }
        }

        foreach ($properties as $prop) {
            $mask = 'hms-'.$hms_id.'-'.$prop['property_id'];
            if (!isset($su_prop_arr[$mask])) {
                $su_prop_arr[$mask]['propertyid'] = $mask;
                $su_prop_arr[$mask]['property_id'] = $prop['property_id'];
                $su_prop_arr[$mask]['propertyname'] = $prop['property_name'];
                $su_prop_arr[$mask]['sync_status'] = '{clt_not_synced}';
                $su_prop_arr[$mask]['need_sync'] = '<span style="color:#03a9f4"><i class="fa fa-minus" aria-hidden="true"></i></span>';
            } else {
                $su_prop_arr[$mask]['need_sync'] = '<span style="color:#8bc34a"><i class="fa fa-check" aria-hidden="true"></i></span>';
                if ($su_prop_arr[$mask]['propertyname'] != $prop['property_name']) {
                    $su_prop_arr[$mask]['propertyname'] =
                        '<span style="color:#e51c23"><b>'.$prop['property_name'].'</b></span>';
                    $su_prop_arr[$mask]['need_sync'] =
                        '<span style="color:#e51c23"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i></span>';
                }
            }
            $su_prop_arr[$mask]['property_url'] = "/setup_property_c2/property_information/{$prop['property_id']}";
            $su_prop_arr[$mask]['property_su_check'] = $prop['is_active'] ? 'checked' : false;
            $su_prop_arr[$mask]['autoclose'] = $prop['autoclose'] ? 'checked' : false;
            foreach( $services as &$service ){
                if( $service['id'] == $prop['service'] ){
                    $service['selected'] = 'selected';
                } else {
                    $service['selected'] = '';
                }
            }
            $su_prop_arr[$mask]['services'] = $services;
        }

        $data['su_prop_arr'] = $su_prop_arr;

        $this->load->view('/dc_su_api/properties_view', $data);
    }

    /**
     * properties_post.
     *
     * @uses $db
     *
     * Deletes and inserts properties intent
     */
    public function properties_post(): void
    {
        $this->db
            ->where('id >', 0)
            ->delete('dc_su_api_properties_active');

        $active = $this->input->post('is_su') ? $this->input->post('is_su') : [];
        foreach ($active as $key => $prop) {
            $prop_id = explode('-', $key)[2];

            $this->db->set('hms_property_id', $prop_id)->insert('dc_su_api_properties_active');
        }

        $autoclose = $this->input->post('autoclose') ? $this->input->post('autoclose') : [];

        $autoclosed = array_column(
            $this->db
            ->where('name', 'autoclose')
            ->where('int_value', 1)
            ->get('dc_su_xml_cfg')
            ->result_array(),
            'dc_account_id',
            'dc_account_id'
        );

        foreach( $autoclose as $k => $prop ){
            $prop_id = explode('-', $k)[2];
            if( isset($autoclosed[$prop_id]) ){
                unset($autoclosed[$prop_id]);
                continue;
            }
            $sql = "INSERT INTO dc_su_xml_cfg (dc_account_id, name, int_value) 
                VALUES ($prop_id, 'autoclose', 1)
                ON DUPLICATE KEY UPDATE int_value = 1";

            $this->db->query( $sql );
        }

        foreach( $autoclosed as $prop ){
            $this->db->set( 'autoclose', 0)
                ->where('dc_account_id', $prop)->where('name', 'autoclose')
                ->update('dc_su_xml_cfg');
        }

        $services = $this->input->post('default_service') ? $this->input->post('default_service') : [];

        foreach( $services as $k => $prop ){
            $prop_id = explode('-', $k)[2];

            $sql = "INSERT INTO dc_su_xml_cfg (dc_account_id, name, int_value) 
                VALUES ($prop_id, 'service_type_id', $prop)
                ON DUPLICATE KEY UPDATE int_value = $prop";

            $this->db->query( $sql );
        }

        exit("<meta http-equiv='refresh' content='0;url=/dc_su_api/categories'>");
    }

    /**
     * @uses session::userdata
     * @uses config::item
     * @uses dcm_su_api::get_properties_short_list
     * @uses dcm_su_api::get_categories_list
     * @uses dcm_su::get_rooms
     * @uses load::model dcm_su
     * @uses load::view dc_su_api/categories_view
     *
     * Page with room types
     * - Selects all intent properties
     * - Retrieves SU rooms for each property
     * - Selects all categories for each property
     * - Filters active categories
     * - Adds data to SU categories array against local properties
     * - Loads view to display
     */
    public function categories(): void
    {
        $show_only_su = $this->session->userdata('show_only_su_categories');
        $show_only_su_checked = '';
        $only_su_data_state = $show_only_su ?? false;

        $sql_join = 'LEFT JOIN';
        $set_active = '';
        if ($show_only_su == 'on') {
            $show_only_su_checked = 'checked';
            $sql_join = 'INNER JOIN';
        }

        $properties = $this->dcm_su_api->get_properties_short_list();
        $hms_id = $this->config->item('hotel_id');

        $rooms = [];
        $categories = [];

        $this->load->model('dcm_su');

        foreach ($properties as $prop) {
            $su_property_id = "hms-$hms_id-{$prop['dc_account_id']}";

            $su_rooms = $this->dcm_su->get_rooms($su_property_id)['rooms'] ?? [];

            foreach ($su_rooms as $key => $room) {
                list($hms_idd, $prop_id, $room_id) = explode('-', $room['roomid']);
                $a = $room['roomid'];
                $res_rooms[$a] = $room;
                $res_rooms[$a]['property_id'] = $prop_id;
                $res_rooms[$a]['property_name'] = '<span style="color:#e51c23"><b>'.$prop_id.'</b></span>';
                $res_rooms[$a]['rate_web_active_check'] = false;
                $res_rooms[$a]['hms_category_id'] = $room_id;
                $res_rooms[$a]['sync_status'] = $room['status'] == 'Active'
                    ? '{clt_active}'
                    : '{clt_not_active}';
                $res_rooms[$a]['category_url'] = '#';
                $res_rooms[$a]['need_sync'] = '<span style="color:#e51c23"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i></span>';
            }
            $rooms = array_merge($rooms, $res_rooms);

            $res_cat = $this->dcm_su_api->get_categories_list($sql_join, $set_active, $prop['dc_account_id']);
            $categories = array_merge($categories, $res_cat);
        }

        foreach ($categories as $cat) {
            $mask = "$hms_id-{$cat['property_id']}-{$cat['id']}";
            if (!isset($rooms[$mask])) {
                $rooms[$mask]['roomid'] = $mask;
                $rooms[$mask]['roomname'] = $cat['name'];
                $rooms[$mask]['roomtype'] = $cat['type_name'];
                $rooms[$mask]['maximumoccupancy'] = $cat['add_places'];
                $rooms[$mask]['quantity'] = $cat['room_count'];
                $rooms[$mask]['quantity1'] = $cat['room_count'];
                $rooms[$mask]['sizemeasurement'] = $cat['size'];

                switch ($cat['size_type']) {
                    case 1:
                        $size_type = 'sqm';
                        break;
                    case 2:
                        $size_type = 'sqft';
                        break;
                    default:
                        $size_type = 'sqm';
                        break;
                }
                $rooms[$mask]['sizemeasurementunit'] = $size_type;
                $rooms[$mask]['rate'] = $cat['base_price'];
                $rooms[$mask]['property_id'] = $cat['property_id'];
                $rooms[$mask]['property_name'] = $cat['property_name'];
                $rooms[$mask]['category_id'] = $cat['id'];

                $rooms[$mask]['sync_status'] = 'clt_not_synced';
                $rooms[$mask]['need_sync'] = '<span style="color:#03a9f4"><i class="fa fa-minus" aria-hidden="true"></i></span>';
            } else {
                $rooms[$mask]['need_sync'] = '<span style="color:#8bc34a"><i class="fa fa-check" aria-hidden="true"></i></span>';
                $rooms[$mask]['property_name'] = $cat['property_name'];

                if ($rooms[$mask]['roomname'] != $cat['name']) {
                    $rooms[$mask]['roomname'] = '<span style="color:#e51c23"><b>'.$cat['name'].'</b></span>';
                    $rooms[$mask]['need_sync'] = '<span style="color:#e51c23"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i></span>';
                }

                if ($rooms[$mask]['roomtype'] != $cat['type_name']) {
                    $rooms[$mask]['roomtype'] = '<span style="color:#e51c23"><b>'.$cat['type_name'].'</b></span>';
                    $rooms[$mask]['need_sync'] = '<span style="color:#e51c23"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i></span>';
                }

                if ($rooms[$mask]['maximumoccupancy'] != $cat['add_places']) {
                    $rooms[$mask]['maximumoccupancy'] = '<span style="color:#e51c23"><b>'.$cat['add_places'].'</b></span>';
                    $rooms[$mask]['need_sync'] = '<span style="color:#e51c23"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i></span>';
                }

                if ($rooms[$mask]['quantity'] != $cat['room_count']) {
                    $rooms[$mask]['quantity'] = '<span style="color:#e51c23"><b>'.$cat['room_count'].'</b></span>';
                }

                if ($rooms[$mask]['sizemeasurement'] != $cat['size']) {
                    $rooms[$mask]['sizemeasurement'] = '<span style="color:#e51c23"><b>'.$cat['size'].'</b></span>';
                    $rooms[$mask]['need_sync'] = '<span style="color:#e51c23"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i></span>';
                }

                switch ($cat['size_type']) {
                    case 2:
                        $size_type = 'sqft';
                        break;
                    case 1:
                    default:
                        $size_type = 'sqm';
                        break;
                }

                if ($rooms[$mask]['sizemeasurementunit'] != $size_type) {
                    $rooms[$mask]['sizemeasurementunit'] = '<span style="color:#e51c23"><b>'.$size_type.'</b></span>';
                    $res_rooms[$key]['need_sync'] = '<span style="color:#e51c23"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i></span>';
                }

                if ($rooms[$mask]['rate'] != $cat['base_price']) {
                    $rooms[$mask]['rate'] = '<span style="color:#e51c23"><b>'.$cat['base_price'].'</b></span>';
                    $res_rooms[$key]['need_sync'] = '<span style="color:#e51c23"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i></span>';
                }
            }
            $rooms[$mask]['category_url'] = '/setup_categories_c2/edit/'.$cat['id'];
            $rooms[$mask]['category_su_check'] = $cat['active_id'] != null ? 'checked' : false;
            $rooms[$mask]['hms_category_id'] = $cat['id'];
            $rooms[$mask]['room_limit'] = $cat['room_limit'] > $cat['intent_room_limit'] ? $cat['room_limit'] : $cat['intent_room_limit'];
        }

        $data['rooms'] = $rooms;
        $data['show_only_su_checked'] = $show_only_su_checked;
        $data['only_su_data_state'] = $only_su_data_state;

        $this->load->view('/dc_su_api/categories_view', $data);
    }

    /**
     * Deleted and inserts categories intent.
     */
    public function categories_post(): void
    {
        $this->db
            ->where('id >', 0)
            ->delete('dc_su_api_categories_active');

        $active = $this->input->post('is_su') ? $this->input->post('is_su') : [];
        $limits = $this->input->post('room_limit') ? $this->input->post('room_limit') : [];

        foreach ($active as $key => $val) {
            list($id, $prop) = explode('-', $key);
            $this->db
                ->set(['hms_category_id' => $id, 'room_limit' => $limits[$key] ?? 0])
                ->insert('dc_su_api_categories_active');
        }

        exit("<meta http-equiv='refresh' content='0;url=/dc_su_api/rates'>");
    }

    public function ajax_show_only_active_cat(): void
    {
        $post = $this->input->post();

        if (isset($post['show_only_su'])) {
            $show_only_active = $post['show_only_su'];
            $newdata = [
                'show_only_su_categories' => $show_only_active,
            ];
            $this->session->set_userdata($newdata);
        } else {
            $array_items = [
                'show_only_su_categories' => '',
            ];
            $this->session->unset_userdata($array_items);
        }
        echo '{"result":"success"}';
    }

    public function ajax_show_only_active_rate(): void
    {
        $post = $this->input->post();

        if (isset($post['show_only_su'])) {
            $this->session->set_userdata('su_show_only_web_active_rates', 'on');
        } else {
            $this->session->unset_userdata('su_show_only_web_active_rates');
        }
        echo '{"result":"success"}';
    }

    public function ajax_show_only_active_contact(): void
    {
        $post = $this->input->post();

        if (isset($post['show_only_su'])) {
            $this->session->set_userdata('show_only_su_contacts', 'on');
        } else {
            $this->session->unset_userdata('show_only_su_contacts');
        }
        echo '{"result":"success"}';
    }

    public function rates(): void
    {
        $show_only_web_active = $this->session->userdata('su_show_only_web_active_rates');
        $show_only_web_active_checked = '';
        $only_su_data_state = $show_only_web_active ?? false;

        if ($show_only_web_active == 'on') {
            $onlinerates_sql = ' INNER JOIN dc_su_api_rates_active ON dc_su_api_rates_active.hms_rate_id = rate.id';
            $show_only_web_active_checked = 'checked';
        } else {
            $onlinerates_sql = ' LEFT JOIN dc_su_api_rates_active ON dc_su_api_rates_active.hms_rate_id = rate.id ';
        }

        $su_properties = $this->dcm_su_api->get_properties_short_list();

        $rates = [];
        $hms_id = $this->config->item('hotel_id');
        $restricts = $this->db->get('dc_global_restrict_rate')->result_array();

        foreach ($su_properties as $prop) {
            $su_property_id = "hms-$hms_id-{$prop['dc_account_id']}";

            $su_rates = $this->dcm_su_api->get_su_rates($su_property_id);

            if (empty($su_rates)) {
                continue;
            }

            foreach ($su_rates as $key => $rate) {
                $rate_id_arr = explode('-', $rate['rateplanid']);
                $a = $rate_id_arr[2];
                $res_rates[$a]['rate_url'] = '#';
                $res_rates[$a]['hms_rate_name'] = '----';

                $res_rates[$a]['properties'][$rate_id_arr[1]] = $rate;
                $res_rates[$a]['properties'][$rate_id_arr[1]]['rate_id'] = $rate_id_arr[1].'-'.$a;
                $res_rates[$a]['properties'][$rate_id_arr[1]]['meal_plan'] = $this->dcm_su_api->map_meal_plan($rate['mealplanid'], true)['name'] ?? '????';
                $res_rates[$a]['properties'][$rate_id_arr[1]]['property_name'] = $rate_id_arr[1];
                $res_rates[$a]['properties'][$rate_id_arr[1]]['rate_su_check'] = false;
                $res_rates[$a]['properties'][$rate_id_arr[1]]['sync_status'] = $rate['status'] == 'Active'
                    ? '{clt_active}'
                    : '{clt_not_active}';

                $res_rates[$a]['properties'][$rate_id_arr[1]]['need_sync'] =
                    '<span style="color:#e51c23"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i></span>';

                if (!isset($res_rates[$a]['properties'][$rate_id_arr[1]]['restricts'])) {
                    $res_rates[$a]['properties'][$rate_id_arr[1]]['restricts'][0]['restrict_rate_id'] = 0;
                    $res_rates[$a]['properties'][$rate_id_arr[1]]['restricts'][0]['name'] = '---';
                    $res_rates[$a]['properties'][$rate_id_arr[1]]['restricts'][0]['selected'] = '';
                    foreach ($restricts as $k => $restrict) {
                        $res_rates[$a]['properties'][$rate_id_arr[1]]['restricts'][$k + 1]['restrict_rate_id'] = $restrict['rate_id'];
                        $res_rates[$a]['properties'][$rate_id_arr[1]]['restricts'][$k + 1]['name'] = $restrict['name'];
                        $res_rates[$a]['properties'][$rate_id_arr[1]]['restricts'][$k + 1]['selected'] = '';
                    }
                }
            }
            $rates += $res_rates;
        }

        $hms_rates = $this->dcm_su_api->get_rates_list($onlinerates_sql);

        foreach ($hms_rates as $rate) {
            $rate_id = $rate['rate_id'];
            if (!isset($rates[$rate_id])) {
                foreach ($su_properties as $prop) {
                    $rates[$rate_id]['properties'][$prop['dc_account_id']]['rateplanid'] = $hms_id.'-'.$prop['dc_account_id'].'-'.$rate_id;
                    $rates[$rate_id]['properties'][$prop['dc_account_id']]['rate_id'] = $prop['dc_account_id'].'-'.$rate_id;
                    $rates[$rate_id]['properties'][$prop['dc_account_id']]['rateplanname'] = $rate['international_rate_name'];
                    $rates[$rate_id]['properties'][$prop['dc_account_id']]['mealplanid']
                        = $this->dcm_su_api->map_meal_plan($rate['meal_policy_id'])['su_id'] ?? 15;
                    $rates[$rate_id]['properties'][$prop['dc_account_id']]['meal_plan']
                        = $this->dcm_su_api->map_meal_plan($rate['meal_policy_id'])['name'] ?? '{-(None)-}';
                    $rates[$rate_id]['properties'][$prop['dc_account_id']]['rate_su_check'] =
                        ($rate['active_id'] != null && $prop['dc_account_id'] == $rate['property_id'])
                        ? 'checked' : false;
                    $rates[$rate_id]['properties'][$prop['dc_account_id']]['property_name'] = $prop['property_name'];

                    $rates[$rate_id]['properties'][$prop['dc_account_id']]['sync_status'] = '{clt_not_synced}';
                    $rates[$rate_id]['properties'][$prop['dc_account_id']]['need_sync'] =
                        '<span style="color:#03a9f4"><i class="fa fa-minus" aria-hidden="true"></i></span>';

                    if (!isset($rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'])) {
                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][0]['restrict_rate_id'] = 0;
                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][0]['name'] = '---';
                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][0]['selected'] = '';
                        foreach ($restricts as $k => $restrict) {
                            $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][$k + 1]['restrict_rate_id'] = $restrict['rate_id'];
                            $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][$k + 1]['name'] = $restrict['name'];
                            $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][$k + 1]['selected'] =
                                $rate['online_restrictid'] == $restrict['rate_id']
                                ? 'selected'
                                : '';
                        }
                    }
                }
                $rates[$rate_id]['rate_url'] = "/setup_rates_c2/edit_v2/$rate_id";
                $rates[$rate_id]['hms_rate_name'] = $rate['international_rate_name'];
                $rates[$rate_id]['rate_iid'] = $rate_id;
            } else {
                $rates[$rate_id]['hms_rate_name'] = $rate['international_rate_name'];
                $rates[$rate_id]['rate_url'] = "/setup_rates_c2/edit_v2/$rate_id";
                $rates[$rate_id]['rate_iid'] = $rate_id;
                foreach ($su_properties as $prop) {
                    if (isset($rates[$rate_id]['properties'][$prop['dc_account_id']])) {
                        if ($rate['property_id'] != null && $rate['property_id'] != $prop['dc_account_id']) {
                            continue;
                        }
                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['need_sync'] =
                            '<span style="color:#8bc34a"><i class="fa fa-check" aria-hidden="true"></i></span>';

                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['property_name'] = $prop['property_name'];

                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['rate_su_check'] =
                            ($rate['active_id'] != null && $prop['dc_account_id'] == $rate['property_id'])
                            ? 'checked' : false;

                        if (!isset($rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'])) {
                            $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][0]['restrict_rate_id'] = 0;
                            $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][0]['name'] = '---';
                            $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][0]['selected'] = '';

                            foreach ($restricts as $k => $restrict) {
                                $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][$k + 1]['restrict_rate_id'] = $restrict['rate_id'];
                                $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][$k + 1]['name'] = $restrict['name'];
                                $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][$k + 1]['selected'] =
                                    $rate['online_restrictid'] == $restrict['rate_id']
                                    ? 'selected'
                                    : '';
                            }
                        } else {
                            foreach ($rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'] as $r_k => $r_v) {
                                if ($r_v['restrict_rate_id'] == $rate['online_restrictid']) {
                                    $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][$r_k]['selected'] = 'selected';
                                }
                            }
                        }

                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['mealplanid']
                            = $this->dcm_su_api->map_meal_plan($rate['meal_policy_id'])['su_id'] ?? 15;

                        if ($rates[$rate_id]['properties'][$prop['dc_account_id']]['rateplanname'] != $rate['international_rate_name']) {
                            $rates[$rate_id]['properties'][$prop['dc_account_id']]['rateplanname'] =
                                '<span style="color:#e51c23"><b>'.$rate['international_rate_name'].'</b></span>';
                            $rates[$rate_id]['properties'][$prop['dc_account_id']]['need_sync'] =
                                '<span style="color:#e51c23"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i></span>';
                        }

                        if (
                            $rates[$rate_id]['properties'][$prop['dc_account_id']]['mealplanid']
                            != $this->dcm_su_api->map_meal_plan($rate['meal_policy_id'])['su_id'] ?? 15
                        ) {
                            $rates[$rate_id]['properties'][$prop['dc_account_id']]['mealplanid'] =
                                '<span style="color:#e51c23"><b>'
                                .$this->dcm_su_api->map_meal_plan($rate['meal_policy_id'])['name'] ?? '{-(None)-}'
                                .'</b></span>';
                            $rates[$rate_id]['properties'][$prop['dc_account_id']]['need_sync'] =
                                '<span style="color:#e51c23"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i></span>';
                        }
                    } else {
                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['rateplanid'] = $hms_id.'-'.$prop['dc_account_id'].'-'.$rate_id;
                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['rate_id'] = $prop['dc_account_id'].'-'.$rate_id;
                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['rateplanname'] = $rate['international_rate_name'];
                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['mealplanid']
                            = $this->dcm_su_api->map_meal_plan($rate['meal_policy_id'])['su_id'] ?? 15;
                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['meal_plan']
                            = $this->dcm_su_api->map_meal_plan($rate['meal_policy_id'])['name'] ?? '{-(None)-}';
                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['rate_su_check'] =
                            ($rate['active_id'] != null && $prop['dc_account_id'] == $rate['property_id'])
                            ? 'checked' : false;
                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['property_name'] = $prop['property_name'];

                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['sync_status'] = '{clt_not_synced}';
                        $rates[$rate_id]['properties'][$prop['dc_account_id']]['need_sync'] =
                            '<span style="color:#03a9f4"><i class="fa fa-minus" aria-hidden="true"></i></span>';

                        if (!isset($rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'])) {
                            $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][0]['restrict_rate_id'] = 0;
                            $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][0]['name'] = '---';
                            $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][0]['selected'] = '';
                            foreach ($restricts as $k => $restrict) {
                                $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][$k + 1]['restrict_rate_id'] = $restrict['rate_id'];
                                $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][$k + 1]['name'] = $restrict['name'];
                                $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][$k + 1]['selected'] =
                                    $rate['online_restrictid'] == $restrict['rate_id']
                                    ? 'selected'
                                    : '';
                            }
                        } else {
                            foreach ($rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'] as $r_k => $r_v) {
                                if ($r_v['restrict_rate_id'] == $rate['online_restrictid']) {
                                    $rates[$rate_id]['properties'][$prop['dc_account_id']]['restricts'][$r_k]['selected'] = 'selected';
                                }
                            }
                        }
                    }
                }
            }
        }

        $data['rates'] = $rates;
        $data['show_only_web_active_checked'] = $show_only_web_active_checked;
        $data['only_su_data_state'] = $only_su_data_state;

        $this->load->view('/dc_su_api/rates_view', $data);
    }

    public function rates_post(): void
    {
        $this->db
            ->where('id >', 0)
            ->delete('dc_su_api_rates_active');

        $active = $this->input->post('web_active') ? $this->input->post('web_active') : [];
        $resticts = $this->input->post('restrictid') ? $this->input->post('restrictid') : [];

        foreach ($active as $key => $val) {
            list($prop, $rate) = explode('-', $key);
            $data = [
                'hms_rate_id' => $rate,
                'property_id' => $prop,
                'restrictid' => $resticts[$key],
            ];
            $this->db->set($data)->insert('dc_su_api_rates_active');
        }

        exit("<meta http-equiv='refresh' content='0;url=/dc_su_api/contacts'>");
    }

    public function contacts(): void
    {
        $show_only_su = $this->session->userdata('show_only_su_contacts');
        $show_only_su_checked = '';
        $only_su_data_state = $show_only_su ?? false;
        $sql_join = 'LEFT JOIN dc_su_api_contacts_active AS co ON co.hms_contact_id = contacts.id';
        $where = '';
        if ($show_only_su == 'on') {
            $show_only_su_checked = 'checked';
            $sql_join = 'INNER JOIN dc_su_api_contacts_active AS co ON co.hms_contact_id = contacts.id AND co.is_active = 1';
        }

        $contacts = $this->dcm_su_api->get_contacts_list($sql_join);

        foreach ($contacts as $k => $con) {
            $contacts[$k]['contact_name'] = $con['contact_name'].' '.$con['contact_surname'];
            $contacts[$k]['contact_su_check'] = $con['is_active'] ? 'checked' : false;
        }

        $data['contacts'] = $contacts;
        $data['show_only_su_checked'] = $show_only_su_checked;
        $data['only_su_data_state'] = $only_su_data_state;

        $this->load->view('/dc_su_api/contacts_view', $data);
    }

    public function contacts_post(): void // TBD !!!
    {
        $contacts = $this->db->get('dc_su_api_contacts_active')->result_array();
        $active = $this->input->post('is_su');

        foreach ($contacts as $con) {
            if (!array_key_exists($con['hms_contact_id'], $active)) {
                if ($con['is_active'] == 1) {
                    $update_data = [
                        'is_active' => 0,
                    ];
                    $this->db->set('is_active', 0)->where('hms_contact_id', $con['hms_contact_id'])->update('dc_su_api_contacts_active');
                }
            } else {
                $this->db->set('is_active', 1)->where('hms_contact_id', $con['hms_contact_id'])->update('dc_su_api_contacts_active');
            }
            unset($active[$con['hms_contact_id']]);
        }

        foreach ($active as $key => $val) {
            $data = [
                'hms_contact_id' => $key,
                'is_active' => 1,
            ];

            $this->db->set($data)->insert('dc_su_api_contacts_active');
        }

        exit("<meta http-equiv='refresh' content='0;url=/dc_su_api/sync'>");
    }

    public function sync(): void
    {
        $data = [];
        $this->load->view('/dc_su_api/sync_view', $data);
    }

    public function sync_post(): void
    {
        $sync_status = 'OK';

        $overbooking_cat = $this->hotelix_config->get_record('overbooking_category_id', 'int');
        $sql = "INSERT INTO dc_su_xml_cfg (name, int_value) VALUES('overbooking_category_id', $overbooking_cat) 
            ON DUPLICATE KEY UPDATE int_value = $overbooking_cat";
        
        $hms_id = $this->config->item('hotel_id');
        $mask = 'hms-'.$hms_id;

        $remote_hash = [];

        $su_properties_response = $this->dcm_su->get_hotels();

        $this->load->model('dcm_su');
        $this->load->model('mrates');
        $this->load->model('mcategory');

        if (isset($su_properties_response['properties'])) {
            foreach ($su_properties_response['properties'] as $k => $prop) {
                if (preg_match("~$mask~", $prop['propertyid'])) {
                    array_push($remote_hash, $prop['propertyid']);
                }
            }
        }

        $sql = "SELECT pi.id as property_id, link.su_property_id as link_id, str_value, contacts.id as contact_id, actve.id AS is_active
        FROM property_information as pi 
        LEFT JOIN dc_su_properties_link as link ON pi.id=link.hms_property_id
        LEFT JOIN dc_su_xml_cfg as cfg ON link.su_property_id=cfg.dc_account_id AND name='hotel_id'
        LEFT JOIN dc_su_api_properties_active as actve ON pi.id=actve.hms_property_id
        LEFT JOIN contacts ON pi.id=contacts.property_id";

        $properties = $this->db->query($sql)->result_array();

        $to_add = [];
        $to_update = [];
        $to_delete = [];

        foreach ($properties as $prop) {
            $su_property_id = "hms-$hms_id-{$prop['property_id']}";

            if (in_array($su_property_id, $remote_hash)) {
                if ($prop['is_active']) {
                    array_push($to_update, $su_property_id);
                } else {
                    array_push($to_delete, $su_property_id);
                }
                $kkey = array_search($su_property_id, $remote_hash);
                unset($remote_hash[$kkey]);
            } else {
                if ($prop['is_active']) {
                    array_push($to_add, $su_property_id);
                } else {
                    $this->db
                        ->where('hms_property_id', $prop['property_id'])
                        ->delete('dc_su_properties_link');
                    $this->db
                        ->where('int_value', $prop['property_id'])
                        ->where('name', 'hotel_id')
                        ->delete('dc_su_xml_cfg');
                    $this->db
                        ->where('hms_contact_id', $prop['contact_id'])
                        ->delete('dc_su_api_contacts_active');
                    $this->dcm_su_api->clean_rooms_and_rates($hms_id, $prop['property_id']);
                }
            }
        }

        if (!empty($remote_hash)) {
            foreach ($remote_hash as $to_del) {
                array_push($to_delete, $to_del);
            }
        }

        if (!empty($to_add)) {
            $su_over = $this->db->where('name', 'overbooking_category_id')->get('dc_su_xml_cfg')->row();

            if ($su_over == null) {
                $overbooking_cat = $this->hotelix_config->get_record('overbooking_category_id', 'int');
                $sql = "INSERT INTO dc_su_xml_cfg (name, int_value) VALUES('overbooking_category_id', $overbooking_cat) 
                    ON DUPLICATE KEY UPDATE int_value = $overbooking_cat";
                $query = $this->db->query($sql);

                $sql = "INSERT INTO dc_su_xml_cfg (name, int_value) VALUES('general_update', 1) ON DUPLICATE KEY UPDATE int_value = 1";
                $query = $this->db->query($sql);
            }
        }

        $log_data = [];

        foreach ($to_update as $prop) {
            $property_id = explode('-', $prop)[2] ?? false;
            if (!$property_id) {
                continue;
            }

            $update_data = [
                'property_id' => $property_id,
                'status' => 'update',
                'hms_id' => $hms_id,
            ];

            $prop_result = $this->dcm_su_api->create_update_property($update_data);

            if (!isset($prop_result['curl_response']['Status'])
                || $prop_result['curl_response']['Status'] != 'Success'
            ) {
                $sync_status = 'Failed';
                $log_data[] = [
                    'action' => 'Update property',
                    'object' => $prop,
                    'result' => 'fail',
                    'error' => $prop_result['curl_response']['Errors'][0]['ShortText'],
                ];
                unset($prop_result);
                continue;
            }

            $log_data[] = [
                'action' => 'Update property',
                'object' => $prop,
                'result' => 'success',
                'error' => '',
            ];

            unset($prop_result);

            foreach ($properties as $local) {
                if ($local['property_id'] == $property_id) {
                    if ($local['link_id'] == null) {
                        $this->db
                            ->set(['su_property_id' => $property_id, 'hms_property_id' => $property_id])
                            ->insert('dc_su_properties_link');
                    }

                    if ($local['str_value'] == null) {
                        $cfg_data = [
                            'dc_account_id' => $property_id,
                            'name' => 'hotel_id',
                            'str_value' => $prop,
                            'int_value' => $property_id,
                        ];
                        $this->db->set($cfg_data)->insert('dc_su_xml_cfg');
                    }
                }
            }

            $rooms_result = $this->dcm_su_api->sync_rooms($hms_id, $property_id);
            $rates_result = $this->dcm_su_api->sync_rates($hms_id, $property_id);
            $log_data = array_merge($log_data, $rooms_result['details']);
            $log_data = array_merge($log_data, $rates_result['details']);

            if (!$rooms_result['result'] || !$rates_result['result']) {
                $sync_status = 'Failed';
            }

            unset($rooms_result);
            unset($rates_result);
        }

        foreach ($to_add as $prop) {
            $property_id = explode('-', $prop)[2] ?? false;
            if (!$property_id) {
                continue;
            }

            $update_data = [
                'property_id' => $property_id,
                'status' => 'create',
                'hms_id' => $hms_id,
            ];

            $prop_result = $this->dcm_su_api->create_update_property($update_data);

            if (
                !isset($prop_result['curl_response']['Status'])
                || $prop_result['curl_response']['Status'] != 'Success'
            ) {
                $sync_status = 'Failed';
                $log_data[] = [
                    'action' => 'Create property',
                    'object' => $prop,
                    'result' => 'fail',
                    'error' => $prop_result['curl_response']['Errors'][0]['ShortText'],
                ];
                unset($prop_result);
                continue;
            }

            $log_data[] = [
                'action' => 'Update property',
                'object' => $prop,
                'result' => 'success',
                'error' => '',
            ];
            unset($prop_result);

            foreach ($properties as $local) {
                if ($local['property_id'] == $property_id) {
                    if ($local['link_id'] == null) {
                        $this->db
                            ->set(['su_property_id' => $property_id, 'hms_property_id' => $property_id])
                            ->insert('dc_su_properties_link');
                    }

                    if ($local['str_value'] == null) {
                        $cfg_data = [
                            'dc_account_id' => $property_id,
                            'name' => 'hotel_id',
                            'str_value' => $prop,
                            'int_value' => $property_id,
                        ];
                        $this->db->set($cfg_data)->insert('dc_su_xml_cfg');
                    }
                }
            }

            $rooms_result = $this->dcm_su_api->sync_rooms($hms_id, $property_id, true);
            $rates_result = $this->dcm_su_api->sync_rates($hms_id, $property_id, true);
            $log_data = array_merge($log_data, $rooms_result['details']);
            $log_data = array_merge($log_data, $rates_result['details']);

            if (!$rooms_result['result'] || !$rates_result['result']) {
                $sync_status = 'Failed';
            }
            unset($rooms_result);
            unset($rates_result);
        }

        foreach ($to_delete as $prop) {
            $mappings = $this->dcm_su_api->get_mappings($prop);

            if (empty($mappings)) {
                $prop_result = $this->dcm_su->delete_property($prop);

                if (!isset($prop_result['Status'])
                    || $prop_result['Status'] != 'Success'
                ) {
                    $sync_status = 'Failed';
                    $log_data[] = [
                        'action' => 'Delete property',
                        'object' => $prop,
                        'result' => 'fail',
                        'error' => $prop_result['Errors'][0]['ShortText'],
                    ];
                    unset($prop_result);
                    continue;
                }

                $log_data[] = [
                    'action' => 'Delete property',
                    'object' => $prop,
                    'result' => 'success',
                    'error' => '',
                ];
                unset($prop_result);

                $property_id = explode('-', $prop)[2];
                $this->db
                    ->where('hms_property_id', $property_id)
                    ->delete('dc_su_properties_link');
                $this->db
                    ->where(['dc_account_id' => $property_id])
                    ->delete('dc_su_xml_cfg');

                foreach ($properties as $local) {
                    if ($local['property_id'] == $property_id) {
                        if ($local['contact_id'] != null) {
                            $this->db
                                ->where('hms_contact_id', $local['contact_id'])
                                ->delete('dc_su_api_contacts_active');
                        }
                    }
                }

                $this->dcm_su_api->clean_rooms_and_rates($hms_id, $property_id);
            } else {
                $sync_status = 'Failed';
                $log_data[] = [
                    'action' => 'Delete property',
                    'object' => $prop,
                    'result' => 'fail',
                    'error' => 'Property has mappings',
                ];
            }
        }

        $sync_log_data = [];
        $sync_log_data['date'] = date('Y-m-d H:i:s');
        $sync_log_data['user_id'] = $_SESSION['user']['id'];
        $sync_log_data['status'] = $sync_status;
        $sync_log_data['details'] = json_encode($log_data);

        $this->db->set($sync_log_data)->insert('dc_su_api_log');

        if ($this->debug) {
            exit();
        }
        exit("<meta http-equiv='refresh' content='0;url=/dc_su_api/sync'>");
    }

    public function clients($debug = false)
    {
        if (isset($_POST['su_property_id'])) {
            $session_data = [
                'su_property_id_ota' => $this->input->post('su_property_id'),
                'su_search_country' => addslashes($this->input->post('country')),
                'su_search_region' => $this->input->post('region'),
                'su_search_property_type' => $this->input->post('property_type'),
                'su_search_ota_name' => addslashes($this->input->post('ota_name')),
            ];
            $this->session->set_userdata($session_data);
        }

        $sql = "SELECT dc_su_xml_cfg.str_value as su_property_id, dc_su_xml_cfg.str_value, internationalfields.value AS su_property_name
                FROM dc_su_xml_cfg
                LEFT JOIN internationalfields ON dc_su_xml_cfg.dc_account_id=internationalfields.table_id 
	            AND table_type = 'property_custom'
	            AND language_id = 45
	            AND internationalfields.`name` = 'international_name'
                WHERE dc_su_xml_cfg.`name` = 'hotel_id'";

        $properties = $this->db->query($sql)->result_array();

        $data['properties'] = $properties;
        $data['su_all_channels'] = $this->dcm_su_api->get_su_channels();

        if (empty($properties)) {
            $this->load->view('/dc_su_api/clients', $data);

            return false;
        }

        $focused_property = $properties[0]['str_value'];

        foreach ($properties as $k => $prop) {
            if ($prop['str_value'] == $this->session->userdata('su_property_id_ota')) {
                $focused_property = $prop['str_value'];
                $data['properties'][$k]['property_selected'] = 'selected';
            } else {
                $data['properties'][$k]['property_selected'] = '';
            }
        }
        $data['su_property_id_ota'] = $focused_property;

        $chs_list_arr = $this->dcm_su_api->get_mappings($focused_property);

        $data['chs_list_arr'] = $chs_list_arr;

        if ($debug) {
            if ($this->session->userdata('global_debug')) {
                echo '<table border=1 style="border-collapse: collapse"><tr>';
                echo "<td>#</td>";
                echo "<td>Channle name</td>";
                echo "<td>Channel code</td>";
                echo "<td>Encrypted channel code</td>";
                echo "<td>Status</td>";
                echo '</tr><tr>';
                //echo '<pre>';
                //print_r($data);
                $i = 1;
                foreach ($data['su_all_channels'] as $k => $v) {
                    if ($v['status'] != 'Online') {
                        $v['encrypted_channel_code'] = "N/A";
                        $v['channel_code'] = "N/A";
                        //unset($data['su_all_channels'][$k]);
                        //continue;
                    }
                    echo "<td>$i</td>";
                    echo "<td>{$v['channel_name']}</td>";
                    echo "<td>{$v['channel_code']}</td>";
                    echo "<td>{$v['encrypted_channel_code']}</td>";
                    echo "<td>{$v['status']}</td></tr><tr>";
                    //$data['su_all_channels'][$k]['counter'] = $i;
                    ++$i;
                }
                echo "</tr></table>";
                //print_r($data['su_all_channels']);
                exit();
            }
        }

        $this->load->view('/dc_su_api/clients', $data);
    }

    public function clients_edit($su_property_id, $su_channel_id, $debug = false): void
    {
        $data = $this->dcm_su_api->get_connector_data($su_channel_id);

        $data['su_property_id'] = $su_property_id;

        if ($this->session->userdata('global_debug') && $debug) {
            echo '<pre>';
            print_r($data);
            exit();
        }

        $this->load->view('/dc_su_api/clients_edit', $data);
    }

    public function clients_edit_post(): void
    {
        $post = $_POST;

        $dc_id = $post['dc_id'];
        $ch_id = $post['ch_id'];
        $hms_property_id = $post['hms_property_id'];
        $hms_id = $this->config->item('hotel_id');

        $sql = "INSERT INTO dc_su_data (su_dc_id, hms_property_id, `name`, int_value) VALUES($dc_id, $hms_property_id, 'dealer_id', {$post['dealer']}) 
            ON DUPLICATE KEY UPDATE int_value = {$post['dealer']}, hms_property_id = $hms_property_id";

        $this->db->query($sql);

        exit("<meta http-equiv='refresh' content='0;url=/dc_su_api/clients_edit/hms-$hms_id-$hms_property_id/$ch_id'>");
    }
}
