<?php

class dc_su extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('dcm_abstract');
        $this->load->model('property_model');
        $this->load->model('mcategory');
        $this->load->model('mrates');
        $this->load->model('dcm_su_api');
        $this->load->model('dcm_su');
        $this->load->model('htmltpl');
        $this->load->model('Authorization');
        $this->load->model('curl_model');
        $this->load->model('Loger_admin');
        $this->Authorization->IsLogined('admin_access');

        // ==== billing plan access start ==========
        $data_access = ['module_name' => 'channel_manager'];
        $billing_plan_access = $this->Access->get_billing_plan_access($data_access);
        if ($billing_plan_access == 0) {
            exit("<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/52'>");
        }
        // ==== billing plan access end ==========
    }

    public function test_confirm()
    {
        $this->dcm_su->acknowledge();
    }

    public function get_hotels()
    {
        $url = $this->url.'pmsproperty';
        $debug = 0;
        $headers = [
            'Authorization: Basic '.$this->dcm_su->auth,
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $buffer = curl_exec($ch);
        $information = curl_getinfo($ch);

        curl_close($ch);

        $result = json_decode($buffer, true);

        echo '<pre>';
        print_r($result);
        exit();
    }

    public function update_restrictions($hotel_id = '109-1', $room_id = '109-1-1', $rate_id = '109-1')
    {
        $updates = [
            'hotelid' => $hotel_id,
            'room' => [
                [
                    'id' => $room_id,
                    'date' => [
                        [
                            'from' => date('Y-m-d'),
                            'to' => date('Y-m-d', strtotime('+1 week')),
                            'rate' => [
                                [
                                    'id' => $rate_id,
                                ],
                            ],
                            'closed' => rand(0, 1),
                            'minimumstay' => '1',
                            'maximumstay' => '500',
                            'closedonarrival' => rand(0, 1),
                            'closedondeparture' => rand(0, 1),
                        ],
                    ],
                ],
            ],
        ];
        echo '<pre>';
        print_r($updates);
        $url = $this->url.'availability';

        $headers = [
            'Authorization: Basic '.$this->dcm_su->auth,
            'Content-Type: application/json',
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($updates));

        $buffer = curl_exec($ch);
        $information = curl_getinfo($ch);

        curl_close($ch);

        $result = json_decode($buffer, true);

        echo '<pre>';
        print_r($result);
        exit();
    }

    public function catgories_edit()
    {
        $data = [];
        $this->load->library('parser');
        $this->load->view('/dc_su/catgories_edit_view.php', $data);
    }

    public function categories_edit_post()
    {
        $categories_link = $this->input->post('categories', true);
        $data_1 = $this->Loger_admin->get_dccategories_multivalues('dc_su_room_categories_link');
        $data_category2occupancy_1 = $this->Loger_admin->get_dccategories_multivalues('dc_su_category2occupancy', 1);
        $c2o = $_POST['c2o'];

        $this->dcm_su->category2occupancy_save($c2o);

        $data_2 = $this->Loger_admin->get_dccategories_multivalues('dc_su_room_categories_link');
        $data_category2occupancy_2 = $this->Loger_admin->get_dccategories_multivalues('dc_su_category2occupancy', 1);

        $this->Loger_admin->SaveLog_dc_multicol($data_1, $data_2, 'loger_admin', 'dc_su_room_categories_link', 'edit');
        $this->Loger_admin->SaveLog_dc_multicol($data_category2occupancy_1, $data_category2occupancy_2, 'loger_admin', 'dc_su_category2occupancy', 'edit', 2);

        exit("<meta http-equiv='refresh' content='0;url=/dc_su/catgories_edit'>");
    }

    public function rates_edit()
    {
        $data = [];
        $this->load->library('parser');
        $this->load->view('/dc_su/rates_edit_view.php', $data);
    }

    public function rates_edit_post()
    {
        $r2c = $_POST['r2c'];
        // 		echo "<pre>";
        // 		print_r($_POST);
        // 		die();
        $data_rate2category_link_1 = $this->Loger_admin->get_dcrate_multivalues('dc_su_rate2category_link', 1);
        $restricts = $_POST['restricts'];

        $this->dcm_su->rate2category_save_su($r2c, $restricts);

        $data_rate2category_link_2 = $this->Loger_admin->get_dcrate_multivalues('dc_su_rate2category_link', 1);
        $this->Loger_admin->SaveLog_dc_multicol($data_rate2category_link_1, $data_rate2category_link_2, 'loger_admin', 'dc_su_rate2category_link', 'edit', 1);

        exit("<meta http-equiv='refresh' content='0;url=/dc_su/rates_edit'>");
    }

    public function get_rooms($die_option)
    {
        $this->dcm_su->import_room_rates();
        // die();
        if ($die_option == 1) {
            $_SESSION['dc_msg']['text'] = $curl_result;
            exit("<meta http-equiv='refresh' content='0;url=/dc_su/catgories_edit'>");
        }
    }

    public function category_delete($dc_category_id)
    {
        $sql = 'DELETE FROM dc_su_room_categories WHERE dc_room_id = '.$dc_category_id;
        $query = $this->db->query($sql);
        $sql = 'DELETE FROM dc_su_room_categories_link WHERE dc_category_id = '.$dc_category_id;
        $query = $this->db->query($sql);
        $sql = 'DELETE FROM dc_su_category2occupancy WHERE dc_category_id = '.$dc_category_id;
        $query = $this->db->query($sql);
        $sql = 'DELETE FROM dc_su_rate2category_link WHERE dc_category_id = '.$dc_category_id;
        $query = $this->db->query($sql);
        $sql = 'DELETE FROM dc_su_restricts_link WHERE dc_category_id = '.$dc_category_id;
        $query = $this->db->query($sql);
        $sql = 'DELETE FROM dc_su_occupancy WHERE roomcategory = '.$dc_category_id;
        $query = $this->db->query($sql);

        exit("<meta http-equiv='refresh' content='0;url=/dc_su/catgories_edit'>");
    }

    public function truncate_categories()
    {
        $sql = 'DELETE FROM dc_su_room_categories WHERE 1';
        $query = $this->db->query($sql);
        $sql = 'DELETE FROM dc_su_room_categories_link WHERE 1';
        $query = $this->db->query($sql);
        $sql = 'DELETE FROM dc_su_category2occupancy WHERE 1';
        $query = $this->db->query($sql);
        $sql = 'DELETE FROM dc_su_occupancy WHERE 1';
        $query = $this->db->query($sql);
        $sql = 'DELETE FROM dc_su_categories_strtoint WHERE 1';
        $query = $this->db->query($sql);
        $sql = 'DELETE FROM dc_su_restricts_link WHERE 1';
        $query = $this->db->query($sql);
        $sql = 'DELETE FROM dc_su_rate2category_link WHERE 1';
        $query = $this->db->query($sql);

        exit("<meta http-equiv='refresh' content='0;url=/dc_su/catgories_edit'>");
    }

    public function rate_full_delete($dc_rate_id)
    {
        $sql = 'DELETE FROM  dc_su_rate2category_link WHERE dc_rate_id = '.$dc_rate_id;
        $query = $this->db->query($sql);

        $sql = 'DELETE FROM  dc_su_rates WHERE dc_rate_id = '.$dc_rate_id;
        $query = $this->db->query($sql);

        $sql = 'DELETE FROM  dc_su_rates_strtoint WHERE id = '.$dc_rate_id;
        $query = $this->db->query($sql);
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/rates_edit'>");
    }

    public function truncate_rates()
    {
        $sql = 'DELETE FROM dc_su_rates WHERE 1';
        $query = $this->db->query($sql);

        $sql = 'DELETE FROM dc_su_rate2category_link WHERE 1';
        $query = $this->db->query($sql);

        $sql = 'DELETE FROM dc_su_rates_strtoint WHERE 1';
        $query = $this->db->query($sql);
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/rates_edit'>");
    }

    public function rate_delete($dc_rate_id, $dc_category_id)
    {
        $sql = 'DELETE FROM  dc_su_rate2category_link WHERE dc_rate_id = '.$dc_rate_id.' AND dc_category_id = '.$dc_category_id;
        $query = $this->db->query($sql);
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/rates_edit'>");
    }

    public function ra_params_edit()
    {
        $data = [];
        $this->load->library('parser');
        $this->load->view('/dc_su/ra_params_edit_view.php', $data);
    }

    public function ra_params_edit_post()
    {
        $ra_params = $this->input->post('ra');
        $rooms = $this->input->post('rooms');
        foreach ($rooms as $dc_room_id => $cell) {
            $this->db->update('dc_su_room_categories_link', [
                'min' => $cell['min'],
                'max' => $cell['max'],
            ], [
                'dc_category_id' => $dc_room_id,
            ]);
        }

        exit("<meta http-equiv='refresh' content='0;url=/dc_su/ra_params_edit'>");
    }

    public function create_rate($su_property_id, $hms_rate_id)
    {
        $data = ['su_property_id' => $su_property_id, 'hms_rate_id' => $hms_rate_id];
        //echo "<pre>";
        //print_r($data);
        $create_result = $this->dcm_su->create_rate($data);
        echo '<pre>';
        print_r($create_result);
        //die();
        if (isset($create_result['curl_response']['Status'])) {
            if ($create_result['curl_response']['Status'] == 'Success') {
                // ========= IMPORT DATA ========
                $this->dcm_su->import_room_rates();
                // ========= BIND ========
                $hms_id = $this->config->item('hotel_id');
                $hms_property_id = $this->dcm_su->get_hms_prop_id_by_su_prop_id($su_property_id);
                $su_rate_id = "$hms_id-$hms_property_id-$hms_rate_id";
                $this->dcm_su->bind_rates([
                    'hms_rate_id' => $hms_rate_id,
                    'su_rate_id' => $su_rate_id,
                    'su_property_id' => $su_property_id,
                ]);
            } else {
                if ($create_result['curl_response']['Status'] == 'Fail') {
                    if (isset($create_result['curl_response']['Errors']['ShortText'])) {
                        if ($create_result['curl_response']['Errors']['ShortText'] == 'Room Already Exist') {
                            // ========= IMPORT DATA ========
                            $this->dcm_su->import_room_rates();
                            // ========= BIND ========
                            $hms_id = $this->config->item('hotel_id');
                            $hms_property_id = $this->get_hms_prop_id_by_su_prop_id($su_property_id);
                            $su_rate_id = "$hms_id-$hms_property_id-$hms_rate_id";
                            $this->dcm_su->bind_rates([
                                'hms_rate_id' => $hms_rate_id,
                                'su_rate_id' => $su_rate_id,
                                'su_property_id' => $su_property_id,
                            ]);
                        }
                    }
                }
            }

            $session_data = [
                'header_msg_text' => json_encode($create_result['curl_response']),
            ];
            $this->session->set_userdata($session_data);
        }

        //die();
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/rates_list/$su_property_id'>");
    }

    public function create_room($su_property_id, $hms_category_id)
    {
        $data = ['su_property_id' => $su_property_id, 'hms_category_id' => $hms_category_id];
        $create_result = $this->dcm_su->create_room($data);
        //         echo "<pre>";
        //         print_r($create_result);
        //         die();;
        if (isset($create_result['curl_response']['Status'])) {
            if ($create_result['curl_response']['Status'] == 'Success') {
                // ========= IMPORT DATA ========
                $this->dcm_su->import_room_rates();
                // ========= BIND ========
                $hms_id = $this->config->item('hotel_id');
                $hms_property_id = $this->dcm_su->get_hms_prop_id_by_su_prop_id($su_property_id);
                $su_room_id = "$hms_id-$hms_property_id-$hms_category_id";
                $this->dcm_su->bind_rooms([
                    'hms_room_id' => $hms_category_id,
                    'su_room_id' => $su_room_id,
                    'su_property_id' => $su_property_id,
                ]);
            } else {
                if ($create_result['curl_response']['Status'] == 'Fail') {
                    if (isset($create_result['curl_response']['Errors']['ShortText'])) {
                        if ($create_result['curl_response']['Errors']['ShortText'] == 'Room Already Exists') {
                            //$this->dcm_su->update_su_properties_cfg(array('su_property_id' => $create_result['su_property_id']));
                            $this->dcm_su->import_room_rates();

                            // ========= BIND ========
                            $hms_id = $this->config->item('hotel_id');
                            $hms_property_id = $this->dcm_su->get_hms_prop_id_by_su_prop_id($su_property_id);
                            $su_room_id = "$hms_id-$hms_property_id-$hms_category_id";
                            $this->dcm_su->bind_rooms([
                                'hms_room_id' => $hms_category_id,
                                'su_room_id' => $su_room_id,
                                'su_property_id' => $su_property_id,
                            ]);
                        }
                    } //else {
        //                         $session_data = array(
        //                             'header_msg_text' => json_encode($create_result['curl_response'])
        //                         );
        //                         $this->session->set_userdata($session_data);
        //                     }
                }
            }

            $session_data = [
                'header_msg_text' => json_encode($create_result['curl_response']),
            ];
            $this->session->set_userdata($session_data);
        }

        //die();
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/rooms_list/$su_property_id'>");
    }

    public function options()
    {
        $data = [];
        $this->load->library('parser');
        $this->load->view('/dc_su/options_view.php', $data);
    }

    public function options_post()
    {
        $post = $_POST;
        $this->dcm_su->options_save($post);
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/options'>");
    }

    public function properties_list()
    {
        $data = [];
        $this->load->view('dc_su/properties_list_view.php', $data);
    }

    public function rates_list($su_prop_id = null)
    {
        $data = ['su_prop_id' => $su_prop_id];
        $this->load->view('dc_su/rates_list_view.php', $data);
    }

    public function rooms_list($su_prop_id = null)
    {
        $data = ['su_prop_id' => $su_prop_id];
        $this->load->view('dc_su/rooms_list_view.php', $data);
    }

    public function property_create_OLD($property_id)
    {
        $data = ['property_id' => $property_id, 'status' => 'create'];
        $create_result = $this->dcm_su->create_update_property($data);
        //         echo "<pre>";
        //         print_r($create_result);
        //         echo "<br>";
        //         die();
        if (isset($create_result['curl_response']['Status'])) {
            if ($create_result['curl_response']['Status'] == 'Success') {
                $this->dcm_su->update_su_properties_cfg(['su_property_id' => $create_result['su_property_id']]);
                $su_prop_id = $create_result['su_property_id'];
                $property_validate_status = $this->dcm_su->validate_su_property_id(['su_property_id' => $su_prop_id]);

                if ($property_validate_status) {
                    if (!$this->dcm_su->property_already_binded(['su_property_id' => $su_prop_id])) {
                        $this->dcm_su->bind_properties(['hms_property_id' => $property_id, 'su_property_id' => $su_prop_id]);
                    } else {
                        if ($this->debug) {
                            echo '<pre>';
                            exit("Property $su_prop_id allready binded!<br>");
                        }
                    }
                }
            } else {
                if ($create_result['curl_response']['Status'] == 'Fail') {
                    if (isset($create_result['curl_response']['Errors']['ShortText'])) {
                        if ($create_result['curl_response']['Errors']['ShortText'] == 'Property already exists') {
                            $this->dcm_su->update_su_properties_cfg(['su_property_id' => $create_result['su_property_id']]);
                            $su_prop_id = $create_result['su_property_id'];
                            $property_validate_status = $this->dcm_su->validate_su_property_id(['su_property_id' => $su_prop_id]);
                            //                             echo "----$su_prop_id++".$property_validate_status."====";
                            //                             die();
                            if ($property_validate_status) {
                                if (!$this->dcm_su->property_already_binded(['su_property_id' => $su_prop_id])) {
                                    $this->dcm_su->bind_properties(['hms_property_id' => $property_id, 'su_property_id' => $su_prop_id]);
                                } else {
                                    if ($this->debug) {
                                        echo '<pre>';
                                        exit("Property $su_prop_id allready binded!<br>");
                                    }
                                }
                            }
                        }
                    } else {
                        $session_data = [
                            'header_msg_text' => json_encode($create_result['curl_response']),
                        ];
                        $this->session->set_userdata($session_data);
                    }
                }
            }
        }
        //die();;
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/properties_list'>");
    }

    public function property_create($property_id)
    {
        $data = ['property_id' => $property_id];
        $this->dcm_su->property_create($data);
        //die();;
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/properties_list'>");
    }

    public function property_update($su_property_id)
    {
        $data = ['su_property_id' => $su_property_id];
        $this->dcm_su->property_update($data);
        //die();
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/properties_list'>");
    }

    public function property_bind($hms_prop_id, $su_prop_id)
    {
        $property_validate_status = $this->dcm_su->validate_su_property_id(['su_property_id' => $su_prop_id]);
        $return_msg = "Property $su_prop_id is binded!";
        if ($property_validate_status) {
            $this->dcm_su->update_su_properties_cfg(['su_property_id' => $su_prop_id]); // dc_su_cfg hotel_id insert if not exist
            if (!$this->dcm_su->property_already_binded(['su_property_id' => $su_prop_id])) {
                $this->dcm_su->bind_properties(['hms_property_id' => $hms_prop_id, 'su_property_id' => $su_prop_id]);
            } else {
                $return_msg = "Property $su_prop_id allready binded!";
            }
        } else {
            $return_msg = "Property $su_prop_id validate_status error!";
        }

        $session_data = [
            'header_msg_text' => $return_msg,
        ];
        $this->session->set_userdata($session_data);
        //die();
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/properties_list'>");
    }

    public function property_unbind($su_prop_id)
    {
        $this->dcm_su->unbind_properties(['su_property_id' => $su_prop_id]);
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/properties_list'>");
    }

    public function property_delete($su_prop_id)
    {
        $this->dcm_su->delete_properties_conections(['su_property_id' => $su_prop_id]);
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/properties_list'>");
    }

    public function property_recovery($su_prop_id)
    {
        $this->dcm_su->update_su_properties_cfg(['su_property_id' => $su_prop_id]);
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/properties_list'>");
    }

    public function room_bind($hms_room_id, $su_room_id, $su_prop_id)
    {
        //         echo "$hms_room_id-$su_room_id-$su_prop_id";
        //         die();
        $property_validate_status = $this->dcm_su->validate_su_property_id(['su_property_id' => $su_prop_id]);
        if ($property_validate_status) {
            if (!$this->dcm_su->room_already_binded(['su_room_id' => $su_room_id])) {
                $this->dcm_su->bind_rooms([
                    'hms_room_id' => $hms_room_id,
                    'su_room_id' => $su_room_id,
                    'su_property_id' => $su_prop_id,
                ]);
            } else {
                if ($this->debug) {
                    echo '<pre>';
                    exit("Room $su_room_id allready binded!<br>");
                }
            }
        } else {
            if ($this->debug) {
                echo '<pre>';
                print_r($property_attributes->Errors);
                exit("Property $su_prop_id errored on su!<br> ");
            }
        }
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/rooms_list/$su_prop_id'>");
    }

    public function rate_unbind($su_rate_id, $su_prop_id)
    {
        $this->dcm_su->unbind_rates(['su_rate_id' => $su_rate_id, 'su_prop_id' => $su_prop_id]);
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/rates_list/$su_prop_id'>");
    }

    public function room_unbind($su_room_id, $su_prop_id)
    {
        $this->dcm_su->unbind_rooms(['su_room_id' => $su_room_id]);
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/rooms_list/$su_prop_id'>");
    }

    public function change_room_status($su_room_id, $su_prop_id, $status)
    {
        $this->dcm_su->change_room_status($su_prop_id, $su_room_id, $status);
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/rooms_list/$su_prop_id'>");
    }

    public function change_rate_status($su_rate_id, $su_prop_id, $status)
    {
        $this->dcm_su->change_rate_status($su_prop_id, $su_rate_id, $status);
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/rates_list/$su_prop_id'>");
    }

    public function update_su_room($su_property_id, $su_room_id, $hms_category_id)
    {
        $data = ['su_property_id' => $su_property_id, 'su_room_id' => $su_room_id, 'hms_category_id' => $hms_category_id];
        $create_result = $this->dcm_su->update_room($data);
        if (isset($create_result['curl_response']['Status'])) {
            if ($create_result['curl_response']['Status'] == 'Success') {
                //$this->dcm_su->update_su_properties_cfg(array('su_property_id' => $create_result['su_property_id']));
            } else {
                if ($create_result['curl_response']['Status'] == 'Fail') {
                    if (isset($create_result['curl_response']['Errors']['ShortText'])) {
                        if ($create_result['curl_response']['Errors']['ShortText'] == 'Room Already Exist') {
                            //$this->dcm_su->update_su_properties_cfg(array('su_property_id' => $create_result['su_property_id']));
                        }
                    }
                }
            }

            $session_data = [
                'header_msg_text' => json_encode($create_result['curl_response']),
            ];
            $this->session->set_userdata($session_data);
        }

        //die();
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/rooms_list/$su_property_id'>");
    }

    public function update_su_rate($su_property_id, $su_rate_id, $hms_rate_id)
    {
        $data = ['su_property_id' => $su_property_id, 'su_rate_id' => $su_rate_id, 'hms_rate_id' => $hms_rate_id];
        $create_result = $this->dcm_su->update_rate($data);
        if (isset($create_result['curl_response']['Status'])) {
            if ($create_result['curl_response']['Status'] == 'Success') {
                //$this->dcm_su->update_su_properties_cfg(array('su_property_id' => $create_result['su_property_id']));
            } else {
                if ($create_result['curl_response']['Status'] == 'Fail') {
                    if (isset($create_result['curl_response']['Errors']['ShortText'])) {
                        if ($create_result['curl_response']['Errors']['ShortText'] == 'Room Already Exist') {
                            //$this->dcm_su->update_su_properties_cfg(array('su_property_id' => $create_result['su_property_id']));
                        }
                    }
                }
            }

            $session_data = [
                'header_msg_text' => json_encode($create_result['curl_response']),
            ];
            $this->session->set_userdata($session_data);
        }

        //die();
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/rates_list/$su_property_id'>");
    }

    public function rate_bind($hms_rate_id, $su_rate_id, $su_prop_id)
    {
        //echo $hms_rate_id."-".$su_rate_id."-".$su_prop_id;

        $property_validate_status = $this->dcm_su->validate_su_property_id(['su_property_id' => $su_prop_id]);
        //echo $property_validate_status;
        //die();
        if ($property_validate_status) {
            if (!$this->dcm_su->rate_already_binded(['su_rate_id' => $su_rate_id, 'su_property_id' => $su_prop_id])) {
                //echo "++++++";
                //die();
                $this->dcm_su->bind_rates([
                    'hms_rate_id' => $hms_rate_id,
                    'su_rate_id' => $su_rate_id,
                    'su_property_id' => $su_prop_id,
                ]);
            } else {
                if ($this->debug) {
                    echo '<pre>';
                    exit("Rate $su_rate_id allready binded!<br>");
                }
            }
        } else {
            if ($this->debug) {
                echo '<pre>';
                print_r($property_attributes->Errors);
                exit("Property $su_rate_id errored on Booking!<br> ");
            }
        }
        //die();
        exit("<meta http-equiv='refresh' content='0;url=/dc_su/rates_list/$su_prop_id'>");
    }

    public function reservations_form()
    {
        $data = [];
        $this->load->library('parser');
        $this->load->view('/dc_su/reservations_form_view.php', $data);
    }

    public function reservations_post()
    {
        $post = $this->input->post();
        if ($this->session->userdata('global_debug')) {
            echo '<pre>';
            echo '============ POST ========= ';
            echo '<br>';
            print_r($_POST);
        }
        $this->dcm_su->save_reservations($post);
    }

    public function reservations_post_bydate()
    {
        $post = $this->input->post();
        if ($this->session->userdata('global_debug')) {
            echo '<pre>';
            echo '============ POST ========= ';
            echo '<br>';
            print_r($_POST);
            echo '<br>';
        }
        $this->dcm_su->save_reservations_bydate($post);
    }

    function get_bookings_formfile(){
        $str_data = file_get_contents ( $_FILES ['file_data'] ['tmp_name'] );
        
        $encoding = $this->input->post ( 'encoding' );
        switch ($encoding) {
            case "windows1251" :
                $str_data = iconv ( "windows-1251", "utf-8", $str_data );
                break;
            case "utf8" :
                break;
            default :
                //$str_data = iconv ( "windows-1251", "utf-8", $str_data );
                break;
        }
        echo "<pre>";
        echo $str_data;
        $result_array = json_decode($str_data, 1);
        $this->dcm_su->get_bookings ( $result_array );
    }

    public function test_booking()
    {
        $book = '{"reservations":[{"booked_at":"2024-06-21","commissionamount":"2924.64","currencycode":"EUR","paymenttype":"Hotel Collect","hotel_id":"hms-92-5","hotel_name":"Vit","paymentdue":"","customer":{"corporate_booking_detail":{"booking_source":"","tax_id":"","billing_company":"","billing_address":"","payment_information":"Bill To Company","payment_due_date":"2022-12-30","booker_address":"","booker_taxid":"","booking_type":""},"address":"\u0425\u0440\u0435\u0449\u0430\u0442\u0438\u043a, 1","cc_cvc":"","cc_expiration_date":"","cc_name":"","cc_number":"","cc_type":"","cc_current_balance":"","cc_activation_date":"","vcc_expiration_date":"","cc_token":"","cc_token_expiration":"","cc_unique_code":"","city":"\u041a\u0438\u0457\u0432","state":"","countrycode":"\u0423\u043a\u0440\u0430\u0457\u043d\u0430","email":"vyachmenev@otelms.com","first_name":"Vit","last_name":"Ya","remarks":"Approximate time of arrival: between 17:00 and 18:00Are double beds available?","telephone":"145454","zip":"79000","cc_vault_token":"","cc_tracking_id":"","tokensource":"","tokentype":"","token_id":"","cc_virtual":""},"rooms":[{"arrival_date":"2024-06-21","departure_date":"2024-06-22","info":"\n\t\t\t\t\tThis modern room is equipped with a work desk and a flat-screen TV with satellite channels. Enjoy a convenient Breakfast at the property for USD 18 per person, per night. Children and Extra Bed Policy: Children cannot be accommodated at the hotel. There is no capacity for extra beds in the room. Deposit Policy: 100 percent of the first night may be charged anytime after booking. Cancellation Policy: If cancelled or modified up to 1 day before the date of arrival, no fee will be charged. If cancelled or modified later or in case of no-show, 100 percent of the first night will be charged.\n\t\t\t\t\t","facilities":"No Smoking Meal plan :Enjoy a convenient Breakfast at the property for USD 18 per person, per night. rewritten_from_name : SECRET DEAL genius_rate : no","specialrequest":"No Smoking Meal plan :Enjoy a convenient Breakfast at the property for USD 18 per person, per night. rewritten_from_name : SECRET DEAL genius_rate : no","eta":"","guest_name":"Vit Ya","first_name":"Vit","last_name":"Ya","id":"92-5-3","max_children":"1","numberofguests":"2","numberofchildren":"1","numberofadults":"2","roomstaystatus":"new","roomreservation_id":"1718959294189","totalbeforetax":"11227.469226982","totaltax":"5.5307730182177","totalprice":"11233","price":[{"amount":"11209.478089611","date":"2024-06-21","rate_id":"92-5-164","mealplan_id":"1","mealplan":"All inclusive","tax":"5.521910388971","pricebeforetax":"11209.478089611","priceaftertax":"11215"}],"adults":[],"addons":[{"name":"Breakfast","nights":"1","priceperunit":"18.00","pricemode":"4","price":"18","comment":"Adult : 2,Child : 2,Base : 2"}],"extracomponents":[]},{"arrival_date":"2024-06-21","departure_date":"2024-06-22","info":"\n\t\t\t\t\tThis modern room is equipped with a work desk and a flat-screen TV with satellite channels. Enjoy a convenient Breakfast at the property for USD 18 per person, per night. Children and Extra Bed Policy: Children cannot be accommodated at the hotel. There is no capacity for extra beds in the room. Deposit Policy: 100 percent of the first night may be charged anytime after booking. Cancellation Policy: If cancelled or modified up to 1 day before the date of arrival, no fee will be charged. If cancelled or modified later or in case of no-show, 100 percent of the first night will be charged.\n\t\t\t\t\t","facilities":"No Smoking Meal plan :Enjoy a convenient Breakfast at the property for USD 18 per person, per night. rewritten_from_name : SECRET DEAL genius_rate : no","specialrequest":"No Smoking Meal plan :Enjoy a convenient Breakfast at the property for USD 18 per person, per night. rewritten_from_name : SECRET DEAL genius_rate : no","eta":"","guest_name":"Vit Ya","first_name":"Vit","last_name":"Ya","id":"92-5-3","max_children":"1","numberofguests":"2","numberofchildren":"1","numberofadults":"2","roomstaystatus":"new","roomreservation_id":"1718959294835","totalbeforetax":"13132.530773018","totaltax":"6.4692269817824","totalprice":"13139","price":[{"amount":"13114.539635647","date":"2024-06-21","rate_id":"92-5-164","mealplan_id":"1","mealplan":"All inclusive","tax":"6.4603643525357","pricebeforetax":"13114.539635647","priceaftertax":"13121"}],"adults":[],"addons":[{"name":"Breakfast","nights":"1","priceperunit":"18.00","pricemode":"4","price":"18","comment":"Adult : 2,Child : 2,Base : 2"}],"extracomponents":[]}],"affiliation":{"pos":"ds","source":"Airbnb","OTA_Code":"244","companyname":"","gstno":"","companyaddress":""},"chain_id":"","external_id":"","otadue":"","cancelreason":"","sellamount":"24372","nettamount":"24372","discount":"","confirmationlink":"","payment_charge":"","channel_booking_id":"505370221","thread_id":"","guest_id":"","numberofpets":"","numberofinfants":"","listingbaseprice":"","processed_at":"2024-06-21 08:41:30","bookingcharged":"N","amountcharged":"","pgtransactionid":"","deposit":"","cvv_available":"false","source":"Su","pg_refid":"","pg_type":"","cancellation_fee":"","newsletter_subscription":"N","vendor_booking_id":"122543543","id":"505370221_hms-92-5","reservation_notif_id":"171895929055398014681","modified_at":"2024-06-21","status":"new","totalprice":"24372","totaltax":"12","extrafees":[],"taxes":[]},{"booked_at":"2024-06-21","commissionamount":"2924.64","currencycode":"EUR","paymenttype":"Hotel Collect","hotel_id":"hms-92-5","hotel_name":"Vit","paymentdue":"","customer":{"corporate_booking_detail":{"booking_source":"","tax_id":"","billing_company":"","billing_address":"","payment_information":"Bill To Company","payment_due_date":"2022-12-30","booker_address":"","booker_taxid":"","booking_type":""},"address":"\u0425\u0440\u0435\u0449\u0430\u0442\u0438\u043a, 1","cc_cvc":"","cc_expiration_date":"","cc_name":"","cc_number":"","cc_type":"","cc_current_balance":"","cc_activation_date":"","vcc_expiration_date":"","cc_token":"","cc_token_expiration":"","cc_unique_code":"","city":"\u041a\u0438\u0457\u0432","state":"","countrycode":"\u0423\u043a\u0440\u0430\u0457\u043d\u0430","email":"vyachmenev@otelms.com","first_name":"Vit","last_name":"Ya","remarks":"Approximate time of arrival: between 17:00 and 18:00Are double beds available?","telephone":"145454","zip":"79000","cc_vault_token":"","cc_tracking_id":"","tokensource":"","tokentype":"","token_id":"","cc_virtual":""},"rooms":[{"arrival_date":"2024-06-21","departure_date":"2024-06-22","info":"\n\t\t\t\t\tThis modern room is equipped with a work desk and a flat-screen TV with satellite channels. Enjoy a convenient Breakfast at the property for USD 18 per person, per night. Children and Extra Bed Policy: Children cannot be accommodated at the hotel. There is no capacity for extra beds in the room. Deposit Policy: 100 percent of the first night may be charged anytime after booking. Cancellation Policy: If cancelled or modified up to 1 day before the date of arrival, no fee will be charged. If cancelled or modified later or in case of no-show, 100 percent of the first night will be charged.\n\t\t\t\t\t","facilities":"No Smoking Meal plan :Enjoy a convenient Breakfast at the property for USD 18 per person, per night. rewritten_from_name : SECRET DEAL genius_rate : no","specialrequest":"No Smoking Meal plan :Enjoy a convenient Breakfast at the property for USD 18 per person, per night. rewritten_from_name : SECRET DEAL genius_rate : no","eta":"","guest_name":"Vit Ya","first_name":"Vit","last_name":"Ya","id":"92-5-3","max_children":"1","numberofguests":"2","numberofchildren":"1","numberofadults":"2","roomstaystatus":"cancelled","roomreservation_id":"1718959294189","totalbeforetax":"11227.469226982","totaltax":"5.5307730182177","totalprice":"11233","price":[{"amount":"11209.478089611","date":"2024-06-21","rate_id":"92-5-164","mealplan_id":"1","mealplan":"All inclusive","tax":"5.521910388971","pricebeforetax":"11209.478089611","priceaftertax":"11215"}],"adults":[],"addons":[{"name":"Breakfast","nights":"1","priceperunit":"18.00","pricemode":"4","price":"18","comment":"Adult : 2,Child : 2,Base : 2"}],"extracomponents":[]},{"arrival_date":"2024-06-21","departure_date":"2024-06-22","info":"\n\t\t\t\t\tThis modern room is equipped with a work desk and a flat-screen TV with satellite channels. Enjoy a convenient Breakfast at the property for USD 18 per person, per night. Children and Extra Bed Policy: Children cannot be accommodated at the hotel. There is no capacity for extra beds in the room. Deposit Policy: 100 percent of the first night may be charged anytime after booking. Cancellation Policy: If cancelled or modified up to 1 day before the date of arrival, no fee will be charged. If cancelled or modified later or in case of no-show, 100 percent of the first night will be charged.\n\t\t\t\t\t","facilities":"No Smoking Meal plan :Enjoy a convenient Breakfast at the property for USD 18 per person, per night. rewritten_from_name : SECRET DEAL genius_rate : no","specialrequest":"No Smoking Meal plan :Enjoy a convenient Breakfast at the property for USD 18 per person, per night. rewritten_from_name : SECRET DEAL genius_rate : no","eta":"","guest_name":"Vit Ya","first_name":"Vit","last_name":"Ya","id":"92-5-3","max_children":"1","numberofguests":"2","numberofchildren":"1","numberofadults":"2","roomstaystatus":"cancelled","roomreservation_id":"1718959294835","totalbeforetax":"13132.530773018","totaltax":"6.4692269817824","totalprice":"13139","price":[{"amount":"13114.539635647","date":"2024-06-21","rate_id":"92-5-164","mealplan_id":"1","mealplan":"All inclusive","tax":"6.4603643525357","pricebeforetax":"13114.539635647","priceaftertax":"13121"}],"adults":[],"addons":[{"name":"Breakfast","nights":"1","priceperunit":"18.00","pricemode":"4","price":"18","comment":"Adult : 2,Child : 2,Base : 2"}],"extracomponents":[]}],"affiliation":{"pos":"ds","source":"Airbnb","OTA_Code":"244","companyname":"","gstno":"","companyaddress":""},"chain_id":"","external_id":"","otadue":"","cancelreason":"","sellamount":"24372","nettamount":"24372","discount":"","confirmationlink":"","payment_charge":"","channel_booking_id":"505370221","thread_id":"","guest_id":"","numberofpets":"","numberofinfants":"","listingbaseprice":"","processed_at":"2024-06-21 09:32:24","bookingcharged":"N","amountcharged":"","pgtransactionid":"","deposit":"","cvv_available":"false","source":"Su","pg_refid":"","pg_type":"","cancellation_fee":"","newsletter_subscription":"N","vendor_booking_id":"122543543","id":"505370221_hms-92-5","reservation_notif_id":"171896234488748115629","modified_at":"2024-06-21","status":"cancelled","totalprice":"24372","totaltax":"12","extrafees":[],"taxes":[]}]}';
        $book = '{"reservations":[{"booked_at":"2024-07-21","commissionamount":"2924.64","currencycode":"EUR","paymenttype":"Hotel Collect","hotel_id":"hms-92-5","hotel_name":"Vit","paymentdue":"","customer":{"corporate_booking_detail":{"booking_source":"","tax_id":"","billing_company":"","billing_address":"","payment_information":"Bill To Company","payment_due_date":"2022-12-30","booker_address":"","booker_taxid":"","booking_type":""},"address":"\u0425\u0440\u0435\u0449\u0430\u0442\u0438\u043a, 1","cc_cvc":"","cc_expiration_date":"","cc_name":"","cc_number":"","cc_type":"","cc_current_balance":"","cc_activation_date":"","vcc_expiration_date":"","cc_token":"","cc_token_expiration":"","cc_unique_code":"","city":"\u041a\u0438\u0457\u0432","state":"","countrycode":"\u0423\u043a\u0440\u0430\u0457\u043d\u0430","email":"vyachmenev@otelms.com","first_name":"Vit","last_name":"QQ","remarks":"Approximate time of arrival: between 17:00 and 18:00Are double beds available?","telephone":"145454","zip":"79000","cc_vault_token":"","cc_tracking_id":"","tokensource":"","tokentype":"","token_id":"","cc_virtual":""},"rooms":[{"arrival_date":"2024-07-21","departure_date":"2024-07-22","info":"\n\t\t\t\t\tThis modern room is equipped with a work desk and a flat-screen TV with satellite channels. Enjoy a convenient Breakfast at the property for USD 18 per person, per night. Children and Extra Bed Policy: Children cannot be accommodated at the hotel. There is no capacity for extra beds in the room. Deposit Policy: 100 percent of the first night may be charged anytime after booking. Cancellation Policy: If cancelled or modified up to 1 day before the date of arrival, no fee will be charged. If cancelled or modified later or in case of no-show, 100 percent of the first night will be charged.\n\t\t\t\t\t","facilities":"No Smoking Meal plan :Enjoy a convenient Breakfast at the property for USD 18 per person, per night. rewritten_from_name : SECRET DEAL genius_rate : no","specialrequest":"No Smoking Meal plan :Enjoy a convenient Breakfast at the property for USD 18 per person, per night. rewritten_from_name : SECRET DEAL genius_rate : no","eta":"","guest_name":"Vit QQ1","first_name":"Vit","last_name":"QQ","id":"92-5-3","max_children":"1","numberofguests":"2","numberofchildren":"1","numberofadults":"2","roomstaystatus":"new","roomreservation_id":"1718959294189","totalbeforetax":"11227.469226982","totaltax":"5.5307730182177","totalprice":"11233","price":[{"amount":"11209.478089611","date":"2024-07-21","rate_id":"92-5-164","mealplan_id":"1","mealplan":"All inclusive","tax":"5.521910388971","pricebeforetax":"11209.478089611","priceaftertax":"11215"}],"adults":[],"addons":[{"name":"Breakfast","nights":"1","priceperunit":"18.00","pricemode":"4","price":"18","comment":"Adult : 2,Child : 2,Base : 2"}],"extracomponents":[]},{"arrival_date":"2024-07-21","departure_date":"2024-07-22","info":"\n\t\t\t\t\tThis modern room is equipped with a work desk and a flat-screen TV with satellite channels. Enjoy a convenient Breakfast at the property for USD 18 per person, per night. Children and Extra Bed Policy: Children cannot be accommodated at the hotel. There is no capacity for extra beds in the room. Deposit Policy: 100 percent of the first night may be charged anytime after booking. Cancellation Policy: If cancelled or modified up to 1 day before the date of arrival, no fee will be charged. If cancelled or modified later or in case of no-show, 100 percent of the first night will be charged.\n\t\t\t\t\t","facilities":"No Smoking Meal plan :Enjoy a convenient Breakfast at the property for USD 18 per person, per night. rewritten_from_name : SECRET DEAL genius_rate : no","specialrequest":"No Smoking Meal plan :Enjoy a convenient Breakfast at the property for USD 18 per person, per night. rewritten_from_name : SECRET DEAL genius_rate : no","eta":"","guest_name":"Vit QIIo","first_name":"Vit","last_name":"QII","id":"92-5-3","max_children":"1","numberofguests":"2","numberofchildren":"1","numberofadults":"2","roomstaystatus":"new","roomreservation_id":"1718959294835","totalbeforetax":"13132.530773018","totaltax":"6.4692269817824","totalprice":"13139","price":[{"amount":"13114.539635647","date":"2024-06-21","rate_id":"92-5-164","mealplan_id":"1","mealplan":"All inclusive","tax":"6.4603643525357","pricebeforetax":"13114.539635647","priceaftertax":"13121"}],"adults":[],"addons":[{"name":"Breakfast","nights":"1","priceperunit":"18.00","pricemode":"4","price":"18","comment":"Adult : 2,Child : 2,Base : 2"}],"extracomponents":[]}],"affiliation":{"pos":"ds","source":"Airbnb","OTA_Code":"244","companyname":"","gstno":"","companyaddress":""},"chain_id":"","external_id":"","otadue":"","cancelreason":"","sellamount":"24372","nettamount":"24372","discount":"","confirmationlink":"","payment_charge":"","channel_booking_id":"505370221","thread_id":"","guest_id":"","numberofpets":"","numberofinfants":"","listingbaseprice":"","processed_at":"2024-06-21 08:41:30","bookingcharged":"N","amountcharged":"","pgtransactionid":"","deposit":"","cvv_available":"false","source":"Su","pg_refid":"","pg_type":"","cancellation_fee":"","newsletter_subscription":"N","vendor_booking_id":"122543543","id":"505370221_hms-92-5","reservation_notif_id":"171895929055398014681","modified_at":"2024-06-21","status":"new","totalprice":"24372","totaltax":"12","extrafees":[],"taxes":[]}]}';
        $book_array = json_decode($book, true);
        if ($this->session->userdata('global_debug')) {
            echo '<pre>+++';
            print_r($book_array);
        }
        $this->dcm_su->get_bookings($book_array);
    }

    public function get_reservations_bydate()
    {
        //$dc_hotel_id = $data["dc_hotel_id"];

        $curl_data = [];
        $curl_data['api_url'] = $this->dcm_su->url.'Bookings';
        $curl_data['post_data'] = ['Su_hotelid' => 'hms-1918-1', 'date_from' => '07-16-2024', 'date_to' => '11-16-2024'];
        echo '<pre>';
        print_r($curl_data);
        $curl_response = $this->dcm_su->request_api($curl_data);
        $return_data = ['curl_response' => $curl_response];

        echo $return_data.'++++';
        print_r($return_data);
        exit();
        //$this->get_bookings($curl_response);
    }
}
