<?php
class dc_gateway extends CI_Controller {
	public function __construct() {
		parent::__construct ();
		
		$this->load->model ( 'frontdesk_c2' );
		$this->load->model ( 'mlanguages' );
	}
	
	function yandex_list(){
	    $return_array = array();

	    $property_types = $this->frontdesk_c2->get_property_types();
	    
	    $where_str = "hotelstateid IN (0, 1, 2, 3, 4, 6, 8, 11) AND id_country_3c = 'RUS'";
	    $result_array = $this->db->select('id, host, db_name')->get_where('visitka.config', $where_str)->result_array();
	    
	    //print_r($result_array);
	    
	    foreach($result_array as $hotel_main_data){
	        $db_name = $hotel_main_data["db_name"];
	        $hms_id = $hotel_main_data["id"];
	        
	        $property_array = $this->db->select('property_name, dwelling, property_type, street, city, state, country, gps_coordinates, reception_phone, email')->get($db_name.'.property_information')->result_array();
	        foreach($property_array as $property_data){
	            $dwelling = $property_data["dwelling"];
	            $property_type = $property_data["property_type"];
	            $category = "";
	            if(isset($property_types[$dwelling][$property_type])){
	                $category = $this->mlanguages->getdictionaryword("tbl_property_types", $lang = "rus", $property_types[$dwelling][$property_type]["property_type_name"]);
	            }
	            
	            $address_str = $property_data["street"].", ".$property_data["city"].", ".$property_data["state"].", ".$property_data["country"];
	            array_push($return_array, array(
	                'hms_id' => $hms_id,
	                'property' => $property_data["property_name"],
	                'address' => $address_str,
	                'gps' => $property_data["gps_coordinates"],
	                'category' => $category,
	                'phone' => $property_data["reception_phone"],
	                'url' => "book-".$hotel_main_data["host"],
	                'email' => $property_data["email"],
	            ));
	        }
	    }
	    
	    echo json_encode($return_array);
	    //echo "<pre>";
	    //print_r($return_array);
	}
}
?>