<?php
class dc_airbnb_c2_dev extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('dcm_airbnb');
        $this->load->model('dc_airbnb_rest');
        $this->load->model ( 'Authorization' );
        $this->load->model ( 'curl_model' );
        $this->load->helper('url');
        $this->Authorization->IsLogined ( "admin_access" );
    }

    function test() {
        $this->dcm_airbnb->validate_token();
        echo "<pre>";
        $listings_data_result = $this->dcm_airbnb->get_listings();
        
        
        $listings = json_decode($listings_data_result, true);
        
        $i = 1;
        foreach ($listings['listings'] as $listing) {
            //print_r($listing);
            echo $i . " - " . $listing['id'] . " [" . $listing['listing_import_id'].  "] - " .$listing['name'] . " - " .anchor('/dc_airbnb_c2_dev/delete_listing/' . $listing['id'], 'delete', '');
            echo "\n";
            $i++;
        }
        
        echo "\n";
        echo "\n";
        
        $listing_imports_result = $this->dcm_airbnb->get_listing_imports();
        $imports = json_decode($listing_imports_result, true);
        
        $i = 1;
        foreach ($imports['listing_imports'] as $import) {
            //print_r($listing);
            echo $i . " - " . $import['id'] . " - " .$import['listing_id'] . " " 
                . anchor('/dc_airbnb_c2_dev/delete_import/' . $import['id'], 'delete', '')
                . " - "
                . anchor('/dc_airbnb_c2_dev/migrate_import/' . $import['id'], 'migrate', '');
            echo "\n";
            $i++;
        }
        
        print_r($listing);
        print_r($imports);
    }
    
    public function delete_listing( $listing_id )
    {
        $this->dcm_airbnb->validate_token();
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $access_token,
            'X-Airbnb-API-Key:' . $clientid,
        );
        
        $url = "https://api.airbnb.com/v2/listings/{$listing_id}/";
        
        
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "DELETE",
            CURLOPT_HTTPHEADER =>  $headers,
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        echo '<pre>';
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            print_r(json_decode($response));
            echo $response;
        }
    }
    
    function migrate_import($import_id) {
        echo "<pre>";
        $this->dcm_airbnb->validate_token();
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $access_token,
            'X-Airbnb-API-Key:' . $clientid,
        );
        
        $url = "https://api.airbnb.com/v2/listing_imports/" . $import_id . "/import_convert_to_rest";
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "DELETE",
            CURLOPT_HTTPHEADER =>  $headers,
       ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
            echo "cURL Error #:" . $err;
            print_r(json_decode($err, true));
        } else {
            echo $response;
            
            print_r(json_decode($response, true));
        }	
    }
    
    function test2($listing_id = "656149804997378314", $category_id = 6) {
        echo "<pre>";
        
        $data_result = $this->dc_airbnb_rest->update_airbnb($listing_id, $category_id);
        
        
        print_r($data_result);
    }
    function test3($listing_id = "658462566963815160", $category_id = 3) {
        echo "<pre>";
        $price_settings = $this->dc_airbnb_rest->set_price_settings($listing_id,$category_id);
        $res = $this->dc_airbnb_rest->update_price_settings($listing_id,$price_settings);
        
        print_r($res);;
    }
}
