var user_currency = $('.frame-2 .droopdown').data('value');
var result_div = '.booking_result_div';
var result_bottom_div = '.booking_result_div_bottom';

function isInView(element, fullyInView = false)
{
	let pageTop = $(window).scrollTop();
	let pageBottom = pageTop + $(window).height();
	let elementTop = $(element).offset().top;
	let elementBottom = elementTop + $(element).height();
    if (fullyInView === true) {
        return ((pageTop < elementTop) && (pageBottom > elementBottom));
    } else {
        return ((elementTop <= pageBottom) && (elementBottom >= pageTop));
    }
}

$(window).scroll(function(){
	if($(result_div).hasClass('active_visibility') != $(result_bottom_div).hasClass('active_visibility')){
		if (isInView($('div.available-rooms-results-block'))){
			$(result_div).removeClass('d0').addClass('active_visibility');
			$(result_bottom_div).removeClass('active_visibility').hide();
		}else{
			
			$(result_bottom_div).removeClass('d0');//!!! temp solution

			$(result_div).addClass('d0').removeClass('active_visibility');
			$(result_bottom_div).show().addClass('active_visibility');
		}  
	}
})

function showOccDiv(btn, div_id) {
	$(btn).toggleClass('d0');
	$(btn).parents('.room-variant').find('span.room_free_count').toggleClass('d0');
	$('#cancel_occ_btn_' + div_id).toggleClass('d0');
	$('#div_occ_qtty_' + div_id).toggleClass('d0');
	recalculateRoomvariantFreerooms($(btn).parents('.room-variants'));
}

function hideOccDiv(btn, div_id) {
	$(btn).toggleClass('d0');
	$(btn).parents('.room-variant').find('span.room_free_count').toggleClass('d0');
	$('#select_occ_btn_' + div_id).toggleClass('d0');
	$('#div_occ_qtty_' + div_id).toggleClass('d0');
	$('#div_occ_qtty_' + div_id).find('option:first').prop('selected', true);
	let occupancies = $('#div_occ_qtty_' + div_id).find('input[id^=occ_]');
	occupancies.each(function (i, occupancy) {
		let def_checking = false;
		if($(occupancy).hasClass('default_chioce_indicator')){
			def_checking = true;
			$(btn).parents('.room-variant').find('span.room_price').not('.old_price').text($(this).data('occupancy_price'));
		}
		$(this).prop('checked', def_checking);
	});
	recalculateRoomvariantFreerooms($(btn).parents('.room-variants'));
}

function nextStep() {
	let selected_result = {'occupancies' : ''};
	let occupancies = [];
	let divs_set = $('.occ_qtty_divs').not('.d0');
	divs_set.each(function (i, div) {
		let div_set = $(div).find('input:checked, option:selected');
		occupancies.push({'occ': $(div_set[0]).prop('id'), 'qtty' : $(div_set[1]).val(), 'metadata' : $(div_set[0]).data('metadata')});		
	});
	selected_result.occupancies = occupancies;
	
	let next_location = 'propguests';
	PostRedirect(selected_result, next_location);
}

function PostRedirect(data, location) {
	var form = document.createElement("form");
	form.method = "POST";
	form.action = location;
    var element = document.createElement("input");
    element.type = "hidden";
    element.value = JSON.stringify(data);
    element.name = 'result';
    form.appendChild(element);
	document.body.appendChild(form);
	form.submit(); 
}

function recalculateRoomvariantFreerooms(room_variants_div) {
	let booked_qtty = 0;
	let booked_qtty_selectors = $(room_variants_div).find('.occ_qtty_divs').not('.d0').find('option:selected');
	let total_qtty = $(room_variants_div).find('.occ_qtty_divs select').first().find('option').length;
	booked_qtty_selectors.each(function (i, selector) {
		booked_qtty += parseInt($(selector).val());
	});
	let all_rates_qttys_selects = $(room_variants_div).find('.occ_qtty_divs select');
	all_rates_qttys_selects.each(function (i, select) {
		$(select).find('option').each(function (i, option) {
			let booked_qtty_exact_this_select = booked_qtty - parseInt($(option).parent('select').find('option:selected').val());
			if (booked_qtty_exact_this_select + parseInt($(option).val()) > total_qtty){
				$(option).attr('disabled', true);
			}else{
				$(option).attr('disabled', false);
			}
		});
	});
	if (booked_qtty === total_qtty){
		$(room_variants_div).find('[id^=select_occ_btn]').not('.d0').attr('disabled', true).toggleClass('d0');
	}else{
		$(room_variants_div).find('[id^=select_occ_btn]:disabled').attr('disabled', false).toggleClass('d0');
	}
	$(room_variants_div).find('span.free_rooms_lefts_qtty').text(total_qtty - booked_qtty);
	
	updateBookingResult();
}

function updateQttySelector(selector){
	let occupancy_price = strWithCurrencyToFloat($(selector).parents('.occ_qtty_divs').find('input:checked').data('occupancy_price'));
	let occ_qtty = parseInt($(selector).val());
	let sum = parseFloat(occupancy_price * occ_qtty).toFixed(2);
	$(selector).parents('.room-variant').find('.room_price').not('.old_price').text(formatingFloatToStrWithCurrency(sum));
	
	let occupancy_old_price = strWithCurrencyToFloat($(selector).parents('.occ_qtty_divs').find('input:checked').data('occupancy_beforepromo_price'));
	let sum_old_price = parseFloat(occupancy_old_price * occ_qtty).toFixed(2);
	$(selector).parents('.room-variant').find('.room_price.old_price .line').text(formatingFloatToStrWithCurrency(sum_old_price));
	
	recalculateRoomvariantFreerooms($(selector).parents('.room-variants'));
}

function updateOccupSelector(selector){
	let occupancy_price = strWithCurrencyToFloat($(selector).data('occupancy_price'));
	let occ_qtty = parseInt($(selector).parents('.occ_qtty_divs').find('select option:selected').val());
	let sum = parseFloat(occupancy_price * occ_qtty).toFixed(2);
	$(selector).parents('.room-variant').find('.room_price').not('.old_price').text(formatingFloatToStrWithCurrency(sum));
	
	let occupancy_old_price = strWithCurrencyToFloat($(selector).data('occupancy_beforepromo_price'));
	let sum_old_price = parseFloat(occupancy_old_price * occ_qtty).toFixed(2);
	$(selector).parents('.room-variant').find('.room_price.old_price .line').text(formatingFloatToStrWithCurrency(sum_old_price));
	
	recalculateRoomvariantFreerooms($(selector).parents('.room-variants'));
}

function getBookingResultDiv_tmplt(){//for future
	return new Promise (
			(resolve, reject) => {
				fetch('ajax_get_booking_result_div_tmplt')
				.then(resp => resp.text())
				.then((fetched_result_div_tmplt) => {
					resolve(fetched_result_div_tmplt);
				})
			}
	)
}

function updateBookingResult(){
	
	fetch('ajax_get_booking_result_div_tmplt')
	.then(resp => resp.text())
	.then((fetched_result_tmplt) => {
		
		$(result_div).html(fetched_result_tmplt);
		
		let rooms_tmplt = $(result_div).find('ul');
		let room_tmplt = $(result_div).find('li:first');
		
		$(rooms_tmplt).empty();
		
		let result_set = $('.occ_qtty_divs').not('.d0');
		if(result_set.length){
			$(result_div).removeClass('d0').addClass('active_visibility');
			result_set.each(function (i, room_variant) {
				let room_id = room_variant.dataset.cat_id;
				let room_variant_name = $(room_variant).parents('.available-rooms-result').find('.room_title:first').text();
				let room_variant_qtty = $(room_variant).find('option:selected').val();
				let room_variant_price = strWithCurrencyToFloat($(room_variant).parents('.room-variant').find('.room_price').not('.old_price').text());
				$(room_tmplt).attr('id', room_id);
				if($(rooms_tmplt).find('li#' + room_id).length){
					let exist_qtty_span = $('li#' + room_id +' span.room_variant_qtty');
					$(exist_qtty_span).text(parseInt($(exist_qtty_span).text()) + parseInt(room_variant_qtty));
					
					let room_variant_prices = 0;
					let choosed_sub_results = $(room_variant).parents('.available-rooms-result').find('.occ_qtty_divs').not('.d0');
					choosed_sub_results.each(function (i, sub_result) {
						room_variant_prices += parseFloat(strWithCurrencyToFloat($(sub_result).parents('.room-variant').find('.room_price').not('.old_price').text()));
					});
					$('li#' + room_id +' span.room_variant_price').text(room_variant_prices);
				}else{
					$(room_tmplt).find('span.room_variant_qtty').text(room_variant_qtty);
					$(room_tmplt).find('span.room_variant_name').text(room_variant_name);
					$(room_tmplt).find('span.room_variant_price').text(room_variant_price);
					$(rooms_tmplt).append($(room_tmplt).clone());
				}
			});
			let total_qtty = 0;
			let total_sum = 0;
			$(rooms_tmplt).find('li').each(function (i, room_variant) {
				total_qtty += parseInt($(room_variant).find('span.room_variant_qtty').text());
				total_sum += parseFloat(strWithCurrencyToFloat($(room_variant).find('span.room_variant_price').text()));
				
				$(room_variant).find('span.room_variant_name').bind('click', function() {
					let room_id = $(this).parents('li').attr('id');	
					console.log($(result_div).height(), '  --  ', $('.available-rooms-result[data-id=' + room_id + '] .room-variant').offset().top);
			        let destination = $('.available-rooms-result[data-id=' + room_id + '] .room-variant').offset().top + $(result_div).height();
		            $('html').animate({ scrollTop: destination }, 1100, "swing");
			        return false;
				});
			});
			$('.room_variants_total .total_currency').text(user_currency);
			$('.room_variants_total .total_qtty').text(total_qtty);
			$('.room_variants_total .total_sum').text(add_000_Separator(parseFloat(total_sum).toFixed(2)));//data-occupancy_price
			let word_ending = getWordRoomEnding(total_qtty);
			$('.room_variants_total').find('span.word_ending_'+word_ending).removeClass('d0');
			
			let bottom_resume = $('.booking_result_div_bottom span.total_bottom_resume');
			$(bottom_resume).empty();
			let word_variant_ending = $(result_bottom_div).find('.word_endings span.word_ending_' + word_ending).text();
			$(bottom_resume).text(
					total_qtty + ' '
					+ word_variant_ending + ' '
					+ $(result_bottom_div).find('.word_endings span.word_for_clt').text() + ' '
					+ user_currency + ' '
					+ $('.room_variants_total .total_sum').text());
		}else{
			$(result_div).addClass('d0').removeClass('active_visibility');
		}
	})
}

function cancelBookedRoomVariant(btn){
	let room_id = $(btn).parents('li').attr('id');
	$('.room-variant').find('button[id^=cancel_occ_btn_'+room_id+']').not('.d0').each(function (i, close_btn) {
		$(close_btn).click();
	});
}

function formatingFloatToStrWithCurrency(float_num){
	return add_000_Separator(float_num) + ' ' + user_currency
}

function strWithCurrencyToFloat(strWithCurrency){
	return parseFloat(strWithCurrency.replace(/\,/g,'')).toFixed(2);
}

function add_000_Separator(nStr)
{
    nStr += '';
    var x = nStr.split('.');
    var x1 = x[0];
    var x2 = x.length > 1 ? '.' + x[1] : '';
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + ',' + '$2');
    }
    return x1 + x2;
}

function closeBottomResultDiv(){
	$(result_bottom_div).fadeOut();
	/*$(result_div).addClass('d0');
	
	$('.room-variant').find('button[id^=cancel_occ_btn_]').not('.d0').each(function (i, close_btn) {
		$(close_btn).click();
	});
	$(result_bottom_div).addClass('d0');*/
}

function getWordRoomEnding(number) {
    let n = Math.abs(number);
    n %= 100;
    if (n >= 5 && n <= 20) {
      return 3;
    }
    n %= 10;
    if (n === 1) {
      return 1;
    }
    if (n >= 2 && n <= 4) {
      return 2;
    }
    return 3;
  }

function hideAllAmenities(btn){
	$(btn).parents('.frame-155').find('.room-info-btn_open, .sm_amenity').show();
	$(btn).parents('.frame-155').find('.room_info, .room-info-btn_close').hide();
	console.log();
}

function showAllAmenities(btn){
	$(btn).parents('.frame-155').find('.room-info-btn_open, .sm_amenity').hide();
	$(btn).parents('.frame-155').find('.room_info, .room-info-btn_close').show();
	console.log();
}