<?php
$start_settings = [
    'startdate' => date('d.m.Y', strtotime("+1 day")),
    'enddate' => date('d.m.Y', strtotime("+2 day")),
    'parties' => [['adults' => 2, 'children'=>'']]//"8", "10"
];
$session_data = $this->session->userdata('client_dataset');
$rooms_list = [];
if (isset($session_data['client_data'])){
    $client_dataset = $session_data['client_data'];

    if (isset($client_dataset['rooms'])){
        $parties = [];
        $start_settings['parties'] = [];
        $separator = ',';
        foreach ($client_dataset['rooms'] as $room) {
                array_push($parties, [
                    'adults' => $room['adult'],
                    'children' => (isset($room['children'])) ? $room['children'] : []
                ]);
                array_push($start_settings['parties'], [
                    'adults' => $room['adult'],
                    'children' => (isset($room['children'])) ? implode(",", $room['children']) : '',
                    'separator' => $separator
                ]);
        }
        $start_settings['parties'][count($start_settings['parties'])-1]['separator'] = '';
        if (isset($client_dataset['selectedDate'])){
            $startdate = date("Y-m-d", substr($client_dataset['selectedDate']['in']['timestamp'], 0, -3));
            $start_settings['startdate'] = date('d.m.Y', substr($client_dataset['selectedDate']['in']['timestamp'], 0, -3));
            $enddate = date("Y-m-d", substr($client_dataset['selectedDate']['out']['timestamp'], 0, -3));
            $start_settings['enddate'] = date('d.m.Y', substr($client_dataset['selectedDate']['out']['timestamp'], 0, -3));
            $incoming_data = [
                'date_range' => $startdate." - ".$enddate,
                'startdate' => $startdate,
                'enddate' => $enddate,
                'parties' => $parties
            ];
            $freerooms_resp = $this->content->get_curl_freerooms($incoming_data);
            if (isset($freerooms_resp['response']['hms_free_rooms'])){
                $freerooms_resp = $freerooms_resp['response'];
                $freerooms_resp['hotel_id'] = 92;
                $freerooms_resp['lang_code'] = 45;
                $rooms_list = $this->content->get_rooms_data($freerooms_resp);
            }
        }
    }
}
$data = [];
$data['rooms_list'] = $rooms_list;
$data['start_settings'] = [$start_settings];
$this->parser->parse ( 'templates/booking_view.html', $data );