<?php
$start_settings = [
    'startdate' => date('d.m.Y', strtotime("+1 day")),
    'enddate' => date('d.m.Y', strtotime("+2 day")),
    'promocode' => '',
    'parties' => [['adults' => 2, 'children'=>'']]//"8", "10"
];
$session_booking_data = $this->session->userdata('booking_data');
$parties = $session_booking_data['parties'] ?? [];
$rooms_list = [];
$filters = [];
$nofreerooms_pars_data = [];
$freerooms_hide_titile_class = 'd0';
if (isset($session_booking_data['parties']) && isset($session_booking_data['date_in']) && isset($session_booking_data['date_out'])){
    $start_settings['parties'] = $parties;
    foreach ($start_settings['parties'] as &$party) {
        $party['children'] = implode(",", $party['children']);
    }
    $startdate = $session_booking_data['date_in'];
    $start_settings['startdate'] = date('d.m.Y', strtotime($startdate));
    $enddate = $session_booking_data['date_out'];
    $start_settings['enddate'] = date('d.m.Y', strtotime($enddate));
    $promocode = $start_settings['promocode'] = $session_booking_data['promo']['code'] ?? '';
    $incoming_data = [
        'date_range' => $startdate." - ".$enddate,
        'startdate' => $startdate,
        'enddate' => $enddate,
        'parties' => $parties,
        'promocode' => $promocode,
    ];
    /* if (isset($session_booking_data['checked_prop_id'])) {
        $incoming_data['checked_prop_id'] = $session_booking_data['checked_prop_id'];
    } */
    $freerooms_resp = $this->content->get_curl_freerooms($incoming_data);

    if($this->debug_mode){
        echo "<pre>";
        print_r($freerooms_resp);
        die("DIED by A Department at rooms_view.php function_container() on 8 сент. 2021 г. 16:22:19");
    }
    if (isset($freerooms_resp['response']['hms_free_rooms'])){
        $freerooms_hide_titile_class = '';
        $freerooms_resp['response']['lang_code'] = $this->mlanguages->interface_lang->code;
        $rooms_data = $this->content->get_rooms_data($freerooms_resp['response']);
        $rooms_list = $rooms_data['rooms_list'];
        $filters = [$rooms_data['filters']];
    }
    if (isset($freerooms_resp['response']['hms_nofree_variants'])){
        $nofreerooms_pars_data = $this->content->get_nofree_variants_v2([
            'hms_nofree_variants' => $freerooms_resp['response']['hms_nofree_variants'],
            'di' => $startdate,
            'do' => $enddate,
            'parties' => $parties
        ]);
        $this->session->set_userdata(['hms_nofree_variants'=>$freerooms_resp['response']['hms_nofree_variants']]);
    }
}

$data = [
    'header' => $this->content->get_Header(),
    'footer' => $this->content->get_Footer(),
    'page_title' => $this->content->get_page_title_pars_data(),
    'nofreerooms_block' => $this->htmltpl->get_nofreerooms_block($nofreerooms_pars_data),
    'calendar_block' => $this->htmltpl->get_calendar_block(),
    'filters' => $filters,
    'rooms_list' => $rooms_list,
    'reviews_list' => $this->content->get_reviews(),
    'reviews_list_hot' => $this->content->get_reviews("block_1"),
    'start_settings' => [$start_settings],
    'ppls_icons' => $this->content->get_parties_icons_pars_arr($parties),
    'freerooms_hide_titile_class' => $freerooms_hide_titile_class,
    'faqs' => $this->content->get_faqs_pars_arr(),
    'middletext' => $this->personal->middletext ? $this->personal->middletext : '',
    'promotions' => $this->pay_processor->get_promotions(),
];
$this->mlanguages->getdictionary("bookit_c2_step1", "", $data);
$this->mlanguages->getdictionary("tbl_cancellationpolicies", "", $data);
$this->mlanguages->getdictionary("pmv3", "", $data);
$this->mlanguages->getdictionary("bed_types", "", $data);
$this->parser->parse_string($this->parser->parse ( 'templates/booking/rooms_view.html', $data, TRUE ), $data);