<?php
$reservation_info = $reservation_info;
$order_id = $order_id;
$order_is_canceled_hide_class = '';
$order_is_canceled = true;
$order_title_clt = '{clt_confirmed}';
$customer = '';
$rooms = (isset($reservation_info->rooms) ? $reservation_info->rooms : []);
$services = (isset($reservation_info->services) ? $reservation_info->services : []);
$right_block_data = [];
$total_amount = $guests_count = 0;
$is_reservation_canceled_hide_class = '';
if ($rooms){
    foreach ($rooms as $key => &$room) {
        $total_amount += $room->amount;
        $guests_count += $room->room_guests_count;
        $room_descriptions = $this->content->get_room_descriptions(['category_id'=>$room->category_id]);
        $room->name = $room_descriptions['name'];
        $room->number = $key+1;
        $room->guests_clt_var = '{clt_guest_s'.$this->content->get_clt_variant_or_clt_ending(['val'=>$room->room_guests_count, 'clts'=>[], 'return_type' =>1]).'}';
        $room->amount = $this->mcurrency->fullvalue($room->amount);
        $room->reservation_is_canceled_hide_class = '';
        $room->reservation_is_not_canceled_hide_class = 'd0';
        $is_reservation_canceled = $room->cancel;
        $order_is_canceled &= $is_reservation_canceled;
        if ($is_reservation_canceled) {
            $room->reservation_is_canceled_hide_class = 'd0';
            $room->reservation_is_not_canceled_hide_class = '';
        }
    }
    unset($room);

    $right_block_data['guests_count'] = $guests_count;
    $right_block_data['date_in'] = $rooms{0}->date_in;
    $right_block_data['date_out'] = $rooms{0}->date_out;
    $right_block_data['duration'] = round((strtotime($rooms{0}->date_out) - strtotime($rooms{0}->date_in))/86400);
    $right_block_data['rooms_count'] = count($rooms);
    $right_block_data['rooms_clt_var'] = '{clt_room_s'.$this->content->get_clt_variant_or_clt_ending(['val'=>count($rooms), 'clts'=>[], 'return_type' =>1]).'}';
    $right_block_data['nights_clt_var'] = $this->content->get_clt_variant_or_clt_ending(['val'=>$right_block_data['duration'], 'clts'=>['{clt_night_s}', '{clt_night_s_p}', '{clt_night_s_pp}'], 'return_type' =>0]);
    $right_block_data['guests_clt_var'] = '{clt_guest_s'.$this->content->get_clt_variant_or_clt_ending(['val'=>$guests_count, 'clts'=>[], 'return_type' =>1]).'}';

    $customer = new stdClass();
    $customer->lastname = $rooms{0}->lastname;
    $customer->firstname = $rooms{0}->firstname;
    $customer->email = $rooms{0}->email;
    $customer->phone = $rooms{0}->phone;

    foreach ($services as $key => &$service) {
        $total_amount += $service->amount;
        $service->number = $key+1;
    }
    unset($service);
}
if ($order_is_canceled) {
    $order_is_canceled_hide_class = 'd0';
    $order_title_clt = '{mlw_cancel}';
}
$data = array();
$data['header'] = $this->content->get_Header();
$data['footer'] = $this->content->get_Footer();
$data['order_title_clt'] = $order_title_clt;
$data['order_is_canceled_hide_class'] = $order_is_canceled_hide_class;
$data['customer'] = [$customer];
$data['order_id'] = $order_id;
$data['rooms'] = $rooms;
$data['services'] = $services;
$data['total_amount'] = $this->mcurrency->fullvalue($total_amount);
$data['created_time'] = $rooms{0}->date_increated_time ?? '';
$data['right_block'] = [$right_block_data];
$data['page_title'] = $this->content->get_page_title_pars_data();
$data['middletext'] = $this->personal->middletext;
$this->mlanguages->getdictionary("bookit_c2_step1", "", $data);
$this->mlanguages->getdictionary("bookit_c2_step5", "", $data);
$this->mlanguages->getdictionary("pmv3", "", $data);
$this->mlanguages->getdictionary("words_endings", "", $data);
$this->parser->parse_string($this->parser->parse ( 'templates/booking/reservation_info_view.html', $data, TRUE ), $data);