<?php
$booking_data = $this->session->userdata('booking_data');
$parties = $booking_data['parties'];
$parsing_arr = array();
$room_number = 0;
foreach ($parties as $room_num => $party) {
    $room_number ++;
    $room_guests = array();
    $room_guests['adults'] = array_fill(1, $party['adults'], array());
    foreach ($room_guests['adults'] as  $adult_num => &$adult) {
        $adult['adult_number'] = $adult_num;
        $adult['room_number'] = $room_number;
        $adult['hidden'] = ($adult_num == 1)? '': "hidden";
        $adult['hiddened'] = ($adult_num == 1)? '': "hiddened";
    }
    $room_guests['children'] = array();
    $count_children = isset($party['children'])? count($party['children']) : 0;
    if ($count_children){
        foreach ($party['children'] as $child_num => $child_age) {
            $room_guests['children'][$child_num + 1] = array(
                'child_num' => $child_num,
                'age' => $child_age,
                'room_number' => $room_number,
                'hidden' => "hidden",
                'hiddened' => "hiddened",
            );
        }
    }
    $room_descriptions = $this->content->get_room_descriptions(['category_id' => $party['selected_category']]);
    $room_descriptions['ppls_icons'] = $this->content->get_parties_icons_pars_arr([$party]);
    $room_descriptions['rate_descriptions'] = [$this->content->get_rate_descriptions(['rate_id' => $party['selected_rate']])];
    array_push($parsing_arr, array(
        'room_number' => $room_number,
        'room_descriptions' => [$room_descriptions],
        'adults' => $room_guests['adults'],
        'children' => $room_guests['children'],
        'room_details' => $this->content->get_room_details(['category_id' => $party['selected_category']])
    ));
}
$checkin_time = isset($parsing_arr[0]['room_details']->checkin_time) ? $parsing_arr[0]['room_details']->checkin_time : $this->personal->checkouttime;
$checkout_time = isset($parsing_arr[0]['room_details']->checkout_time) ? $parsing_arr[0]['room_details']->checkout_time : $this->personal->checkouttime;
$right_block_services = [];
$rooms_amount = $booking_data['rooms_amount'];
$services_amount = 0;
$services = $booking_data['services'] ?? false;
if ($services){
    $services_amount = $services['amount'];
    $right_block_services = [
        [
            'services_amount' => $this->mcurrency->fullvalue($services_amount),
            'services_qty' => count($services['list']),
            'services_clt_var' => '{clt_service_s'.$this->content->get_clt_variant_or_clt_ending(['val'=>count($services['list']), 'clts'=>[], 'return_type' =>1]).'}',
        ]
    ];
}
$discount_block = [];
$promo_amount = 0;
if ($booking_data['promo']['promoted']) {
    $promo_data = $booking_data['promo']['promo_data'];
    switch ($promo_data['type_txt']) {
        case 'percent'://id = 1
            $promo_value = $promo_data['value']." %";
            $promo_amount = $rooms_amount * ($promo_data['value'] / 100);
            break;
        case 'fixed'://id = 2
            $promo_value = $this->mcurrency->fullvalue($promo_data['value']);
            $promo_amount = $promo_data['value'];
            break;
    }
    $discount_block = [
        [
            'amount' => "- ". $this->mcurrency->fullvalue($promo_amount),
            'value' => $promo_value,
        ]
    ];
}
$right_block_pars_arr = [
    'date_in' => $booking_data['date_in'],
    'date_out' => $booking_data['date_out'],
    'peoples' => $booking_data['peoples'],
    'duration' => $booking_data['duration'],
    'rooms_count' => count($parties),
    'rooms_amount' => $this->mcurrency->fullvalue($rooms_amount),
    'discount_block' => $discount_block,
    'services' => $right_block_services,
    'full_amount' => $this->mcurrency->fullvalue($rooms_amount + $services_amount - $promo_amount),

    'guests_clt_var' => '{clt_guest_s'.$this->content->get_clt_variant_or_clt_ending(['val'=>$booking_data['peoples'], 'clts'=>[], 'return_type' =>1]).'}',
    'rooms_clt_var' => '{clt_variant_s'.$this->content->get_clt_variant_or_clt_ending(['val'=>count($parties), 'clts'=>[], 'return_type' =>1]).'}',
    'nights_clt_var' => $this->content->get_clt_variant_or_clt_ending(['val'=>$booking_data['duration'], 'clts'=>['{clt_night_s}', '{clt_night_s_p}', '{clt_night_s_pp}'], 'return_type' =>0]),

];
//if processor is mandarine routine START =============================
$mandarin_cashback_html = '';
if ($this->pay_processor->get_mandarin_cashback_pay_state()) {
    $return_url = $this->personal->mandarin_return_url;
    $mandarin_cashback_html = $this->parser->parse ( 'templates/payment/mandarin_cashback_html_block.html', $data=['encoded_redirect_url' => urlencode("https://$return_url/booking/guests")], TRUE );
}
//if processor is mandarine routine FINAL =============================
$data = [
    'header' => $this->content->get_Header(),
    'footer' => $this->content->get_Footer(),
    'page_title' => $this->content->get_page_title_pars_data(),
    'parsing_arr' => $parsing_arr,
    'right_block' => [$right_block_pars_arr],
    'customer' => [$this->session->userdata('customer') ?? ['firstname'=>'', 'lastname'=>'', 'phone'=>'', 'email'=>'',]],
    'checkin_time' => $checkin_time,
    'checkout_time' => $checkout_time,
    'middletext' => $this->personal->middletext,
    'mandarin_cashback_html' => $mandarin_cashback_html,
    'home_page_url' => $this->home_page_url,
];
$this->mlanguages->getdictionary("bookit_c2_step1", "", $data);
$this->mlanguages->getdictionary("tbl_cancellationpolicies", "", $data);
$this->mlanguages->getdictionary("pmv3", "", $data);
$this->mlanguages->getdictionary("words_endings", "", $data);
$this->parser->parse_string($this->parser->parse ( 'templates/booking/guests_view.html', $data, TRUE ), $data);
?>