<?php
$confirmation_data = $this->session->userdata('confirmation_data');
$request_data = $confirmation_data['request_data'];
$customer = $this->session->userdata('customer');
$rooms = $right_block_data = [];
$right_block_data['guests_count'] = 0;
$right_block_data['date_in'] = $request_data['booking_data']['date_in'];
$right_block_data['date_out'] = $request_data['booking_data']['date_out'];
$right_block_data['duration'] = round((strtotime($right_block_data['date_out']) - strtotime($right_block_data['date_in']))/86400);
$right_block_data['rooms_count'] = count($confirmation_data['hms_resevation_ids']);
$right_block_data['rooms_clt_var'] = '{clt_room_s'.$this->content->get_clt_variant_or_clt_ending(['val'=>count($confirmation_data['hms_resevation_ids']), 'clts'=>[], 'return_type' =>1]).'}';
$right_block_data['nights_clt_var'] = $this->content->get_clt_variant_or_clt_ending(['val'=>count($confirmation_data['hms_resevation_ids']), 'clts'=>['{clt_night_s}', '{clt_night_s_p}', '{clt_night_s_pp}'], 'return_type' =>0]);
foreach ($confirmation_data['guests'] as $room_num => $room_guests) {
    $room_adults_count = count($room_guests['adults']);
    $room_children_count = isset($room_guests['children']) ? count($room_guests['children']) : 0;
    $room_descriptions = $this->content->get_room_descriptions(['category_id'=>$request_data['booking_data']['parties'][$room_num-1]['selected_category']]);
    array_push($rooms, [
        'number' => $room_num,
        'name' => $room_descriptions['name'],
        'adults_count' => $room_adults_count,
        'children_count' => $room_children_count,
        'amount' => $this->mcurrency->fullvalue($confirmation_data['hms_resevation_ids'][$room_num-1]['amount']),
        'hms_res_id' => $confirmation_data['hms_resevation_ids'][$room_num-1]['hms_res_id']
    ]);
    $right_block_data['guests_count'] += $room_adults_count + $room_children_count;
}
$right_block_data['guests_clt_var'] = '{clt_guest_s'.$this->content->get_clt_variant_or_clt_ending(['val'=>$right_block_data['guests_count'], 'clts'=>[], 'return_type' =>1]).'}';
$all_services = $this->content->get_services_data();
$services = $request_data['booking_data']['services']['list'] ?? [];
if (count($services)){
    $counter = 1;
    foreach ($services as $id => &$service) {
        $service ['number'] = $counter; $counter++;
        $service ['service_price'] = $this->mcurrency->fullvalue($service ['service_price']);
        $service ['name'] = $all_services[$id]['service_name'];

        //'services_clt_var' => '{clt_service_s'.$this->content->get_clt_variant_or_clt_ending(['val'=>count($services['list']), 'clts'=>[], 'return_type' =>1]).'}',
    }
}
$payment_required = $confirmation_data['request_data']['booking_data']['payment_required']['ccforce'] ?? 0;
if($payment_required == 1){
    $customer['payment_required_txt'] = "{clt_payment_required}";
}else{
    $customer['payment_required_txt'] = "{clt_pay_upon_arrival}";
}
$data = array();
$data['header'] = $this->content->get_Header();
$data['footer'] = $this->content->get_Footer();
$data['customer'] = [$customer];
$data['order_id'] = $confirmation_data['hms_resevation_ids'][0]['dc_reservation_id'];
$data['rooms'] = $rooms;
$data['services'] = $services;
$data['total_amount'] = $this->mcurrency->fullvalue($confirmation_data['total_amount']);
$data['created_time'] = $confirmation_data['created_time'];
$data['right_block'] = [$right_block_data];
$data['page_title'] = $this->content->get_page_title_pars_data();
$data['middletext'] = $this->personal->middletext;
$this->mlanguages->getdictionary("bookit_c2_step1", "", $data);
$this->mlanguages->getdictionary("pmv3", "", $data);
$this->mlanguages->getdictionary("words_endings", "", $data);
$this->parser->parse_string($this->parser->parse ( 'templates/booking/confirmation_view.html', $data, TRUE ), $data);