<?php
class Reservation extends CI_Model {

    public $orders_tbl;
	function __construct() {
		parent::__construct ();
		$this->orders_tbl = 'booking_otelms.orders_pmv3';
	}

	function get_new_dc_reservation_id() {
	    $this->db->query('LOCK TABLE inc_dc_reservation_id WRITE');
	    $row = $this->db->select('value')->get_where("inc_dc_reservation_id", array('id'=>1))->row();
	    if ($row) {
	        $value = $row->value+1;
	    }
	    $this->db->update('inc_dc_reservation_id', ['value'=>$value], ['id', 1]);
	    $this->db->query('UNLOCK TABLES');

	    // sync vertex_id (pmv2) to dc_res_id
	    $this->db->insert('orders_vertex', ['hms_id' => $this->personal->hotel_id, 'id'=>$value]);

	    return $value;
	}
	function get_new_roomreservation_id() {
	    $this->db->query('LOCK TABLE inc_dc_roomreservation_id WRITE');
	    $row = $this->db->select('value')->
	    get_where("inc_dc_roomreservation_id", array('id'=>1))->row();
	    if ($row) {
	        $value = $row->value+1;
	    }
	    $this->db->where('id', 1);
	    $this->db->update('inc_dc_roomreservation_id', array('value'=>$value));
	    $this->db->query('UNLOCK TABLES');
	    return $value;
	}

	function save_order_record($insert_arr = []) {
	    $tbl = $this->orders_tbl;
	    $this->db->insert($tbl, $insert_arr);
	}

	function update_order_record($update_arr) {
	    $tbl = $this->orders_tbl;
        $this->db->update($tbl, [
            'hms_res_id' => $update_arr['hms_res_id']
        ], [
            'dc_reservation_id' => $update_arr['dc_reservation_id'],
            'dc_roomreservation_id' => $update_arr['dc_roomreservation_id']
        ]);
	}

	function create_reservation($dc_reservation_id = null) {
	    $completed_steps = $this->session->userdata('completed_steps') ?? [];
	    $completed_booking_data = $completed_steps['booking_data'] ?? false;
	    $completed_customer = $completed_steps['customer'] ?? false;
	    $dc_reservation_id = $dc_reservation_id ?? false;
	    if ($completed_booking_data && $completed_customer && $dc_reservation_id){
    	    $booking_data = $this->session->userdata('booking_data');
    	    $order_insert_arr = [
    	        'hms_id' => $this->personal->hotel_id,
    	        'dc_reservation_id' => $dc_reservation_id
    	    ];
    	    foreach ($booking_data['parties'] as &$party) {
    	        $party['dc_reservationid'] = $dc_reservation_id;
    	        $party['dc_roomreservation_id'] = $order_insert_arr['dc_roomreservation_id'] = $this->reservation->get_new_roomreservation_id();
    	        $this->reservation->save_order_record($order_insert_arr);
    	    }
    	    unset($party);
    	    $customer = $this->session->userdata('customer');
    	    $guests = $this->session->userdata('guests');
    	    $data_curl = array(
    	        'booking_data' => $booking_data,
    	        'customer' => $customer,
    	        'guests' => $guests,
    	    );
    	    $data_curl = json_encode ($data_curl);
//     	    echo $data_curl;
//     	    die();
    	    $host = $this->personal->hms_host;
    	    $url = "https://$host/gateway_pmv3/booking_request/";
    	    
    	    $operation_exec_start_time = microtime(true);
    	    $response = $this->curl_model->CurlPlugRaw ( $data_curl, $url );
    	    $operation_exec_end_time = microtime(true);
    	    
    	    $log_data = array();
    	    $log_data['hms_id'] = $this->personal->hotel_id;
    	    $log_data['pm_version'] = 3;
    	    $log_data['request'] = $data_curl;
    	    $log_data['response'] = $response;
    	    $log_data['payneedity'] = isset($booking_data['payment_required']['ccforce']) ? $booking_data['payment_required']['ccforce'] : 0;
    	    if ($log_data['payneedity']) {
    	        $log_data['cc_proc'] = $this->personal->cc_processor;
    	    }
    	    $log_data['dc_reservation_id'] = $dc_reservation_id;
    	    $log_data['exec_time'] = $operation_exec_end_time - $operation_exec_start_time;

    	    $this->db->insert('log_hms_response', $log_data);

    	    $result = json_decode ( $response, true );

    	    $res = ['response'=>$response, 'dc_reservation_id' => $dc_reservation_id];
    	    if (isset($result['rezult']) && $result['rezult'] == "ok") {
    	        if (isset($result['hms_resevation_ids'])){
    	            foreach ($result['hms_resevation_ids'] as $res_ids) {
    	                $this->reservation->update_order_record($res_ids);
    	            }
    	        }
    	        $this->session->set_userdata(['confirmation_data'=>$result]);
    	        $_SESSION['confirmation_data'] = $result;
    	        $res['result'] = "ok";
    	    } else {
    	        $res['result'] = "fail hms booking.";
    	    }
    	    $this->session->unset_userdata(['completed_steps', 'booking_data']);
	    }else{
	        $res['result'] = "fail module data compliting.";
	    }
	    return $res;
	}

	public function get_ids_by_hms_res_id($param) {
	    $dc_reservation_id_query = $this->db->select('dc_reservation_id')->get_where($this->orders_tbl, ['hms_res_id'=>$param['hms_res_id'], 'hms_id'=>$this->personal->hotel_id])->row();
	    if($dc_reservation_id_query){
	        $result = $this->db->get_where($this->orders_tbl, ['dc_reservation_id'=>$dc_reservation_id_query->dc_reservation_id])->result();
	    }else{
            $result = [
                (object) [
                    'hms_res_id' => $param['hms_res_id'],
                    'dc_reservation_id' => $param['hms_res_id']
                ]
            ];
	    }

	    return $result;
	}
	
	public function get_hms_res_ids_by_dc_order_id($dc_order_id) {
	    $dc_reservations_ids = $this->db->select('hms_res_id')->get_where($this->orders_tbl, ['dc_reservation_id'=> $dc_order_id])->result();
	    
	    return $dc_reservations_ids;
	}

	public function get_reservation_info($param) {
	    $reservation_ids = $this->reservation->get_ids_by_hms_res_id(['hms_res_id'=>$param['hms_res_id']]);
	    $data_curl = json_encode ($reservation_ids);
	    $host = $this->personal->hms_host;
	    $url = "https://$host/gateway_pmv3/reservation_info/";
	    $response = json_decode($this->curl_model->CurlPlugRaw ( $data_curl, $url ));
	    $response->order_id = $reservation_ids{0}->dc_reservation_id;
	    return $response;
	}

	public function cancel_reservation($hms_reservation_id) {
	    $data_curl = array(
	        'res_id' => $hms_reservation_id,
	        'status' => 5,
	        'guestbe_request' => 1,
	        'dcname' => 'PMV3',
	        'description' => ''
	    );
	    $data_curl = json_encode ($data_curl);
	    $response = $this->curl_model->CurlPlugRaw ( $data_curl, "https://{$this->personal->hms_host}/gateway_pmv3/canceling_request/" );

	    return $response;
	}
	
	public function cancel_order($dc_order_id) {
	    $hms_res_ids = $this->get_hms_res_ids_by_dc_order_id($dc_order_id);
	    
	    $hms_reservation_id_for_pagemaking = $hms_res_ids[0]->hms_res_id;
	    
	    foreach ($hms_res_ids as $hms_res_id) {
	        $this->cancel_reservation($hms_res_id->hms_res_id);
	    }
	    return $hms_reservation_id_for_pagemaking;
	}
}
