<?php
class Personal extends CI_Model {
    const HOTELS_DATA_TABLE = 'booking_otelms.hotels_personal_v2';
    const HOST_FILD = 'pmv3_host';
    const ALTERNATIVE_HOST_FILD = 'host_v2_custom';
    const HMS_SYSTEM_ID_FILD = 'hotel_id';

    public $hotel_id;
    public $timezone;
    public $host;
    public $hms_host;
    public $pmv3_host;
    public $currencyID;
    public $country_code;
    public $language_code;
    public $checkintime;
    public $checkouttime;
    public $cc_processor;
    public $is_acquiring_available;
    public $cc_test_mode;
    public $publickey;
    public $liqpay_privat_key;
    public $middletext;
    public $paypal_merchant_seller_id;
    public $prlwy24_client_id;
    public $prlwy24_client_secret;
    public $prlwy24_crc;
    public $home_page_type;
    public $custom_css;
    public $use_custom_css;
    public $url_to_website;
    public $map_access;
    
	function __construct() {
	    parent::__construct ();
		$this->mount_personal_data();
	}

	public function mount_personal_data() {
	    $get = $this->input->get();
	    
	    if (isset($get['cmd']) && $get['cmd'] === 'clear_session') {
	        session_destroy();
	        die('Session destroyed!');
	    }
	    
	    if (isset($get['hms_system_id'])) {
	        $hms_system_id = (integer) $get['hms_system_id']; // add integer check
	    }else{
	        $hms_system_id = $this->session->userdata('hms_system_id');
	    }

	    $hotel_defined = false;
	    $filds_to_select = implode(", ", array_keys(get_object_vars($this)));
	    $tbl = self::HOTELS_DATA_TABLE;
	    
	    if ($hms_system_id) {
	        $where_fild = self::HMS_SYSTEM_ID_FILD;
	        $like_fild = $hms_system_id;
	        $query_row = $this->db->query ( "SELECT $filds_to_select FROM $tbl WHERE $where_fild LIKE $like_fild" )->row();
	        if ($query_row) {
	            $hotel_defined = true;
	            $this->session->set_userdata(['hms_system_id' => $hms_system_id]);
	        }/* else{
	            $this->session->unset_userdata('hms_system_id');
	        } */
	    }
	    
	    if (!$hotel_defined){
	        $where_fild = self::HOST_FILD;
	        $where_alternative_fild = self::ALTERNATIVE_HOST_FILD;
	        $host = $_SERVER ["HTTP_HOST"];
	        $like_fild = "'$host'";
            $query_row = $this->db->query("SELECT $filds_to_select FROM $tbl 
                                            WHERE ($where_fild LIKE $like_fild) OR ($where_alternative_fild LIKE $like_fild)")->row();
	        if ($query_row) {
	            $hotel_defined = true;
	        }
	    }
	    
	    if ($hotel_defined) {
	        foreach ($query_row as $fild_name => $fild_val) {
	            $this->$fild_name = $fild_val;
	        }
	    }else {
	        $redirect_url = '../welcome';
	        die ( "<meta http-equiv='refresh' content='0;url=$redirect_url'>" );
	    }

	    $this->mandarin_return_url = $this->pmv3_host;
	    if ($_SERVER['REMOTE_ADDR'] == "109.70.24.230") {
	        $this->mandarin_return_url = str_replace("otelms.com", "agast.ru", $this->return_url );
	    }
	}
}
/*  stdClass Object
(
    [id] => 1389
    [hotel_id] => 92
    [booking_id] => 0
    [user] =>
    [init_password] =>
    [password] =>
    [timezone] => Europe/Kiev
    [onlypersonalpage] => 0
    [is_active] => 0
    [feedback_view] => 0
    [guestbe_discount] => 0
    [logo_web_url] =>
    [creditcard_data] => 0
    [cc_processor] => 2
    [cc_test_mode] => 1
    [cc_stripe_ca_id] => 0
    [cc_stripe_ca_region_id] => 1
    [host] => book-dev-ul2.otelms.com
    [hms_host] => dev-ul2.otelms.com
    [pmv3_host] => pmv3-booking-dev2.otelms.com
    [root_host] => 0
    [ip_key] =>
    [avoidtime] => 0
    [stripe_secret] =>
    [stripe_publishable] =>
    [stripe_standart_secret] =>
    [stripe_standart_published] =>
    [stripe_standart_connected] => acct_1Bj5EIHScC4K9wht
    [upc_allowordertype] => 0
    [upc_daily_prepayment] => 0
    [uniteller_test_mode] => 1
    [uniteller_allowordertype] => 0
    [uniteller_daily_prepayment] => 0
    [uniteller_payment_type] => 0
    [ligpay_test_mode] => 1
    [liqpay_privat_key] => ElvlYDqHToLIboCdjxx9Uk6LCYHKcHOt0KRuMeTu
    [liqpay_daily_prepayment] => 0
    [publickey] => i89691670268
    [fast_allowordertype] => 0
    [allowordertype3] => 0
    [server_certificate] =>
    [upc_signature] =>
    [upc_merchantid] =>
    [upc_terminalid] =>
    [upc_host] =>
    [rating] => 0
    [currencyID] => 980
    [country_code] => RUS
    [language_code] => 570
    [checkintime] => 15:00
    [checkouttime] => 12:00
    [middletext] =>


)*/
?>