<?php
class Pay_processor extends CI_Model {
    function __construct() {
        parent::__construct ();
    }
    
    public function calculate_ccforce_rooms_amount_single_rate($data) {
        $room_price = 0;
        $ccamount_type = $data['payment_required']['ccamount_type'];
        $ccamount = $data['payment_required']['ccamount'];
        $ccforce = $data['payment_required']['ccforce'];
        $ccamount_daily = $ccamount / $data['duration'] * $data['rooms_amount'];
        
        $room_price = $data['rooms_amount'];
        
        if ($data['promo']['promoted']) {
            $promo_data = $data['promo']['promo_data'];
            switch ($promo_data['type_txt']) {
                case 'percent'://id = 1
                    $room_price = $room_price * (1 - $promo_data['value'] / 100);
                    break;
                case 'fixed'://id = 2
                    $room_price -= $promo_data['value'];
                    break;
            }
            if ($room_price < 0) {
                $room_price = $data['rooms_amount'];
            }
        }
        
        if ($ccforce == 1) {
            $rate_data_amount = array();
            $rate_data_amount["ccamount_type"] = $ccamount_type;
            $rate_data_amount["ccamount"] = $ccamount;
            $rate_data_amount["ccamount_daily"] = $ccamount_daily;
            $rate_data_amount["amount"] = $room_price;
            
            $room_price = $this->get_room_rate_amount($rate_data_amount);
        }
        return $room_price;
    }
    
    function calculate_ccforce_rooms_amount()
    {
        $room_price = 0;

        $booking_data = $this->session->userdata('booking_data');
        
        if (is_array($booking_data) && count($booking_data)) {
            
            if (isset($booking_data['payment_required']['occupancy_way']) && $booking_data['payment_required']['occupancy_way']) {
                foreach ($booking_data['parties'] as $party) {
                    if ($party['payment_required']->ccforce) {
                        $booking_data['payment_required'] = (array)$party['payment_required'];
                        $booking_data['rooms_amount'] = $party['price'];
                        $room_price += $this->calculate_ccforce_rooms_amount_single_rate($booking_data);
                    }
                }
            } else {
                $room_price = $this->calculate_ccforce_rooms_amount_single_rate($booking_data);
            }
        }
        
        return $room_price;
    }

    function get_room_rate_amount($data)
    {
        $amount = $data["amount"];
        switch ($data["ccamount_type"]) {
            case 1:// fixed value
                if ($data["ccamount"] <= $amount) {
                    $amount = $data["ccamount"];
                }
                break;
            case 2:// percent
                $amount = ($amount / 100) * $data["ccamount"];
                break;
            case 3:// days
                $amount = $data["ccamount_daily"];
                break;
        }
        return $amount;
    }

    function get_pp_html() {
        $dc_order_id = $this->reservation->get_new_dc_reservation_id();
        $this->session->set_userdata(array('dc_order_id'=>$dc_order_id));

        $booking_data = $this->session->userdata('booking_data');
        $booking_data['vertex_id'] = $dc_order_id;
        $this->session->set_userdata(['booking_data' => $booking_data]);

        $cc_processor = $this->personal->cc_processor;
        switch($cc_processor){
            case 1://============ LIQPAY ====================
                $liqpay_blocks = $this->htmltpl->get_step4dopay_liqpay_block($dc_order_id);
                $html_daily_prepayment = $liqpay_blocks["liqpay_daily_prepayment"];
                break;
            case 2://============ APPEX ====================
                $appex_blocks = $this->htmltpl->get_step4dopay_appex_block($dc_order_id);
                $html_daily_prepayment = $appex_blocks["appex_daily_prepayment"];
                break;
            case 3://============= STRIPE ==============================
                $stripe_blocks = $this->htmltpl->get_step4dopay_stripe_block($dc_order_id);
                $html_daily_prepayment = $stripe_blocks["stripe_daily_prepayment"];
                break;
            case 4://============ PayPal ====================
                $paypal_blocks = $this->htmltpl->get_step4dopay_paypal_block($dc_order_id);
                $html_daily_prepayment = $paypal_blocks["paypal_daily_prepayment"];
                break;
            case 5://============ Przelewy24 ====================
                $przelewy_blocks = $this->htmltpl->get_step4dopay_przelewy_block($dc_order_id);
                $html_daily_prepayment = $przelewy_blocks["przelewy_daily_prepayment"];
                break;
            case 6://============ Mandarin ====================
                $blocks = $this->htmltpl->get_step4dopay_mandarin_block($dc_order_id);
                $html_daily_prepayment = $blocks["mandarin_daily_prepayment"];
                break;
            case 7://============ Bog ====================
                $blocks = $this->htmltpl->get_step4dopay_bog_block($dc_order_id);
                $html_daily_prepayment = $blocks["bog_daily_prepayment"];
                break;
            case 8://============ Monosbank ====================
                $blocks = $this->htmltpl->get_step4dopay_monobank_block($dc_order_id);
                $html_daily_prepayment = $blocks["monobank_daily_prepayment"];
                break;
            case 9://============= PayPal 2 ==============================
                $paypal_v2_blocks = $this->htmltpl->get_step4dopay_paypal_v2_block($dc_order_id);
                $html_daily_prepayment = $paypal_v2_blocks["paypal_v2_daily_prepayment"];
                break;
            case 10://============ Transbank ====================
                $blocks = $this->htmltpl->get_step4dopay_transbank_block($dc_order_id);
                $html_daily_prepayment = $blocks["transbank_daily_prepayment"];
                break;
            case 0:
                $stripe_blocks = $this->htmltpl->get_step4dopay_stripe_block($dc_order_id);
                $html_daily_prepayment = $stripe_blocks["stripe_daily_prepayment"];
                break;
        }
        return  $html_daily_prepayment;
    }

    public function get_custom_pay_processor_html_form() {
        //$this->session->userdata('reservation_info') //was saved in session at Booking::pay($hms_reservation_id=0, $amount=0, $arg_signature="") : void
        switch($this->personal->cc_processor){
            case 1://LIQPAY
                $html_form = $this->htmltpl->get_liqpay_html_form();
                break;
            case 2://APPEX
                $html_form = $this->htmltpl->get_appex_html_form();
                break;
            case 3://STRIPE
            case 0:
                $html_form = $this->htmltpl->get_stripe_html_form();
                break;
            case 4://============ PayPal ====================
                $html_form = $this->htmltpl->get_paypal_html_form();
                break;
            case 5://============ Przelewy24 ====================
                $html_form = $this->htmltpl->get_przelewy_html_form();
                break;
            case 6://============ Mandarin ====================
                $html_form = $this->htmltpl->get_mandarin_html_form();
                break;
            case 7://============ Bog ====================
                $html_form = $this->htmltpl->get_bog_html_form();
                break;
            case 8://============ Monobank ====================
                $html_form = $this->htmltpl->get_monobank_html_form();
                break;
            case 9://============ PayPal 2 ====================
                $html_form = $this->htmltpl->get_paypal_v2_html_form();
                break;
            case 10://============ Transbank ====================
                $html_form = $this->htmltpl->get_transbank_html_form();
                break;
        }
        return  $html_form;
    }

    public function get_mandarin_cashback_pay_state() {//button on guests
        $state = 0;
        if ($this->get_mandarin_cashback_common_allowing_state() && $this->get_mandarin_promotion_conditions_state()) {
            $state = 1;
        }
        return $state;
    }

    public function get_mandarin_cashback_common_allowing_state() {
        $state = 0;
        if ($this->personal->cc_processor == 6 && $this->personal->country_code == 'RUS' && $this->config->item('mandarin_cashback')) {
            $mandarin = $this->get_mandarin_sync_data();
            if (isset($mandarin->cashback_promotion) && isset($mandarin->account_id_cashback) && $mandarin->cashback_promotion == 1 && $mandarin->account_id_cashback != '') {
                $state = 1;
            }
        }
        return $state;
    }

    private function get_mandarin_promotion_conditions_state() {
        $state = 0;
        $today = date('Y-m-d');
        $promotion_min_amount = 1000;
        $promotion_start = "2022-10-01";
        $promotion_end = "2022-12-25";
        $book_period_start = date('Y-m-d');
        //$book_period_end = date('Y-m-d', strtotime('+ 4 weeks'));
        $book_period_end = "2022-09-10";

        $book_min_days_duration = 3;

        $booking_data = (object)$this->session->userdata('booking_data');
        if (isset($booking_data->date_in) && isset($booking_data->date_out) && isset($booking_data->rooms_amount)) {
            $datein_int = new DateTime($booking_data->date_in);
            $dateout_int = new DateTime($booking_data->date_out);
            $book_days_duration = $dateout_int->diff($datein_int)->d;
            if ($booking_data->rooms_amount >= $promotion_min_amount &&
                $booking_data->date_in >= $promotion_start && $booking_data->date_out <= $promotion_end &&
                $today >= $book_period_start && $today <= $book_period_end &&
                $book_days_duration >= $book_min_days_duration) {
                $state = 1;
            }
        }
        return $state;
    }

    public function get_promotions() {//banner on rooms
        $promotions = '';
        if ($this->get_mandarin_cashback_common_allowing_state()){
            $data = [];
            $promotions = $this->parser->parse("templates/promotions/mandarin_cashback_promotion_banner.html", $data, TRUE);
        }
        return $promotions;
    }

    public function get_mandarin_sync_data() {
        $tbl = 'booking_otelms.hms_config_params';
        $prefix = 'mandarin_';
        $result = [];
        $query_res = $this->db->select('name, value')->like('name', $prefix, 'after')->get_where($tbl, ['hms_id'=>$this->personal->hotel_id])->result();
        foreach ($query_res as $item) {
            $result[str_replace($prefix, '', $item->name)] = $item->value;
        }
        return (object)$result;
    }

    public function get_transbank_sync_data() {
        $tbl = 'booking_otelms.hms_config_params';
        $prefix = 'transbank_';
        $result = [];
        $query_res = $this->db->select('name, value')->like('name', $prefix, 'after')->get_where($tbl, ['hms_id'=>$this->personal->hotel_id])->result();
        foreach ($query_res as $item) {
            $result[str_replace($prefix, '', $item->name)] = $item->value;
        }
        return (object)$result;
    }
    
    public function get_monobank_sync_data() {
        $tbl = 'booking_otelms.hms_config_params';
        $prefix = 'monobank_';
        $result = [];
        $query_res = $this->db->select('name, value')->like('name', $prefix, 'after')->get_where($tbl, ['hms_id'=>$this->personal->hotel_id])->result();
        foreach ($query_res as $item) {
            $result[str_replace($prefix, '', $item->name)] = $item->value;
        }
        return (object)$result;
    }
    
    public function get_bog_sync_data() {
        $tbl = 'booking_otelms.hms_config_params';
        $prefix = 'bog_';
        $result = [];
        $query_res = $this->db->select('name, value')->like('name', $prefix, 'after')->get_where($tbl, ['hms_id'=>$this->personal->hotel_id])->result();
        foreach ($query_res as $item) {
            $result[str_replace($prefix, '', $item->name)] = $item->value;
        }
        return (object)$result;
    }
    
    public function get_paypal_v2_client_id() {
        $tbl = 'booking_otelms.hms_config_params';
        $query_row = $this->db->select('name, value as paypal_client_id')->like('name', 'paypal_client_id')->get_where($tbl, ['hms_id'=>$this->personal->hotel_id])->row();
        $result = $query_row ? $query_row->paypal_client_id : '';
        return $result;
    }
}