<?php
class Mlanguages extends CI_Model {
    public $langs_tbl = 'dic_languages';
    public $interface_lang;
    public $hotel_lang = [
        'code' => 570,
        'ch3' => 'rus',
        'ch2' => 'ru',
        'name_lat' => 'Russian',
        'name_original' => 'Русский'
    ];
    function __construct() {
        parent::__construct();
        $this->mount_personal_language_data();
        $this->mount_interface_language_data();
    }

    public function mount_personal_language_data() {
        $this->hotel_lang = $this->db->select('code, 3char as ch3, 2char as ch2, name_lat, name_original')
        ->get_where($this->langs_tbl, ['hotel_id' => $this->personal->hotel_id, 'code' => $this->personal->language_code])->row();
    }

    public function mount_interface_language_data() {
        if (isset ( $_SESSION ["interface_language"] ) && $_SESSION ["interface_language"] != "") {
            $lang_ch3 = $_SESSION ["interface_language"];
            $this->interface_lang = $this->db->select('code, 3char as ch3, 2char as ch2, name_lat, name_original')
                                                ->get_where($this->langs_tbl, ['hotel_id' => $this->personal->hotel_id, '3char' => $lang_ch3])->row();
        } else {
            $browser_lang_2ch = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
            $supported_hotel_langs = $this->get_supported_hotel_langs();
            foreach ($supported_hotel_langs as $supported_hotel_lang) {
                if($supported_hotel_lang->ch2 == $browser_lang_2ch){
                    $this->interface_lang = $supported_hotel_lang;
                    break;
                }
            }
            if(!$this->interface_lang){
                $this->interface_lang = $this->hotel_lang;
            }
            $_SESSION ["interface_language"] = $this->interface_lang->ch3;
        }
    }

    public function get_supported_hotel_langs() {
        $res = $this->db->select('code, 3char as ch3, 2char as ch2, name_lat, name_original')
            ->get_where($this->langs_tbl, ['hotel_id' => $this->personal->hotel_id, 'is_active' => 1])->result();
        return $res;
    }

    function getdictionary($page, $lang = "", &$data) {
		if ($lang <> "") {
			if(strpos($lang, "lang_") === false){
				$lang = "lang_" . $lang;
			}
		} else {
			if (isset ( $_SESSION ["interface_language"] ) && $_SESSION ["interface_language"] != "") {
				$lang_3name = $_SESSION ["interface_language"];
				$lang = "lang_" . $lang_3name;
			} else {
				$interface_language_3char = $this->get_interface_language_3char();
				$lang = "lang_".$interface_language_3char;
			}
		}
		switch ($lang) {
		    case "lang_eng" :
		        $lang_datepicker = "en-GB";
		        break;
		    case "lang_pol" :
		        $lang_datepicker = "pl";
		        break;
		    case "lang_rus" :
		        $lang_datepicker = "ru";
                break;
            case "lang_ukr":
                $lang_datepicker = "uk";
                break;
            case "lang_geo":
                $lang_datepicker = "ka";
                break;
            case "lang_spa":
              	$lang_datepicker = "es";
               	break;
            case "lang_ita":
            	$lang_datepicker = "it";
            	break;
        	case "lang_bul":
        	    $lang_datepicker = "bg";
        	    break;
            default:
                $lang_datepicker = "en-GB";
		        break;
		}
		$data['datepicker_lang'] = $lang_datepicker;
		$sql = "select caption, " . $lang . " as value from global_hotelix_languages.languages where page='" . $page. "' or page='buttons' or page='mlw'";
        $query = $this->db->query($sql);
        if ($query->num_rows()) {
            foreach ($query->result() as $row) {
            	if (trim ( $row->value ) != "") {
					$data [$row->caption] = $row->value;
				}else{
					$data [$row->caption] = "{".$row->caption."}";
				}
            }
        }
    }

    function get_interface_language_3char(){
        $default_interface_language_2char = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
        $language_data_by_2char = $this->get_language_data_by_2char($default_interface_language_2char, $this->personal_data ["hotel_id"]);

        if($language_data_by_2char["lang_3char_name"] == ""){

            $interface_language_code = $this->get_hotel_lang_code($this->personal_data ["hotel_id"]);
            $interface_language_3char = $this->get_language_data_by_code($interface_language_code, $this->personal_data ["hotel_id"]);

            if($interface_language_3char == ""){
                $interface_language_3char = "eng";
            }

        }else{
            $interface_language_3char = $language_data_by_2char["lang_3char_name"];
        }

        if ($this->session->userdata('interface_language') == "") {
            $this->set_interface_language_session($interface_language_3char);
        }

        return $interface_language_3char;
    }

    function set_interface_language_session($interface_language_3char)
    {
        $interface_language_code = "";
        $sql = "SELECT code FROM dic_languages WHERE 3char LIKE '" . $interface_language_3char . "'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $interface_language_code = $row->code;
        }

        $newdata = array(
            'interface_language' => $interface_language_3char,
            'interface_language_code' => $interface_language_code
        );
        $this->session->set_userdata($newdata);
        $_SESSION["interface_language"] = $interface_language_3char;
        $_SESSION["interface_language_code"] = $interface_language_code;
    }

    function getdictionaryword($page, $lang = "", $caption) {
    	$caption = str_replace("{", "", $caption);
    	$caption = str_replace("}", "", $caption);

		if ($lang <> "") {
			if(strpos($lang, "lang_") === false){
				$lang = "lang_" . $lang;
			}
		} else {
		    if (isset ( $_SESSION ["interface_language"] ) && $_SESSION ["interface_language"] != "") {
		        $lang_3name = $_SESSION ["interface_language"];

		        $lang = "lang_" . $lang_3name;
		    } else {
		        $interface_language_3char = $this->get_interface_language_3char();

		        $lang = "lang_".$interface_language_3char;
		    }
		}

		$translate_word = "";
        $sql = "select " . $lang . " as value from global_hotelix_languages.languages where caption LIKE '".$caption."' AND page='" . $page. "'";
        //echo $sql;
        $query = $this->db->query($sql);
        if ($query->num_rows()) {
            $row = $query->row();
        	if (trim ( $row->value ) != "") {
            	$translate_word = $row->value;
            }else{
            	$translate_word = "{".$caption."}";
            }
        }
        return $translate_word;
    }

    function get_translated_str($page, $lang = "", $str) {
        $rez_str = $str;
        while (strpos($rez_str, "{")){
            $start = strpos($str, "{");
            $end = strpos($str, "}");
            $caption = substr($str, $start, $end - $start + 1);
            $rez_str = str_replace ( $caption , $this->getdictionaryword($page, $lang, $caption) , $rez_str );
        }
    	return $rez_str;
    }

    function get_language_prefix($param = "") {
        $lang = "lang_eng";
        if (isset($_SESSION ['user']['language'])) {
            $lang = "" . $_SESSION ['user']['language'];
        } else {
            $lang = "eng";
        }
        return $lang;
    }

    function get_language_data_by_2char($str_2char = "", $hotel_id = 0){
    	$lang_3char_name = "";
    	$lang_code = "";
    	$sql = "SELECT code, 3char as lang_3char_name FROM dic_languages WHERE 2char LIKE '".$str_2char."' AND is_active = 1 AND hotel_id = ".$hotel_id;
    	//echo $sql."<br>";
    	$query = $this->db->query ( $sql );
    	if ($query->num_rows () > 0) {
    		$row = $query->row();
    		$lang_3char_name = $row->lang_3char_name;
    		$lang_code = $row->code;
    	}

    	$return_data = array();
    	$return_data ["lang_3char_name"] = $lang_3char_name;
    	$return_data ["lang_code"] = $lang_code;
    	return $return_data;
    }

    function get_language_data_by_code($lang_code = "", $hotel_id = 0){
    	$lang_3char_name = "";
    	$sql = "SELECT 3char as lang_3char_name FROM dic_languages WHERE code = ".$lang_code." AND is_active = 1 AND hotel_id = ".$hotel_id;
    	$query = $this->db->query ( $sql );
    	if ($query->num_rows () > 0) {
    		$row = $query->row();
    		$lang_3char_name = $row->lang_3char_name;
    	}

    	return $lang_3char_name;
    }
    function get_hotel_lang_code($hotel_id){
    	$language_code = "";
    	$sql = "SELECT language_code FROM hotels_personal_v2 WHERE hotel_id = ".$hotel_id;
    	$query = $this->db->query ( $sql );
    	if ($query->num_rows () > 0) {
    		$row = $query->row();
    		$language_code = $row->language_code;
    	}

    	return $language_code;
    }

    function get_inteface_language_data($hotel_id){
        $return_data = array();
        $default_interface_language_2char = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
        $language_data_by_2char = $this->get_language_data_by_2char($default_interface_language_2char);
        //print_r($language_data_by_2char);
        //die();
        if($language_data_by_2char["lang_3char_name"] == ""){
            $interface_language_3char = "eng";
            $language_code = "45";
        }else{
            $interface_language_3char = $language_data_by_2char["lang_3char_name"];
            $language_code = $language_data_by_2char["lang_code"];
        }
        $lang = "lang_".$interface_language_3char;

        $return_data["language_2char"] = $language_data_by_2char;
        $return_data["language_3char"] = $interface_language_3char;
        $return_data["language_code"] = $language_code;
        return $return_data;
    }
}