<?php
class Mcurrency extends CI_Model {
    public $currencies_tbl = 'currency';
    public $rates_tbl = 'currency_rates_today';
	public $hotel_currency;
	public $interface_currency;
//                                             	[id] => 147
//                                             	[code] => 980
//                                             	[name] => UAH
//                                             	[full_name] => Ukrainian hryvnia
//                                             	[sort_order] => 0
//                                             	[active] => 1
	public $exchange_rates_koef = 1;
	function __construct() {
		parent::__construct ();
		if (php_sapi_name() === 'cli') {
		    return ;
		}
		$this->mount_hotel_currency_data();
		$this->mount_interface_currency_data();
		$this->mount_exchange_rates_koef();
	}

	public function mount_hotel_currency_data() {
	    $this->hotel_currency = $this->db->get_where($this->currencies_tbl, ['code' => $this->personal->currencyID])->row();
	}

	public function mount_interface_currency_data() {
	    if (isset ( $_SESSION ["interface_currency"] ) && $_SESSION ["interface_currency"] != "") {
	        $this->interface_currency = $this->db->get_where($this->currencies_tbl, ['name' => $_SESSION ["interface_currency"]])->row();
	    } else {
	        $this->interface_currency = $this->hotel_currency;
	        $_SESSION ["interface_currency"] = $this->interface_currency->name;
	    }
	}

	public function mount_exchange_rates_koef() {
	    if ($this->interface_currency->name != $this->hotel_currency->name){
	        $rate_to = $this->db->select('rate')->get_where($this->rates_tbl, ['name' =>$this->interface_currency->name])->row()->rate;
	        $rate_from = $this->db->select('rate')->get_where($this->rates_tbl, ['name' =>$this->hotel_currency->name])->row()->rate;
	        $this->exchange_rates_koef = $rate_to/$rate_from;
	    }
	}

	public function get_supported_currencies() {
	    $res = $this->db->select('name, code, sort_order')->order_by('sort_order', 'ASC')->get_where($this->currencies_tbl, ['active' => 1])->result();
	    return $res;
	}

	function fullvalue($amount) {
        $converted_currency = ($amount > 0) ? $this->convert_currency($amount) : 0;
		return $converted_currency." ".$this->interface_currency->name;
	}

	function convert_currency($amount){
	    return number_format($amount * $this->exchange_rates_koef, 2);
	}

	function get_currency_rate_from_fixer($currencies_arr = array()){
	    // 		$currencies_arr = array('GBP','PLN','RUB','UAH','USD','EUR',);
	    $endpoint = 'latest';
	    $access_key = '06907d75e3c95ee0b8986ceafe71165b';// '70eef38b9e84b2af2f92f86e7bc40eb4';
	    if (count($currencies_arr) == 0){
	        $sql = "SELECT name FROM currency";
	        $query = $this->db->query ( $sql );
	        foreach ($query->result () as $row){
	            array_push($currencies_arr, $row->name);
	        }
	    }
	    $currency_set = '&symbols=';
	    foreach ($currencies_arr as $val){
	        $currency_set .= $val.',';
	    }
	    $ch = curl_init('http://data.fixer.io/api/'.$endpoint.'?access_key='.$access_key.''.$currency_set.'');
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	    $json = curl_exec($ch);
	    curl_close($ch);
	    $exchangeRates = json_decode($json, true);
	    if ($exchangeRates['success'] == 1){
	        $insert_data = array();
	        foreach ($exchangeRates['rates'] as $curr_name => $curr_rate){
	            array_push ( $insert_data, array (
	                'name' => $curr_name,
	                'rate' => $curr_rate,
	                'timestamp' => $exchangeRates ['timestamp']
	            ) );
	        }
	        $tbl_name = "currency_rates_today";
	        $this->db->query("TRUNCATE " . $tbl_name);
	        $this->db->insert_batch($tbl_name, $insert_data);
	        $tbl_name = "currency_rates_history";
	        $this->db->insert_batch($tbl_name, $insert_data);
	        echo "currencies updated.";
	    }elseif (isset($exchangeRates['error'])){
	        echo "ERROR ". $exchangeRates['error']['code']. " - " . $exchangeRates['error']['type'];
	    }else{
	        echo "Some else error";
	    }
	}

	function get_currency_name(){
	    $currency_name = "";
	    $currency_code = $this->get_currency_code();
	    if($currency_code != ""){
	        $query = $this->db->query("SELECT name FROM currency WHERE code = ".$currency_code);
	        if ($query->num_rows() > 0) {
	            $row = $query->row();
	            $currency_name = strtolower($row->name);
	        }
	    }

	    return $currency_name;
	}

	function get_currency_code(){
	    $currency_code = "";
	    //if (isset($_SESSION["interface_currency"])) {
	    //    $currency_code = $_SESSION["interface_currency"];
	    //} else {
	    $query = $this->db->query("SELECT currencyID FROM hotels_personal_v2 WHERE hotel_id = " . $this->personal->hotel_id);
	    if ($query->num_rows() > 0) {
	        $row = $query->row();
	        $currency_code = $row->currencyID;
	    }
	    //}
	    return $currency_code;
	}
}
?>