<?php
class Htmltpl extends CI_Model {
	function __construct() {
		parent::__construct ();

	}

	public function get_step4dopay_mandarin_block($dc_order_id) {
	    $data = [];
	    $merchant_selector = 0;
	    $amount = $this->pay_processor->calculate_ccforce_rooms_amount();
	    $cc_processor_data = $this->session->userdata('cc_processor_data');
	    if (isset($cc_processor_data['mandarin_merchant_selector'])) {
	        if ($cc_processor_data['mandarin_merchant_selector'] == 1) {
	            $merchant_selector = 1;
	            $booking_data = (object)$this->session->userdata('booking_data');
	            $amount = $booking_data->rooms_amount;
	        }
	        $this->session->unset_userdata('cc_processor_data');
	    }
	    $data['amount_str'] = $this->mcurrency->fullvalue($amount, 2);
	    $data['merchant_selector'] = $merchant_selector;
	    $return_data = [];
	    $return_data["mandarin_daily_prepayment"] = $this->parser->parse ( 'templates/payment/mandarin_daily_prepayment.html', $data, TRUE );
	    return $return_data;
	}

	public function get_mandarin_html_form() {
	    $data = [];

	    $this->mlanguages->getdictionary("pay", "", $data);
	    $html_form = $this->parser->parse('templates/pay_custom/mandarin_form.html', $data, true);
	    return $html_form;
	}

	public function get_step4dopay_przelewy_block($dc_order_id) {
	    $data = [];
	    $data['amount_str'] = $this->mcurrency->fullvalue($this->pay_processor->calculate_ccforce_rooms_amount(), 2);

	    $return_data = [];
	    $return_data["przelewy_daily_prepayment"] = $this->parser->parse ( 'templates/payment/przelewy_daily_prepayment.html', $data, TRUE );
	    return $return_data;
	}

	public function get_przelewy_html_form() {
	    $data = [];

	    $this->mlanguages->getdictionary("pay", "", $data);
	    $html_form = $this->parser->parse('templates/pay_custom/przelewy_form.html', $data, true);
	    return $html_form;
	}

	public function get_step4dopay_transbank_block($dc_order_id) {
	    $data = [];
	    $amount = $this->pay_processor->calculate_ccforce_rooms_amount();
	    $amount = round($amount, 0);
	    $data['amount_str'] = $this->mcurrency->fullvalue($amount, 2);

	    $return_data = [];
	    $return_data["transbank_daily_prepayment"] = $this->parser->parse ( 'templates/payment/transbank_daily_prepayment.html', $data, TRUE );
	    return $return_data;
	}

	public function get_transbank_html_form() {
	    $data = [];

	    $this->mlanguages->getdictionary("pay", "", $data);
	    $html_form = $this->parser->parse('templates/pay_custom/transbank_form.html', $data, true);
	    return $html_form;
	}
	
	public function get_step4dopay_monobank_block($dc_order_id) {
	    $data = [];
	    $amount = $this->pay_processor->calculate_ccforce_rooms_amount();
	    $amount = round($amount, 0);
	    $data['amount_str'] = $this->mcurrency->fullvalue($amount, 2);
	    
	    $return_data = [];
	    $return_data["monobank_daily_prepayment"] = $this->parser->parse ( 'templates/payment/monobank_daily_prepayment.html', $data, TRUE );
	    return $return_data;
	}
	
	public function get_monobank_html_form() {
	    $data = [];
	    
	    $this->mlanguages->getdictionary("pay", "", $data);
	    $html_form = $this->parser->parse('templates/pay_custom/monobank_form.html', $data, true);
	    return $html_form;
	}
	
	public function get_step4dopay_bog_block($dc_order_id) {
	    $data = [];
	    $amount = $this->pay_processor->calculate_ccforce_rooms_amount();
	    $amount = round($amount, 0);
	    $data['amount_str'] = $this->mcurrency->fullvalue($amount, 2);
	    
	    $return_data = [];
	    $return_data["bog_daily_prepayment"] = $this->parser->parse ( 'templates/payment/bog_daily_prepayment.html', $data, TRUE );
	    return $return_data;
	}
	
	public function get_bog_html_form() {
	    $data = [];
	    
	    $this->mlanguages->getdictionary("pay", "", $data);
	    $html_form = $this->parser->parse('templates/pay_custom/bog_form.html', $data, true);
	    return $html_form;
	}

	public function get_step4dopay_ipay_block($dc_order_id) {
	    $data = [];
	    $data['amount_str'] = $this->mcurrency->fullvalue($this->pay_processor->calculate_ccforce_rooms_amount(), 2);

	    $return_data = [];
	    $return_data["ipay_daily_prepayment"] = $this->parser->parse ( 'templates/payment/ipay_daily_prepayment.html', $data, TRUE );
	    return $return_data;
	}

	public function get_ipay_html_form() {
	    $data = [];

	    $this->mlanguages->getdictionary("pay", "", $data);
	    $html_form = $this->parser->parse('templates/pay_custom/ipay_form.html', $data, true);
	    return $html_form;
	}

	public function get_step4dopay_paypal_block($dc_order_id) {
	    $data = [];
	    $data['amount_str'] = $this->mcurrency->fullvalue($this->pay_processor->calculate_ccforce_rooms_amount(), 2);
	    $data["client_id"] = $this->paypal_mdl->get_clientId();
	    $data["merchant_id"] = $this->paypal_mdl->get_merchant_seller();

	    $return_data = [];
	    $return_data["paypal_daily_prepayment"] = $this->parser->parse ( 'templates/payment/paypal_daily_prepayment.html', $data, TRUE );
	    return $return_data;
	}
	
	public function get_step4dopay_paypal_v2_block($dc_order_id) {
	    $data = [];
	    $data['amount'] = $this->pay_processor->calculate_ccforce_rooms_amount();
	    $data['currency'] = $this->mcurrency->hotel_currency->name;//'USD';
	    $data['amount_str'] = $this->mcurrency->fullvalue($data['amount'], 2);
	    $data['client_id'] = $this->pay_processor->get_paypal_v2_client_id();
	    $data['reference_id'] = "{$this->personal->hotel_id}-{$this->session->userdata('dc_order_id')}-book";
	    
	    $return_data = [];
	    $return_data["paypal_v2_daily_prepayment"] = $this->parser->parse ( 'templates/payment/paypal_v2_daily_prepayment.html', $data, TRUE );
	    return $return_data;
	}

	public function get_paypal_html_form() {
	    $pay_custom_session_data = $this->session->userdata('reservation_info');

	    $hms_res_id = $pay_custom_session_data->hms_res_id;
	    $hms_hotel_id = $this->personal->hotel_id;
	    $pincode_md5 = md5($this->config->item('reservation_pincode_phrase') . $hms_hotel_id . $hms_res_id);
	    $next_url = "/booking/reservation_info/$hms_hotel_id/$hms_res_id/$pincode_md5";

	    $data = [];
	    $data["client_id"] = $this->paypal_mdl->get_clientId();
	    $data["merchant_id"] = $this->paypal_mdl->get_merchant_seller();
	    $data["next_url"] = $next_url;

	    $this->mlanguages->getdictionary("pay", "", $data);
	    $html_form = $this->parser->parse('templates/pay_custom/paypal_form.html', $data, true);
	    return $html_form;
	}
	
	public function get_paypal_v2_html_form() {
	    $pay_custom_session_data = $this->session->userdata('reservation_info');
	    
	    $hms_res_id = $pay_custom_session_data->hms_res_id;
	    $hms_hotel_id = $this->personal->hotel_id;
	    
	    $data = [];
	    $data["client_id"] = $this->pay_processor->get_paypal_v2_client_id();
	    $data['reference_id'] = "{$this->personal->hotel_id}-{$hms_res_id}-custom_pay-".time();
	    $data['amount'] = $pay_custom_session_data->custom_amount;
	    $data['currency'] = $this->mcurrency->hotel_currency->name;
	    
	    $this->mlanguages->getdictionary("pay", "", $data);
	    $html_form = $this->parser->parse('templates/pay_custom/paypal_v2_form.html', $data, true);
	    
	    return $html_form;	    
	}

	public function get_nofreerooms_block($inc_data = []) {
	    $data['title_block']= $data['possibilities'] = $data = [];
	    if ($inc_data && !isset($inc_data['errors'])){
	        foreach ($inc_data as &$set) {
	            $set['price'] = $this->mcurrency->fullvalue($set['price']);
	        }
	        $data['possibilities'][]['variants'] = $inc_data;
	        $data['title_block'][] = [];
    	    $this->mlanguages->getdictionary("pmv3", "", $data);
	    }
 	    else{
 	        if (isset($inc_data['errors'])){
 	            $data['title_block'][] = [];
     	        /* echo "Printed at Htmltpl.php get_nofreerooms_block() line 20<br>";
     	        print_r( $inc_data['errors']); */
 	        }else{

 	        }

 	    }
 	    return $this->parser->parse ( 'templates/booking/nofreerooms_block.html', $data, TRUE );
	}

	public function get_calendar_block() {
	    $data=[];
	    $this->mlanguages->getdictionary("pmv3", "", $data);
	    return $this->parser->parse ( 'templates/booking/calendar_block.html', $data, TRUE );
	}

	function get_step4dopay_appex_block($dc_order_id)
    {
        $booking_data = $this->session->userdata('booking_data');

        $services_price = 0;
        if (isset($booking_data['services_price'])) {
            $services_price = $booking_data['services_price'];
        }

        $ccforce_amount = $this->pay_processor->calculate_ccforce_rooms_amount();
        $amount_full = number_format($ccforce_amount + $services_price, 2, '.', '');
        $amountcurr = "RUB";
        $currency = "MBC";

        $authparam = $this->acquiring->get_appex_authparam();
        $account = $authparam["account"];
        $key1 = $authparam["key1"];
        $key2 = $authparam["key2"];
        $url = $authparam["url"];

        $timestamp = time();
        $Order_IDP = $this->personal->hotel_id . "-" . $dc_order_id . "-ibm-" . $timestamp;
        $description = urlencode("Оплата за проживание на $amount_full $amountcurr");

        $online_module_v = 3;
        $backURL = "https://xml.otelms.com/api_appex/gate_online_module/".$this->personal->hotel_id."/".$online_module_v;
        $trtype = "1";

        $data = [];
        $data['amountcurr'] = $amountcurr;
        $data['currency'] = $currency;
        $data['number'] = $Order_IDP;
        $data['trtype'] = $trtype;
        $data['account'] = $account;
        $data['backURL'] = $backURL;
        $data['description'] = $description;
        $data['server_url'] = $url;
        $data['amount'] = $amount_full;
        $data['signature'] = strtoupper(md5("$amount_full:$amountcurr:$currency:$Order_IDP:$description:$trtype:$account:$backURL:$key1:$key2"));
        $data['amount_str'] = $this->mcurrency->fullvalue($amount_full, 2);

        $appex_daily_prepayment = $this->parser->parse('templates/payment/appex_daily_prepayment.html', $data, true);

        $return_data = [];
        $return_data["appex_daily_prepayment"] = $appex_daily_prepayment;
        return $return_data;
    }

    public function get_appex_html_form() {

        $pay_custom_session_data = $this->session->userdata('reservation_info');

        $custom_amount = number_format($pay_custom_session_data->custom_amount, 2, '.', '');
        $hms_res_id = $pay_custom_session_data->hms_res_id;

        $authparam = $this->acquiring->get_appex_authparam();
        $account = $authparam["account"];
        $key1 = $authparam["key1"];
        $key2 = $authparam["key2"];
        $url = $authparam["url"];

        $timestamp = time();
        $amountcurr = "RUB";
        $currency = "MBC";
        $number = $this->personal->hotel_id . "-" . $hms_res_id . "-" . $timestamp."m";
        $description = urlencode("Оплата за проживание на $custom_amount $amountcurr");

        $reservation_pincode_phrase = $this->config->item('reservation_pincode_phrase');
        $md5_str = md5($reservation_pincode_phrase . $this->personal->hotel_id . $hms_res_id);
        $backURL = "https://" . $this->personal->pmv3_host ."/booking/reservation_info/".$this->personal->hotel_id."/".$hms_res_id."/".$md5_str;

        $trtype = "1";

        $signature = strtoupper(md5("$custom_amount:$amountcurr:$currency:$number:$description:$trtype:$account:$backURL:$key1:$key2"));
        $data = [
            'amount' => $custom_amount,
            'amountcurr' => $amountcurr,
            'currency' => $currency,
            'signature' => $signature,
            'number' => $number,
            'description' => $description,
            'trtype' => $trtype,
            'account' => $account,
            'backURL' => $backURL,
            'server_url' => $url
        ];

        $this->mlanguages->getdictionary("pay", "", $data);
        $html_form = $this->parser->parse('templates/pay_custom/appex_form.html', $data, true);
        return $html_form;
    }

	function get_step4dopay_stripe_block($dc_order_id)
    {
        require_once (APPPATH . 'libraries/stripe/init.php');

        $booking_data = $this->session->userdata('booking_data');
        $customer_data = $this->session->userdata('customer');

        $services_price = 0;
        if (isset($booking_data['services_price'])) {
            $services_price = $booking_data['services_price'];
        }

        $ccforce_amount = $this->pay_processor->calculate_ccforce_rooms_amount();
        $amount = $ccforce_amount;// + $services_price;

        $currency = strtoupper($this->mcurrency->get_currency_name());
        $hotel_id = $this->personal->hotel_id;
        $hms_host = $this->personal->hms_host;

        $invoice = $hotel_id . "-" . $dc_order_id . "-" . time();
        $fee = ceil($amount * 0.002 * 100);
        $stripe = $this->acquiring->get_stripe_standart_authparam();

        \Stripe\Stripe::setApiKey($stripe['stripe_secret']);

        $intetnt_arr = array(
            'amount' => $amount * 100,
            'currency' => $currency,
            'payment_method_types' => ['card'],
            'description' => "hms-" . $invoice,
            'metadata' => array(
                'order_id' => $dc_order_id,
                'order_id_type' => "vertex",
                'hms_host' => $hms_host,
                'hms_id' => $hotel_id
            )
        );

        if ($stripe['country_code'] != "MEX") {
            $intetnt_arr['application_fee_amount'] = $fee;
        }

        try {
            $intent = \Stripe\PaymentIntent::create($intetnt_arr, array(
                'stripe_account' => $stripe['connected_stripeAccount']
            ));
        } catch (\Stripe\Error\Permission $e) {
            $error = $e->getJsonBody();
            echo $error['error']['message'];
            die();
        }
        $data = [];
        $data["amount"] = $amount;
        $data["currency"] = $currency;
        $data["order_id"] = $dc_order_id;
        $data["hotel_id"] = $hotel_id;
        $data['stripe_publishable'] = $stripe['stripe_publishable'];
        $data['connected_stripeAccount'] = $stripe['connected_stripeAccount'];
        $data['intent_client_secret'] = $intent->client_secret;
        $data['customer_name'] = $customer_data['lastname'] . " " . $customer_data['firstname'];
        $data['customer_email'] = $customer_data['email'];
        $data['amount_str'] = $this->mcurrency->fullvalue($amount, 2);

        $stripe_daily_prepayment = $this->parser->parse('templates/payment/stripe_daily_prepayment.html', $data, true);

        $return_data = [];
        $return_data["stripe_daily_prepayment"] = $stripe_daily_prepayment;
        return $return_data;
    }

    public function get_stripe_html_form() {
        require_once (APPPATH . 'libraries/stripe/init.php');

        $pay_custom_session_data = $this->session->userdata('reservation_info');
        $dc_order_id = $pay_custom_session_data->hms_res_id;
        $customer_data = [
            'lastname' => $pay_custom_session_data->reservation_info->rooms[0]->lastname,
            'firstname' => $pay_custom_session_data->reservation_info->rooms[0]->firstname,
            'email' => $pay_custom_session_data->reservation_info->rooms[0]->email
        ];

        $booking_data = $this->session->userdata('booking_data');
        $services_price = 0;
        if (isset($booking_data['services_price'])) {
            $services_price = $booking_data['services_price'];
        }

        $amount = $pay_custom_session_data->custom_amount;// + $services_price;

        $currency = strtoupper($this->mcurrency->get_currency_name());
        $hotel_id = $this->personal->hotel_id;
        $hms_host = $this->personal->hms_host;

        $invoice = $hotel_id . "-" . $dc_order_id . "-" . time();
        $fee = ceil($amount * 0.002 * 100);
        $stripe = $this->acquiring->get_stripe_standart_authparam();

        \Stripe\Stripe::setApiKey($stripe['stripe_secret']);

        $intetnt_arr = array(
            'amount' => $amount * 100,
            'currency' => $currency,
            'payment_method_types' => ['card'],
            'description' => "hms-" . $invoice,
            'metadata' => array(
                'order_id' => $dc_order_id,
                'hms_host' => $hms_host,
                'hms_id' => $hotel_id
            )
        );

        if ($stripe['country_code'] != "MEX") {
            $intetnt_arr['application_fee_amount'] = $fee;
        }

        try {
            $intent = \Stripe\PaymentIntent::create($intetnt_arr, array(
                'stripe_account' => $stripe['connected_stripeAccount']
            ));
        } catch (\Stripe\Error\Permission $e) {
            $error = $e->getJsonBody();
            echo $error['error']['message'];
            die();
        }
        $data = [];
        $data["amount"] = $amount;
        $data["currency"] = $currency;
        $data["order_id"] = $dc_order_id;
        $data["hotel_id"] = $hotel_id;
        $data['stripe_publishable'] = $stripe['stripe_publishable'];
        $data['connected_stripeAccount'] = $stripe['connected_stripeAccount'];
        $data['intent_client_secret'] = $intent->client_secret;
        $data['customer_name'] = $customer_data['lastname'] . " " . $customer_data['firstname'];
        $data['customer_email'] = $customer_data['email'];

        $html_form = $this->parser->parse('templates/pay_custom/stripe_form.html', $data, true);
        return $html_form;
    }

	function get_step4dopay_liqpay_block($dc_order_id)
    {
        $booking_data = $this->session->userdata('booking_data');

        $services_price = 0;
        if (isset($booking_data['services_price'])) {
            $services_price = $booking_data['services_price'];
        }

        $ccforce_amount = $this->pay_processor->calculate_ccforce_rooms_amount();
        $amount_full = $ccforce_amount;// + $services_price;

        $data = [];
        $data['version'] = 3;
        $data['result_url'] = "https://" . $this->personal->pmv3_host . "/booking/confirmation";

        $authparam = $this->acquiring->get_liqpay_authparam();
        $data['server_url'] = "https://xml.otelms.com/api_liqpay/push/999";
        $data['sandbox'] = $authparam['sandbox'];
        $data['public_key'] = $authparam['public_key'];
        $data['action'] = "pay";
        $data['amount'] = $amount_full;
        $data['currency'] = "UAH";
        $data['description'] = "liqpay payment";
        $data['order_id'] = "hms-liqpay-" . $this->personal->hotel_id . "-" . $dc_order_id . "-ibm";

        $datastr = base64_encode(json_encode($data, true));
        $private_key = $authparam['private_key'];
        $signature = base64_encode(sha1($private_key . $datastr . $private_key, 1));

        $data_html = array(
            "liqpay_datastr" => $datastr,
            "liqpay_signature" => $signature,
            "amount" => $amount_full,
            "amount_str" => $this->mcurrency->fullvalue($amount_full, 2)
        );
        $liqpay_daily_prepayment = $this->parser->parse('templates/payment/liqpay_daily_prepayment.html', $data_html, true);

        $return_data = [];
        $return_data["liqpay_daily_prepayment"] = $liqpay_daily_prepayment;
        return $return_data;
    }

    public function get_liqpay_html_form() {
        $pay_custom_session_data = $this->session->userdata('reservation_info');

        $amount_full = $pay_custom_session_data->custom_amount;
        $hms_res_id = $pay_custom_session_data->hms_res_id;

        $data = [];
        $data['version'] = 3;
        $data['result_url'] = "https://" . $this->personal->pmv3_host . "/booking/confirmation";

        $authparam = $this->acquiring->get_liqpay_authparam();
        $data['server_url'] = "https://xml.otelms.com/api_liqpay/push/0";
        $data['sandbox'] = $authparam['sandbox'];
        $data['public_key'] = $authparam['public_key'];
        $data['action'] = "pay";
        $data['amount'] = $amount_full;
        $data['currency'] = "UAH";
        $data['description'] = "liqpay payment";
        $data['order_id'] = "hms-liqpay-" . $this->personal->hotel_id . "-" . $hms_res_id . "-ibm";

        $datastr = base64_encode(json_encode($data, true));
        $private_key = $authparam['private_key'];
        $signature = base64_encode(sha1($private_key . $datastr . $private_key, 1));

        $data_html = [
            "liqpay_datastr" => $datastr,
            "liqpay_signature" => $signature,
            "amount" => $amount_full,
        ];
        $html_form = $this->parser->parse('templates/pay_custom/liqpay_form.html', $data_html, true);
        return $html_form;
    }
}