<?php
class Echannel_mdl extends CI_Model {

    public $auth_tbl = '`echannel_client`.`users`';
    public $hms_id;
    public $endpoint;
    public $dc_id;
    public $creds;
    public $last_curl_request;
    public $last_request_url;
    public $last_curl_response;

    public function __construct() {
        parent::__construct();
        $this->is_user_logined();
    }

    private function is_user_logined(){
        if ($this->session->user['logined']) {
            $user = $this->db->get_where($this->auth_tbl, ['id' => $this->session->user['id']])->row();
            $this->set_creds($user);
        }else{
            if ($_SERVER['PATH_INFO'] != '/echannel/login') {
                $this->session->sess_destroy();
                die ( "<meta http-equiv='refresh' content='0;url=/echannel/login'>" );
            }
        }
    }

    private function set_creds($user){
        $this->creds = ['user' => $user->echannel_user, 'password' => $user->echannel_password];
        $this->dc_id = $user->dc_id;
        $this->hms_id = $user->hms_id;
        if ($user->endpoint != '') {
            $base_endpoint = $user->endpoint;
        }else{
            $base_endpoint = $this->config->item('base_echannel_endpoint_url');
        }
        $this->endpoint = "$base_endpoint/echannel";
    }

    public function  get_rooms($request = []) {
        if (!count($request)) {
            $request = $this->creds;
            $request['hms_id'] = $this->hms_id;
            $request['dc_id'] = $this->dc_id;
        }
        $result = [
            'request' => $request,
            'response' => $this->request_curl($request, $this->endpoint.'/get_rooms_info')
        ];
        return $result;
    }

    public function  get_rates($request = []) {
        if (!count($request)) {
            $request = $this->creds;
            $request['hms_id'] = $this->hms_id;
            $request['dc_id'] = $this->dc_id;
        }
        $result = [
            'request' => $request,
            'response' => $this->request_curl($request, $this->endpoint.'/get_rates_info')
        ];
        return $result;
    }
    
    public function get_properties($request = []) {
        if (!count($request)) {
            $request = $this->creds;
            $request['hms_id'] = $this->hms_id;
            $request['dc_id'] = $this->dc_id;
        }
        $result = [
            'request' => $request,
            'response' => $this->request_curl($request, $this->endpoint.'/get_property_info')
        ];
        return $result;
    }
    
    public function get_properties_list($request = []) {
        if (!count($request)) {
            $request = $this->creds;
            //$request['hms_id'] = $this->hms_id;
            $request['dc_id'] = $this->dc_id;
        }
        $result = [
            'request' => $request,
            'response' => $this->request_curl($request, $this->endpoint.'/get_properties_list')
        ];

        return $result;
    }

    public function get_reservations($request = []) {
        if (!count($request)) {
            $request = $this->creds;
            $request['hms_id'] = $this->hms_id;
            $request['dc_id'] = $this->dc_id;
        }
        $result = [
            'request' => $request,
            'response' => $this->request_curl($request, $this->endpoint.'/get_bookings')
        ];
        return $result;
    }

    public function  set_reservation($post) {
        if (isset($post['re_request'])) {
            $request = json_decode($post['re_request'], true);
            if (json_last_error() !== JSON_ERROR_NONE) {
                $request = $post['re_request'];
            }
        }else {
            $request = $this->creds;
            $request ['hms_id'] = $this->hms_id;
            $request ['dc_id'] = $this->dc_id;
            $request ['booking']['id'] = $post['dc_uid'];
            $request ['booking']['last_name'] = "Test_echannel pmv3";
            $request ['booking']['first_name'] = "echannel";
            $request ['booking']['phone'] = "0011188";
            $request ['booking']['email'] = "test@qq.ww";
            $request ['booking']['created'] = date('Y-m-d H:i');
            $request ['booking']['date_in'] = $post['date_in'];
            $request ['booking']['date_out'] = $post['date_out'];
            $request ['booking']['status'] = "new";
            $request ['booking']['room_id'] = $post['room'];
            $request ['booking']['rate_id'] = $post['rate'];
            $request ['booking']['price'] = $post['price'];
            $request ['booking']['guest_count'] = $post['guest_count'];
            
            if($post['guest_count'] > 0){
                $request ['booking']['guest_data'] = array();
                for($i = 1; $i <= $post['guest_count']; $i++){
                    array_push($request ['booking']['guest_data'], array(
                        'firstname' => "firstname_$i",
                        'lastname' => "lastname_$i"
                    ));
                }
            }
            
        }

        $result = [
            'request' => $request,
            'response' => $this->request_curl($request, $this->endpoint.'/set_booking')
        ];
        return $result;
    }

    public function cancel_reservation($post) {
        if (isset($post['re_request'])) {
            $request = json_decode($post['re_request'], true);
            if (json_last_error() !== JSON_ERROR_NONE) {
                $request = $post['re_request'];
            }
        }else {
            $request = $this->creds;
            $request ['hms_id'] = $this->hms_id;
            $request ['dc_id'] = $this->dc_id;
            $request ['id'] = $post['dc_uid'];
            $request ['status'] = "cancel";
        }

        $result = [
            'request' => $request,
            'response' => $this->request_curl($request, $this->endpoint.'/reservation_cancel')
        ];
        return $result;
    }

    public function get_reservation_info($post) {
        if (isset($post['re_request'])) {
            $request = json_decode($post['re_request'], true);
            if (json_last_error() !== JSON_ERROR_NONE) {
                $request = $post['re_request'];
            }
        }else {
            $request = $this->creds;
            $request ['hms_id'] = $this->hms_id;
            $request ['dc_id'] = $this->dc_id;
            $request ['id'] = $post['dc_uid'];
        }
        $result = [
            'request' => $request,
            'response' => $this->request_curl($request, $this->endpoint.'/get_reservation_info')
        ];
        return $result;
    }

    public function get_rna($post) {
        if (isset($post['re_request'])) {
            $request = json_decode($post['re_request'], true);
            if (json_last_error() !== JSON_ERROR_NONE) {
                $request = $post['re_request'];
            }
        }else {
            $request = $this->creds;
            $request ['hms_id'] = $this->hms_id;
            $request ['dc_id'] = $this->dc_id;
            $request ['from_date'] = $post['date_from'];
            $request ['to_date'] = $post['date_to'];
        }

        $result = [
            'request' => $request,
            'response' => $this->request_curl($request, $this->endpoint.'/get_rna')
        ];
        return $result;

    }

    public function Get_Header($p = []) {
        $data = $p;
        $active_class = 'text-secondary';
        $base_class = 'text-white';
        $nav = ['home', 'second', 'orders', 'products', '5'];
        $nav_products = ['rooms', 'rates', 'rnas', 'resinfo', 'dores', 'cancelres'];
        for ($i = 0; $i < count($nav); $i++) {
            $data["nav_activity_class_$i"] = $base_class;
        }
        foreach ($nav_products as $sub_item) {
            $data["sub_nav_products_$sub_item"] = $base_class;
        }

        if (isset($p['nav_item_marker'])) {
            $nav_current_item = $p['nav_item_marker'];
            $i = array_search($nav_current_item, $nav);
            if ($i !== false) {
                $data["nav_activity_class_$i"] = $active_class;
            }
            if (isset($p['sub_nav_item_marker'])) {
                $sub_nav_current_item = $p['sub_nav_item_marker'];
                if (isset($data["sub_nav_$nav_current_item"."_$sub_nav_current_item"])) {
                    $data["sub_nav_$nav_current_item"."_$sub_nav_current_item"] = $active_class;
                }
            }
        }
        $data['customer'] = $this->session->user['user'];
        return $this->parser->parse ( 'templates/echannel/header_view.html', $data, true);
    }

    public function request_curl($data, $url){
        if (is_array($data) || is_object($data)) {
            $body = json_encode($data);
        } else {
            $body = $data;
        }

        $this->last_curl_request = $body;
        $this->last_request_url = $url;

        $headers = array('Content-Type: application/json');
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        $response = curl_exec($ch);
        curl_close ( $ch );

        $this->last_curl_response = $response;

        $decoded_response = json_decode($response);
        if (json_last_error() === JSON_ERROR_NONE) {
            return $decoded_response;
        }

        return $response;
    }
}