<?php
class Curl_model extends CI_Model {

	function __construct() {
		// Call the Model constructor
		parent::__construct ();
	}

	function CurlPlugRaw($post, $url, $method = "POST")
	{

		$headers = array(
				'Content-Type: application/json'
		);
		$ch = curl_init ();
		curl_setopt ( $ch, CURLOPT_SSL_VERIFYPEER, FALSE );
		curl_setopt ( $ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)" );

		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true );

		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post);

		$result = curl_exec ( $ch );
		// close connection

		$http_code = - 1;

		if (! curl_errno ( $ch )) {
			$info = curl_getinfo ( $ch );
			$http_code = $info ['http_code'];
			if ($http_code == 500) {
				// $result = "500, Internal Server Error" . $result;
			}
			// echo "Post code=" . $http_code . "\n";
		}

		curl_close ( $ch );

		return $result;
	}

	function CurlPlug($data, $url, $bool = 0) {

		$fields_string = "";
		foreach ( $data as $key => $value ) {
			$fields_string .= $key . '=' . $value . '&';
		}
		$fields_string = rtrim ( $fields_string, '&' );

		//echo $fields_string . "+";
		//die();
		//open connection
		$ch = curl_init ();

		//set the url, number of POST vars, POST data
		curl_setopt ( $ch, CURLOPT_SSL_VERIFYPEER, FALSE );
		curl_setopt ( $ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)" );
		//curl_setopt ( $ch, CURLOPT_FAILONERROR, 1 );
		curl_setopt ( $ch, CURLOPT_FOLLOWLOCATION, 1 );
		curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, 1 );
		//curl_setopt ( $ch, CURLOPT_TIMEOUT, 3 );
		//curl_setopt ( $ch, CURLOPT_SSL_VERIFYHOST, FALSE );
		//curl_setopt($ch, CURLOPT_COOKIEJAR, "/tmp/cookieFileName");
		curl_setopt ( $ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt' );
		curl_setopt ( $ch, CURLOPT_COOKIEFILE, 'cookie.txt' );
		curl_setopt ( $ch, CURLOPT_URL, $url );
		curl_setopt ( $ch, CURLOPT_POST, count ( $data ) );
		curl_setopt ( $ch, CURLOPT_POSTFIELDS, $fields_string );

		//execute post
		$result = curl_exec ( $ch );

		//close connection
		curl_close ( $ch );
		return $result;
	}

	function CurlGET($data, $url)
    {
        $params = http_build_query($data);
        // echo "URl=".$url.'?'.$params."<br>";
        $ch = curl_init();

        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url . '?' . $params);

        $result = curl_exec($ch);

        curl_close($ch);
        return $result;
    }

	function CurlPlugMass($data, $url) {
		$fields_string = "";
		$fields_string .= 'order_data=' . $data . '&';
		rtrim ( $fields_string, '&' );
		//echo $fields_string;
		//die();
		//open connection
		$ch = curl_init ();

		//set the url, number of POST vars, POST data
		curl_setopt ( $ch, CURLOPT_SSL_VERIFYPEER, FALSE );
		curl_setopt ( $ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)" );
		//curl_setopt ( $ch, CURLOPT_FAILONERROR, 1 );
		curl_setopt ( $ch, CURLOPT_FOLLOWLOCATION, 1 );
		curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, 1 );
		//curl_setopt ( $ch, CURLOPT_TIMEOUT, 3 );
		//curl_setopt ( $ch, CURLOPT_SSL_VERIFYHOST, FALSE );
		//curl_setopt($ch, CURLOPT_COOKIEJAR, "/tmp/cookieFileName");
		curl_setopt ( $ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt' );
		curl_setopt ( $ch, CURLOPT_COOKIEFILE, 'cookie.txt' );
		curl_setopt ( $ch, CURLOPT_URL, $url );
		curl_setopt ( $ch, CURLOPT_POST, count ( $data ) );
		curl_setopt ( $ch, CURLOPT_POSTFIELDS, $fields_string );

		//execute post
		$result = curl_exec ( $ch );

		//close connection
		curl_close ( $ch );
		return $result;
	}

	function CurlAppex($fields, $url)
	{
	    $ch = curl_init();

	    $postvars = '';
	    foreach ($fields as $key => $value) {
	        $postvars .= $key . "=" . $value . "&";
	    }

	    // echo "\n\n" . $postvars . "\n\n";

	    curl_setopt($ch, CURLOPT_URL, $url);
	    curl_setopt($ch, CURLOPT_POST, 1); // 0 for a get request
	    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);
	    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
	    $response = curl_exec($ch);

	    curl_close($ch);
	    return $response;
	}

	function curl_plug_json($data, $url){
	    $headers = array('Content-Type: application/json');
	    $ch = curl_init();
	    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
	    curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
	    curl_setopt($ch, CURLOPT_URL, $url);
	    curl_setopt($ch, CURLOPT_POST, true);
	    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	    $result = curl_exec($ch);
	    curl_close ( $ch );
	    return $result;
	}
}
?>