<?php

class Content extends CI_Model {
    function __construct() {
        // Call the Model constructor
    }
    function get_Header() {
        $langs_list = $currencies_list = [];
        $supported_hotel_langs = $this->mlanguages->get_supported_hotel_langs();
        foreach ($supported_hotel_langs as $lang) {
            array_push($langs_list, ['name' => $lang->name_original, 'val'=>$lang->ch3]);
        }
        $supported_currencies = $this->mcurrency->get_supported_currencies();
        foreach ($supported_currencies as $currency) {
            array_push($currencies_list, ['name' => $currency->name, 'val'=>$currency->name]);
        }
        $data = [
            'langs' => [
                [
                    'selected_name' => $this->mlanguages->interface_lang->name_original,
                    'selected_val' => $this->mlanguages->interface_lang->ch3,
                    'langs_list' => $langs_list

                ]
            ],
            'currencies' => [
                [
                    'selected_name' => $this->mcurrency->interface_currency->name,
                    'selected_val' => $this->mcurrency->interface_currency->name,
                    'currencies_list' => $currencies_list

                ]
            ],
            'hotel' => []
        ];
        
        $home_page = $this->home_page_url;
        
        switch ($home_page) {
            case 'rooms':
                array_push($data['hotel'], $this->get_hotel_header_pars_data());
                break;
            case 'proprooms':
                array_push($data['hotel'], $this->get_hotel_header_pars_data());
                break;
            case 'properties':
                break;
            default:
                break;
        }
        
        if ($_SERVER['REMOTE_ADDR'] == "194.44.192.205") {
//             echo "<br>";
//             print_r($_SESSION);
//             echo $this->personal->hotel_id;
//             die();

        }
        $header_file_name = $this->get_Header_template_file_name();

        if ($this->personal->hotel_id == 10638 || $this->personal->hotel_id == 92) {
            $header_file_name = 'header_custom.html';
        }
        return $this->parser->parse("templates/booking/$header_file_name", $data, TRUE);
    }
    
    public function get_Header_template_file_name() {
//         0, null - header.html
//         1 - header_custom.html
//         2..n - header_custom_{N}.html

        $header_template_id = $this->session->userdata('header_template_id');
        if ($header_template_id) {
            switch ($header_template_id) {
                case 1:
                    $file_name = 'header_custom.html';
                    break;
                default:
                    $file_name = "header_custom_$header_template_id.html";
                    break;
            }
        }
        if (!isset($file_name) || !file_exists("application/views/templates/booking/$file_name")) {
            $file_name = 'header.html';
        }        
        return $file_name;
    }

    public function get_Footer() {
        $remote_adr = $_SERVER['REMOTE_ADDR'];
        $company_name = 'OTELMS.COM';
        $company_site_link = '//OTELMS.COM';
        if ($remote_adr == "109.70.24.230") {
            $company_name = 'Agast Technologies';
            $company_site_link = '//agast.ru';
        }
        $data = [
            'now_year' => date('Y'),
            'company_name' => $company_name,
            'company_site_link' => $company_site_link,
        ];
        return $this->parser->parse('templates/booking/footer.html', $data, TRUE);
    }

    public function get_faqs_pars_arr() {
        $hotel_id = $this->personal->hotel_id;
        $interface_lang_code = $this->mlanguages->interface_lang->code;
        $faqs_pars_arr = $faqs = [];
        $sql = "SELECT faq_descriptions.faq_id, faq_descriptions.value, faq_descriptions.name as international_type_name
                FROM  faq_descriptions
                WHERE faq_descriptions.hotel_id = $hotel_id AND faq_descriptions.language_id = $interface_lang_code";
        $query_res = $this->db->query($sql)->result();
        if ($query_res) {
            foreach ( $query_res as $row ) {
                switch ($row->international_type_name) {
                    case 'international_title' :
                        $faqs [$row->faq_id] ['title'] = $row->value;
                        break;
                    case 'international_description' :
                        $faqs [$row->faq_id] ['description'] = $row->value;
                        break;
                }
            }
            foreach ($faqs as $faq_id => $faq) {
                if (!isset($faq['title']) || $faq['title'] == ''){
                    unset($faqs[$faq_id]);
                }
            }
            $faqs_pars_arr = [['list'=>$faqs]];
        }
        return $faqs_pars_arr;
    }

    function get_rooms_data($incoming_data) {
        $hotel_id = $this->personal->hotel_id;
        $lang_code = $incoming_data['lang_code'] ?? $this->mlanguages->interface_lang->code;
        $lang_full_name = $this->mlanguages->interface_lang->name_lat;
        $categories = [];
        $filters = [];
        if (!empty($incoming_data['hms_free_rooms'])){
            $filters['meal_filter'] = [];
            $filters['payment_filter'] = [//key and id are ccforce
                0 => ['id'=>0,'name'=>'{clt_pay_upon_arrival}'],
                1 => ['id'=>1,'name'=>'{clt_payment_required}']
            ];
            $categories = $incoming_data['hms_free_rooms'];
            $requested_categories = $requested_rates = [];
            foreach ($categories as $category_id => &$category) {
                array_push($requested_categories, $category['category_id']);
                $category['name'] = "!! Category $category_id name NOT synchronized in $lang_full_name language !!";
                $category['description'] = "!! Category $category_id description NOT synchronized in $lang_full_name language !!";
                $category['clt_size_str'] = '';
                $category['category_size'] = '';
                $category['base_places'] = '';
                $category['add_places'] = '';
                $category['additional_places_str'] = '';
                $category['bed_id'] = 3;//by def
                $category['bed_name'] = '{-double_bed-}';//by def
                foreach ($category['rates'] as $rate) {
                    if (!in_array($rate['rate_id'], $requested_rates)){
                        array_push($requested_rates, $rate['rate_id']);
                    }
                }
            }
            unset($category);
            $requested_categories = implode (', ', $requested_categories);
            $requested_rates = implode (', ', $requested_rates);

            $categories_images = [];
            $sql = " SELECT id_position, category_id, id FROM `categories_images_c2` WHERE hotel_id = $hotel_id";
            $query_res = $this->db->query ($sql)->result();
            foreach ( $query_res as $row ) {
                $categories_images [$row->category_id]["images"][$row->id]["category_id"] = $row->category_id;
                $categories_images [$row->category_id]["images"][$row->id]["id_position"] = $row->id_position;
            }

            $categories_images_fototags = [];
            $sql = "SELECT category_fototags.*, fototags.name
                    FROM `category_fototags`
                    JOIN fototags ON fototags.id = category_fototags.tag_id
                    WHERE category_fototags.hotel_id = $hotel_id";
            $query_res = $this->db->query ( $sql )->result();
            foreach ( $query_res as $row ) {
                if(!isset($categories_images_fototags [$row->category_id][$row->foto_id]))
                    $categories_images_fototags [$row->category_id][$row->foto_id]["tag_name"] = "{-".$row->name."-}";
            }

            $meal_policies = [];
            $sql = "SELECT id, name FROM meal_policies";
            $query_res = $this->db->query ($sql)->result();
            foreach ( $query_res as $row ) {
                $meal_policies[$row->id]["name"] = $row->name;
            }

            $cancelation_policies = [];
            $sql = "SELECT id, type_id, name FROM dc_cancelationpolicy_list";
            $query_res = $this->db->query ($sql)->result();
            foreach ( $query_res as $row ) {
                $cancelation_policies[$row->id]["description"] = "{-".$row->name."_txt}";
                $cancelation_policies[$row->id]["type"] = $row->type_id == 2 ? '{-Free Cancellations-}' : '{-Non-Free Cancellations-}';
            }
            //======== GET RATES DESCRIPTIONS AND DETAILES FROM PERSONAL ==============
            $rates_descriptions = [];
            $sql = "SELECT t1.rate_id, t1.cancellation_policy_id, t1.meal_policy_id
                    FROM rate_details AS t1
                    WHERE t1.rate_id IN ($requested_rates) AND t1.hotel_id = $hotel_id";
            $query_res = $this->db->query ($sql)->result();
            foreach ( $query_res as $row ) {
                $rates_descriptions [$row->rate_id] ["cancellation_policy_id"] = $row->cancellation_policy_id;
                $rates_descriptions [$row->rate_id] ["meal_policy_id"] = $row->meal_policy_id ?? 1;
            }
            $sql = "SELECT t1.rate_id, t1.value, t1.name as international_type_name
                    FROM rate_descriptions AS t1
                    WHERE t1.rate_id IN ($requested_rates) AND t1.hotel_id = $hotel_id AND t1.language_id = $lang_code";
            $query_res = $this->db->query ($sql)->result();
            foreach ( $query_res as $row ) {
                switch ($row->international_type_name) {
                    case "international_name" :
                        $rates_descriptions [$row->rate_id] ['rate_name'] = ($row->value != "") ? $row->value : "!! Rate $row->rate_id name is empty in $lang_full_name language !!";
                        break;
                    case "international_description" :
                        $rates_descriptions [$row->rate_id] ['description'] = ($row->value != "") ? $row->value : "!! Rate $row->rate_id description is empty in $lang_full_name language !!";
                        break;
                }
            }
            //======== GET CATEGORIES DESCRIPTIONS AND DETAILES FROM PERSONAL  ==============
            $sql = "SELECT category_descriptions.category_id, category_descriptions.value, category_descriptions.name as international_type_name
                    FROM category_descriptions
                    WHERE category_descriptions.category_id IN ($requested_categories) AND category_descriptions.hotel_id = $hotel_id AND category_descriptions.language_id = $lang_code";
            $query_res = $this->db->query ($sql)->result();
            foreach ( $query_res as $row ) {
                switch ($row->international_type_name) {
                    case "international_name" :
                        $categories[$row->category_id]["name"] = ($row->value != "") ? $row->value : "!! Category $row->category_id name is empty in $lang_full_name language !!";
                        break;
                    case "international_comment" :
                        $categories[$row->category_id]["description"] = ($row->value != "") ? $this->shorting_text(['text'=>$row->value]) : "!! Category $row->category_id description is empty in $lang_full_name language !!";
                        break;
                }
            }
            $sql = "SELECT category_details.category_id, category_details.places, category_details.add_places, category_details.size, category_details.size_type, bed_id
                    FROM category_details
                    WHERE category_details.category_id IN ($requested_categories) AND category_details.hotel_id = $hotel_id";
            $query_res = $this->db->query ($sql)->result();
            foreach ( $query_res as $row ) {
                switch($row->size_type){
                    case 1:
                        $clt_size_str = "{clt_sq_m}";
                        break;
                    case 2:
                        $clt_size_str = "{clt_sq_ft}";
                        break;
                    default:
                        $clt_size_str = "{clt_sq_m}";
                        break;
                }
                $categories[$row->category_id]["clt_size_str"] = $clt_size_str;
                $categories[$row->category_id]["category_size"] = $row->size;
                $categories[$row->category_id]["base_places"] = $row->places;
                $categories[$row->category_id]["add_places"] = $row->add_places;
                $places_diff = $row->add_places - $row->places;
                $categories[$row->category_id]["additional_places_str"] = ($places_diff > 0) ? "+ ".($row->add_places - $row->places)." {clt_on_extra_bed}" : '';
                if ($row->bed_id) {
                    $categories[$row->category_id]["bed_id"] = $row->bed_id;
                    $query_bed_name_row = $this->db->select('clt_name')->get_where('bed_types', ['id' => $row->bed_id])->row();
                    if ($query_bed_name_row) {
                        $categories[$row->category_id]["bed_name"] = '{-'.$query_bed_name_row->clt_name.'-}';
                    }
                }
            }
            foreach ( $categories as $category_id => &$category_set ) {
                $category_set["amenities_list"] = $this->get_room_amenities_list(['category_id'=>$category_id]);
                $img_list = $carousel_indicators = [];
                if (isset ( $categories_images [$category_id] ["images"] )) {
                    $i = 0;
                    foreach ( $categories_images [$category_id] ["images"] as $foto_id => $cell) {
                        $img = $this->config->item ( 'foto_web_path' ) . $hotel_id . '_' . $category_id . '_' . $cell["id_position"] . '_500.jpg';
                        $imgSmall = $this->config->item ( 'foto_web_path' ) . $hotel_id . '_' . $category_id . '_' . $cell["id_position"] . '_100.jpg';
                        if ($img != "/images/pixel.jpg") {
                            $img_class_active = ($i == 0) ? 'active' : '';
                            array_push($img_list, array(
                                "category_id" => $category_id,
                                "img" => $img,
                                "small_img" => $imgSmall,
                                "image_id_position" => $cell["id_position"],
                                "image_inc" => $i,
                                "img_class_active" => $img_class_active,
                                "tag_name" => $categories_images_fototags[$category_id][$foto_id]["tag_name"] ?? ''
                            ));
                            array_push ( $carousel_indicators, array (
                                "image_inc" => $i,
                                "img_class_active" => $img_class_active
                            ) );
                        }
                        $i++;
                    }
                }
                $category_set["img_list"] = $img_list;
                $category_set["hidden_empty_foto_class"] = (count($img_list) == 0) ? 'd0' : '';
                $category_set["carousel_indicators"] = $carousel_indicators;
                foreach ( $category_set ["rates"] as $rate_id => &$rate_set ) {
                    $rate_set ["category_id"] = $category_id;
                    $rate_set ["rate_name"] = $rates_descriptions [$rate_id] ["rate_name"] ?? "!! Rate $rate_id name NOT synchronized in $lang_full_name language !!";
                    $rate_set ["description"] = $rates_descriptions [$rate_id] ["description"] ?? "!! Rate $rate_id description NOT synchronized in $lang_full_name language !!";
                    $rate_set ["amount"] = $this->mcurrency->fullvalue($rate_set ['price']);
                    $rate_set ["ccforce_text"] = ($rate_set["ccforce"] == 1) ? '{clt_payment_required}' : '{clt_pay_upon_arrival}';
                    $rate_set ["rate_rooms_remaining"] = $categories [$category_id]['rooms_remaining'];
                    $rate_set ["cancellation_policy_id"] = $rates_descriptions [$rate_id] ["cancellation_policy_id"] ?? 0;
                    $rate_set ["cancellation_policy_description"] = $cancelation_policies [$rate_set ["cancellation_policy_id"]] ["description"] ?? '{clt_no_cancellation_policy_desc}';
                    $rate_set ["cancellation_policy_type"] = $cancelation_policies [$rate_set ["cancellation_policy_id"]] ["type"] ?? '{-Free Cancellations-}';
                    $rate_set ["meal_policy_id"] = $rates_descriptions [$rate_id] ["meal_policy_id"] ?? 0;
                    $rate_set ["meal_policy_name"] = $meal_policies [$rate_set ["meal_policy_id"]] ["name"] ?? '{clt_no_meal_policy_name}';
                    $rate_set ["bed_name"] = $category_set['bed_name'];

                    $discount_pars_arr = [];
                    /*
                    'promoted' => $is_set_cat_rate_is_promoted,
                    'promo_data' => $is_set_cat_rate_is_promoted ? $promo_data : array(),
                    $promo_data['type_txt'] = $query_row->discount_type == 1 ? 'percent' : 'fixed';
                    $promo_data['type_id'] = $query_row->discount_type == 1 ? 1 : 2;
                    $promo_data['value'] = $query_row->discount_value;
                     */
                    if ($rate_set['promoted']) {
                        $promoted_amount = 0;
                        switch ($rate_set['promo_data']['type_txt']) {
                            case 'percent'://id = 1
                                $promoted_amount = $rate_set['price'] * (1 - $rate_set['promo_data']['value'] / 100);
                                $promoted_value = $rate_set['promo_data']['value']." %";
                                break;
                            case 'fixed'://id = 2
                                $promoted_amount = $rate_set ['price'] - $rate_set['promo_data']['value'];
                                $promoted_value = $this->mcurrency->fullvalue($rate_set['promo_data']['value']);
                                break;
                        }
                        array_push($discount_pars_arr, [
                            'amount' => $this->mcurrency->fullvalue($rate_set ['price']),
                            'value' => $promoted_value,
                        ]);
                        $rate_set ["amount"] = $this->mcurrency->fullvalue($promoted_amount);
                    }

                    $rate_set ['discount_pars_arr'] = $discount_pars_arr;

                    if (!isset($filters['meal_filter'][$rate_set ["meal_policy_id"]])){
                        $filters['meal_filter'][$rate_set ["meal_policy_id"]] = ['id'=>$rate_set ["meal_policy_id"], 'name'=>$rate_set ["meal_policy_name"]];
                    }
                    $rate_set ["metadata"] = base64_encode(json_encode([
                        'rooms_amount' => $rate_set['price'],
                        'payment_required' => [
                            'ccforce' => $rate_set['ccforce'],
                            'ccamount_type' => $rate_set['ccamount_type'],
                            'ccamount' => $rate_set['ccamount']
                        ],
                        'promoted' => $rate_set['promoted'],
                        'promo_data' => $rate_set['promo_data']
                    ]));
                }
                unset($rate_set);
            }
            unset($category_set);
        }
        return ['rooms_list'=>$categories, 'filters'=>$filters];
    }
    
    public function get_proprooms_data($incoming_data) {
        $hotel_id = $this->personal->hotel_id;
        $lang_code = $incoming_data['lang_code'] ?? $this->mlanguages->interface_lang->code;
        $lang_full_name = $this->mlanguages->interface_lang->name_lat;
        $categories = [];
        $filters = [];
        if (!empty($incoming_data['hms_free_proprooms'])){
            $filters['meal_filter'] = [];
            $filters['payment_filter'] = [//key and id are ccforce
                0 => ['id'=>0,'name'=>'{clt_pay_upon_arrival}'],
                1 => ['id'=>1,'name'=>'{clt_payment_required}']
            ];
            $categories = $incoming_data['hms_free_proprooms'];
            $requested_categories = $requested_rates = [];
            foreach ($categories as $category_id => &$category) {
                array_push($requested_categories, $category['category_id']);
                $category['name'] = "!! Category $category_id name NOT synchronized in $lang_full_name language !!";
                $category['description'] = "!! Category $category_id description NOT synchronized in $lang_full_name language !!";
                $category['clt_size_str'] = '';
                $category['category_size'] = '';
                $category['base_places'] = '';
                $category['add_places'] = '';
                $category['additional_places_str'] = '';
                $category['bed_id'] = 3;//by def
                $category['bed_name'] = '{-double_bed-}';//by def
                foreach ($category['rates'] as $rate) {
                    if (!in_array($rate['rate_id'], $requested_rates)){
                        array_push($requested_rates, $rate['rate_id']);
                    }
                }
            }
            unset($category);
            $requested_categories = implode (', ', $requested_categories);
            $requested_rates = implode (', ', $requested_rates);
            
            $categories_images = [];
            $sql = " SELECT id_position, category_id, id FROM `categories_images_c2` WHERE hotel_id = $hotel_id";
            $query_res = $this->db->query ($sql)->result();
            foreach ( $query_res as $row ) {
                $categories_images [$row->category_id]["images"][$row->id]["category_id"] = $row->category_id;
                $categories_images [$row->category_id]["images"][$row->id]["id_position"] = $row->id_position;
            }
            
            $categories_images_fototags = [];
            $sql = "SELECT category_fototags.*, fototags.name
            FROM `category_fototags`
            JOIN fototags ON fototags.id = category_fototags.tag_id
            WHERE category_fototags.hotel_id = $hotel_id";
            $query_res = $this->db->query ( $sql )->result();
            foreach ( $query_res as $row ) {
                if(!isset($categories_images_fototags [$row->category_id][$row->foto_id]))
                    $categories_images_fototags [$row->category_id][$row->foto_id]["tag_name"] = "{-".$row->name."-}";
            }
            
            $meal_policies = [];
            $sql = "SELECT id, name FROM meal_policies";
            $query_res = $this->db->query ($sql)->result();
            foreach ( $query_res as $row ) {
                $meal_policies[$row->id]["name"] = $row->name;
            }
            
            $cancelation_policies = [];
            $sql = "SELECT id, type_id, name FROM dc_cancelationpolicy_list";
            $query_res = $this->db->query ($sql)->result();
            foreach ( $query_res as $row ) {
                $cancelation_policies[$row->id]["description"] = "{-".$row->name."_txt}";
                $cancelation_policies[$row->id]["type"] = $row->type_id == 2 ? '{-Free Cancellations-}' : '{-Non-Free Cancellations-}';
            }
            //======== GET RATES DESCRIPTIONS AND DETAILES FROM PERSONAL ==============
            $rates_descriptions = [];
            $sql = "SELECT t1.rate_id, t1.cancellation_policy_id, t1.meal_policy_id
            FROM rate_details AS t1
            WHERE t1.rate_id IN ($requested_rates) AND t1.hotel_id = $hotel_id";
            $query_res = $this->db->query ($sql)->result();
            foreach ( $query_res as $row ) {
                $rates_descriptions [$row->rate_id] ["cancellation_policy_id"] = $row->cancellation_policy_id;
                $rates_descriptions [$row->rate_id] ["meal_policy_id"] = $row->meal_policy_id ?? 1;
            }
            $sql = "SELECT t1.rate_id, t1.value, t1.name as international_type_name
            FROM rate_descriptions AS t1
            WHERE t1.rate_id IN ($requested_rates) AND t1.hotel_id = $hotel_id AND t1.language_id = $lang_code";
            $query_res = $this->db->query ($sql)->result();
            foreach ( $query_res as $row ) {
                switch ($row->international_type_name) {
                    case "international_name" :
                        $rates_descriptions [$row->rate_id] ['rate_name'] = ($row->value != "") ? $row->value : "!! Rate $row->rate_id name is empty in $lang_full_name language !!";
                        break;
                    case "international_description" :
                        $rates_descriptions [$row->rate_id] ['description'] = ($row->value != "") ? $row->value : "!! Rate $row->rate_id description is empty in $lang_full_name language !!";
                        break;
                }
            }
            //======== GET CATEGORIES DESCRIPTIONS AND DETAILES FROM PERSONAL  ==============
            $sql = "SELECT category_descriptions.category_id, category_descriptions.value, category_descriptions.name as international_type_name
            FROM category_descriptions
            WHERE category_descriptions.category_id IN ($requested_categories) AND category_descriptions.hotel_id = $hotel_id AND category_descriptions.language_id = $lang_code";
            $query_res = $this->db->query ($sql)->result();
            foreach ( $query_res as $row ) {
                switch ($row->international_type_name) {
                    case "international_name" :
                        $categories[$row->category_id]["name"] = ($row->value != "") ? $row->value : "!! Category $row->category_id name is empty in $lang_full_name language !!";
                        break;
                    case "international_comment" :
                        $categories[$row->category_id]["description"] = ($row->value != "") ? $this->shorting_text(['text'=>$row->value]) : "!! Category $row->category_id description is empty in $lang_full_name language !!";
                        break;
                }
            }
            $sql = "SELECT category_details.category_id, category_details.places, category_details.add_places, category_details.size, category_details.size_type, bed_id
            FROM category_details
            WHERE category_details.category_id IN ($requested_categories) AND category_details.hotel_id = $hotel_id";
            $query_res = $this->db->query ($sql)->result();
            foreach ( $query_res as $row ) {
                switch($row->size_type){
                    case 1:
                        $clt_size_str = "{clt_sq_m}";
                        break;
                    case 2:
                        $clt_size_str = "{clt_sq_ft}";
                        break;
                    default:
                        $clt_size_str = "{clt_sq_m}";
                        break;
                }
                $categories[$row->category_id]["clt_size_str"] = $clt_size_str;
                $categories[$row->category_id]["category_size"] = $row->size;
                $categories[$row->category_id]["base_places"] = $row->places;
                $categories[$row->category_id]["add_places"] = $row->add_places;
                $places_diff = $row->add_places - $row->places;
                $categories[$row->category_id]["additional_places_str"] = ($places_diff > 0) ? "+ ".($row->add_places - $row->places)." {clt_on_extra_bed}" : '';
                if ($row->bed_id) {
                    $categories[$row->category_id]["bed_id"] = $row->bed_id;
                    $query_bed_name_row = $this->db->select('clt_name')->get_where('bed_types', ['id' => $row->bed_id])->row();
                    if ($query_bed_name_row) {
                        $categories[$row->category_id]["bed_name"] = '{-'.$query_bed_name_row->clt_name.'-}';
                    }
                }
            }
            foreach ( $categories as $category_id => &$category_set ) {
                $rooms_remaining_counting_arr = [];
                /*[property_id] => 5
                [property_dwelling] => 2 - multy
                [property_type] => 13 13 - hostel */
                $accommodation_option_clt = $category_set['property_type'] == 13 ? 'clt_place_s' : 'clt_room_s';
                $free_rooms_remaining_clt = '{'.$accommodation_option_clt . $this->get_clt_variant_or_clt_ending([
                    'val' => $category_set['rooms_remaining'],
                    'clts' => [],
                    'return_type' => 1
                ]) . '}';//'{clt_free_rooms}';
                foreach (range(1, $category_set['rooms_remaining']) as $room_remaining_number) {
                    array_push($rooms_remaining_counting_arr, [
                        'room_number' => $room_remaining_number,
                        'rooms_clt_var' => '{'. $accommodation_option_clt . $this->get_clt_variant_or_clt_ending([
                            'val' => $room_remaining_number,
                            'clts' => [],
                            'return_type' => 1
                        ]) . '}'
                    ]);
                }
                $category_set["amenities_list"] = $this->get_room_amenities_list(['category_id'=>$category_id]);
                $category_set['amenities'] = $this->content->get_room_amenities_by_type(['category_id'=>$category_id]);
                $img_list = $carousel_indicators = [];
                if (isset ( $categories_images [$category_id] ["images"] )) {
                    $i = 0;
                    foreach ( $categories_images [$category_id] ["images"] as $foto_id => $cell) {
                        $img = $this->config->item ( 'foto_web_path' ) . $hotel_id . '_' . $category_id . '_' . $cell["id_position"] . '_500.jpg';
                        $imgSmall = $this->config->item ( 'foto_web_path' ) . $hotel_id . '_' . $category_id . '_' . $cell["id_position"] . '_100.jpg';
                        if ($img != "/images/pixel.jpg") {
                            $img_class_active = ($i == 0) ? 'active' : '';
                            array_push($img_list, array(
                                "category_id" => $category_id,
                                "img" => $img,
                                "small_img" => $imgSmall,
                                "image_id_position" => $cell["id_position"],
                                "image_inc" => $i,
                                "img_class_active" => $img_class_active,
                                "tag_name" => $categories_images_fototags[$category_id][$foto_id]["tag_name"] ?? ''
                            ));
                            array_push ( $carousel_indicators, array (
                                "image_inc" => $i,
                                "img_class_active" => $img_class_active
                            ) );
                        }
                        $i++;
                    }
                }
                $category_set["img_list"] = $img_list;
                $category_set["hidden_empty_foto_class"] = (count($img_list) == 0) ? 'd0' : '';
                $category_set["carousel_indicators"] = $carousel_indicators;
                foreach ( $category_set ["rates"] as $rate_id => &$rate_set ) {
                    $is_rate_promoted = false;
                    if (isset($rate_set['promoted']) && $rate_set['promoted']) {
                        $is_rate_promoted = true;
                    }
                    if (isset($rate_set['occupancy'])) {
                        $default_occupancy_places = 2;
                        $default_occupancy_places_was_checked = false;
                        foreach ($rate_set['occupancy'] as $occupancy_set_key => &$occupancy_set) {
                            $occupancy_set['default_checked'] = '';
                            $occupancy_set['default_checked_class'] = '';
                            if ($occupancy_set['occupancy_places'] == $default_occupancy_places) {
                                $default_occupancy_key = $occupancy_set_key;
                                $default_occupancy_places_was_checked = true;
                            }
                            
                            if ($is_rate_promoted) {
                                $occupancy_set['beforepromo_price'] = $occupancy_set['price'];
                                $occupancy_set['beforepromo_price_full_str'] = $this->mcurrency->fullvalue($occupancy_set['price']);
                                $promoted_occupancy_price = 0;
                                switch ($rate_set['promo_data']['type_txt']) {
                                    case 'percent'://id = 1
                                        $promoted_occupancy_price = $occupancy_set['price'] * (1 - $rate_set['promo_data']['value'] / 100);
                                        $promoted_value = $rate_set['promo_data']['value']." %";
                                        break;
                                    case 'fixed'://id = 2
                                        $promoted_occupancy_price = $occupancy_set['price'] - $rate_set['promo_data']['value'];
                                        $promoted_value = $this->mcurrency->fullvalue($rate_set['promo_data']['value']);
                                        break;
                                }
                                $occupancy_set['price'] = $promoted_occupancy_price;
                            }
                            $occupancy_set["metadata"] = base64_encode(json_encode([
                                'beforepromo_price' => isset($occupancy_set['beforepromo_price']) ? $occupancy_set['beforepromo_price'] : 0,
                                'price' => $occupancy_set['price'],
                                'payment_required' => [
                                    'ccforce' => $rate_set['ccforce'],
                                    'ccamount_type' => $rate_set['ccamount_type'],
                                    'ccamount' => $rate_set['ccamount']
                                ],
                                'promoted' => $is_rate_promoted,
                                'promo_data' => $is_rate_promoted ? $rate_set['promo_data'] : []
                            ]));
                            $occupancy_set['price'] = $this->mcurrency->fullvalue( $occupancy_set ['price'] );
                        }
                        unset($occupancy_set);
                        if (! $default_occupancy_places_was_checked) {
                            $default_occupancy_key = array_keys($rate_set['occupancy'])[0];
                        }
                        $rate_set['occupancy'][$default_occupancy_key]['default_checked_class'] = 'default_chioce_indicator';
                        $rate_set['occupancy'][$default_occupancy_key]['default_checked'] = 'checked';
                        $rate_set ['price'] = $rate_set['occupancy'][$default_occupancy_key]['price'];
                    }else {
                        $rate_set ['price'] = $category_set['base_price'];
                        if ($is_rate_promoted) {
                            $promoted_amount = 0;
                            switch ($rate_set['promo_data']['type_txt']) {
                                case 'percent'://id = 1
                                    $promoted_amount = $rate_set['price'] * (1 - $rate_set['promo_data']['value'] / 100);
                                    $promoted_value = $rate_set['promo_data']['value']." %";
                                    break;
                                case 'fixed'://id = 2
                                    $promoted_amount = $rate_set ['price'] - $rate_set['promo_data']['value'];
                                    $promoted_value = $this->mcurrency->fullvalue($rate_set['promo_data']['value']);
                                    break;
                            }
                            $beforepromo_price = $rate_set ['price'];
                            $rate_set ['price'] = $promoted_amount;
                        }
                    }
                    
                    $rate_set ["category_id"] = $category_id;
                    $rate_set ["rate_name"] = $rates_descriptions [$rate_id] ["rate_name"] ?? "!! Rate $rate_id name NOT synchronized in $lang_full_name language !!";
                    $rate_set ["description"] = $rates_descriptions [$rate_id] ["description"] ?? "!! Rate $rate_id description NOT synchronized in $lang_full_name language !!";
                    $rate_set ["amount"] = isset($default_occupancy_key) ? $rate_set ['price'] : $this->mcurrency->fullvalue( $rate_set ['price'] );
                    $rate_set ["ccforce_text"] = ($rate_set["ccforce"] == 1) ? '{clt_payment_required}' : '{clt_pay_upon_arrival}';
                    $rate_set ["rate_rooms_remaining"] = $categories [$category_id]['rooms_remaining'];
                    $rate_set ["cancellation_policy_id"] = $rates_descriptions [$rate_id] ["cancellation_policy_id"] ?? 0;
                    $rate_set ["cancellation_policy_description"] = $cancelation_policies [$rate_set ["cancellation_policy_id"]] ["description"] ?? '{clt_no_cancellation_policy_desc}';
                    $rate_set ["cancellation_policy_type"] = $cancelation_policies [$rate_set ["cancellation_policy_id"]] ["type"] ?? '{-Free Cancellations-}';
                    $rate_set ["meal_policy_id"] = $rates_descriptions [$rate_id] ["meal_policy_id"] ?? 0;
                    $rate_set ["meal_policy_name"] = $meal_policies [$rate_set ["meal_policy_id"]] ["name"] ?? '{clt_no_meal_policy_name}';
                    $rate_set ['rooms_remaining_counting_arr'] = $rooms_remaining_counting_arr;
                    $rate_set ["bed_name"] = $category_set['bed_name'];
                    $rate_set ['free_rooms_remaining_clt'] = $free_rooms_remaining_clt;
                    
                    $discount_pars_arr = [];
                    if ($is_rate_promoted) {
                        $rate_promoted_amount = isset($default_occupancy_key) ? $rate_set['occupancy'][$default_occupancy_key]['beforepromo_price'] : $beforepromo_price;
                        array_push($discount_pars_arr, [
                            'amount' => $this->mcurrency->fullvalue($rate_promoted_amount),
                            'value' => $promoted_value,
                        ]);
                    }
                    $rate_set ['discount_pars_arr'] = $discount_pars_arr;
                    
                    if (!isset($filters['meal_filter'][$rate_set ["meal_policy_id"]])){
                        $filters['meal_filter'][$rate_set ["meal_policy_id"]] = ['id'=>$rate_set ["meal_policy_id"], 'name'=>$rate_set ["meal_policy_name"]];
                    }
                    $rate_set ["metadata"] = base64_encode(json_encode([
                        'rooms_amount' => $rate_set['price'],
                        'payment_required' => [
                            'ccforce' => $rate_set['ccforce'],
                            'ccamount_type' => $rate_set['ccamount_type'],
                            'ccamount' => $rate_set['ccamount']
                        ],
                        'promoted' => $is_rate_promoted,
                        'promo_data' => $is_rate_promoted ? $rate_set['promo_data'] : []
                    ]));
                }
                unset($rate_set);
            }
            unset($category_set);
        }
        return ['rooms_list'=>$categories, 'filters'=>$filters];
    }

    public function get_curl_freerooms($incoming_data) {
        $data_curl = json_encode ($incoming_data);
        $hms_host = $this->personal->hms_host;
        $url_curl = "https://$hms_host/gateway_pmv3/get_freerooms/";
        $result_curl = $this->curl_model->CurlPlugRaw ( $data_curl, $url_curl );

        $result = json_decode ( $result_curl, true );
        if (isset($result['debug'])) {
            $debug_data = $this->session->userdata('debug_data');
            $debug_data['get_curl_freerooms']['request'] = $incoming_data;
            $debug_data['get_curl_freerooms']['debug'] = $result['debug'];
            $this->session->set_userdata(['debug_data' => $debug_data]);
        }
        return json_decode ( $result_curl, true );
    }
    
    public function get_freeprops($incoming_data) {
        return $this->get_freeprops_by_curl_from_system($incoming_data);
    }
    
    public function get_freeprops_by_curl_from_system($incoming_data) {
        $data_curl = json_encode ($incoming_data);
        $hms_host = $this->personal->hms_host;
        $url_curl = "https://$hms_host/gateway_pmv3/get_freeprops/";
        $result_curl = $this->curl_model->CurlPlugRaw ( $data_curl, $url_curl );
        
        $result = json_decode ( $result_curl, true );
        if (isset($result['debug'])) {
            $debug_data = $this->session->userdata('debug_data');
            $debug_data['get_curl_freeprops']['request'] = $incoming_data;
            $debug_data['get_curl_freeprops']['debug'] = $result['debug'];
            $this->session->set_userdata(['debug_data' => $debug_data]);
        }
        return $result;
    }

    public function get_services_data($incoming_data = []) {
        $hotel_id = $incoming_data['hotel_id'] ?? $this->personal->hotel_id;
        $lang_code = $incoming_data['lang_code'] ?? $this->mlanguages->interface_lang->code;
        $servicesList = [];
        $sql = "SELECT service_details.hotel_id, service_details.service_id, service_details.price, service_descriptions.name as name_type,
                service_descriptions.value
                FROM service_details
                LEFT JOIN service_descriptions ON service_details.service_id = service_descriptions.service_id AND service_details.hotel_id = service_descriptions.hotel_id
                WHERE service_descriptions.language_id = ".$lang_code." AND service_details.hotel_id = $hotel_id";

        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $servicesList [$row->service_id]["service_id"] = $row->service_id;
                switch($row->name_type){
                    case "international_name";
                    $servicesList [$row->service_id]["service_name"] = $row->value;
                    break;
                    case "international_description";
                    $servicesList [$row->service_id]["service_description"] = $row->value;
                    break;
                }
                $servicesList [$row->service_id]["service_price"] = $row->price;
                $servicesList [$row->service_id]["service_qty"] = 1;
                $servicesList [$row->service_id]["metadata"] = base64_encode(json_encode(['service_price'=>$row->price, 'service_qty'=>1]));;
                $servicesList [$row->service_id]["service_baseprice"] = $this->mcurrency->fullvalue($row->price);
                $servicesList [$row->service_id]["service_image_url"] = $this->get_service_image_url(['hotel_id'=>$hotel_id, 'service_id'=>$row->service_id]);
            }
        }
        return $servicesList;
    }

    public function check_services_availability($incoming_data = []) {
        $hotel_id = $this->personal->hotel_id;
        $sql = "SELECT service_id FROM service_details WHERE service_details.hotel_id = $hotel_id";
        $available_servicesList = $this->db->query ( $sql )->result_array();
        return $available_servicesList;
    }

    public function get_service_image_url($in_data) {//['hotel_id'=>$hotel_id, 'service_id'=>$row->service_id]

//        $url = '../static/service2.png';
        $service_id = $in_data['service_id'];
        $hotel_id = $in_data['hotel_id'];
        $url = '/images/bell.jpg';
        $query_image_exist_row = $this->db->query ( "SELECT service_id  FROM service_images WHERE hotel_id = $hotel_id AND service_id  = $service_id" )->row();
        if ($query_image_exist_row) {
            $url = "/view_images/service/$service_id";
        }
        return $url;
    }

    public function get_room_details($incoming_data) {
        $hotel_id = $incoming_data['hotel_id'] ?? $this->personal->hotel_id;
        $category_id = $incoming_data['category_id'] ?? 0;
        $details = $this->db->select('check_in_time AS checkin_time, check_out_time AS checkout_time')
            ->from('property_information')
            ->join('category_details', "category_details.property_id = property_information.property_id")
            ->where([
            'category_details.hotel_id' => $hotel_id,
            'category_details.category_id' => $category_id,
            'property_information.hotel_id' => $hotel_id
        ])
            ->get()->row();
        return $details;
    }

    public function get_room_descriptions($incoming_data) {
        $hotel_id = $incoming_data['hotel_id'] ?? $this->personal->hotel_id;
        $lang_code = $incoming_data['lang_code'] ?? $this->mlanguages->interface_lang->code;
        $lang_full_name = $this->mlanguages->interface_lang->name_lat;
        $category_id = $incoming_data['category_id'] ?? 0;
        $result = [
            "name" => "!! Category $category_id name NOT synchronized in $lang_full_name language !!",
            "description" => "!! Category $category_id description NOT synchronized in $lang_full_name language !!"
        ];
        $sql = "SELECT category_descriptions.value, category_descriptions.name as international_type_name
                FROM category_descriptions
                WHERE category_descriptions.category_id = $category_id AND category_descriptions.hotel_id = $hotel_id AND category_descriptions.language_id = $lang_code";
        $query_result = $this->db->query ( $sql )->result();
        foreach ($query_result as $query_row) {
            switch ($query_row->international_type_name) {
                case "international_name" :
                    $result["name"] = ($query_row->value != "") ? $query_row->value : "!! Category $category_id name is empty in $lang_full_name language !!";
                    break;
                case "international_comment" :
                    $result["description"] = ($query_row->value != "") ? $query_row->value : "!! Category $category_id description is empty in $lang_full_name language !!";
                    break;
            }
        }
        $sql = "SELECT category_details.places, category_details.add_places, category_details.size, category_details.size_type
                FROM category_details
                WHERE category_details.category_id = $category_id AND category_details.hotel_id = $hotel_id";
        $query_row = $this->db->query ( $sql )->row();
        if ($query_row) {
            switch($query_row->size_type){
                case 1:
                    $clt_size_str = "{clt_sq_m}";
                    break;
                case 2:
                    $clt_size_str = "{clt_sq_ft}";
                    break;
                default:
                    $clt_size_str = "{clt_sq_m}";
                    break;
            }
            $result["clt_size_str"] = $clt_size_str;
            $result["category_size"] = $query_row->size;
            $result["base_places"] = $query_row->places;
            $result["add_places"] = $query_row->add_places;
            $places_diff = $query_row->add_places - $query_row->places;
            $result["additional_places_str"] = ($places_diff > 0) ? "+ $places_diff {clt_on_extra_bed}" : "";
            $result['images'] = $this->get_room_imgs(['category_id'=>$category_id]);
        }
        return $result;
    }

    public function get_rate_descriptions($incoming_data) {
        $hotel_id = $incoming_data['hotel_id'] ?? $this->personal->hotel_id;
        $lang_code = $incoming_data['lang_code'] ?? $this->mlanguages->interface_lang->code;
        $lang_full_name = $this->mlanguages->interface_lang->name_lat;
        $rate_id = $incoming_data['rate_id'] ?? 0;
        $result = [
            "name" => "!! Rate $rate_id name NOT synchronized in $lang_full_name language !!",
            "description" => "!! Rate $rate_id description NOT synchronized in $lang_full_name language !!"
        ];
        $sql = "SELECT t1.rate_id, t1.value, t1.name as international_type_name
                FROM rate_descriptions AS t1
                WHERE t1.rate_id = $rate_id AND t1.hotel_id = $hotel_id AND t1.language_id = $lang_code";
        $query_res = $this->db->query ($sql)->result();
        foreach ( $query_res as $row ) {
            switch ($row->international_type_name) {
                case "international_name" :
                    $result["name"] = ($row->value != "") ? $row->value : "!! Rate $row->rate_id name is empty in $lang_full_name language !!";
                    break;
                case "international_description" :
                    $result["description"] = ($row->value != "") ? $row->value : "!! Rate $row->rate_id description is empty in $lang_full_name language !!";
                    break;
            }
        }
        $sql = "SELECT  t2.ccforce,
                        t3.name as cancellation_policy,
                        t4.name as meal_policy
                FROM rate_details as t2
                LEFT JOIN dc_cancelationpolicy_list as t3 ON t3.id = t2.cancellation_policy_id
                LEFT JOIN meal_policies as t4 ON t4.id = t2.meal_policy_id
                WHERE t2.rate_id = $rate_id AND t2.hotel_id = $hotel_id";
        $query_result = $this->db->query ( $sql )->result();
        foreach ($query_result as $query_row) {
            $result ["cancellation_policy"] = "{-$query_row->cancellation_policy-}";
            $result ["meal_policy"] = $query_row->meal_policy;
            $result ["ccforce"] = $query_row->ccforce;
        }
        return $result;
    }

    public function get_room_amenities_by_type($incoming_data) {
        $hotel_id = $incoming_data['hotel_id'] ?? $this->personal->hotel_id;
        $category_id = $incoming_data['category_id'] ?? 0;
        $result = [];
        $sql = "SELECT category2amenities.category_id, category_amenety_type.id as amenity_type_id,
        category_amenety_type.name as amenity_type_name, category_ameneties.class_name as amenity_class_name,
        category_ameneties.id as amenity_id, category_ameneties.name as amenity_name, category_ameneties.img_name as amenity_img
        FROM category2amenities
        INNER JOIN category_ameneties ON category_ameneties.id = category2amenities.amenity_id
        INNER JOIN category_amenety_type ON category_amenety_type.id = category_ameneties.type_id
        WHERE category2amenities.hotel_id = $hotel_id AND category2amenities.category_id = $category_id";
        $query_res = $this->db->query ( $sql )->result ();
        if ($query_res) {
            foreach ( $query_res as $row ) {
                $result [$row->amenity_type_id]["amenity_type_id"] = $row->amenity_type_id;
                $result [$row->amenity_type_id]["amenity_type_name"] = "{-".$row->amenity_type_name."-}";
                $result [$row->amenity_type_id]["amenity_class_name"] = $row->amenity_class_name;
                $result [$row->amenity_type_id]["type_amenities"][$row->amenity_id]["amenity_img"] = $row->amenity_img;
                $result [$row->amenity_type_id]["type_amenities"][$row->amenity_id]["amenity_id"] = $row->amenity_id;
                $result [$row->amenity_type_id]["type_amenities"][$row->amenity_id]["amenity_name"] = "{-".$row->amenity_name."-}";
            }
        }
        return $result;
    }

    public function get_room_amenities_list($incoming_data) {
        $hotel_id = $incoming_data['hotel_id'] ?? $this->personal->hotel_id;
        $category_id = $incoming_data['category_id'] ?? 0;
        $result = [];
        $sql = "SELECT /* t2.class_name, */ t2.id, t2.name, t2.img_name
        FROM category2amenities as t1
        JOIN category_ameneties as t2 ON t2.id = t1.amenity_id
        WHERE t1.hotel_id = $hotel_id AND t1.category_id = $category_id LIMIT 10";
        $result = $this->db->query ( $sql )->result ();
        return $result;
    }

    public function get_hotel_header_pars_data (){
        $hotel_id = $this->personal->hotel_id;
        $lang_code = $this->mlanguages->interface_lang->code;
        $url_to_website = $this->personal->url_to_website;
        $data = (object) [
            'name' => '',
            'address' => '',
            'phone' => '',
            'email' => '',
            'url_to_website' => substr_count($url_to_website, 'http') ? $url_to_website : "http://$url_to_website",
            'url_to_website_vis_class' => $url_to_website ? '' : 'd0',
        ];
        $address = [
            'country' => '',
            'city' => '',
            'street' => '',
            'post_code' => ''
        ];
        $sql = "SELECT * FROM property_information WHERE hotel_id = $hotel_id LIMIT 0, 1";
        $hotel_query_row = $this->db->query($sql)->row();
        foreach ($address as $fild => $value) {
            $address[$fild] = isset($hotel_query_row->$fild) ? $hotel_query_row->$fild : "";
        }
        $sql_country = "SELECT NAME_LAT, native_name FROM dic_country WHERE id LIKE '" . strtolower($address['country']) . "'";
        $country_query_row = $this->db->query($sql_country)->row();
        $address['country'] = $country_query_row->native_name;
        $data->address = implode(', ', $address);
        $data->phone = $hotel_query_row->reception_phone;
        $data->email = $hotel_query_row->email;
        $data->images = $this->get_hotel_imgs();
        $data->logo_img = $this->get_hotel_logo_img();
        $sql_property_international_name = "SELECT value FROM property_descriptions WHERE hotel_id = $hotel_id AND property_id = $hotel_query_row->property_id AND language_id = $lang_code AND name LIKE 'international_name'";
        $query_property_international_name_row = $this->db->query ( $sql_property_international_name )->row();

        $data->name = $query_property_international_name_row->value ?? $hotel_query_row->property_name;
        return $data;
    }

    public function get_parties_icons_pars_arr($parties = []) {
        foreach ($parties as &$party) {
            $party['adults'] = array_fill(1, $party['adults'], []);
            $party['children'] = array_fill(1, count($party['children']), []);
            $party['plus_icon'] = count($party['children']) ? [0=>[]] : [];
        }
        return $parties;
    }

    public function get_reviews($block_type = "block_2") {
        $hotel_id = $this->personal->hotel_id;
        $query = $this->db->select('body, dc_id')->get_where('hms_reviews', ['hms_id'=>$hotel_id, $block_type => 1])->result();
        $reviews = [];
        foreach ($query as $row) {
            $review = json_decode($row->body, true);
            if ($row->dc_id == 1) {
                $cell = [];
                $cell['reviewer_name'] = $review['reviewer']['name'] ?? "anonymous";
                $cell['content_headline'] = $review['content']['headline'] ?? "";
                $cell['content_positive'] = $review['content']['positive'] ?? "";
                $cell['content_negative'] = $review['content']['negative'] ?? "";
                $cell['date'] = $review['created_timestamp'] ?? "";
                $cell['review_score'] = $review['scoring']['review_score'] ?? "";
                $total = 0;
                $count = 0;
                foreach ($review['scoring'] as $arg) {
                    $total += $arg;
                    $count++;
                }
                $cell['review_score'] = number_format($total / $count, 1, ".", "");
                array_push($reviews, $cell);
            }

            if ($row->dc_id == 0) {
                $cell = [];
                $cell['reviewer_name'] = $review['reviewer']['name'] ?? "anonymous";
                $cell['content_headline'] = $review['content']['headline'] ?? "";
                $cell['content_positive'] = $review['experience_text'] ?? "";
                $cell['content_negative'] = $review['content']['negative'] ?? "";
                $cell['date'] = $review['created_timestamp'] ?? "";
                $cell['review_score'] = $review['experience_value'] ?? "";

                $cell['review_score'] = number_format($cell['review_score'], 1, ".", "");
                array_push($reviews, $cell);
            }
            //return $reviews;
        }
        return $reviews;
    }

    public function get_hotel_imgs() {
        $hotel_id = $this->personal->hotel_id;
        $tbl = 'property_images';
        $web_path = $this->config->item ('foto_web_path');
        $imgs_prop = $imgs_cat = [];
        $query_res = $this->db->select('id_position as pos, property_id as prop')->get_where($tbl, ['hotel_id' => $hotel_id])->result();
        if($query_res){
            $imgs_prop = $query_res;
            foreach ($imgs_prop as &$img) {
                $img->small_img = $web_path.$hotel_id.'_'.$img->prop.'_'.$img->pos.'prop_100.jpg';
                $img->big_img = $web_path.$hotel_id.'_'.$img->prop.'_'.$img->pos.'prop_500.jpg';
            }
        }
        $tbl = 'categories_images_c2';
        $query_res = $this->db->select('id_position as pos, category_id as cat')->get_where($tbl, ['hotel_id' => $hotel_id])->result();
        if($query_res){
            $imgs_cat = $query_res;
            foreach ($imgs_cat as &$img) {
                $img->small_img = $web_path.$hotel_id.'_'.$img->cat.'_'.$img->pos.'_100.jpg';
                $img->big_img = $web_path.$hotel_id.'_'.$img->cat.'_'.$img->pos.'_500.jpg';
            }
        }
        return array_merge($imgs_prop, $imgs_cat);
    }

    public function get_hotel_logo_img() {
        $logo_img = 'https://fr-online-booking.otelms.com/himages/92_2_logo_original.jpg';//sunset & man with his car, forever architector logo!
        $hotel_id = $this->personal->hotel_id;
        $tbl = 'property_information';
        $query_row = $this->db->select('property_id as prop')->order_by('property_id ASC')->get_where($tbl, ['hotel_id' => $hotel_id])->row();
        if($query_row){
            $web_path = $this->config->item ('foto_web_path');
            $logo_img = $web_path.$hotel_id.'_'.$query_row->prop.'_logo_original.jpg';
        }
        return $logo_img;
    }

    public function get_room_imgs($incoming_data = []) {
        $cat = $incoming_data['category_id'] ?? 0;
        $hotel_id = $this->personal->hotel_id;
        $tbl = 'categories_images_c2';
        $imgs = [];
        $query_res = $this->db->select('id_position as pos')->get_where($tbl, ['hotel_id' => $hotel_id, 'category_id' => $cat])->result();
        if($query_res){
            $web_path = $this->config->item ('foto_web_path');
            $imgs = $query_res;
            foreach ($imgs as &$img) {
                $img->small_img = $web_path.$hotel_id.'_'.$cat.'_'.$img->pos.'_100.jpg';
                $img->big_img = $web_path.$hotel_id.'_'.$cat.'_'.$img->pos.'_500.jpg';
            }
        }
        return $imgs;
    }

    public function shorting_text($inc = ['text'=>'', 'len']) {
        $def_len = 480;//for room description
        $t = (object) $inc;
        $t->len = $t->len ?? $def_len;
        if (strlen($t->text) > $t->len){
            $t->text = substr($t->text, 0, strrpos(substr($t->text, 0, $t->len), ' ', -1)).' ...';
        }
        return $t->text;
    }

    public function get_page_title_pars_data (){
        $hotel_id = $this->personal->hotel_id;
        $lang_code = $this->mlanguages->interface_lang->code;
        $hotel_query_row = $this->db->query("SELECT property_id, property_name FROM property_information WHERE hotel_id = $hotel_id LIMIT 0, 1")->row();
        $hotel_property_name = $hotel_query_row->property_name ?? 'No name';
        $sql_property_international_name = "SELECT value FROM property_descriptions WHERE hotel_id = $hotel_id AND property_id = $hotel_query_row->property_id AND language_id = $lang_code AND name LIKE 'international_name'";
        $query_property_international_name_row = $this->db->query ( $sql_property_international_name )->row();
        return $query_property_international_name_row->value ?? $hotel_property_name;
    }

    public function get_nofree_variants__($data = []) {

        $hms_nofree_variants = $data ['hms_nofree_variants'];
        $di = round ( strtotime ( $data ['di']) / 86400 );
        $do = round ( strtotime ( $data ['do']) / 86400 );

        $parties = $data ['parties'];

        // print_r ($hms_nofree_variants);

        $count_cat = count ( $hms_nofree_variants );

        for($j = 0; $j <= $count_cat; $j ++) {
            // $cat[]=key($_SESSION['hms_nofree_variants']);
        }

        foreach ( $hms_nofree_variants as $key => $value ) {
            foreach ( $hms_nofree_variants [$key] as $key1 => $value1 )
                $cat [] = array (
                    'category' => $key,
                    'rate' => $key1
                );
        }

        $duration = $do - $di;
        $dmax = $do + 9;
        $count = count ( $parties );

        $res = array ();
        for($i = 0; $i < count ( $cat ); $i ++) {
            $di1 = $di;
            $do1 = '';

            for($j = $di; $j <= $dmax; $j ++) { // $_SESSION['hms_nofree_variants'][$cat[$i][$cat[$i]['category']][$cat[$i]['rate']]];
                if ($hms_nofree_variants [$cat [$i] ['category']] [$cat [$i] ['rate']] [$j] ['rooms'] >= $count) {

                    $do1 = $j;
                } else if ($hms_nofree_variants [$cat [$i] ['category']] [$cat [$i] ['rate']] [$j] ['rooms'] <= $count) {
                    if ($do1 != '') {
                        // echo $di1." ".$do1." ";
                        $dur = $do1 - $di1 + 1;
                        if ($dur > $duration) {
                            for($g = 0; $g <= $dur - $duration; $g ++) {
                                $res [] = array (
                                    'cat' => $cat [$i] ['category'],
                                    'rate' => $cat [$i] ['rate'],
                                    'di' => $di1 + $g,
                                    'do' => $di1 + $g + $duration - 1,
                                    'dur' => $di + $g + $duration - 1 - ($di + $g) + 1,
                                    'price' => '' ,
                                    'datein'=>'',
                                    'dateout'=>'',
                                    'dis'=>'',
                                    'dos'=>''
                                );
                            }
                        } else {
                            $res [] = array (
                                'cat' => $cat [$i] ['category'],
                                'rate' => $cat [$i] ['rate'],
                                'di' => $di1,
                                'do' => $do1,
                                'dur' => $do1 - $di1 + 1,
                                'price' => '',
                                'datein'=>'',
                                'dateout'=>'',
                                'dis'=>'',
                                'dos'=>''
                            );
                        }
                    }
                    $di1 = $j + 1;
                    $do1 = '';
                }

                if ($j == $dmax) {
                    if ($hms_nofree_variants [$cat [$i] ['category']] [$cat [$i] ['rate']] [$j] ['rooms'] >= $count) { // echo $di1." ".$do1."</br> ";
                        $dur = $do1 - $di1 + 1;

                        if ($dur > $duration) {
                            for($g = 0; $g <= $dur - $duration; $g ++) {
                                $res [] = array (
                                    'cat' => $cat [$i] ['category'],
                                    'rate' => $cat [$i] ['rate'],
                                    'di' => $di1 + $g,
                                    'do' => $di1 + $g + $duration - 1,
                                    'dur' => $di + $g + $duration - 1 - ($di + $g) + 1,
                                    'price' => '',
                                    'datein'=>'',
                                    'dateout'=>'',
                                    'dis'=>'',
                                    'dos'=>''
                                );
                            }
                        } else {
                            $res [] = array (
                                'cat' => $cat [$i] ['category'],
                                'rate' => $cat [$i] ['rate'],
                                'di' => $di1,
                                'do' => $do1,
                                'dur' => $do1 - $di1 + 1,
                                'price' => '' ,
                                'datein'=>'',
                                'dateout'=>'',
                                'dis'=>'',
                                'dos'=>''

                            );
                        }
                    } else { // echo "</br> ";
                    }
                }
            }
        }
        // print_r($res);
        $final = array ();
        $count_res = count ( $res );


        $del = array();
        for($i=0;$i<count($res);$i++){

        	for($j=$i+1;$j<count($res);$j++){

        		if((($res[$i]['di'] <= $res[$j]['di']) AND( $res[$j]['di']<= $res[$i]['do'])) AND (($res[$i]['di']<=$res[$j]['do']) AND($res[$j]['do']<=$res[$i]['do']))){

        			$del[]=$j;
        		}
        		else if((($res[$j]['di'] <= $res[$i]['di']) AND( $res[$i]['di']<= $res[$j]['do'])) AND (($res[$j]['di']<=$res[$i]['do']) AND($res[$i]['do']<=$res[$j]['do']))){

        			$del[]=$i;
        		}

        	}
        }

        $del=array_unique($del);

        arsort($del);

        foreach ($del as $row) {

        	array_splice($res,$row,1);
        }


        $final = array ();
        $count_res = count ( $res );


        if ($count_res > 3) {
            for($j = $di; $j <= $dmax; $j ++) {
                $test = array ();
                for($i = 0; $i <= $count_res - 1; $i ++) {

                    if ($res [$i] ['di'] == $j) {
                        $test [] = $res [$i];
                        // echo $j;
                    }
                }
                // print_r($test);
                if (count ( $test ) > 1) {
                    for($g = $duration; $g > 0; $g --) {
                        for($k = 0; $k < count ( $test ); $k ++) {
                            if ($test [$k] ['dur'] == $g) {
                                $final [] = $test [$k];
                            }
                        }
                    }
                    unset ( $test );
                } elseif (count ( $test ) == 1) {
                    $final [] = $test ['0'];
                    unset ( $test );
                }
            }
        }
else {
            $final = $res;
        }

         //print_r($final);

        for($j = 0; $j < 3; $j ++) {

            for($k = $final [$j] ['di']; $k <= $final [$j] ['do']; $k ++) {
                $final [$j] ['price'] += $hms_nofree_variants [$final [$j] ['cat']] [$final [$j] ['rate']] [$k] ['price'];
            }
            $final [$j] ['datein'] = date ( 'Y-m-d', $final [$j] ['di'] * 86400 );
            $final [$j] ['dateout'] = date ( 'Y-m-d', ($final [$j] ['do'] + 1) * 86400 );
            $diday= date ( 'j ', $final [$j] ['di'] * 86400 );
            $dimonth= date ( 'F ', $final [$j] ['di'] * 86400 );
            $diday_name= date ( 'D ', $final [$j] ['di'] * 86400 );
            $doday= date ( 'j ', ($final [$j] ['do']+1) * 86400 );
            $domonth= date ( 'F ', ($final [$j] ['do']+1) * 86400 );
            $doday_name= date ( 'D ', ($final [$j] ['do']+1) * 86400 );
            $final [$j] ['dis'] = $diday.'{clt_mth_'.trim(strtolower ($dimonth)).'}';
            $final [$j] ['dos'] = $doday.'{clt_mth_'.trim(strtolower ($domonth)).'}';
            $final [$j] ['dis_d'] = '{clt_week_'.trim($diday_name).'}';
            $final [$j] ['dos_d'] = '{clt_week_'.trim($doday_name).'}';
            $data1 [$j] = $final [$j];
        }
        return $data1;
    }

    public function get_nofree_variants($data = array())
    {
        // nofree
        global $errors;
        $errors = [];

        function myErrorHandler($errno, $errstr, $errfile, $errline)
        {
            array_push($GLOBALS['errors'], "Error: [$errno] $errstr on line $errline in file $errfile <br />\n");
            return;
        }
        set_error_handler('myErrorHandler');

        echo "<pre>";
        /*
         * print_r( $data );
         * die();
         */
        $hms_nofree_variants = $data['hms_nofree_variants'];
        $di = round(strtotime($data['di']) / 86400);
        $do = round(strtotime($data['do']) / 86400);
        $min = 0;
        $parties = $data['parties'];

        $count_cat = count($hms_nofree_variants);

        for ($j = 0; $j <= $count_cat; $j ++) {
            // $cat[]=key($_SESSION['hms_nofree_variants']);
        }

        foreach ($hms_nofree_variants as $key => $value) {
            foreach ($hms_nofree_variants[$key] as $key1 => $value1)
                foreach ($value1 as $day) {
                    if ($day['price'] != '') {
                        $cat[] = array(
                            'category' => $key,
                            'rate' => $key1
                        );
                    }
                }
        }
        $duration = $do - $di;
        $dmax = $do + 9;
        $count = count($parties);

        $res = array();
        for ($i = 0; $i < count($cat); $i ++) {
            $di1 = $di;
            $do1 = '';

            for ($j = $di; $j <= $dmax; $j ++) { // $_SESSION['hms_nofree_variants'][$cat[$i][$cat[$i]['category']][$cat[$i]['rate']]];
                if ($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$j]['rooms'] >= $count) {

                    $do1 = $j;
                } else
                    if ($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$j]['rooms'] <= $count) {
                        if ($do1 != '') {
                            // echo $di1." ".$do1." ";
                            $dur = $do1 - $di1 + 1;
                            if ($dur > $duration) {
                                for ($g = 0; $g <= $dur - $duration; $g ++) {
                                    for ($k = ($di1 + $g); $k <= $di1 + $g + $duration - 1; $k ++) {
                                        $min = max($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['minstay'], $min);
                                    }
                                    if ($min <= ($di + $g + $duration - 1 - ($di + $g) + 1)) {
                                        $res[] = array(
                                            'cat' => $cat[$i]['category'],
                                            'rate' => $cat[$i]['rate'],
                                            'di' => $di1 + $g,
                                            'do' => $di1 + $g + $duration - 1,
                                            'dur' => $di + $g + $duration - 1 - ($di + $g) + 1,
                                            'price' => '',
                                            'datein' => '',
                                            'dateout' => '',
                                            'dis' => '',
                                            'dos' => '',
                                            'isclosed' => $is_closed
                                        );
                                    }
                                    $min = 0;

                                }
                            } else {

                                for ($k = $di1; $k <= $do1; $k ++) {
                                        $is_closed = $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['isclosed'] == '1' ? "1"  : $is_closed;

                                    $min = max($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['minstay'], $min);
                                } // echo $min;
                                if ($min <= ($do1 - $di1 + 1)) {
                                    $res[] = array(
                                        'cat' => $cat[$i]['category'],
                                        'rate' => $cat[$i]['rate'],
                                        'di' => $di1,
                                        'do' => $do1,
                                        'dur' => $do1 - $di1 + 1,
                                        'price' => '',
                                        'datein' => '',
                                        'dateout' => '',
                                        'dis' => '',
                                        'dos' => '',
                                        'isclosed' => $is_closed
                                    );
                                }
                                $min = 0;
                                $is_closed=0;

                            }
                        }
                        $di1 = $j + 1;
                        $do1 = '';
                    }

                if ($j == $dmax) {
                    if ($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$j]['rooms'] >= $count) { // echo $di1." ".$do1."</br> ";
                        $dur = $do1 - $di1 + 1;

                        if ($dur > $duration) {
                            for ($g = 0; $g <= $dur - $duration; $g ++) {
                                $is_closed=0;

                                for ($k = $di1 + $g; $k <= $di1 + $g + $duration - 1; $k ++) {
                                        $is_closed = $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['isclosed'] == '1' ? "1"  : $is_closed;

                                    $min = max($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['minstay'], $min);
                                } // echo $min;
                                if ($min <= ($di + $g + $duration - 1 - ($di + $g) + 1)) {
                                    $res[] = array(
                                        'cat' => $cat[$i]['category'],
                                        'rate' => $cat[$i]['rate'],
                                        'di' => $di1 + $g,
                                        'do' => $di1 + $g + $duration - 1,
                                        'dur' => $di + $g + $duration - 1 - ($di + $g) + 1,
                                        'price' => '',
                                        'datein' => '',
                                        'dateout' => '',
                                        'dis' => '',
                                        'dos' => '',
                                        'isclosed' => $is_closed
                                    );
                                }
                                $min = 0;
                                $is_closed=0;

                            }
                        } else {
                            $is_closed=0;

                            for ($k = $di1; $k <= $do1; $k ++) {
                                        $is_closed = $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['isclosed'] == '1' ? "1"  : $is_closed;

                                $min = max($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['minstay'], $min);
                            }
                            // echo $min;
                            if ($min <= ($do1 - $di1 + 1)) {
                                $res[] = array(
                                    'cat' => $cat[$i]['category'],
                                    'rate' => $cat[$i]['rate'],
                                    'di' => $di1,
                                    'do' => $do1,
                                    'dur' => $do1 - $di1 + 1,
                                    'price' => '',
                                    'datein' => '',
                                    'dateout' => '',
                                    'dis' => '',
                                    'dos' => '',
                                    'isclosed' => $is_closed
                                )
                                ;
                            }
                            $min = 0;
                            $is_closed=0;

                        }
                    } else { // echo "</br> ";
                    }
                }
            }
        }

        $final = array();
        $count_res = count($res);

        $del = [];

        for ($i = 0; $i < count($res); $i ++) {

            for ($j = $i + 1; $j < count($res); $j ++) {

                if ((($res[$i]['di'] <= $res[$j]['di']) and ($res[$j]['di'] <= $res[$i]['do'])) and (($res[$i]['di'] <= $res[$j]['do']) and ($res[$j]['do'] <= $res[$i]['do']))) {

                    $del[] = $j;
                } else
                    if ((($res[$j]['di'] <= $res[$i]['di']) and ($res[$i]['di'] <= $res[$j]['do'])) and (($res[$j]['di'] <= $res[$i]['do']) and ($res[$i]['do'] <= $res[$j]['do']))) {

                        $del[] = $i;
                    }
            }
        }

        $del = array_unique($del);

        arsort($del);

        foreach ($del as $row) {

            array_splice($res, $row, 1);
        }

        $final = array();
        $count_res = count($res);

        if ($count_res > 3) {
            for ($j = $di; $j <= $dmax; $j ++) {
                $test = array();
                for ($i = 0; $i <= $count_res - 1; $i ++) {

                    if ($res[$i]['di'] == $j) {
                        $test[] = $res[$i];
                        // echo $j;
                    }
                }
                // print_r($test);
                if (count($test) > 1) {
                    for ($g = $duration; $g > 0; $g --) {
                        for ($k = 0; $k < count($test); $k ++) {
                            if ($test[$k]['dur'] == $g) {
                                $final[] = $test[$k];
                            }
                        }
                    }
                    unset($test);
                } elseif (count($test) == 1) {
                    $final[] = $test['0'];
                    unset($test);
                }
            }
        } else {
            $final = $res;
        }


        $data1 = [];
        for ($j = 0; $j < 3; $j ++) {
            for ($k = $final[$j]['di']; $k <= $final[$j]['do']; $k ++) {
                $final[$j]['price'] += $hms_nofree_variants[$final[$j]['cat']][$final[$j]['rate']][$k]['price'];
            }
            $final[$j]['datein'] = date('Y-m-d', $final[$j]['di'] * 86400);
            $final[$j]['dateout'] = date('Y-m-d', ($final[$j]['do'] + 1) * 86400);
            $diday = date('j ', $final[$j]['di'] * 86400);
            $dimonth = date('F ', $final[$j]['di'] * 86400);
            $diday_name = date('D ', $final[$j]['di'] * 86400);
            $doday = date('j ', ($final[$j]['do'] + 1) * 86400);
            $domonth = date('F ', ($final[$j]['do'] + 1) * 86400);
            $doday_name = date('D ', ($final[$j]['do'] + 1) * 86400);
            $final[$j]['dis'] = $diday . '{clt_mth_' . trim(strtolower($dimonth)) . '}';
            $final[$j]['dos'] = $doday . '{clt_mth_' . trim(strtolower($domonth)) . '}';
            $final[$j]['dis_d'] = '{clt_week_' . trim($diday_name) . '}';
            $final[$j]['dos_d'] = '{clt_week_' . trim($doday_name) . '}';
            $data1[$j] = $final[$j];
        }

        if ($errors) {
            $data1 = [];
            $data1['errors'] = $errors;
        }
        restore_error_handler();
        return $data1;
    }

    public function get_nofree_variants_v2($data = array())
    {
        // nofree
        global $errors;
        $errors = [];

        function myErrorHandler($errno, $errstr, $errfile, $errline)
        {
            array_push($GLOBALS['errors'], "Error: [$errno] $errstr on line $errline in file $errfile <br />\n");
            return;
        }
        set_error_handler('myErrorHandler');


        $hms_nofree_variants = $data['hms_nofree_variants'];
        $di = round(strtotime($data['di']) / 86400);
        $do = round(strtotime($data['do']) / 86400);
        $min = 0;
        $max = 365;
        $isClosed = false;
        $parties = $data['parties'];
        foreach ($hms_nofree_variants as $key => $value) {
            foreach ($value as $key1 => $value1){

                        $cat[] = array(
                            'category' => $key,
                            'rate' => $key1
                        );
                    }

        }

        $duration = $do - $di;
        $dmax = $do + 9;
        $count = count($parties);
        echo '<pre>';
      //print_r($hms_nofree_variants);
        $res = array();
        for ($i = 0; $i < count($cat); $i ++) {
            $di1 = $di;
            $do1 = '';

            for ($j = $di; $j <= $dmax; $j ++) { // $_SESSION['hms_nofree_variants'][$cat[$i][$cat[$i]['category']][$cat[$i]['rate']]];
                if ($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$j]['rooms'] >= $count) {

                    $do1 = $j;
                } else
                    if ($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$j]['rooms'] <= $count) {
                        if ($do1 != '') {
//                             $special_off = $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$do1]['rate_specialoffer_timeshift'];

//                             $special_off_cond = true;
//                             if ($special_off != 0) {
//                             $now = DateTime::createFromFormat('U.u', 
//                                     microtime(true));
//                             $di_obj = DateTime::createFromFormat('U.u', 
//                                     $di1 * 86400 + '.0001');
//                             $di_obj->setTime(14, 00);
//                             $diff = $di_obj->diff($now);
//                             $hours = $diff->h;
//                             $hours = $hours + ($diff->days * 24);
                            
//                             $special_off_cond = $special_off < 0 ? ($hours + $special_off <=
//                                     0 ? true : false) : ($hours - $special_off >= 0 ? true : false);
//                         }

//                         if (
//                               //  $can_arr == 0 && $can_dep == 0 && 
//                                 $special_off_cond==true) {
                            $dur = $do1 - $di1 + 1;
                            if ($dur > $duration) {
                                for ($g = 0; $g <= $dur - $duration; $g ++) {
                                    for ($k = ($di1 + $g); $k <= $di1 + $g + $duration - 1; $k ++) {
                                        
                                        $min = max($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['minstay'], $min);
                                        $max = min($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['maxstay'], $max);
                                        $isClosed = ($isClosed || $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['isclosed']==1)? true : false;
                                        
                                    }
                                    
                                    $can_arr = $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$di1+ $g]['closedonarrival'];
                                    $can_dep = isset($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$di1 + $g + $duration - 1]['closedondeparture'])?$hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$di1 + $g + $duration - 1]['closedondeparture']:1;
                                    $special_off = $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$di1+ $g]['rate_specialoffer_timeshift'];
                                    $special_off_cond = true;
                                    if ($special_off != 0) {
                                        $now = DateTime::createFromFormat('U.u',
                                                microtime(true));
                                        $di_obj = DateTime::createFromFormat('U.u',
                                                ($di1 + $g) * 86400 + '.0001');
                                        $di_obj->setTime(14, 00);
                                        $diff = $di_obj->diff($now);
                                        $hours = $diff->h;
                                        $hours = $hours + ($diff->days * 24);
                                        
                                        $special_off_cond = $special_off < 0 ? ($hours + $special_off <=
                                                0 ? true : false) : ($hours - $special_off >= 0 ? true : false);
                                    }
                                    if ($min <= ($di + $g + $duration - 1 - ($di + $g) + 1)&& $max>=($di + $g + $duration - 1 - ($di + $g) + 1) && $isClosed == false && $can_arr == 0 && $can_dep == 0 && $special_off_cond==true) {
                                      //  echo $di1 + $g + $duration - 1;echo "1<br>";
                                        $res[] = array(
                                            'cat' => $cat[$i]['category'],
                                            'rate' => $cat[$i]['rate'],
                                            'di' => $di1 + $g,
                                            'do' => $di1 + $g + $duration - 1,
                                            'dur' => $di + $g + $duration - 1 - ($di + $g) + 1,
                                            'price' => '',
                                            'datein' => '',
                                            'dateout' => '',
                                            'dis' => '',
                                            'dos' => '',
                                        );
                                    }
                                    $min = 0;
                                    $max=365;
                                    $isClosed=false;
                                }
                            } else {

                                for ($k = $di1; $k <= $do1; $k ++) {

                                    $min = max($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['minstay'], $min);
                                    $max = min($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['maxstay'], $max);
                                    $isClosed = ($isClosed || $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['isclosed']==1)? true : false;
                                    

                                } // echo $min;
                                $can_arr = $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$di1]['closedonarrival'];
                                $can_dep = isset($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$do1]['closedondeparture'])?$hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$do1]['closedondeparture']:1;
                                
                                $special_off = $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$di1]['rate_specialoffer_timeshift'];
                                $special_off_cond = true;
                                if ($special_off != 0) {
                                    $now = DateTime::createFromFormat('U.u',
                                            microtime(true));
                                    $di_obj = DateTime::createFromFormat('U.u',
                                            $di1 * 86400 + '.0001');
                                    $di_obj->setTime(14, 00);
                                    $diff = $di_obj->diff($now);
                                    $hours = $diff->h;
                                    $hours = $hours + ($diff->days * 24);
                                    
                                    $special_off_cond = $special_off < 0 ? ($hours + $special_off <=
                                            0 ? true : false) : ($hours - $special_off >= 0 ? true : false);
                                }
                                if ($min <= ($do1 - $di1 + 1) && $max>=($do1 - $di1 + 1) && $isClosed == false && $can_arr == 0 && $can_dep == 0 && $special_off_cond==true) {
                                 //   echo $do1;echo "2<br>";
                                    $res[] = array(
                                        'cat' => $cat[$i]['category'],
                                        'rate' => $cat[$i]['rate'],
                                        'di' => $di1,
                                        'do' => $do1,
                                        'dur' => $do1 - $di1 + 1,
                                        'price' => '',
                                        'datein' => '',
                                        'dateout' => '',
                                        'dis' => '',
                                        'dos' => '',
                                    );
                                }
                                $min = 0;
                                $max=365;
                                $isClosed=false;
                                
                            }
                        
                        }
                        $di1 = $j + 1;
                        $do1 = '';
                        
                    }

                if ($j == $dmax) {
                    if ($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$j]['rooms'] >= $count) { // echo $di1." ".$do1."</br> ";
                        $dur = $do1 - $di1 + 1;
//                         $can_arr = $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$di1]['closedonarrival'];
//                         $can_dep = $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$do1]['closedondeparture'];

//                         if (
// //                                 $can_arr == 0 && $can_dep == 0 && 
//                                 $special_off_cond==true) {
                        if ($dur > $duration) {
                            for ($g = 0; $g <= $dur - $duration; $g ++) {

                                for ($k = $di1 + $g; $k <= $di1 + $g + $duration - 1; $k ++) {

                                    $min = max($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['minstay'], $min);
                                    $max = min($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['maxstay'], $max);
                                    $isClosed = ($isClosed || $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['isclosed']==1)? true : false;
                                    

                                } // echo $min;
                                $can_arr = $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$di1 + $g]['closedonarrival'];
                                $can_dep = isset($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$di1 + $g + $duration ]['closedondeparture'])?$hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$di1 + $g + $duration ]['closedondeparture']:1;
                                $special_off = $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$di1 + $g]['rate_specialoffer_timeshift'];
                                $special_off_cond = true;
                                if ($special_off != 0) {
                                    $now = DateTime::createFromFormat('U.u',
                                            microtime(true));
                                    $di_obj = DateTime::createFromFormat('U.u',
                                            ($di1 + $g) * 86400 + '.0001');
                                    $di_obj->setTime(14, 00);
                                    $diff = $di_obj->diff($now);
                                    $hours = $diff->h;
                                    $hours = $hours + ($diff->days * 24);
                                    
                                    $special_off_cond = $special_off < 0 ? ($hours + $special_off <=
                                            0 ? true : false) : ($hours - $special_off >= 0 ? true : false);
                                }
                                if ($min <= ($di + $g + $duration - 1 - ($di + $g) + 1) && $max>=($di + $g + $duration - 1 - ($di + $g) + 1) && $isClosed == false && $can_arr == 0 && $can_dep == 0 && $special_off_cond==true) {
                                   // echo $di1 + $g;echo "3<br>";
                                    //echo ($di1 + $g).'-'.($di1 + $g + $duration ).'<br>';
                                    
                                    $res[] = array(
                                        'cat' => $cat[$i]['category'],
                                        'rate' => $cat[$i]['rate'],
                                        'di' => $di1 + $g,
                                        'do' => $di1 + $g + $duration - 1,
                                        'dur' => $di + $g + $duration - 1 - ($di + $g) + 1,
                                        'price' => '',
                                        'datein' => '',
                                        'dateout' => '',
                                        'dis' => '',
                                        'dos' => '',
                                    );
                                }
                                $min = 0;
                                $max=365;
                                $isClosed=false;
                                

                            }
                        } else {

                            for ($k = $di1; $k <= $do1; $k ++) {

                                $min = max($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['minstay'], $min);
                                $max = min($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['maxstay'], $max);
                                $isClosed = ($isClosed || $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$k]['isclosed']==1)? true : false;
                                

                            }
                            $can_arr = $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$di1]['closedonarrival'];
                            $can_dep = isset($hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$do1]['closedondeparture'])?$hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$do1]['closedondeparture']:1;
                            $special_off = $hms_nofree_variants[$cat[$i]['category']][$cat[$i]['rate']][$di1]['rate_specialoffer_timeshift'];
                            $special_off_cond = true;
                            if ($special_off != 0) {
                                $now = DateTime::createFromFormat('U.u',
                                        microtime(true));
                                $di_obj = DateTime::createFromFormat('U.u',
                                        $di1 * 86400 + '.0001');
                                $di_obj->setTime(14, 00);
                                $diff = $di_obj->diff($now);
                                $hours = $diff->h;
                                $hours = $hours + ($diff->days * 24);
                                
                                $special_off_cond = $special_off < 0 ? ($hours + $special_off <=
                                        0 ? true : false) : ($hours - $special_off >= 0 ? true : false);
                            }
                            // echo $min;
                            if ($min <= ($do1 - $di1 + 1)&& $max>=($do1 - $di1 + 1) && $isClosed == false && $can_arr == 0 && $can_dep == 0 && $special_off_cond==true) {
                               // echo $do1;echo "4<br>";
                                
                                $res[] = array(
                                    'cat' => $cat[$i]['category'],
                                    'rate' => $cat[$i]['rate'],
                                    'di' => $di1,
                                    'do' => $do1,
                                    'dur' => $do1 - $di1 + 1,
                                    'price' => '',
                                    'datein' => '',
                                    'dateout' => '',
                                    'dis' => '',
                                    'dos' => '',
                                )
                                ;
                            }
                            $min = 0;
                            $max=365;
                            $isClosed=false;
                            

                        }
                        
                    } else { // echo "</br> ";
                    }
                }
            }
        }

        
        $final = array();
        $count_res = count($res);

        $del = [];

        for ($i = 0; $i < count($res); $i ++) {

            for ($j = $i + 1; $j < count($res); $j ++) {

                if ((($res[$i]['di'] <= $res[$j]['di']) and ($res[$j]['di'] <= $res[$i]['do'])) and (($res[$i]['di'] <= $res[$j]['do']) and ($res[$j]['do'] <= $res[$i]['do']))) {

                    $del[] = $j;
                } else
                    if ((($res[$j]['di'] <= $res[$i]['di']) and ($res[$i]['di'] <= $res[$j]['do'])) and (($res[$j]['di'] <= $res[$i]['do']) and ($res[$i]['do'] <= $res[$j]['do']))) {

                        $del[] = $i;
                    }

            }
        }

        $del = array_unique($del);

        arsort($del);

        foreach ($del as $row) {

            array_splice($res, $row, 1);
        }
        $final = array();
        $count_res = count($res);
        if ($count_res > 3) {
            for ($j = $di; $j <= $dmax; $j ++) {
                $test = array();
                for ($i = 0; $i <= $count_res - 1; $i ++) {

                    if ($res[$i]['di'] == $j) {
                        $test[] = $res[$i];
                        // echo $j;
                    }
                }
                // print_r($test);
                if (count($test) > 1) {
                    for ($g = $duration; $g > 0; $g --) {
                        for ($k = 0; $k < count($test); $k ++) {
                            if ($test[$k]['dur'] == $g) {
                                $final[] = $test[$k];
                            }
                        }
                    }
                    unset($test);
                } elseif (count($test) == 1) {
                    $final[] = $test['0'];
                    unset($test);
                }
            }
        } else {
            $final = $res;
        }
        $data1 = [];
        for ($j = 0; $j < count($final); $j ++) {
            $price_arr = [];
            foreach ($hms_nofree_variants as $cat => $val) {
                foreach ($val as $rate => $val1) {
                    $price = 0;
                    for ($k = $final[$j]['di']; $k <= $final[$j]['do']; $k ++) {
                        if ($hms_nofree_variants[$cat][$rate][$k]['price']!='0' ) {
                            $price += $hms_nofree_variants[$cat][$rate][$k]['price'];
                        } else {
                            break 2;
                        }
                    }
                    $price_arr[] = $price;
                }
            }
            $final[$j]['price'] = min($price_arr);
            $final[$j]['datein'] = date('Y-m-d', $final[$j]['di'] * 86400);
            $final[$j]['dateout'] = date('Y-m-d', ($final[$j]['do'] + 1) * 86400);
            $diday = date('j ', $final[$j]['di'] * 86400);
            $dimonth = date('F ', $final[$j]['di'] * 86400);
            $diday_name = date('D ', $final[$j]['di'] * 86400);
            $doday = date('j ', ($final[$j]['do'] + 1) * 86400);
            $domonth = date('F ', ($final[$j]['do'] + 1) * 86400);
            $doday_name = date('D ', ($final[$j]['do'] + 1) * 86400);
            $final[$j]['dis'] = $diday . '{clt_mth_' . trim(strtolower($dimonth)) . '}';
            $final[$j]['dos'] = $doday . '{clt_mth_' . trim(strtolower($domonth)) . '}';
            $final[$j]['dis_d'] = '{clt_week_' . trim($diday_name) . '}';
            $final[$j]['dos_d'] = '{clt_week_' . trim($doday_name) . '}';
            $data1[$j] = $final[$j];
        }
        
        $data1=array_slice($data1, 0, 3);
        if ($errors) {
            $data1 = [];
            $data1['errors'] = $errors;
        }
        restore_error_handler();
        return $data1;
    }


    public function get_nofree_variants1($data = []) {
		$hms_nofree_variants = $data ['hms_nofree_variants'];
		$di = round ( strtotime ( $data ['di']) / 86400 );
		$do = round ( strtotime ( $data ['do']) / 86400 );

		$parties = $data ['parties'];

		// print_r ($hms_nofree_variants);

		$count_cat = count ( $hms_nofree_variants );

		for($j = 0; $j <= $count_cat; $j ++) {
			// $cat[]=key($_SESSION['hms_nofree_variants']);
		}

		foreach ( $hms_nofree_variants as $key => $value ) {
			foreach ( $hms_nofree_variants [$key] as $key1 => $value1 )
				$cat [] = array (
						'category' => $key,
						'rate' => $key1
				);
		}

		$duration = $do - $di;
		$dmax = $do + 9;
		$count = count ( $parties );

		$res = array ();
		for($i = 0; $i < count ( $cat ); $i ++) {
			$di1 = $di;
			$do1 = '';

			for($j = $di; $j <= $dmax; $j ++) { // $_SESSION['hms_nofree_variants'][$cat[$i][$cat[$i]['category']][$cat[$i]['rate']]];
				if ($hms_nofree_variants [$cat [$i] ['category']] [$cat [$i] ['rate']] [$j] ['rooms'] >= $count) {

					$do1 = $j;
				} else if ($hms_nofree_variants [$cat [$i] ['category']] [$cat [$i] ['rate']] [$j] ['rooms'] <= $count) {
					if ($do1 != '') {
						// echo $di1." ".$do1." ";
						$dur = $do1 - $di1 + 1;
						if ($dur > $duration) {
							for($g = 0; $g <= $dur - $duration; $g ++) {
								$res [] = array (
										'cat' => $cat [$i] ['category'],
										'rate' => $cat [$i] ['rate'],
										'di' => $di1 + $g,
										'do' => $di1 + $g + $duration - 1,
										'dur' => $di + $g + $duration - 1 - ($di + $g) + 1,
										'price' => '' ,
										'datein'=>'',
										'dateout'=>'',
										'dis'=>'',
										'dos'=>''
								);
							}
						} else {
							$res [] = array (
									'cat' => $cat [$i] ['category'],
									'rate' => $cat [$i] ['rate'],
									'di' => $di1,
									'do' => $do1,
									'dur' => $do1 - $di1 + 1,
									'price' => '',
									'datein'=>'',
									'dateout'=>'',
									'dis'=>'',
									'dos'=>''
							);
						}
					}
					$di1 = $j + 1;
					$do1 = '';
				}

				if ($j == $dmax) {
					if ($hms_nofree_variants [$cat [$i] ['category']] [$cat [$i] ['rate']] [$j] ['rooms'] >= $count) { // echo $di1." ".$do1."</br> ";
						$dur = $do1 - $di1 + 1;

						if ($dur > $duration) {
							for($g = 0; $g <= $dur - $duration; $g ++) {
								$res [] = array (
										'cat' => $cat [$i] ['category'],
										'rate' => $cat [$i] ['rate'],
										'di' => $di1 + $g,
										'do' => $di1 + $g + $duration - 1,
										'dur' => $di + $g + $duration - 1 - ($di + $g) + 1,
										'price' => '',
										'datein'=>'',
										'dateout'=>'',
										'dis'=>'',
										'dos'=>''
								);
							}
						} else {
							$res [] = array (
									'cat' => $cat [$i] ['category'],
									'rate' => $cat [$i] ['rate'],
									'di' => $di1,
									'do' => $do1,
									'dur' => $do1 - $di1 + 1,
									'price' => '' ,
									'datein'=>'',
									'dateout'=>'',
									'dis'=>'',
									'dos'=>''

							);
						}
					} else { // echo "</br> ";
					}
				}
			}
		}
		// print_r($res);
		$final = array ();
		$count_res = count ( $res );


		for($i=0;$i<count($res);$i++){

			for($j=$i+1;$j<count($res);$j++){
				echo $i." ".$j."</br>";
				if((($res[$i]['di'] <= $res[$j]['di']) AND( $res[$j]['di']<= $res[$i]['do'])) AND (($res[$i]['di']<=$res[$j]['do']) AND($res[$j]['do']<=$res[$i]['do']))){
					echo $j.'</br>';
					$del[]=$j;
				}
				else if((($res[$j]['di'] <= $res[$i]['di']) AND( $res[$i]['di']<= $res[$j]['do'])) AND (($res[$j]['di']<=$res[$i]['do']) AND($res[$i]['do']<=$res[$j]['do']))){
					echo $i.'</br>';
					$del[]=$i;
				}

			}
		}
		$del=array_unique($del);

		arsort($del);
		foreach ($del as $row) {

			array_splice($res,$row,1);
		}

		print_r($res);
		$final = array ();
		$count_res = count ( $res );


		if ($count_res > 3) {
			for($j = $di; $j <= $dmax; $j ++) {
				$test = array ();
				for($i = 0; $i <= $count_res - 1; $i ++) {

					if ($res [$i] ['di'] == $j) {
						$test [] = $res [$i];
						// echo $j;
					}
				}
				// print_r($test);
				if (count ( $test ) > 1) {
					for($g = $duration; $g > 0; $g --) {
						for($k = 0; $k < count ( $test ); $k ++) {
							if ($test [$k] ['dur'] == $g) {
								$final [] = $test [$k];
							}
						}
					}
					unset ( $test );
				} elseif (count ( $test ) == 1) {
					$final [] = $test ['0'];
					unset ( $test );
				}
			}
		}
		else {
			$final = $res;
		}

		//print_r($final);

		$data1 = [];
		for($j = 0; $j < 3; $j ++) {

			for($k = $final [$j] ['di']; $k <= $final [$j] ['do']; $k ++) {
				$final [$j] ['price'] += $hms_nofree_variants [$final [$j] ['cat']] [$final [$j] ['rate']] [$k] ['price'];
			}
			$final [$j] ['datein'] = date ( 'Y-m-d', $final [$j] ['di'] * 86400 );
			$final [$j] ['dateout'] = date ( 'Y-m-d', ($final [$j] ['do'] + 1) * 86400 );
			$diday= date ( 'j ', $final [$j] ['di'] * 86400 );
			$dimonth= date ( 'F ', $final [$j] ['di'] * 86400 );
			$diday_name= date ( 'D ', $final [$j] ['di'] * 86400 );
			$doday= date ( 'j ', ($final [$j] ['do']+1) * 86400 );
			$domonth= date ( 'F ', ($final [$j] ['do']+1) * 86400 );
			$doday_name= date ( 'D ', ($final [$j] ['do']+1) * 86400 );
			$final [$j] ['dis'] = $diday.'{clt_mth_'.trim(strtolower ($dimonth)).'}';
			$final [$j] ['dos'] = $doday.'{clt_mth_'.trim(strtolower ($domonth)).'}';
			$final [$j] ['dis_d'] = '{clt_week_'.trim($diday_name).'}';
			$final [$j] ['dos_d'] = '{clt_week_'.trim($doday_name).'}';
			$data1 [$j] = $final [$j];
		}
		return $data1;
	}

	public function get_clt_variant_or_clt_ending($inc = ['val'=>0, 'clts' => ['val end on one(ночь)', 'val between two and four(ночи)', ' val five and more(ночей)'], 'return_type' => 0]) {
	    //control for right captions is on programmer in case clt variant return ($return_type == 0)
	    $return_type = $inc['return_type'];
	    if ($return_type != 0) $return_type = 1;
	    $val = $inc['val'] ?? 0;
	    $clts = [$inc['clts'] ?? [], ['','_p','_pp']];
	    $val = abs(intval($val)) % 100;
	    if ($val>4 && $val<20) return $clts[$return_type][2] ?? '';
	    $val = $val % 10;
	    if ($val==1) return $clts[$return_type][0] ?? '';
	    if ($val>1 && $val<5) return $clts[$return_type][1] ?? '';
	    return $clts[$return_type][2] ?? '';
	}
	
	public function get_curl_freeproprooms($incoming_data) {
        $data_curl = [
            'datein' => $incoming_data['startdate'],
            'dateout' => $incoming_data['enddate'],
            'add_places' => 0,
            'baby_places' => 0,
            'discountpromocode' => $incoming_data['promocode']
        ];
        if (isset($incoming_data['checked_prop_id'])) {
            $data_curl['prop_id'] = $incoming_data['checked_prop_id'];
        }
        
	    $hms_host = $this->personal->hms_host;
	    $url_curl = "https://$hms_host/gateway/get_free_proprooms_pmv3/";
	    $result_curl = $this->curl_model->CurlPlugRaw ( json_encode($data_curl), $url_curl );
	    
	    $result = json_decode ( $result_curl, true );
	    
	    if (isset($result['debug'])) {
	        $debug_data = $this->session->userdata('debug_data');
	        $debug_data['get_curl_freerooms']['request'] = $incoming_data;
	        $debug_data['get_curl_freerooms']['debug'] = $result['debug'];
	        $this->session->set_userdata(['debug_data' => $debug_data]);
	    }
	    return json_decode ( $result_curl, true );
	}
	
	public function get_home_page_url($home_page_type = 0) {
	    switch ($home_page_type) {
	        case 1:
	            $home_page_url = 'rooms';
	        break;
	        case 2:
	            $home_page_url = 'proprooms';
	            break;
	        case 3:
	            $home_page_url = 'properties';
	            break;
	        default:
	            $home_page_url = 'rooms';
	        break;
	    }
	    return $home_page_url;
	}
	
	public function get_props_minprices_from_echannel($incoming_data = []) {
	    $data_curl = [
	        'startdate' => $incoming_data['startdate'] ?? date('Y-m-d'),
	        'enddate' => $incoming_data['enddate'] ?? date('Y-m-d', strtotime('+ 1 day')),
	        'hms_id' => $this->personal->hotel_id,
	    ];
	    $url_curl = "https://echannel.otelms.com/echannel/get_min_prices";
	    $result_curl = $this->curl_model->CurlPlugRaw ( json_encode($data_curl), $url_curl );
	    return json_decode ( $result_curl, true );
	}
	
	public function make_prop_minprice($property, $props_minprices) {
	    $min_price = 0;
	    foreach ($property['rooms'] as $room_id) {
            if (isset($props_minprices[$room_id])) {
                if ($min_price) {
                    $min_price = ($props_minprices[$room_id]['min_price'] < $min_price) ? $props_minprices[$room_id]['min_price'] : $min_price;
                }else {
                    $min_price = $props_minprices[$room_id]['min_price'];
                }
            }
	    }
	    return $this->mcurrency->fullvalue($min_price);
	}
}