<?php
defined('BASEPATH') or exit('No direct scripts');
class Transbank extends CI_Controller
{
    const LOGINNG_API_REQ_RES = TRUE;
    const API_VERSION = 'v1.2';
    private $client_id = '597055555532';
    private $client_api_key = '579B532A7440BB0C9079DED94D31EA1615BACEB56610332264630D42D0A36B1C';


    private $orders_tbl = 'booking_otelms.tbk_order2dc_order';
    private $api_logs_tbl = 'booking_otelms.tbk_api_logs';

    private $dev_api_ep = 'https://webpay3gint.transbank.cl/rswebpaytransaction/api/webpay/'. self::API_VERSION .'/transactions';
    private $prod_api_ep = 'https://webpay3g.transbank.cl/rswebpaytransaction/api/webpay/'. self::API_VERSION .'/transactions';
    private $api_ep;


    public $host_url;

    public function __construct()
    {
        parent::__construct();
        $this->load->model ( 'personal' );//must be first! coz: public function mount_personal_data()
        $this->load->model ( 'pay_processor' );
        $this->load->model ( 'mcurrency' );
        $this->load->model ( 'curl_model' );
        $this->load->model ( 'reservation' );

        if (!$this->personal->cc_test_mode) {
            $this->api_ep = $this->prod_api_ep;
            $transbank_sync_data = $this->pay_processor->get_transbank_sync_data();
            $this->client_id = $transbank_sync_data->client_id ?? null;
            $this->client_api_key = $transbank_sync_data->client_api_key ?? null;
        }else{
            $this->api_ep = $this->dev_api_ep;
        }

        $this->host_url = $this->personal->pmv3_host;
        if ($_SERVER['REMOTE_ADDR'] == "109.70.24.230") {
            $this->host_url = str_replace("otelms.com", "agast.ru", $this->host_url );
        }
    }

//     public function test(){
//         echo "<pre>";
//         print_r($this);
//         die("DIED by A Department at Transbank.php test() on 14 дек. 2022 г. 21:15:07");
//     }

    
    public function create_order_and_book()
    {
        $amount = $this->pay_processor->calculate_ccforce_rooms_amount();
        $amount = round($amount, 0);
        $dc_order_id = $this->session->userdata('dc_order_id');
        $pay_params = [
            'amount' => $amount,
            'reason' => [
                'type' => '',// empty is booking by default
                'hms_res_id' => 0,
                'dc_order_id' => $dc_order_id
            ]
        ];
        $result = $this->do_payment_routine($pay_params);

        if (isset($result->token) && isset($result->url)) {
            $creation_reservation_resp = $this->reservation->create_reservation($dc_order_id); // this delete session userdata booking_data !!!
            $whr_arr = [
                'hotel_id' => $this->personal->hotel_id,
                'dc_order_id' => $dc_order_id,
            ];
            $upd_arr = [
                'hms_booking_response' => isset($creation_reservation_resp['response']) ? $creation_reservation_resp['response'] : json_encode($creation_reservation_resp),
            ];
           $this->db->update($this->orders_tbl, $upd_arr, $whr_arr);
            if ($creation_reservation_resp['result'] == 'ok') {
                $resp = [
                    'result' => 'ok',
                    'token' => $result->token,
                    'url' => $result->url
                ];
                echo json_encode($resp);
            } else {
                die ( "<meta http-equiv='refresh' content='0;url=/booking/fail'>" );
            }
        }else{
            die ( "<meta http-equiv='refresh' content='0;url=/rooms'>" );//!!!!!!!!!!!!!! Payment init failed!
        }
    }

    public function create_order_custom_pay()
    {
        $pay_custom_session_data = $this->session->userdata('reservation_info');
        $hms_res_id = $pay_custom_session_data->hms_res_id;
        $amount = $pay_custom_session_data->custom_amount;
        $amount = round($amount, 0);

        $pay_params = [
            'amount' => $amount,
            'reason' => [
                'type' => 'custom_pay',
                'hms_res_id' => $hms_res_id,
                'dc_order_id' => 0
            ]
        ];

        $result = $this->do_payment_routine($pay_params);

        if (isset($result->token) && isset($result->url)) {
            $resp = [
                'result' => 'ok',
                'token' => $result->token,
                'url' => $result->url
            ];
            echo json_encode($resp);
        }
    }

    public function do_payment_routine($p = ['amount', 'reason'=>['type'=>'', 'hms_res_id'=>0, 'dc_order_id'=>0]])
    {//'type'=>'' ''-booking, 'custom_pay'
        $hms_id = $this->personal->hotel_id;
        $session_id = "HMS-$hms_id-".time();
        $amount = $p['amount'];

        switch ($p['reason']['type']) {
            case 'custom_pay':
                $dc_order_id = 0;
                $hms_res_id = $p['reason']['hms_res_id'];
                $buy_order = "$hms_id-$hms_res_id-custom_pay";
                break;
            default://type === '' is booking by def
                $dc_order_id = $p['reason']['dc_order_id'];
                $hms_res_id = 0;
                $buy_order = "$hms_id-$dc_order_id-book";
                break;
        }
        $buy_order .= '-'.mt_rand(1, 10000);
        $this->session->set_userdata(['tbk_buy_order' => $buy_order]);
        $params = [
            'post_data' => [
                'buy_order' => $buy_order,
                'session_id' => $session_id,
                'amount' => $amount,
                'return_url' => "https://{$this->host_url}/transbank/callback",
            ],
            'api_url' => $this->api_ep
        ];
        $response = $this->request_api($params);
        $result = json_decode($response);
        $init_req_res_log_data = [
            'request' => $params,
            'response' => $result,
            'creds' => [
                $this->client_id,
                $this->client_api_key
            ]
        ];
        $log_data = [
            'pmv' => 3,
            'buy_order' => $buy_order,
            'hotel_id' => $this->personal->hotel_id,
            'dc_order_id' => $dc_order_id,
            'hms_res_id' => $hms_res_id,
            'amount' => $amount,
            'currency' => 'USD',
            'init_req_res' => json_encode($init_req_res_log_data),
            'commit_result' => '',
            'hms_booking_response' => '',
            'hms_payment_response' => '',
        ];
        $this->db->insert($this->orders_tbl, $log_data);

        return $result;
    }

    public function callback()
    {
        $token = $_GET['token_ws'] ?? $_POST['token_ws'] ?? null;
        if ($token) {
            $api_res = $this->request_api(['api_url' => "$this->api_ep/$token"], 'PUT');//Transaction.commit
            $transaction_commit_response = json_decode($api_res);
            if (isset($transaction_commit_response->buy_order)) {
                $upd_arr = [
                    'commit_result' => $api_res,
                ];
                $whr_arr = [
                    'hotel_id' => $this->personal->hotel_id,
                    'buy_order' => $transaction_commit_response->buy_order
                ];
                $this->db->update($this->orders_tbl, $upd_arr, $whr_arr);
                if (isset($transaction_commit_response->status) && $transaction_commit_response->status === 'AUTHORIZED') {
                    $this->save_payment_to_hms(['buy_order' => $transaction_commit_response->buy_order]);
                    $this->rout_after_callback(['buy_order' => $transaction_commit_response->buy_order ?? null]);
                }else {
//                     echo $transaction_commit_response->status ?? 'No transaction commit status';
//                     die("DIED by A Department at Transbank.php callback()");
                    die ( "<meta http-equiv='refresh' content='0;url=/booking/payment_failed'>" );//!!!!!!!!!!!!!! Payment failed!
                }
            }
            //$res = $this->request_api($params, 'GET');//Get status of a transaction
            //This operation allows you to obtain the status of the transaction at any time.
            //Under normal conditions, it is probably not required to execute,
            //but in the event of an unexpected error, it allows knowing the status and taking the corresponding actions.
        }else {
//             echo "No token";
//             die("DIED by A Department at Transbank.php callback()");
            die ( "<meta http-equiv='refresh' content='0;url=/booking/payment_failed'>" );//!!!!!!!!!!!!!! Payment init failed!
        }
    }

    private function rout_after_callback($p) {
        if (isset($p['buy_order']) && $p['buy_order']) {
            $pay_for = explode('-', $p['buy_order']);
            switch ($pay_for[2]) {
                case 'book':
                    die("<meta http-equiv='refresh' content='0;url=/booking/confirmation'>");
                    break;
                case 'custom_pay':
                    $hms_hotel_id = $this->personal->hotel_id;
                    $whr_arr = [
                        'hotel_id' => $hms_hotel_id,
                        'buy_order' => $p['buy_order']
                    ];
                    $orderInfo = $this->db->get_where($this->orders_tbl, $whr_arr)->row();
                    $hms_res_id = $orderInfo->hms_res_id;
                    $pincode_md5 = md5($this->config->item('reservation_pincode_phrase') . $hms_hotel_id . $hms_res_id);
                    die("<meta http-equiv='refresh' content='0;url=/booking/reservation_info/$hms_hotel_id/$hms_res_id/$pincode_md5'>");
                    break;
                default:
                    echo "Some critical error with buy_order.";
                    die("DIED by A Department at Transbank.php rout_after_callback()");
                    break;
            }
        } else {
            echo "Some critical error. buy_order not setted";
            die("DIED by A Department at Transbank.php rout_after_callback()");
        }
    }

    public function save_payment_to_hms($param)
    {
        $whr_arr = [
            'hotel_id' => $this->personal->hotel_id,
            'buy_order' => $param['buy_order'],
        ];
        $orderInfo = $this->db->get_where($this->orders_tbl, $whr_arr)->row();
        if ($orderInfo) {
            $url = "https://{$this->personal->hms_host}/gateway/transbank_payment_update";
            $pay_curl_data = array();
            $pay_curl_data ['hms_id'] = $this->personal->hotel_id;
            $pay_curl_data ['dc_reservationid'] = $pay_curl_data ['order_id'] = $orderInfo->dc_order_id;
            $pay_curl_data ['hms_res_id'] = $orderInfo->hms_res_id;
            $pay_curl_data ['currency'] = $orderInfo->currency ? $orderInfo->currency : 'USD';
            $pay_curl_data ['amount'] = $orderInfo->amount;
            $pay_curl_data ['transID'] = $orderInfo->buy_order;
            $pay_curl_data ['cc_processor'] = $this->personal->cc_processor;

            $hms_payment_insert_result = $this->curl_model->curl_plug_json($pay_curl_data, $url);

            $upd_arr = [
                'hms_payment_response' => $hms_payment_insert_result
            ];
            $this->db->update($this->orders_tbl, $upd_arr, $whr_arr);
        }
    }

    private function request_api($p, $method='POST') {

        $headers = array(
            'Tbk-Api-Key-Id: ' . $this->client_id,
            'Tbk-Api-Key-Secret: ' . $this->client_api_key,
            'Content-Type: application/json'
        );
        $url = $p['api_url'];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_ENCODING, '');
        curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 0);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        switch (strtoupper($method)) {
            case 'POST':
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($p['post_data']));
                break;
        }
        $curl_response = curl_exec($ch);
//         $curl_info = curl_getinfo($ch);
        curl_close($ch);

        if (self::LOGINNG_API_REQ_RES) {
            $req_resp_log_data = [
                'hotel_id' => $this->personal->hotel_id,
                'buy_order' => $this->session->userdata('tbk_buy_order') ?? 'No buy_order?',
                'request' => json_encode($p),
                'response' => $curl_response,
                'method' => $method,
                'creds' => json_encode([
                    'client_id' => $this->client_id,
                    'client_api_key' => $this->client_api_key
                ]),
            ];
            $this->db->insert($this->api_logs_tbl, $req_resp_log_data);
        }
        return $curl_response;
    }
}