<?php

defined('BASEPATH') or die('No direct scripts');

class Przelewy extends CI_Controller
{
    private $clientId = 174831;
    private $clientSecret = '892c68e7e8ca66ae1a83065b5c717096';
    private $endpoint = 'https://sandbox.przelewy24.pl/api/v1/';
    private $paymentLink = 'https://sandbox.przelewy24.pl/trnRequest/';
    private $crc = 'fa9ba71ecd740ed4';
    private $orders_tbl;

    public function __construct()
    {
        parent::__construct();

        $this->load->model ( 'personal' );//must be first! coz: public function mount_personal_data()
        $this->load->model ( 'pay_processor' );
        $this->load->model ( 'mcurrency' );
        $this->load->model ( 'curl_model' );
        $this->load->model ( 'reservation' );

        $this->orders_tbl = 'booking_otelms.przelewy_order2dc_order';

        if (!$this->personal->cc_test_mode) {
            $this->endpoint = 'https://secure.przelewy24.pl/api/v1/';
            $this->paymentLink = 'https://secure.przelewy24.pl/trnRequest/';
            $this->clientId = $this->personal->prlwy24_client_id;
            $this->clientSecret = $this->personal->prlwy24_client_secret;
            $this->crc = $this->personal->prlwy24_crc;
        }
    }

    public function register_transaction()
    {
        $customer = $this->session->userdata('customer');
        $amount = $this->pay_processor->calculate_ccforce_rooms_amount();
        $amount = (int)($amount * 100);
        $currency = 'PLN';//strtoupper($this->mcurrency->get_currency_name());
        $dc_order_id = $this->session->userdata('dc_order_id');
        $session = $this->personal->hotel_id . '-' . $dc_order_id .'-'. md5(date('Y-m-d H:i:s'));

        $data = [
            'merchantId' => $this->clientId,
            'posId' => $this->clientId,
            'sessionId' => $session,
            'amount' => $amount,
            'currency' => $currency,
            'description' => 'desc',
            'email' => $customer['email'],
            'country' => 'PL',
            'language' => 'pl',
            'urlReturn' => 'https://'. $this->personal->pmv3_host .'/przelewy/callback/'.$dc_order_id,
            'urlStatus' => 'https://'. $this->personal->pmv3_host .'/przelewy/callback_result',
            'waitForResult' => true
        ];
        $data['sign'] = hash('sha384', json_encode([
            'sessionId' => $session,
            'merchantId' => $this->clientId,
            'amount' => $amount,
            'currency' => $currency,
            'crc' => $this->crc
        ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->endpoint . 'transaction/register',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLINFO_HEADER_OUT => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic ' . base64_encode($this->clientId . ':' . $this->clientSecret),
                'Content-Type: application/json',
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $result = json_decode($response, true);
        if (isset($result['error'])) {
            echo "<pre> Error: ";
            print_r($result['error']);
            die();
        }

        if ($result['responseCode'] === 0) {
            $ins_arr = [
                'hotel_id' => $this->personal->hotel_id,
                'dc_order_id' => $dc_order_id,
                'hms_res_id' => 0,
                'session_id' => $session,
                'amount' => $amount,
                'currency' => $currency
            ];
            $this->db->insert($this->orders_tbl, $ins_arr);
            $this->reservation->create_reservation($dc_order_id);//delete session userdata booking_data  !!!
            header('Location:'. $this->paymentLink . $result['data']['token']);
        }
    }

    public function register_transaction_custom_pay()
    {
        $pay_custom_session_data = $this->session->userdata('reservation_info');
        $customer_email = $pay_custom_session_data->reservation_info->rooms[0]->email;
        $hms_res_id = $pay_custom_session_data->hms_res_id;
        $amount = $pay_custom_session_data->custom_amount;
        $amount = (int)($amount * 100);
        $currency = 'PLN';//strtoupper($this->mcurrency->get_currency_name());
        $session = $this->personal->hotel_id . '-' . $hms_res_id .'-'. md5(date('Y-m-d H:i:s'));

        $data = [
            'merchantId' => $this->clientId,
            'posId' => $this->clientId,
            'sessionId' => $session,
            'amount' => $amount,
            'currency' => $currency,
            'description' => 'desc',
            'email' => $customer_email != '' ? $customer_email : 'cltelexlv@gmail.com',
            'country' => 'PL',
            'language' => 'pl',
            'urlReturn' => 'https://'. $this->personal->pmv3_host .'/przelewy/callback_custom_pay/'.$hms_res_id,
            'urlStatus' => 'https://'. $this->personal->pmv3_host .'/przelewy/callback_result',
            'waitForResult' => true
        ];
        $data['sign'] = hash('sha384', json_encode([
            'sessionId' => $session,
            'merchantId' => $this->clientId,
            'amount' => $amount,
            'currency' => $currency,
            'crc' => $this->crc
        ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->endpoint . 'transaction/register',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLINFO_HEADER_OUT => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic ' . base64_encode($this->clientId . ':' . $this->clientSecret),
                'Content-Type: application/json',
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $result = json_decode($response, true);
        if ($result['responseCode'] === 0) {
            $ins_arr = [
                'hotel_id' => $this->personal->hotel_id,
                'dc_order_id' => 0,
                'hms_res_id' => $hms_res_id,
                'session_id' => $session,
                'amount' => $amount,
                'currency' => $currency
            ];
            $this->db->insert($this->orders_tbl, $ins_arr);
            header('Location:'. $this->paymentLink . $result['data']['token']);
        }
    }

    public function callback_result()
    {
        $body = file_get_contents('php://input');
        $body = json_decode($body, true);

        $where_arr = [
            'hotel_id' => $this->personal->hotel_id,
            'session_id' => $body['sessionId'],
        ];
        $upd_arr = [
            'przelewy_order_id' => $body['orderId'],
            'data' => json_encode($body)
        ];
        $this->db->where($where_arr)->update($this->orders_tbl, $upd_arr);
        $verification = $this->verifyTransaction($body['sessionId']);
        $this->db->where($where_arr)->update($this->orders_tbl, ['verification' => $verification]);

        $verification = json_decode($verification);
        if (isset($verification->data->status) && $verification->data->status == 'success') {
            $this->save_payment_to_hms(['session_id' => $body['sessionId']]);
        }
    }

    public function save_payment_to_hms($param)
    {
        $where_arr = [
            'hotel_id' => $this->personal->hotel_id,
            'session_id' => $param['session_id'],
        ];
        $orderInfo = $this->db->where($where_arr)->get($this->orders_tbl)->row();
        if ($orderInfo) {
            $url = "https://" . $this->personal->hms_host . "/gateway/przelewy24_payment_update";
            $pay_curl_data = array();
            $pay_curl_data ['hms_id'] = $this->personal->hotel_id;
            $pay_curl_data ['dc_reservationid'] = $pay_curl_data ['order_id'] = $orderInfo->dc_order_id;
            $pay_curl_data ['hms_res_id'] = $orderInfo->hms_res_id;
            $pay_curl_data ['currency'] = $orderInfo->currency;
            $pay_curl_data ['amount'] = $orderInfo->amount / 100;
            $pay_curl_data ['transID'] = $orderInfo->przelewy_order_id;
            $pay_curl_data ['cc_processor'] = $this->personal->cc_processor;

            $this->curl_model->curl_plug_json($pay_curl_data, $url);
        }
        //die ( "<meta http-equiv='refresh' content='0;url=/booking/confirmation'>" );
    }

    public function callback($dc_order_id)
    {
        die ( "<meta http-equiv='refresh' content='0;url=/booking/confirmation'>" );
    }

    public function callback_custom_pay($hms_res_id)
    {
        $hms_hotel_id = $this->personal->hotel_id;
        $pincode_md5 = md5($this->config->item('reservation_pincode_phrase') . $hms_hotel_id . $hms_res_id);
        die ( "<meta http-equiv='refresh' content='0;url=/booking/reservation_info/$hms_hotel_id/$hms_res_id/$pincode_md5'>" );
    }

    private function verifyTransaction($session = null)
    {
        if (!$session) {
            return false;
        }

        $where_arr = [
            'hotel_id' => $this->personal->hotel_id,
            'session_id' => $session,
        ];

        $orderInfo = $this->db->where($where_arr)->get($this->orders_tbl)->row_array();

        if(!$orderInfo){
            return;
        }

        $data = [
            'merchantId' => $this->clientId,
            'posId' => $this->clientId,
            'sessionId' => $session,
            'amount' => $orderInfo['amount'],
            'currency' => $orderInfo['currency'],
            'orderId' => $orderInfo['przelewy_order_id']
        ];
        $data['sign'] = hash('sha384', json_encode([
            'sessionId' => $data['sessionId'],
            'orderId' => (int) $data['orderId'],
            'amount' => (int) $data['amount'],
            'currency' => $data['currency'],
            'crc' => $this->crc
        ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->endpoint . 'transaction/verify',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLINFO_HEADER_OUT => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'PUT',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic ' . base64_encode($this->clientId . ':' . $this->clientSecret),
                'Content-Type: application/json',
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        return $response;//json_decode($response, true);
    }
}