<?php

defined('BASEPATH') or die('No direct scripts');

class Przelewy extends CI_Controller
{
    private $clientId = 174831;
    private $clientSecret = '892c68e7e8ca66ae1a83065b5c717096';
    private $endpoint = 'https://sandbox.przelewy24.pl/api/v1/';
    private $paymentLink = 'https://sandbox.przelewy24.pl/trnRequest/';
    private $crc = 'fa9ba71ecd740ed4';
    private $orders_tbl;

    public function __construct()
    {
        parent::__construct();

        $this->load->model ( 'personal' );//must be first! coz: public function mount_personal_data()
        $this->load->model ( 'pay_processor' );
        $this->load->model ( 'mcurrency' );
        $this->load->model ( 'curl_model' );
        $this->load->model ( 'reservation' );

        $this->orders_tbl = 'booking_otelms.przelewy_order2dc_order';

        if (!$this->personal->cc_test_mode) {
            $this->endpoint = 'https://secure.przelewy24.pl/api/v1/';
            $this->paymentLink = 'https://secure.przelewy24.pl/trnRequest/';
            $this->clientId = (int)$this->personal->prlwy24_client_id;
            $this->clientSecret = $this->personal->prlwy24_client_secret;
            $this->crc = $this->personal->prlwy24_crc;
        }
    }

    public function register_transaction()
    {
        $customer = $this->session->userdata('customer');
        $amount = $this->pay_processor->calculate_ccforce_rooms_amount();
        $amount = (int)($amount * 100);
        $currency = 'PLN';//strtoupper($this->mcurrency->get_currency_name());
        $dc_order_id = $this->session->userdata('dc_order_id');
        $result = $this->do_transaction_routine([
            'amount' => $amount,
            'currency' => $currency,
            'reason' => [
                'type' => '',//empty is booking by default
                'hms_res_id' => 0,
                'dc_order_id' => $dc_order_id
            ],
            'customer' => [
                'email' => $customer['email'],
                'phone'
            ]
        ]);

        if ($result->responseCode === 0 && isset($result->data->token)) {
            $creation_reservation_resp = $this->reservation->create_reservation($dc_order_id);//this delete session userdata booking_data  !!!
            $where_arr = [
                'hotel_id' => $this->personal->hotel_id,
                'dc_order_id' => $dc_order_id,
            ];
            $upd_arr = [
                'hms_booking_response' => isset($creation_reservation_resp['response']) ? $creation_reservation_resp['response'] : json_encode($creation_reservation_resp),
            ];
            $this->db->update($this->orders_tbl, $upd_arr, $where_arr);

            if ($creation_reservation_resp['result'] == 'ok') {
                header('Location:' . $this->paymentLink . $result->data->token);
            } else {
                die ( "<meta http-equiv='refresh' content='0;url=/booking/fail'>" );
            }
        } else {
            echo "<pre>Error<br>";
            print_r($result);
            die("DIED by A Department at Przelewy.php do_transaction_routine()");
        }
    }

    public function register_transaction_custom_pay()
    {
        $pay_custom_session_data = $this->session->userdata('reservation_info');
        $customer_email = $pay_custom_session_data->reservation_info->rooms[0]->email;
        $hms_res_id = $pay_custom_session_data->hms_res_id;
        $amount = $pay_custom_session_data->custom_amount;
        $amount = (int)($amount * 100);
        $currency = 'PLN';//strtoupper($this->mcurrency->get_currency_name());
        $result = $this->do_transaction_routine([
            'amount' => $amount,
            'currency' => $currency,
            'reason' => [
                'type' => 'custom_pay',
                'hms_res_id' => $hms_res_id,
                'dc_order_id' => 0
            ],
            'customer' => [
                'email' => $customer_email,
                'phone'
            ]
        ]);

        if ($result->responseCode === 0 && isset($result->data->token)) {
            header('Location:' . $this->paymentLink . $result->data->token);
        } else {
            echo "<pre>Error<br>";
            print_r($result);
            die("DIED by A Department at Przelewy.php do_transaction_routine()");
        }
    }

    public function do_transaction_routine ($p = ['amount', 'currency'=>'PLN', 'reason'=>['type'=>'', 'hms_res_id'=>0, 'dc_order_id'=>0], 'customer'=>['email', 'phone']]) {
        $hms_id = $this->personal->hotel_id;
        $amount = $p['amount'];
        $currency = $p['currency'];
        $session = "$hms_id-";
        $retutn_url = 'https://'. $this->personal->pmv3_host .'/przelewy/';
        switch ($p['reason']['type']) {
            case 'custom_pay':
                $dc_order_id = 0;
                $hms_res_id = $p['reason']['hms_res_id'];
                $retutn_url .= "callback_custom_pay/$hms_res_id";
                $session .= "$hms_res_id-custom_pay-" . md5(date('Y-m-d H:i:s'));
                break;
            default://type === '' is booking by def
                $dc_order_id = $p['reason']['dc_order_id'];
                $hms_res_id = 0;
                $retutn_url .= "callback/$dc_order_id";
                $session .= "$dc_order_id-book-" . md5(date('Y-m-d H:i:s'));
                break;
        }
        $body = [
            'merchantId' => $this->clientId,
            'posId' => $this->clientId,
            'sessionId' => $session,
            'amount' => $amount,
            'currency' => $currency,
            'description' => 'desc',
            'email' => $p['customer']['email'],
            'country' => 'PL',
            'language' => 'pl',
            'urlReturn' => $retutn_url,
            'urlStatus' => 'https://'. $this->personal->pmv3_host .'/przelewy/callback_result',
            'waitForResult' => true
        ];
        $body['sign'] = hash('sha384', json_encode([
            'sessionId' => $session,
            'merchantId' => $this->clientId,
            'amount' => $amount,
            'currency' => $currency,
            'crc' => $this->crc
        ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->endpoint . 'transaction/register',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLINFO_HEADER_OUT => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($body),
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic ' . base64_encode($this->clientId . ':' . $this->clientSecret),
                'Content-Type: application/json',
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        $result = json_decode($response);

        $req_resp_log_data = [
            'request' => $body,
            'response' => $result,
            'creds' => [$this->clientId, $this->clientSecret, $this->crc, $this->endpoint]
        ];
        $log_data = [
            'pmv' => 3,
            'hotel_id' => $this->personal->hotel_id,
            'dc_order_id' => $dc_order_id,
            'hms_res_id' => $hms_res_id,
            'session_id' => $session,
            'amount' => $amount,
            'currency' => $currency,
            'req_resp' => json_encode($req_resp_log_data),
        ];
        $this->db->insert($this->orders_tbl, $log_data);
        return $result;
    }

    public function callback_result()
    {
        $body = file_get_contents('php://input');
        $body = json_decode($body, true);
        if (isset($body['sessionId'])) {
            $where_arr = [
                'hotel_id' => $this->personal->hotel_id,
                'session_id' => $body['sessionId'],
            ];
            $upd_arr = [
                'przelewy_order_id' => $body['orderId'],
                'callback_result' => json_encode($body),
            ];
            $this->db->update($this->orders_tbl, $upd_arr, $where_arr);
            $verification = $this->verifyTransaction($body['sessionId']);
            if (isset($verification->data->status) && $verification->data->status == 'success') {
                $this->save_payment_to_hms(['session_id' => $body['sessionId']]);
            }
        }
    }

    public function save_payment_to_hms($param)
    {
        $where_arr = [
            'hotel_id' => $this->personal->hotel_id,
            'session_id' => $param['session_id'],
        ];
        $orderInfo = $this->db->get_where($this->orders_tbl, $where_arr)->row();
        if ($orderInfo) {
            $url = "https://" . $this->personal->hms_host . "/gateway/przelewy24_payment_update";
            $pay_curl_data = array();
            $pay_curl_data ['hms_id'] = $this->personal->hotel_id;
            $pay_curl_data ['dc_reservationid'] = $pay_curl_data ['order_id'] = $orderInfo->dc_order_id;
            $pay_curl_data ['hms_res_id'] = $orderInfo->hms_res_id;
            $pay_curl_data ['currency'] = $orderInfo->currency;
            $pay_curl_data ['amount'] = $orderInfo->amount / 100;
            $pay_curl_data ['transID'] = $orderInfo->przelewy_order_id;
            $pay_curl_data ['cc_processor'] = $this->personal->cc_processor;

            $hms_payment_insert_result = $this->curl_model->curl_plug_json($pay_curl_data, $url);
            $upd_arr = [
                'hms_payment_response' => $hms_payment_insert_result
            ];
            $this->db->update($this->orders_tbl, $upd_arr, $where_arr);
        }
    }

    public function callback($dc_order_id)
    {
        die ( "<meta http-equiv='refresh' content='0;url=/booking/confirmation'>" );
    }

    public function callback_custom_pay($hms_res_id)
    {
        $hms_hotel_id = $this->personal->hotel_id;
        $pincode_md5 = md5($this->config->item('reservation_pincode_phrase') . $hms_hotel_id . $hms_res_id);
        die ( "<meta http-equiv='refresh' content='0;url=/booking/reservation_info/$hms_hotel_id/$hms_res_id/$pincode_md5'>" );
    }

    private function verifyTransaction($session = null)
    {
        if (!is_null($session)) {
            $where_arr = [
                'hotel_id' => $this->personal->hotel_id,
                'session_id' => $session,
            ];

            $orderInfo = $this->db->get_where($this->orders_tbl, $where_arr)->row();

            if($orderInfo){
                $data = [
                    'merchantId' => $this->clientId,
                    'posId' => $this->clientId,
                    'sessionId' => $session,
                    'amount' => $orderInfo->amount,
                    'currency' => $orderInfo->currency,
                    'orderId' => $orderInfo->przelewy_order_id
                ];
                $data['sign'] = hash('sha384', json_encode([
                    'sessionId' => $data['sessionId'],
                    'orderId' => (int) $data['orderId'],
                    'amount' => (int) $data['amount'],
                    'currency' => $data['currency'],
                    'crc' => $this->crc
                ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));

                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => $this->endpoint . 'transaction/verify',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLINFO_HEADER_OUT => true,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'PUT',
                    CURLOPT_POSTFIELDS => json_encode($data),
                    CURLOPT_HTTPHEADER => array(
                        'Authorization: Basic ' . base64_encode($this->clientId . ':' . $this->clientSecret),
                        'Content-Type: application/json',
                    ),
                ));
                $response = curl_exec($curl);
                curl_close($curl);

                $upd_arr = [
                    'verification' => $response,
                ];
            }else {
                $upd_arr = [
                    'verification' => "hms error : session_id - $session no order in $this->orders_tbl",
                ];
            }
            $this->db->update($this->orders_tbl, $upd_arr, $where_arr);
            return json_decode($response);
        }
        return false;
    }
}