<?php
//https://developer.paypal.com/sdk/js/reference/
defined('BASEPATH') or exit('No direct script access allowed');

class Paypal_v2 extends CI_Controller
{
    public $orders_tbl = 'paypal_v2_odrder2dc_order';
    public function __construct()
    {
        parent::__construct();
        $this->load->model ( 'personal' );//must be first! coz: public function mount_personal_data()
        $this->load->model ( 'pay_processor' );
        $this->load->model ( 'paypal_mdl' );
        $this->load->model ( 'mcurrency' );
        $this->load->model ( 'curl_model' );
        $this->load->model ( 'reservation' );
    }

    public function book_on_order_intent_catured()
    {
        $creating_payment = json_decode(file_get_contents('php://input'));
        $amount = $this->pay_processor->calculate_ccforce_rooms_amount();
        if (isset($creating_payment->paypalOrderID) && $creating_payment->paypalOrderID != '') {
            $dc_order_id = $this->session->userdata('dc_order_id');
            $creation_reservation_resp = $this->reservation->create_reservation($dc_order_id); // this delete session userdata booking_data !!!
            $ins_arr = [
                'hotel_id' => $this->personal->hotel_id,
                'pmv' => 3,
                'dc_order_id' => $dc_order_id,
                'reference_id' => "{$this->personal->hotel_id}-$dc_order_id-book",
                'paypal_order_id' => $creating_payment->paypalOrderID,
                'amount' => $amount,
                'currency' => $this->mcurrency->hotel_currency->name,//'USD',
                'status' => 'CAPTURED',
                'hms_booking_response' => isset($creation_reservation_resp['response']) ? $creation_reservation_resp['response'] : json_encode($creation_reservation_resp),
            ];
            $this->db->insert($this->orders_tbl, $ins_arr);
        }
        if (isset($creation_reservation_resp['result']) && $creation_reservation_resp['result'] == 'ok') {
            $response = [
                'status' => 'ok',
            ];
        } else {
            $response = [
                'error' => 'Booking Failed!' . $creation_reservation_resp['result'],
            ];
        }

        echo json_encode($response);
    }
    
    public function payment_approved()
    {
        $post = $this->input->post();
        
        if (is_array($post) && isset($post['details']['id'])) {
            $paypal_order_id = $post['details']['id'];            
            $whr_arr = [
                'hotel_id' => $this->personal->hotel_id,
                'paypal_order_id' => $paypal_order_id,
            ];
            $upd_arr = [
                'hms_payment_response' => $this->save_payment_to_hms(['paypal_order_id' => $paypal_order_id]),
                'paypal_response' => json_encode($post),
                'status' => $post['details']['status'],
            ];
            $this->db->update($this->orders_tbl, $upd_arr, $whr_arr);
            echo '/booking/confirmation';
        }
    }
    
    public function payment_custom_approved()
    {
        $post = $this->input->post();
        
        if (is_array($post) && isset($post['details']['id'])) {
            $paypal_order_id = $post['details']['id'];
            $pay_custom_session_data = $this->session->userdata('reservation_info');
            $hms_res_id = $pay_custom_session_data->hms_res_id;
            $hms_hotel_id = $this->personal->hotel_id;
            $whr_arr = [
                
            ];
            $ins_arr = [
                'hotel_id' => $hms_hotel_id,
                'pmv' => 3,
                'reference_id' => $post['details']['purchase_units'][0]['reference_id'],
                'paypal_order_id' => $paypal_order_id,
                'hms_res_id' => $hms_res_id,
                'paypal_response' => json_encode($post),
                'amount' => $post['details']['purchase_units'][0]['amount']['value'],
                'currency' => $post['details']['purchase_units'][0]['amount']['currency_code'],
                'status' => $post['details']['status'],
            ];
            $this->db->insert($this->orders_tbl, $ins_arr);
            
            $upd_arr = [
                'hms_payment_response' => $this->save_payment_to_hms(['paypal_order_id' => $paypal_order_id]),
            ];
            $this->db->update($this->orders_tbl, $upd_arr, ['hotel_id' => $hms_hotel_id, 'paypal_order_id' => $paypal_order_id]);
                        
            $pincode_md5 = md5($this->config->item('reservation_pincode_phrase') . $hms_hotel_id . $hms_res_id);
            $next_url = "/booking/reservation_info/$hms_hotel_id/$hms_res_id/$pincode_md5";
            echo $next_url;
        }
    }

    public function create_order_custom_pay()
    {
        $pay_custom_session_data = $this->session->userdata('reservation_info');

        $custom_amount = number_format($pay_custom_session_data->custom_amount, 2, '.', '');

        $response = $this->paypal_mdl->create_order(['amount' => $custom_amount]);

        $res = json_decode($response);
        $paypal_order_id = isset($res->id) ? $res->id : 'Error paypal order';

        $this->paypal_mdl->save_paymet_connections([
            'paypal_order_id' => $paypal_order_id,
            'hms_res_id' => $pay_custom_session_data->hms_res_id
        ]);

        echo $response;
    }
    
    public function save_payment_to_hms($param)
    {
        $whr_arr = [
            'hotel_id' => $this->personal->hotel_id,
            'paypal_order_id' => $param['paypal_order_id'],
        ];
        $orderInfo = $this->db->get_where($this->orders_tbl, $whr_arr)->row();
        if ($orderInfo) {
            $url = "https://{$this->personal->hms_host}/gateway/paypal_payment_update";
            $pay_curl_data = array();
            $pay_curl_data ['hms_id'] = $this->personal->hotel_id;
            $pay_curl_data ['dc_reservationid'] = $pay_curl_data ['order_id'] = $orderInfo->dc_order_id;
            $pay_curl_data ['hms_res_id'] = $orderInfo->hms_res_id;
            $pay_curl_data ['currency'] = $orderInfo->currency ? $orderInfo->currency : 'USD';
            $pay_curl_data ['amount'] = $orderInfo->amount;
            $pay_curl_data ['transID'] = $orderInfo->paypal_order_id;
            $pay_curl_data ['cc_processor'] = $this->personal->cc_processor;
            
            return $this->curl_model->curl_plug_json($pay_curl_data, $url);
        }
    }
}
// Test creds:
// sb-xvehd6410265@personal.example.com
// sAv*n52/