<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Paypal extends CI_Controller
{

    // otelMS data
    public $merchant_parent; // otelms merchant
    public $clientId; // клиент айди otelMS
    public $clientSecret; // клиент секрет otelMS
    //

    // Динамические поля
    public $track; // отслеживание клиента нужно далее для запросов
    public $token; // токен
    public $merchant_seller; // мерчант айди аккаунта клиента
    public $api_url;
    //
    public function __construct()
    {
        parent::__construct();
        $this->load->model ( 'personal' );//must be first! coz: public function mount_personal_data()
        $this->load->model ( 'pay_processor' );
        $this->load->model ( 'paypal_mdl' );
        $this->load->model ( 'mcurrency' );
        $this->load->model ( 'curl_model' );
        $this->load->model ( 'reservation' );

        $this->merchant_parent = $this->paypal_mdl->get_merchant_parent();
        $this->merchant_seller = $this->paypal_mdl->get_merchant_seller();

        $this->clientId = $this->paypal_mdl->get_clientId();
        $this->clientSecret = $this->paypal_mdl->get_clientSecret();

        $this->token = $this->getToken(); // получение токена из otelms clientid, secret
        $this->api_url = $this->paypal_mdl->get_api_url();
    }

    public function create_order_and_book()
    {
        $amount = $this->pay_processor->calculate_ccforce_rooms_amount();

        $dc_order_id = $this->session->userdata('dc_order_id');
        $this->reservation->create_reservation($dc_order_id);//delete session userdata booking_data  !!!

        $response = $this->paypal_mdl->create_order(['amount' => $amount]);

        $res = json_decode($response);
        $paypal_order_id = isset($res->id) ? $res->id : 'Error paypal order';

        $this->paypal_mdl->save_paymet_connections([
            'paypal_order_id' => $paypal_order_id,
            'dc_order_id' => $dc_order_id
        ]);

        echo $response;
    }

    public function create_order_custom_pay()
    {
        $pay_custom_session_data = $this->session->userdata('reservation_info');

        $custom_amount = number_format($pay_custom_session_data->custom_amount, 2, '.', '');

        $response = $this->paypal_mdl->create_order(['amount' => $custom_amount]);

        $res = json_decode($response);
        $paypal_order_id = isset($res->id) ? $res->id : 'Error paypal order';

        $this->paypal_mdl->save_paymet_connections([
            'paypal_order_id' => $paypal_order_id,
            'hms_res_id' => $pay_custom_session_data->hms_res_id
        ]);

        echo $response;
    }

    public function capture_order($id)
    {
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => $this->api_url . '/v2/checkout/orders/' . $id . '/capture',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer '.$this->token,
                'Content-Type: application/json',
            ],
        ]
            );

        $response = curl_exec($curl);

        curl_close($curl);

//         $response = json_decode($response, true);//"COMPLETED"
//         $response['idHms'] = 93;

        echo json_encode($response);
    }

    public function getToken()
    {
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => $this->api_url . '/v1/oauth2/token',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'grant_type=client_credentials',
            CURLOPT_HTTPHEADER => [
                'Authorization: Basic ' . base64_encode($this->clientId.':'.$this->clientSecret),
                'Content-Type: application/x-www-form-urlencoded',
            ],
        ]
            );

        $response = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($response, true);

        return $response['access_token'];
    }

}