<?php
//https://api.monobank.ua/docs/acquiring.html
defined('BASEPATH') or exit('No direct scripts');
class Monobank extends CI_Controller
{
    const LOGINNG_API_REQ_RES = TRUE;
    const API_EP = 'https://api.monobank.ua/';

    private $orders_tbl = 'booking_otelms.monobank_order2dc_order';
    private $api_logs_tbl = 'booking_otelms.monobank_api_logs';

    private $api_create_invoice_url = self::API_EP.'api/merchant/invoice/create';
    private $api_get_invoice_status = self::API_EP.'api/merchant/invoice/status?invoiceId=';
    
    private $token = '';
    private $token_dev = 'u6fAPlvx7SQjEVk37vtpbxDINJ1X113GTGaAbK9x86nM';


    public $host_url;

    public function __construct()
    {
        parent::__construct();
        $this->load->model ( 'personal' );//must be first! coz: public function mount_personal_data()
        $this->load->model ( 'pay_processor' );
        $this->load->model ( 'mcurrency' );
        $this->load->model ( 'curl_model' );
        $this->load->model ( 'reservation' );
        $this->load->model ( 'mlanguages' );

        if ($this->personal->cc_test_mode) {
            $this->token = $this->token_dev;
        }else{
            $monobank_sync_data = $this->pay_processor->get_monobank_sync_data();
            $this->token = $monobank_sync_data->token ?? null;
        }
        
        $this->host_url = $this->personal->pmv3_host;
        if ($_SERVER['REMOTE_ADDR'] == "109.70.24.230") {
            $this->host_url = str_replace("otelms.com", "agast.ru", $this->host_url );
        }
    }

    public function create_order_and_book()
    {
        $amount = $this->pay_processor->calculate_ccforce_rooms_amount();
        $amount = round($amount, 0);
        $dc_order_id = $this->session->userdata('dc_order_id');
        $pay_params = [
            'amount' => $amount,
            'reason' => [
                'type' => '',// empty is booking by default
                'hms_res_id' => 0,
                'dc_order_id' => $dc_order_id
            ]
        ];
        $result = $this->do_payment_routine($pay_params);
        
        if (isset($result->invoiceId) && isset($result->pageUrl)) {
            $creation_reservation_resp = $this->reservation->create_reservation($dc_order_id); // this delete session userdata booking_data !!!
            $whr_arr = [
                'hotel_id' => $this->personal->hotel_id,
                //'buy_order' => $this->session->userdata('monobank_buy_order'),
                'dc_order_id' => $dc_order_id,
            ];
            $upd_arr = [
                'hms_booking_response' => isset($creation_reservation_resp['response']) ? $creation_reservation_resp['response'] : json_encode($creation_reservation_resp),
                'invoice_id' => $result->invoiceId,
            ];
           $this->db->update($this->orders_tbl, $upd_arr, $whr_arr);
            if ($creation_reservation_resp['result'] == 'ok') {
                header("Location: $result->pageUrl");
                exit(); 
            } else {
                die ( "<meta http-equiv='refresh' content='0;url=/booking/fail'>" );
            }
        }else{
            die ( "<meta http-equiv='refresh' content='0;url=/booking/fail'>" );//!!!!!!!!!!!!!! Payment init failed!
        }
    }

    public function create_order_custom_pay()
    {
        $pay_custom_session_data = $this->session->userdata('reservation_info');
        $hms_res_id = $pay_custom_session_data->hms_res_id;
        $amount = $pay_custom_session_data->custom_amount;

        $pay_params = [
            'amount' => $amount,
            'reason' => [
                'type' => 'custom_pay',
                'hms_res_id' => $hms_res_id,
                'dc_order_id' => 0
            ]
        ];

        $result = $this->do_payment_routine($pay_params);

        if (isset($result->invoiceId) && isset($result->pageUrl)) {
            $whr_arr = [
                'hotel_id' => $this->personal->hotel_id,
                'buy_order' => $this->session->userdata('monobank_buy_order'),
            ];
            $upd_arr = [
                'invoice_id' => $result->invoiceId,
            ];
            $this->db->update($this->orders_tbl, $upd_arr, $whr_arr);
            header("Location: $result->pageUrl");
        }else{
            die ( "<meta http-equiv='refresh' content='0;url=/booking/payment_failed'>" );//!!!!!!!!!!!!!! Payment init failed!
        }
    }

    public function do_payment_routine($p = ['amount', 'reason'=>['type'=>'', 'hms_res_id'=>0, 'dc_order_id'=>0]])
    {//'type'=>'' ''-booking, 'custom_pay'
        $hms_id = $this->personal->hotel_id;
        $amount = $p['amount'];

        switch ($p['reason']['type']) {
            case 'custom_pay':
                $dc_order_id = 0;
                $hms_res_id = $p['reason']['hms_res_id'];
                $buy_order = "$hms_id-$hms_res_id-custom_pay".time();
                break;
            default://type === '' is booking by def
                $dc_order_id = $p['reason']['dc_order_id'];
                $hms_res_id = 0;
                $buy_order = "$hms_id-$dc_order_id-book";
                break;
        }
        $this->session->set_userdata(['monobank_buy_order' => $buy_order]);
        $params = [
            'post_data' => [
                'amount' => $amount * 100,
                'ccy' => (int) $this->personal->currencyID,
                'merchantPaymInfo' => [
                    'reference' => $buy_order,
                    //'destination' => $destination,
                    'basketOrder' => [
                        [
                            'name' => $this->mlanguages->getdictionaryword('mlw', $this->mlanguages->hotel_lang->ch3, 'clt_accommodation'),
                            'qty' => 1,
                            'sum' => $amount * 100,
                        ]
                    ]
                ],
                'redirectUrl' => "https://{$this->host_url}/monobank/return?buy_order=$buy_order",
                'webHookUrl' => "https://{$this->host_url}/monobank/callback",
            ],
            'api_url' => $this->api_create_invoice_url
        ];

        $log_data = [
            'pmv' => 3,
            'buy_order' => $buy_order,
            'hotel_id' => $this->personal->hotel_id,
            'dc_order_id' => $dc_order_id,
            'hms_res_id' => $hms_res_id,
            'amount' => $amount,
            'currency' => $this->mcurrency->hotel_currency->name,
            'hms_booking_response' => '',
            'hms_payment_response' => '',
        ];
        $this->db->insert($this->orders_tbl, $log_data);
        
        $response = $this->request_api($params);
        $result = json_decode($response);

        return $result;
    }

    public function callback() {
        $body_json = file_get_contents('php://input');
        $body = json_decode($body_json);
        if (isset($body->invoiceId)) {
            $upd_arr = [
                'data_callback' => $body_json,
                'status' => isset($body->status) ? $body->status : 'undefined',
            ];
            $whr_arr = [
                'hotel_id' => $this->personal->hotel_id,
                'invoice_id' => $body->invoiceId,
            ];
            
            $this->db->update($this->orders_tbl, $upd_arr, $whr_arr);
            
            if ($body->status === 'success' && isset($body->reference)) {
                $this->save_payment_to_hms(['buy_order' => $body->reference]);
            }
        }
    }
    
    public function return()
    {
        $body = $this->input->get();
        $buy_order = isset($body['buy_order']) ? $body['buy_order'] : false;
        if ($buy_order) {
            $whr_arr = [
                'hotel_id' => $this->personal->hotel_id,
                'buy_order' => $buy_order
            ];
            $orderInfo = $this->db->get_where($this->orders_tbl, $whr_arr)->row();
            if ($orderInfo && $orderInfo->invoice_id) {
                $api_res = $this->request_api([
                    'api_url' => $this->api_get_invoice_status . $orderInfo->invoice_id
                ], 'GET');
                $upd_arr = ['data_return' => $api_res];
                $response = json_decode($api_res);
                if (isset($response->status)) {
                    $upd_arr['status'] = $response->status;
                }
                $this->db->update($this->orders_tbl, $upd_arr, $whr_arr);
                if ($response->status === 'success') {
                    $this->save_payment_to_hms(['buy_order' => $buy_order]);
                    $this->rout_after_return(['buy_order' => $buy_order]);
                }else {
                    die ( "<meta http-equiv='refresh' content='0;url=/booking/payment_failed'>" );
                }
            }else {
                die ( "<meta http-equiv='refresh' content='0;url=/booking/payment_failed'>" );
            }
        }else {
            die ( "<meta http-equiv='refresh' content='0;url=/booking/payment_failed'>" );
        }
    }

    private function rout_after_return($p) {
        if (isset($p['buy_order']) && $p['buy_order']) {
            $pay_for = explode('-', $p['buy_order']);
            switch ($pay_for[2]) {
                case 'book':
                    die("<meta http-equiv='refresh' content='0;url=/booking/confirmation'>");
                    break;
                case 'custom_pay':
                    $hms_hotel_id = $this->personal->hotel_id;
                    $whr_arr = [
                        'hotel_id' => $hms_hotel_id,
                        'buy_order' => $p['buy_order']
                    ];
                    $orderInfo = $this->db->get_where($this->orders_tbl, $whr_arr)->row();
                    $hms_res_id = $orderInfo->hms_res_id;
                    $pincode_md5 = md5($this->config->item('reservation_pincode_phrase') . $hms_hotel_id . $hms_res_id);
                    die("<meta http-equiv='refresh' content='0;url=/booking/reservation_info/$hms_hotel_id/$hms_res_id/$pincode_md5'>");
                    break;
                default:
                    echo "Some critical error with buy_order.";
                    die("DIED rout_after_return()");
                    break;
            }
        } else {
            echo "Some critical error. buy_order not setted";
            die("DIED rout_after_return()");
        }
    }

    public function save_payment_to_hms($param)
    {
        $whr_arr = [
            'hotel_id' => $this->personal->hotel_id,
            'buy_order' => $param['buy_order'],
        ];
        $orderInfo = $this->db->get_where($this->orders_tbl, $whr_arr)->row();
        if ($orderInfo) {
            $url = "https://{$this->personal->hms_host}/gateway/monobank_payment_update";
            $pay_curl_data = array();
            $pay_curl_data ['hms_id'] = $this->personal->hotel_id;
            $pay_curl_data ['dc_reservationid'] = $pay_curl_data ['order_id'] = $orderInfo->dc_order_id;
            $pay_curl_data ['hms_res_id'] = $orderInfo->hms_res_id;
            $pay_curl_data ['currency'] = $orderInfo->currency ? $orderInfo->currency : $this->mcurrency->hotel_currency->name;
            $pay_curl_data ['amount'] = $orderInfo->amount;
            $pay_curl_data ['transID'] = $orderInfo->buy_order;
            $pay_curl_data ['cc_processor'] = $this->personal->cc_processor;
            $pay_curl_data ['monobank_invoice_id'] = $orderInfo->invoice_id;

            $hms_payment_insert_result = $this->curl_model->curl_plug_json($pay_curl_data, $url);

            $upd_arr = [
                'hms_payment_response' => $hms_payment_insert_result
            ];
            $this->db->update($this->orders_tbl, $upd_arr, $whr_arr);
        }
    }

    private function request_api($p, $method='POST') {

        $headers = array(
            'X-Token: ' . $this->token,
            'X-Cms: OtelMS',
            'Content-Type: application/json'
        );
        $url = $p['api_url'];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_ENCODING, '');
        curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 0);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        switch (strtoupper($method)) {
            case 'POST':
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($p['post_data']));
                break;
        }
        $curl_response = curl_exec($ch);
//         $curl_info = curl_getinfo($ch);
        curl_close($ch);

        if (self::LOGINNG_API_REQ_RES) {
            $req_resp_log_data = [
                'hotel_id' => $this->personal->hotel_id,
                'buy_order' => $this->session->userdata('monobank_buy_order') ?? 'No buy_order?',
                'request' => json_encode($p),
                'response' => $curl_response,
                'method' => $method,
                'creds' => json_encode([
                    'token' => $this->token,
                ]),
            ];
            $this->db->insert($this->api_logs_tbl, $req_resp_log_data);
        }
        return $curl_response;
    }
}