<?php defined('BASEPATH') or die('No direct scripts');

class Mandarin extends CI_Controller
{
    private $merchantId = 4598;
    private $secret = 'm3vvh)w6KoL_kSPj';

    private $cashback_merchantId = 4598;
    private $cashback_secret = 'm3vvh)w6KoL_kSPj';

    private $nosplit_merchantId = 4598;
    private $nosplit_secret = 'm3vvh)w6KoL_kSPj';

    private $endpoint = 'https://secure.mandarinpay.com/api/';
    public $return_url;
    public $orders_tbl = 'booking_otelms.mandarin_order2dc_order';

    public function __construct()
    {
        parent::__construct();
        $this->load->model ( 'personal' );//must be first! coz: public function mount_personal_data()
        $this->load->model ( 'pay_processor' );
        $this->load->model ( 'mcurrency' );
        $this->load->model ( 'curl_model' );
        $this->load->model ( 'reservation' );

        if (!$this->personal->cc_test_mode) {
            $this->endpoint = 'https://secure.mandarinpay.com/api/';

            $this->merchantId = 4654;//$merchant_selector = 0 or null. Common variant with splitting (validity: account_id is set)
            $this->secret = 'khxB@%Hpc$Q!7FOw';

            $this->cashback_merchantId = 4654;//$merchant_selector = 1. Promotion variant allways splitted (account_id_cashback must be setted)
            $this->cashback_secret = 'khxB@%Hpc$Q!7FOw';


            $this->cashback_merchantId = 4884;// Agast cashback $merchant_selector = 1. Promotion variant allways splitted (account_id_cashback must be setted)
            $this->cashback_secret = '6@3s%xOLSJJi4vOd';

            $this->nosplit_merchantId = 4635;//$merchant_selector = 2. Common variant without splitting (validity: account_id is not set)
            $this->nosplit_secret = 'zWMIwUGz84)(4nHi';



        }

        $this->return_url = $this->personal->pmv3_host;
        if ($_SERVER['REMOTE_ADDR'] == "109.70.24.230") {
            $this->return_url = str_replace("otelms.com", "agast.ru", $this->return_url );
        }
        $this->return_url = $_SERVER ["HTTP_HOST"];
    }

    public function create_order_and_book($merchant_selector = 0)
    {
        $customer = $this->session->userdata('customer');
        $amount = $this->pay_processor->calculate_ccforce_rooms_amount();
        $dc_order_id = $this->session->userdata('dc_order_id');

        if ($merchant_selector == 1 && $this->pay_processor->get_mandarin_cashback_pay_state()) {
            $booking_data = (object)$this->session->userdata('booking_data');
            $amount = $booking_data->rooms_amount;
        }else {
            $merchant_selector = 0;
        }

        $pay_params = [
            'amount' => $amount,
            'currency'=>'RUB',
            'reason' => [
                'type' => '',// empty is booking by default
                'hms_res_id' => 0,
                'dc_order_id' => $dc_order_id
            ],
            'customer' => [
                'email' => isset($customer['email']) && $customer['email'] != '' ? $customer['email'] : 'info@gmail.com',
                'phone' => ''
            ],
            'merchant_selector' => $merchant_selector
        ];
        
        $result = $this->do_payment_routine($pay_params);
        
        if (isset($result->userWebLink) && $result->userWebLink != '') {
            $creation_reservation_resp = $this->reservation->create_reservation($dc_order_id);//this delete session userdata booking_data  !!!
            $where_arr = [
                'hotel_id' => $this->personal->hotel_id,
                'dc_order_id' => $dc_order_id,
            ];
            $upd_arr = [
                'hms_response' => isset($creation_reservation_resp['response']) ? $creation_reservation_resp['response'] : json_encode($creation_reservation_resp),
            ];
            $this->db->update($this->orders_tbl, $upd_arr, $where_arr);
            if ($creation_reservation_resp['result'] == 'ok') {
                header('Location:'. $result->userWebLink);
            } else {
                die ( "<meta http-equiv='refresh' content='0;url=/booking/fail'>" );
            }
        }
    }

    public function create_order_custom_pay($merchant_selector = 0)
    {
        $pay_custom_session_data = $this->session->userdata('reservation_info');
        $customer_email = $pay_custom_session_data->reservation_info->rooms[0]->email;
        $hms_res_id = $pay_custom_session_data->hms_res_id;
        $amount = $pay_custom_session_data->custom_amount;

        $pay_params = [
            'amount' => $amount,
            'currency'=>'RUB',
            'reason' => [
                'type' => 'custom_pay',
                'hms_res_id' => $hms_res_id,
                'dc_order_id' => 0
            ],
            'customer' => [
                'email' => $customer_email != '' ? $customer_email : 'info@gmail.com',
                'phone' => ''
            ],
            'merchant_selector' => $merchant_selector
        ];

        $result = $this->do_payment_routine($pay_params);

        if (isset($result->userWebLink) && $result->userWebLink != '') {
            header('Location:'. $result->userWebLink);
        }
    }

    public function do_payment_routine($p = ['amount', 'currency'=>'RUB', 'reason'=>['type'=>'', 'hms_res_id'=>0, 'dc_order_id'=>0], 'customer'=>['email', 'phone'], 'merchant_selector' => 0])
    {//'type'=>'' ''-booking, 'custom_pay'
        //$amount = $p['amount'];
        $amount = number_format($p['amount'], 2, '.', '');
        $currency = $p['currency'];
        $hms_id = $this->personal->hotel_id;
        $merchant_selector = isset($p['merchant_selector']) ? $p['merchant_selector'] : 0;
        $myUniqueOrderId = "$hms_id-";
        $retutn_url = 'https://'. $this->return_url .'/mandarin/';

        switch ($p['reason']['type']) {
            case 'custom_pay':
                $dc_order_id = 0;
                $hms_res_id = $p['reason']['hms_res_id'];
                $myUniqueOrderId .= "$hms_res_id-custom_pay_v3";
                $retutn_url .= "return_custom_pay/$hms_res_id";
                $description_fiscal = "Оплата по заказу $hms_id-$hms_res_id";
                break;
            default://type === '' is booking by def
                $dc_order_id = $p['reason']['dc_order_id'];
                $hms_res_id = 0;
                $myUniqueOrderId .= "$dc_order_id-book_v3";
                $retutn_url .= "return/$dc_order_id";
                $description_fiscal = "Оплата по заказу $hms_id-$dc_order_id";
                break;
        }

        $body = [
            'payment' => [
                'action' => 'pay',
                'orderId' => $myUniqueOrderId,
                'price' => $amount,
                'orderActualTill' => date('Y-m-d H:i:s', strtotime('+15 minutes')),
            ],
            'customerInfo' => [
                'email' => $p['customer']['email'],
                //'phone' => $customerPhone//$p['customer']['phone']
            ],
            'customValues' => [
                ['name' => 'hmsID', 'value' => $hms_id]
            ],
            'urls' => [
                'callback' => 'https://'. $this->personal->pmv3_host .'/mandarin/callback',
                'return' => $retutn_url,
            ]
        ];

        $mandarin = $this->pay_processor->get_mandarin_sync_data();

        if (isset($mandarin->hotel_inn) && $mandarin->hotel_inn != '' 
            && isset($mandarin->account_id) && $mandarin->account_id != ''
            && isset($mandarin->taxation_system) && $mandarin->taxation_system != 'npd'){
            $body['fiscalInformation'] = [
                'taxationSystem' => $mandarin->taxation_system,// Common, Simplified, SimplifiedMinusOutlay, UnifiedImputedIncome, UnifiedAgricultural, Patent, npd
                'items' => [
                    [
                        'quantity' => 1,
                        'vat' => $mandarin->vat_value ?? 'Vat0',//None, Vat0, Vat10, Vat18, Vat20
                        'description' => $description_fiscal,
                        'totalPrice' => $amount,
                        "shipper" => [
                            "name" => $mandarin->hotel_name ?? 'No name',
                            "inn" => $mandarin->hotel_inn,
                            "phones" => [
                                $mandarin->hotel_phone ?? '+79'
                            ]
                        ]
                    ]
                ]
            ];
        }

        if ($merchant_selector == 1) {
            $account_id = $mandarin->account_id_cashback;//must be setted! Is one of prmotion conditions
        } else{
            $account_id = isset($mandarin->account_id) ? $mandarin->account_id : '';
        }
        if ($account_id != '') {
            $fee = $amount * 0.026;
            $body['routing'] = [
                "destination" => [
                    [
                        "accountId" => $account_id,
                        'amount' => [
                            "value" => $amount,
                            'currency' => $currency
                        ],
                        "platformFeeAmount" => [
                            "value" => $fee,
                            'currency' => $currency
                        ],
                        "description" => null
                    ]
                ]
            ];
        }else{
            $merchant_selector = 2;//No split
        }

        $token = $this->getAuthToken($merchant_selector);
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->endpoint . 'transactions',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($body),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'X-Auth: ' . $token
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        $result = json_decode($response);
        $request_log_data = [
            'body' => $body,
            'response' => $result,
            'creds' => [
                'token' => $token,
            ]
        ];
        $log_data = [
            'pmv' => 3,
            'hotel_id' => $this->personal->hotel_id,
            'dc_order_id' => $dc_order_id,
            'hms_res_id' => $hms_res_id,
            'mandarin_id' => isset($result->id) ? $result->id : 'error',
            'amount' => $amount,
            'currency' => $currency,
            'request' => json_encode($request_log_data),
        ];
        $this->db->insert($this->orders_tbl, $log_data);

        if (isset($result->error) || isset($result->errors)) {
            echo "<pre> Error: ";
            print_r($result);
            die("DIED Mandarin.php do_payment_routine()");
        }
        return $result;
    }

    public function print_mandarin_sync_data() {
        echo "<pre>";
        $sync_data = $this->pay_processor->get_mandarin_sync_data();
        print_r($sync_data);
        die("DIED by A Department at Mandarin.php print_mandarin_sync_data() on 17 авг. 2022 г. 18:59:25");;
    }

    public function callback()
    {

        $postdata = file_get_contents("php://input");

        $data = array(
            'get' => $_SERVER['QUERY_STRING'],
            'post' => json_encode($_POST),
            'rawpost' => $postdata,
            'server' => json_encode($_SERVER)
        );
        $this->db->insert('mandarin_callback', $data);
        $id = $this->db->insert_id();

        $data = $_REQUEST;
        $where_arr = [
            'hotel_id' => $this->personal->hotel_id,
            'mandarin_id' => $data['transaction']
        ];
        $upd_arr = [
            'data_callback' => json_encode($data),
            'status' => $data['status']
        ];
        $this->db->where($where_arr)->update($this->orders_tbl, $upd_arr);
        if ($data['status'] === 'success') {
            $this->save_payment_to_hms([
                'mandarin_id' => $data['transaction']
            ]);
        }
        echo "OK";
    }

    public function return()
    {
        $data = $_GET;
        $where_arr = [
            'hotel_id' => $this->personal->hotel_id,
            'mandarin_id' => $data['id']
        ];
        $upd_arr = [
            'data_return' => json_encode($data),
            'status' => $data['status']
        ];
        $this->db->where($where_arr)->update($this->orders_tbl, $upd_arr);

        die ( "<meta http-equiv='refresh' content='0;url=/booking/confirmation'>" );
    }

    public function return_custom_pay($hms_res_id)
    {
        $data = $_GET;
        $where_arr = [
            'hotel_id' => $this->personal->hotel_id,
            'mandarin_id' => $data['id']
        ];
        $upd_arr = [
            'data_return' => json_encode($data),
            'status' => $data['status']
        ];
        $this->db->where($where_arr)->update($this->orders_tbl, $upd_arr);

        $hms_hotel_id = $this->personal->hotel_id;
        $pincode_md5 = md5($this->config->item('reservation_pincode_phrase') . $hms_hotel_id . $hms_res_id);
        die ( "<meta http-equiv='refresh' content='0;url=/booking/reservation_info/$hms_hotel_id/$hms_res_id/$pincode_md5'>" );
    }

    public function save_payment_to_hms($param)
    {
        $where_arr = [
            'hotel_id' => $this->personal->hotel_id,
            'mandarin_id' => $param['mandarin_id'],
        ];
        $orderInfo = $this->db->where($where_arr)->get($this->orders_tbl)->row();
        if ($orderInfo) {
            $url = "https://" . $this->personal->hms_host . "/gateway/mandarin_payment_update";
            $pay_curl_data = array();
            $pay_curl_data ['hms_id'] = $this->personal->hotel_id;
            $pay_curl_data ['dc_reservationid'] = $pay_curl_data ['order_id'] = $orderInfo->dc_order_id;
            $pay_curl_data ['hms_res_id'] = $orderInfo->hms_res_id;
            $pay_curl_data ['currency'] = $orderInfo->currency ? $orderInfo->currency : 'RUB';
            $pay_curl_data ['amount'] = $orderInfo->amount;
            $pay_curl_data ['transID'] = $orderInfo->mandarin_id;
            $pay_curl_data ['cc_processor'] = $this->personal->cc_processor;

            $hms_payment_insert_result = $this->curl_model->curl_plug_json($pay_curl_data, $url);

            $upd_arr = [
                'hms_payment_response' => $hms_payment_insert_result
            ];
            $this->db->update($this->orders_tbl, $upd_arr, $where_arr);
        }
    }

    private function getAuthToken($merchant_selector = 0)
    {
        $merchantId = '';
        switch ($merchant_selector) {
            case 1:
                $merchantId = $this->cashback_merchantId;
                $secret = $this->cashback_secret;
                break;
            case 2:
                $merchantId = $this->nosplit_merchantId;
                $secret = $this->nosplit_secret;
                break;
            case 0:
            default:
                $merchantId = $this->merchantId;
                $secret = $this->secret;
                break;
        }
        $requestId = time() . '_' . microtime(true) . '_' . rand();
        $hash = hash('sha256', $merchantId . '-' . $requestId . '-' . $secret);

        return $merchantId . '-' . $hash . '-' . $requestId;
    }
}
//testing creds on VPN https://docs.mandarin.io/public/test_data.html#тестовые-карты