<?php

defined('BASEPATH') or die('No direct scripts');

class Ipay extends CI_Controller
{
    private $orders_tbl = 'booking_otelms.ipay_order2dc_order_v3';
    private $clientId = 1006;
    private $secretKey = '581ba5eeadd657c8ccddc74c839bd3ad';
    private $endpoint = 'https://dev.ipay.ge/opay/api/v1/';
    private $token;
    private $hash_key = 'wfhu5356jouih35';

    public function __construct()
    {
        parent::__construct();

        $this->load->model ( 'personal' );//must be first! coz: public function mount_personal_data()
        $this->load->model ( 'pay_processor' );
        $this->load->model ( 'mcurrency' );
        $this->load->model ( 'curl_model' );
        $this->load->model ( 'reservation' );

        if (!$this->personal->cc_test_mode && !$this->config->item('ipay_test_mode')) {
            $creds = $this->get_live_sync_creds();
            $this->endpoint = $creds->endpoint;
            $this->clientId = $creds->clientId;
            $this->secretKey = $creds->secretKey;
        }
        $this->token = $this->getToken();
    }

    public function create_order_and_book()
    {
        $amount = $this->pay_processor->calculate_ccforce_rooms_amount();
        $currency = 'GEL';//strtoupper($this->mcurrency->get_currency_name());
        $dc_order_id = $this->session->userdata('dc_order_id');
        $result = $this->do_create_order_routine([
            'amount' => $amount,
            'currency' => $currency,
            'reason' => [
                'type' => '',//empty is booking by default
                'hms_res_id' => 0,
                'dc_order_id' => $dc_order_id
            ]
        ]);

        if (isset($result->status) && $result->status === 'CREATED') {
            $creation_reservation_resp = $this->reservation->create_reservation($dc_order_id);//this delete session userdata booking_data  !!!
            $where_arr = [
                'hotel_id' => $this->personal->hotel_id,
                'dc_order_id' => $dc_order_id,
            ];
            $upd_arr = [
                'hms_booking_response' => isset($creation_reservation_resp['response']) ? $creation_reservation_resp['response'] : json_encode($creation_reservation_resp),
            ];
            $this->db->update($this->orders_tbl, $upd_arr, $where_arr);

            if ($creation_reservation_resp['result'] == 'ok') {
                header('Location:' . $result->links{1}->href);
            } else {
                die ( "<meta http-equiv='refresh' content='0;url=/booking/fail'>" );
            }
        } else {
            echo "<pre>Error<br>";
            print_r($result);
            die("DIED by A Department at Ipay.php do_transaction_routine()");
        }
    }

    public function create_order_custom_pay()
    {
        $pay_custom_session_data = $this->session->userdata('reservation_info');
        $hms_res_id = $pay_custom_session_data->hms_res_id;
        $amount = $pay_custom_session_data->custom_amount;
        $currency = 'GEL';//strtoupper($this->mcurrency->get_currency_name());
        $result = $this->do_create_order_routine([
            'amount' => $amount,
            'currency' => $currency,
            'reason' => [
                'type' => 'custom_pay',
                'hms_res_id' => $hms_res_id,
                'dc_order_id' => 0
            ]
        ]);

        if (isset($result->status) && $result->status === 'CREATED') {
            header('Location:' . $result->links{1}->href);
        } else {
            echo "<pre>Error<br>";
            print_r($result);
            die("DIED by A Department at Ipay.php do_transaction_routine()");
            //                     [error_code] => 405
            //                     [error_message] => Payment not allowed, please contact support@ipay.ge
            //                     [information_link] =>
            //                     [details] =>

        }
    }

    public function do_create_order_routine ($p = ['amount', 'currency'=>'GEL', 'reason'=>['type'=>'', 'hms_res_id'=>0, 'dc_order_id'=>0]]) {
        $hms_id = $this->personal->hotel_id;
        $amount = $p['amount'];
        $currency = $p['currency'];
        $shop_order_id = "$hms_id-";
        $retutn_url = 'https://'. $this->personal->pmv3_host .'/ipay/callback_result';
        $lang = 'en-US'; // чи 'ka' для грузинської
        switch ($p['reason']['type']) {
            case 'custom_pay':
                $dc_order_id = 0;
                $hms_res_id = $p['reason']['hms_res_id'];
                $shop_order_id .= "$hms_res_id-custom_pay";
                $retutn_url .= "?hms_res_id=$hms_res_id";
                break;
            default://type === '' is booking by def
                $dc_order_id = $p['reason']['dc_order_id'];
                $hms_res_id = 0;
                $shop_order_id .= "$dc_order_id-book";
                $retutn_url .= "?dc_order_id=$dc_order_id";
                break;
        }
        $hash_code = urlencode(base64_encode(md5($shop_order_id.$this->hash_key)));
        $retutn_url .= "&code=$hash_code";
        $description = '';

        $body = [
            'intent' => 'CAPTURE',
            'shop_order_id' => $shop_order_id,
            'locale' => $lang,
            'capture_method' => 'AUTOMATIC',
            'items' => [
                [
                    'amount' => $amount,
                    'description' => $description,
                    'quantity' => 1,
                    'product_id' => $shop_order_id,
                ]
            ],
            'redirect_url' => $retutn_url,
            'purchase_units' => [
                [
                    'amount' => [
                        'currency_code' => $currency,
                        'value' => $amount,
                    ],
                    'industry_type' => 'tourism',
                ]
            ]
        ];

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $this->endpoint . 'checkout/orders',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($body),
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                'Authorization: Bearer ' . $this->token
            ],
        ]);
        $response = curl_exec($curl);
        curl_close($curl);

        $result = json_decode($response);
        $ipay_order_id = isset($result->order_id) ? $result->order_id : 'error';

        $req_resp_log_data = [
            'request' => $body,
            'response' => $result,
            'creds' => [$this->clientId, $this->secretKey]
        ];
        $log_data = [
            'pmv' => 3,
            'hotel_id' => $this->personal->hotel_id,
            'dc_order_id' => $dc_order_id,
            'hms_res_id' => $hms_res_id,
            'ipay_order_id' => $ipay_order_id,
            'amount' => $amount,
            'currency' => $currency,
            'req_resp' => json_encode($req_resp_log_data),
        ];
        $this->db->insert($this->orders_tbl, $log_data);
        return $result;
    }

    public function callback_result()
    {
        $get = $this->input->get();
        $hms_hotel_id = $this->personal->hotel_id;
        $selector_tbl_fild = '';
        $selector_id = '';//dc_order or hms_res
        if (isset($get['dc_order_id'])) {
            $selector_tbl_fild = 'dc_order_id';
            $selector_id = $get['dc_order_id'];
            $shop_order_id = "book";
        }elseif (isset($get['hms_res_id'])) {
            $selector_tbl_fild = 'hms_res_id';
            $selector_id = $get['hms_res_id'];
            $shop_order_id = "custom_pay";
        }
        $shop_order_id = "$hms_hotel_id-$selector_id-$shop_order_id";
        $hash_code = md5($shop_order_id.$this->hash_key);
        if (isset($get['code']) && base64_decode(urldecode($get['code'])) == $hash_code && $selector_tbl_fild != '' && $selector_id != '') {
            $where_arr = [
                'hotel_id' => $hms_hotel_id,
                $selector_tbl_fild => $selector_id,
            ];

            $query_order_row = $this->db->select('ipay_order_id')->get_where($this->orders_tbl, $where_arr)->row();
            if ($query_order_row && $query_order_row->ipay_order_id != 'error') {
                $ipay_order_id = $query_order_row->ipay_order_id;
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => $this->endpoint . 'checkout/payment/' . $ipay_order_id,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'GET',
                    CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json',
                        'Authorization: Bearer ' . $this->token
                    ),
                ));
                $response = curl_exec($curl);
                curl_close($curl);

                $result = json_decode($response);

                $upd_arr = [
                    'callback_result' => $response,
                ];
                $this->db->update($this->orders_tbl, $upd_arr, $where_arr);

                if (isset($result->status) && $result->status == 'success') {
                    $this->save_payment_to_hms(['ipay_order_id' => $ipay_order_id]);
                }else {
//                     echo "<pre>";
//                     print_r($result);
//                     die("DIED by A Department at Ipay.php callback_result() on 2 сент. 2022 г. 19:34:28");
                    die ( "<meta http-equiv='refresh' content='0;url=/booking/payment_failed'>" );
                }

                switch ($selector_tbl_fild) {
                    case 'dc_order_id':
                        die ( "<meta http-equiv='refresh' content='0;url=/booking/confirmation'>" );
                    break;
                    case 'hms_res_id':
                        $pincode_md5 = md5($this->config->item('reservation_pincode_phrase') . $hms_hotel_id . $selector_id);
                        die ( "<meta http-equiv='refresh' content='0;url=/booking/reservation_info/$hms_hotel_id/$selector_id/$pincode_md5'>" );
                        break;
                }
            }
        }
    }

    public function save_payment_to_hms($p)
    {
        $where_arr = [
            'hotel_id' => $this->personal->hotel_id,
            'ipay_order_id' => $p['ipay_order_id'],
        ];
        $orderInfo = $this->db->get_where($this->orders_tbl, $where_arr)->row();
        if ($orderInfo) {
            $url = "https://" . $this->personal->hms_host . "/gateway/przelewy24_payment_update";
            $pay_curl_data = array();
            $pay_curl_data ['hms_id'] = $this->personal->hotel_id;
            $pay_curl_data ['dc_reservationid'] = $pay_curl_data ['order_id'] = $orderInfo->dc_order_id;
            $pay_curl_data ['hms_res_id'] = $orderInfo->hms_res_id;
            $pay_curl_data ['currency'] = $orderInfo->currency;
            $pay_curl_data ['amount'] = $orderInfo->amount;
            $pay_curl_data ['transID'] = $orderInfo->ipay_order_id;
            $pay_curl_data ['cc_processor'] = $this->personal->cc_processor;

            $hms_payment_insert_result = $this->curl_model->curl_plug_json($pay_curl_data, $url);
            $upd_arr = [
                'hms_payment_response' => $hms_payment_insert_result
            ];
            $this->db->update($this->orders_tbl, $upd_arr, $where_arr);
        }
    }

    private function getToken()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->endpoint . 'oauth2/token',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'grant_type=client_credentials',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded',
                'Authorization: Basic ' . base64_encode($this->clientId . ':' . $this->secretKey)
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return json_decode($response, true)['access_token'];
    }

    private function get_live_sync_creds() {
        $creds = [];
        $creds['endpoint'] = 'https://ipay.ge/opay/api/v1/';

        $tbl = 'booking_otelms.hms_config_params';
        $prefix = 'ipay_';
        $query_res = $this->db->select('name, value')->like('name', $prefix, 'after')->get_where($tbl, ['hms_id'=>$this->personal->hotel_id])->result();
        foreach ($query_res as $item) {
            $creds[str_replace($prefix, '', $item->name)] = $item->value;
        }
        return (object)$creds;
    }
}