<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Echannel extends CI_Controller {
    public function __construct() {
        parent::__construct ();
        $this->load->model ( 'echannel_mdl' );
    }

	public function index()
	{
		die ( "<meta http-equiv='refresh' content='0;url=/echannel/start_page'>" );
	}

	public function login()
	{
	    $post = $this->input->post();
	    if (count($post)) {
	        if (isset($post['login']) && isset($post['password'])) {
	            $user = $this->db->get_where($this->echannel_mdl->auth_tbl, ['user' => $post['login'], 'password' => md5($post['password'])])->row();
	            if ($user) {
	                $this->session->set_userdata(['user' => ['id'=> $user->id, 'user'=> $user->user, 'logined' => 1]]);
	                die ( "<meta http-equiv='refresh' content='0;url=/echannel'>" );
	            }else {
	                $this->session->sess_destroy();
	            }
	        }else{
	            $this->session->sess_destroy();
	        }
	    }
	    $data = [];
	    $this->parser->parse ( 'templates/echannel/login_view.html', $data);
	}

	public function logout(){
	    $this->session->sess_destroy();
	    die ( "<meta http-equiv='refresh' content='0;url=/echannel'>" );
	}

	public function start_page() {
	    $this->load->view ( '/echannel/start_page_view.php' );
	}

	public function get_rooms() {
	    $post = $this->input->post();
	    $request = [];
	    if (isset($post['re_request'])) {
	        $request = json_decode($post['re_request'], true);
	        if (json_last_error() !== JSON_ERROR_NONE) {
	            $request = $post['re_request'];
	        }
	    }
	    $result = $this->echannel_mdl->get_rooms($request);
	    $pars_data = [
	        'req_resp' => $result,
	        'action' => '/get_rooms'
	    ];
	    if (isset($result['response']->rooms)) {
	        $rooms = $result['response']->rooms;
	    } else {
	        $rooms = [];
	    }
	    $this->load->view ( '/echannel/rooms_view.php', ['rooms' => $rooms, 'req_resp_html'=>$this->get_req_resp_html($pars_data)]);
	}

	public function get_rates() {
	    $post = $this->input->post();
	    $request = [];
	    if (isset($post['re_request'])) {
	        $request = json_decode($post['re_request'], true);
	        if (json_last_error() !== JSON_ERROR_NONE) {
	            $request = $post['re_request'];
	        }
	    }
	    $result = $this->echannel_mdl->get_rates($request);
        $pars_data = [
            'req_resp' => $result,
            'action' => '/get_rates'
        ];
        if (isset($result['response']->rates)) {
            $rates = $result['response']->rates;
        } else {
            $rates = [];
        }
	    $this->load->view ( '/echannel/rates_view.php', ['rates' => $rates, 'req_resp_html'=>$this->get_req_resp_html($pars_data)]);
	}
	
	public function get_properties() {
	    $post = $this->input->post();
	    $request = [];
	    if (isset($post['re_request'])) {
	        $request = json_decode($post['re_request'], true);
	        if (json_last_error() !== JSON_ERROR_NONE) {
	            $request = $post['re_request'];
	        }
	    }
	    $result = $this->echannel_mdl->get_properties($request);
	    $pars_data = [
	        'req_resp' => $result,
	        'action' => '/get_properties'
	    ];
	    if (isset($result['response']->properties)) {
	        $properties = $result['response']->properties;
	    } else {
	        $properties = [];
	    }
	    $this->load->view ( '/echannel/properties_view.php', ['properties' => $properties, 'req_resp_html'=>$this->get_req_resp_html($pars_data)]);
	}
	
	public function get_properties_list() {
	    $post = $this->input->post();
	    $request = [];
	    if (isset($post['re_request'])) {
	        $request = json_decode($post['re_request'], true);
	        if (json_last_error() !== JSON_ERROR_NONE) {
	            $request = $post['re_request'];
	        }
	    }
	    $result = $this->echannel_mdl->get_properties_list($request);
	    $pars_data = [
	        'req_resp' => $result,
	        'action' => '/get_properties_list'
	    ];
	    if (isset($result['response'])) {
	        $properties = $result['response'];
	    } else {
	        $properties = [];
	    }
	    $this->load->view ( '/echannel/properties_list_view.php', ['properties' => $properties, 'req_resp_html'=>$this->get_req_resp_html($pars_data)]);
	}

	public function get_reservations() {
	    $post = $this->input->post();
	    $request = [];
	    if (isset($post['re_request'])) {
	        $request = json_decode($post['re_request'], true);
	        if (json_last_error() !== JSON_ERROR_NONE) {
	            $request = $post['re_request'];
	        }
	    }
	    $result = $this->echannel_mdl->get_reservations($request);
	    $response = $result['response'];
	    $pars_data = [
	        'req_resp' => $result,
	        'action' => '/get_reservations'
	    ];
	    if (isset($response->bookings)) {
	        $reservations = $response->bookings;
	    } else {
	        $reservations = [];
	    }
	    $this->load->view ( '/echannel/reservations_view.php', ['reservations' => $reservations, 'req_resp_html'=>$this->get_req_resp_html($pars_data)]);
	}

	public function booking() {
	    $this->load->view ( '/echannel/booking_view.php' );
	}

	public function booking_post() {
	    $post = $this->input->post();
	    $result = $this->echannel_mdl->set_reservation($post);
	    $pars_data = [
	        'req_resp' => $result,
	        'action' => '/booking_post'
	    ];
	    $data = [];
	    $data['header'] = $this->echannel_mdl->Get_Header(['nav_item_marker'=>'products', 'sub_nav_item_marker'=>'dores']);
	    $data['dc_id'] = $this->echannel_mdl->dc_id;
	    $data['hms_id'] = $this->echannel_mdl->hms_id;
	    $data['req_resp_html'] = $this->get_req_resp_html($pars_data);
	    $this->parser->parse ( 'templates/echannel/booking_result_view.html', $data);
	}

	public function get_rna() {
	    $this->load->view ( '/echannel/get_rna_view.php' );
	}

	public function get_rna_post() {
	    $post = $this->input->post();
	    $result = $this->echannel_mdl->get_rna($post);
	    $pars_data = [
	        'req_resp' => $result,
	        'action' => '/get_rna_post'
	    ];
	    $this->load->view ( '/echannel/rnas_view.php', ['result_requesting' => $result, 'req_resp_html'=>$this->get_req_resp_html($pars_data)]);
	}

	public function cancel_reservation($dc_uid = '') {
	    $post = $this->input->post();
	    if ($dc_uid != '' || isset($post['re_request'])) {
	        $post['dc_uid'] = urldecode($dc_uid);
	        $result = $this->echannel_mdl->cancel_reservation($post);
	    }else {
	        $result = [];
	        $result['request'] = $this->echannel_mdl->creds;
	        $result['request']['hms_id'] = $this->echannel_mdl->hms_id;
	        $result['request']['dc_id'] = $this->echannel_mdl->dc_id;
	        $result['request']['id'] = 'ENTER_RESERVATION_UID';
	        $result['request']['status'] = "cancel";
	        $result['response'] = 'hide_response';
	    }
	    $pars_data = [
	        'req_resp' => $result,
	        'action' => '/cancel_reservation'
	    ];
	    $data = [];
	    $data['header'] = $this->echannel_mdl->Get_Header(['nav_item_marker'=>'products', 'sub_nav_item_marker'=>'cancelres']);
	    $data['dc_id'] = $this->echannel_mdl->dc_id;
	    $data['hms_id'] = $this->echannel_mdl->hms_id;
	    $data['hide_header_class'] = $result['response'] == 'hide_response' ? 'd-none' : '';
	    $data['req_resp_html'] = $this->get_req_resp_html($pars_data);
	    $this->parser->parse ( 'templates/echannel/canceling_result_view.html', $data);
	}

	public function get_reservation_info($dc_uid = '') {
	    $post = $this->input->post();
	    if ($dc_uid != '' || isset($post['re_request'])) {
	        $post['dc_uid'] = urldecode($dc_uid);
	        $result = $this->echannel_mdl->get_reservation_info($post);
	        
	    }else {
	        $result = [];
	        $result['request'] = $this->echannel_mdl->creds;
	        $result['request']['hms_id'] = $this->echannel_mdl->hms_id;
	        $result['request']['dc_id'] = $this->echannel_mdl->dc_id;
	        $result['request']['id'] = 'ENTER_RESERVATION_UID';
	        $result['response'] = 'hide_response';
	    }
	    $pars_data = [
	        'req_resp' => $result,
	        'action' => '/get_reservation_info'
	    ];
	    $data = [];
	    $data['header'] = $this->echannel_mdl->Get_Header(['nav_item_marker'=>'products', 'sub_nav_item_marker'=>'resinfo']);
	    $data['dc_id'] = $this->echannel_mdl->dc_id;
	    $data['hms_id'] = $this->echannel_mdl->hms_id;
	    $data['hide_header_class'] = $result['response'] == 'hide_response' ? 'd-none' : '';
	    $data['req_resp_html'] = $this->get_req_resp_html($pars_data);
	    $this->parser->parse ( 'templates/echannel/reservation_info_view.html', $data);
	}

	private function get_req_resp_html($pars_data) {
	    $req_resp = $pars_data['req_resp'];
	    $form_action = '/echannel';
	    if (isset($pars_data['action'])) {
	        $form_action .= $pars_data['action'];
	    }
	    $data = [];
	    $data['action'] = $form_action;
	    $data['request_url'] = $this->echannel_mdl->last_request_url;
	    $data['request_pure'] = $this->echannel_mdl->last_curl_request;
 	    $data['response_pure'] = $this->echannel_mdl->last_curl_response;
 	    $this->echannel_mdl->last_curl_response = $this->echannel_mdl->last_curl_request = $this->echannel_mdl->last_request_url = '';
	    $data['request'] = is_string($req_resp['request']) ? $req_resp['request'] : json_encode($req_resp['request'], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
	    $maked_response = $this->make_response($req_resp['response']);
	    $data['response'] = $maked_response->body;
	    $data['response_text_bg'] = $maked_response->text_bg;
	    $data['response_hiding'] = $maked_response->hide_response;
	    $data['text_area_rows'] = substr_count($data['request'], PHP_EOL) + 1;
	    $data['text_request_btn'] = $req_resp['response'] == 'hide_response' ? 'Send Request' : 'Resend Request';
	    return $this->parser->parse ( 'templates/echannel/tmplt_request_response.html', $data, true);
	}

	private function make_response($response) {
	    if (is_array($response) || is_object($response)) {
	        $response = '<pre>'.stripslashes(json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)).'</pre>';
	        $text_bg = $hide_response = '';
	    }else {
	        $hide_response = $response == 'hide_response' ? 'd-none' : '';
	        $text_bg = 'text-bg-danger';
	        $response = 'JSON FORMAT ERROR';//response is spring so error, therefore empting it, specialy for volodia
	    }
	    return (object)['body' => $response, 'hide_response' => $hide_response, 'text_bg' => $text_bg];
	}

	public function push(){
	    $tbl = '`echannel_client`.`pushes`';
	    $body = $this->input->post();
	    $this->db->insert($tbl, ['body' => $body]);
	}

	public function get_pushes(){
	    $tbl = '`echannel_client`.`pushes`';
	}
}