<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Debug extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
    public function __construct() {
        parent::__construct ();
        $this->load->model ( 'personal' );//must be first! coz: public function mount_personal_data()
        $this->load->model ( 'content' );
        $this->load->model ( 'mcurrency' );
    }
	public function index()
	{
		echo "Hello World!";
	}

	public function rooms_data() {
	    $incoming_data = array(
	        'hotel_id' => 92,
	        //'lang_code' => 570,//rus
	        'lang_code' => 45,//rus
	        'date_in' => '2020-12-07',
	        'date_out' => '2020-12-08',
	        'requested_rooms_count' => 1,
	        'max_requested_persons' => 4,
	        'duration' => 2,
	        'hms_free_rooms' => array(
	            '3' => array(
	                'category_id' => 3,
	                'rooms_remaining' => 8,
	                'max_room_places' => 10,
	                'rates' => array(
	                    '119' => array(
	                        'rate_id' => 119,
	                        'price' => 667
	                    ),
	                    '158' => array(
	                        'rate_id' => 158,
	                        'price' => 690
	                    )
	                )
	            )
	        )
	    );
	    $result = $this->content->get_rooms_data($incoming_data);
	    echo "<pre>";
	    print_r($result);
	    die("DIED by A Department at Debug.php parsing_free_rooms_TFV() ASAP");

	}

	public function get_reviews() {
	    echo "<pre>";

	    $hotel_id = $this->personal->hotel_id;
	    $query = $this->db->select('body, dc_id')->get_where('hms_reviews', ['hms_id'=>$hotel_id, 'block_2'=>1])->result();

	    $reviews = [];
	    foreach ($query as $row) {
	        echo $row->dc_id . "\n";
	        print_r(json_decode($row->body, true));
	        $review = json_decode($row->body, true);
	        if ($row->dc_id == 1) {
	            $cell = [];
	            $cell['reviewer_name'] = $review['reviewer']['name'] ?? "anonymous";
	            $cell['content_headline'] = $review['content']['headline'] ?? "";
	            $cell['content_positive'] = $review['content']['positive'] ?? "";
	            $cell['content_negative'] = $review['content']['negative'] ?? "";
	            $cell['date'] = $review['created_timestamp'] ?? "";
	            $cell['review_score'] = $review['scoring']['review_score'] ?? "";

	            $total = 0;
	            $count = 0;
	            foreach ($review['scoring'] as $arg) {
	                $total += floatval($arg);
	                echo $total . "-";
	                $count++;
	            }
	            $cell['review_score'] = $total / $count;

	            array_push($reviews, $cell);
	        }
	    }

	    print_r($reviews);
	}
	function show_data() {

// 	    echo "<pre>";
// 	    echo session_id() . "\n";
// 	    $booking_data = $this->session->userdata('booking_data');
// 	    print_r($booking_data);
// 	    print_r($_COOKIE);
// 	    print_r($_SESSION);
// 	    print_r($_SERVER);
	}

	public function for_needs_import_xls_file() {
	    $data = array ();
	    $this->parser->parse ( 'templates/for_needs_import_xls_file.html', $data );
	}
	public function for_needs_import_xls_file_post() {
	    // 		$tab_number = $_POST ['tab_number'];
	    include './application/libraries/xls/Classes/PHPExcel/IOFactory.php';
	    // print_r($_FILES);
	    // die();
	    $inputFileName = $_FILES ['file_data'] ['tmp_name'];
	    // $str_data = utf8_encode($str_data);
	    // $encoding = $this->input->post ( 'encoding' );
	    // Read your Excel workbook
	    try {
	        $inputFileType = PHPExcel_IOFactory::identify ( $inputFileName );
	        $objReader = PHPExcel_IOFactory::createReader ( $inputFileType );
	        $objPHPExcel = $objReader->load ( $inputFileName );
	    } catch ( Exception $e ) {
	        die ( 'Error loading file "' . pathinfo ( $inputFileName, PATHINFO_BASENAME ) . '": ' . $e->getMessage () );
	    }
	    $SheetCount = $objPHPExcel->getSheetCount();
	    $inserting_data = array();
	    while ($SheetCount > 0) {
	        $sheet = $objPHPExcel->getSheet ( $SheetCount-1 );
	        // 			$sheet_name = $sheet->getTitle();
	        $highestRow = $sheet->getHighestRow ();
	        $highestColumn = 'F';//$sheet->getHighestColumn ();//'A';//
	        // 			$rowData = $sheet->rangeToArray ( 'A1:' . $highestColumn . '1', NULL, FALSE, TRUE, TRUE ); // get titles, 1 row
	        // 			$curency_id = $rowData[1]['A'];
	        $rowData = $sheet->rangeToArray ( 'A2:' . $highestColumn.$highestRow, NULL, FALSE, TRUE, TRUE );
	        foreach ($rowData as $value) {
	            // $hms_id = (strpos($value['A'], "(")) ? substr($value['A'], 0, strpos($value['A'], "(")) : $value['A'];

	            // 			    $name = $value['A'];
	            // 			    $name = explode(" ", $name);
	            array_push($inserting_data, array(
	                'id' => $value['A'],
	                'parent_id' => $value['B'],
	                'label' => $value['C'],
	                'caption' => 'clt_billing_'.$value['C'],
	                'region_id' => $value['E'],
	                'level' => $value['F'],
	            ));
	        }
	        $SheetCount--;
	    }
	    if (isset ( $_POST ["save_to_bd"] )) {
	        $tbl_name = "global_hotelix_stripe.plans_modules_1";
	        $this->db->insert_batch($tbl_name, $inserting_data);
	        $updating_status_str = "DB IS updated whith data";
	    } else {
	        $updating_status_str = "DB is NOT updated whith data";
	    }
	    echo("<pre>");
	    echo $updating_status_str, ':<br><a href="/debug/for_needs_import_xls_file"><input type="button" value="OK" /></a><br>';
	    print_r ( $inserting_data );
	    echo $updating_status_str, '<br><a href="/debug/for_needs_import_xls_file"><input type="button" value="OK" /></a><br>';
	}
}
