<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Booking extends CI_Controller {
    public $debug_mode = FALSE;
    public $home_page_url;
    public function __construct() {
        parent::__construct ();
        $this->load->model ( 'personal' );//must be first! coz: public function mount_personal_data()
        $this->load->model ( 'mcurrency' );
        $this->load->model ( 'mlanguages' );
        $this->load->model ( 'content' );
        $this->load->model ( 'reservation' );
        $this->load->model ( 'curl_model' );
        $this->load->model ( 'paypal_mdl' );
        $this->load->model ( 'pay_processor' );
        $this->load->model ( 'acquiring' );
        $this->load->model ( 'htmltpl' );
        
        $this->home_page_url = $this->content->get_home_page_url($this->personal->home_page_type);
    }

	public function index()
	{
		die ( "<meta http-equiv='refresh' content='0;url=/booking/{$this->home_page_url}'>" );
	}
	
	public function properties()
	{
	    //die("PBH_");
	    $get = $this->input->get();
	    if (isset($get['debug']) && $get['debug'] === 'true'){
	        $this->debug_mode = true;
	    }
	    $this->load->view ( '/booking/props_view.php' );
	}

	public function rooms()
	{
	    $get = $this->input->get();
	    if (isset($get['debug']) && $get['debug'] === 'true'){
	        $this->debug_mode = true;
	    }
	    $this->load->view ( '/booking/rooms_view.php' );
	}

	public function ajax_set_session_language() {
	    $post = $this->input->post();
	    $_SESSION ["interface_language"] = $post['lang'];
	}

	public function ajax_set_session_currency() {
	    $post = $this->input->post();
	    $_SESSION ["interface_currency"] = $post['curr'];
	}

	public function rooms_ajax_post_data()//when search btn was pressed
	{
	    $post = $this->input->post();
	    $booking_data = [];
	    if (isset($post['client_data'])){
	        $client_dataset = $post['client_data'];
	        if (isset($client_dataset['rooms'])){
	            $parties = [];
	            foreach ($client_dataset['rooms'] as $room) {
	                array_push($parties, [
	                    'adults' => $room['adult'],
	                    'children' => (isset($room['children'])) ? $room['children'] : []
	                ]);
	            }
	            $booking_data['parties'] = $parties;
	        }
	        $booking_data['peoples'] = isset($client_dataset['peoples']) ? $client_dataset['peoples']['adult'] + $client_dataset['peoples']['children'] : 0;
            if (isset($client_dataset['selectedDate'])){
                $date_in = date("Y-m-d", substr($client_dataset['selectedDate']['in']['timestamp'], 0, -3));
                $date_out = date("Y-m-d", substr($client_dataset['selectedDate']['out']['timestamp'], 0, -3));
                $booking_data['date_in'] = $date_in;
                $booking_data['date_out'] = $date_out;
                $booking_data['duration'] = date_diff(date_create($date_in), date_create($date_out))->days;
            }
            $booking_data['promo'] = [];
            $booking_data['promo']['code'] = $client_dataset['promoCode'];
	    }
	    $this->session->set_userdata(['booking_data' => array_merge((array)$this->session->userdata('booking_data'), $booking_data)]);
	}

	public function ajax_nofreerooms_post_data() {
	    $post = $this->input->post();
	    $booking_data = $this->session->userdata('booking_data');
	    if ($booking_data){
	        $booking_data['date_in'] = $post['date_in'];
	        $booking_data['date_out'] = $post['date_out'];
	        $this->session->set_userdata(['booking_data' => $booking_data]);
	    }
	}

	public function rooms_next_page()
	{
	    $get = $this->input->get();
	    $booking_data = $this->session->userdata('booking_data');
	    $metadata = json_decode(base64_decode($get['data']), true);
	    
	    foreach ($booking_data['parties'] as &$party) {// in future rooms & rates for each party may by different
	        $party['selected_category'] =  $get['room'];
	        $party['selected_rate'] =  $get['rate'];
	        $party['promoted'] = $metadata['promoted'];
	        $party['promo_data'] = $metadata['promo_data'];
	    }
	    
	    $booking_data['rooms_amount'] = $metadata['rooms_amount'];
	    $booking_data['payment_required'] = $metadata['payment_required'];
	    $booking_data['promo']['promoted'] = $metadata['promoted'];
	    $booking_data['promo']['promo_data'] = $metadata['promo_data'];
	    $this->session->set_userdata(['booking_data' => $booking_data]);
	    $this->session->set_userdata(['completed_steps' => ['booking_data' => true]]);

	    $next_page = 'services';//by default
	    $available_servicesList = $this->content->check_services_availability();
	    if (sizeof($available_servicesList) == 0) {
	        $next_page = 'guests';//no services
	    }
        die ( "<meta http-equiv='refresh' content='0;url=/booking/$next_page'>" );
	}

	public function services()
	{
	    $booking_data = $this->session->userdata('booking_data');
	    if (!($booking_data['parties']??false)){
	        die ( "<meta http-equiv='refresh' content='0;url=/booking/{$this->home_page_url}'>" );
	    }
	    $this->load->view ( 'booking/services_view.php');
	}

	public function services_post()
	{
	    $post = $this->input->post();
	    $booking_data = $this->session->userdata('booking_data');

	    $services = $post['services'] ?? false;
	    if ($services){
	        $services_list = [];
	        $services_amount = 0;
	        foreach ($services as $service_id => $nevermind) {
	            $services_list[$service_id] = json_decode(base64_decode($post['data'][$service_id]), true);
	            $services_amount += $services_list[$service_id]['service_price'] * $services_list[$service_id]['service_qty'];
	        }
	        $booking_data['services']['list'] = $services_list;
	        $booking_data['services']['amount'] = $services_amount;
	    }else{
	        unset($booking_data['services']);
	    }
	    $this->session->set_userdata(['booking_data' => $booking_data]);
	    die ( "<meta http-equiv='refresh' content='0;url=/booking/guests'>" );
	}

	public function payment()
	{
	    if (!isset($_SESSION['guest_ip'])) {
	        $_SESSION['guest_ip'] = $_SERVER['REMOTE_ADDR'];
	    }
	    $booking_data = $this->session->userdata('booking_data');
	    if (!($booking_data['parties']??false)){
	        die ( "<meta http-equiv='refresh' content='0;url=/booking/{$this->home_page_url}'>" );
	    }
	    $this->load->view ( 'booking/payment_view.php');
	}

	public function guests()
	{
	    $booking_data = $this->session->userdata('booking_data');
	    if (!($booking_data['parties']??false)){
	        die ( "<meta http-equiv='refresh' content='0;url=/booking/{$this->home_page_url}'>" );
	    }
	    $this->load->view ( 'booking/guests_view.php');
	}


	public function guests_post()
	{
	    $booking_data = $this->session->userdata('booking_data');
	    $post = $this->input->post();
	    $guests = $post['guests'];
	    $customer = $post['customer'];
	    if (isset($customer['is_selfguest'])){
	        $customer['is_selfguest'] = 1;
	    }else{
	        $customer['is_selfguest'] = 0;
	    }
	    if (isset($post['mandarin_merchant_selector'])) {
	        $this->session->set_userdata(['cc_processor_data' => ['mandarin_merchant_selector' => $post['mandarin_merchant_selector']]]);
	        $booking_data['payment_required']['ccforce'] = 1;
	    }
	    $customer['dob'] = date('Y-m-d', strtotime('- 35 year'));
	    $this->session->set_userdata(['customer'=>$customer, 'guests'=>$guests]);
	    $completed_steps = $this->session->userdata('completed_steps') ?? ['completed_steps'];
	    $completed_steps['customer'] = true;
	    $this->session->set_userdata(['completed_steps' => $completed_steps]);
	    $booking_data['description'] = $post['description'];
	    $this->session->set_userdata(['booking_data' => $booking_data]);
	    die ( "<meta http-equiv='refresh' content='0;url=/booking/booking_processing'>" );
	}

	public function show_data() {
	    echo "<pre>";
	    print_r($this->session->userdata());
	}

	public function show_debug_data() {
	    echo "<pre>";
	    print_r($this->session->userdata('debug_data'));
	}

	public function clear_session() {
	    $this->session->unset_userdata('booking_data');
	    $this->session->unset_userdata('confirmation_data');
	    $this->session->unset_userdata('dc_order_id');
	    $this->session->unset_userdata('hms_system_id');
	    //session_destroy();
	}

	function booking_processing() {//modul_booking_request
	    $next_page = "confirmation";
	    $booking_data = $this->session->userdata('booking_data');

	    //$payment_required = (isset($booking_data['payment_required']['ccforce'])) ? $booking_data['payment_required']['ccforce'] : 0;
	    $payment_required = $booking_data['payment_required']['ccforce'] ?? 0;
	    $acquiring_is_available = $this->acquiring->is_available();
// 	    echo $acquiring_is_available." == ". $payment_required;
// echo "<pre>";
// print_r($this->personal);
//  	    die();
	    if ($payment_required && $acquiring_is_available){
	        $next_page = "payment";
	    }else {
	        $response = $this->reservation->create_reservation($this->reservation->get_new_dc_reservation_id());
	        if ($response['result'] != "ok") {
	            $next_page = 'fail';
	        }
	    }
	    die ( "<meta http-equiv='refresh' content='0;url=/booking/$next_page'>" );
	}

	public function confirmation()
	{
	    $confirmation_data = $this->session->userdata('confirmation_data') ?? false;
	    if (!$confirmation_data) $confirmation_data = isset($_SESSION['confirmation_data']) ? $_SESSION['confirmation_data'] : false;
	    if (!$confirmation_data){
	        die ( "<meta http-equiv='refresh' content='0;url=/booking/{$this->home_page_url}'>" );
	    }
	    $this->load->view ( 'booking/confirmation_view.php');
	}

	public function ajax_category_detail_discription() {
	    $post = $this->input->post();
	    $room_data = $this->content->get_room_descriptions(['category_id'=>$post['id']]);
	    $room_data['amenities'] = $this->content->get_room_amenities_by_type(['category_id'=>$post['id']]);
	    $this->mlanguages->getdictionary("bookit_c2_step1", "", $room_data);
	    $this->mlanguages->getdictionary("pmv3", "", $room_data);
	    echo $this->parser->parse_string($this->parser->parse ( 'templates/booking/category_detail_discription_block.html', $room_data, TRUE ), $room_data);
	}

    function ajax_save_reservations(){
        $dc_reservation_id = $this->session->userdata('dc_order_id');//made by pay_processor, by the way it exist in js...
        $response = $this->reservation->create_reservation($dc_reservation_id);
        $result = [];
        if ($response['result'] == "ok") {
            $result['result'] = "ok";
        } else {
            $result['result'] = "fail";
        }
        echo json_encode($result);
    }

    function stripe_sca_success($hotel_id, $reservation_id) {

        die ( "<meta http-equiv='refresh' content='0;url=/booking/confirmation'>" );
    }

    public function agreement_downloadfile(){
        $sql = "SELECT str_value, blob_value FROM files_data WHERE name LIKE 'terms_of_use' AND hotel_id =".$this->personal->hotel_id;
        $query_row = $this->db->query ( $sql )->row();
        if ($query_row) {
            $file_name = $file_type = "";
            $file = $query_row->str_value;
            $file_data = explode(".", $file);
            if(isset($file_data[0])){
                $file_name = $file_data[0];
                $file_type = end($file_data);
            }
            if($file_name != "" && $file_type != ""){
                header("Content-type: $file_type");
                //header("Content-length: $size");
                header("Content-Disposition: attachment; filename=$file");
                header("Content-Description: PHP Generated Data");
                echo base64_decode($query_row->blob_value);
            }
        }else{
            $ref_link = $_SERVER['HTTP_REFERER'];
            die ( "<meta http-equiv='refresh' content='0;url=$ref_link'>" );
        }
    }

    public function privacy_policy_downloadfile(){
        $sql = "SELECT str_value, blob_value FROM files_data WHERE name LIKE 'privacy_policy' AND hotel_id =".$this->personal->hotel_id;
        $query_row = $this->db->query ( $sql )->row();
        if ($query_row) {
            $file_name = $file_type = "";
            $file = $query_row->str_value;
            $file_data = explode(".", $file);
            if(isset($file_data[0])){
                $file_name = $file_data[0];
                $file_type = end($file_data);
            }
            if($file_name != "" && $file_type != ""){
                header("Content-type: $file_type");
                //header("Content-length: $size");
                header("Content-Disposition: attachment; filename=$file");
                header("Content-Description: PHP Generated Data");
                echo base64_decode($query_row->blob_value);
            }
        }else{
            $ref_link = $_SERVER['HTTP_REFERER'];
            die ( "<meta http-equiv='refresh' content='0;url=$ref_link'>" );
        }
    }

    public function get_clt_variable_ending($val = 0) {//just for testing, seems deprecated
        $result = $this->content->get_clt_variant_or_clt_ending(['val'=>$val, 'clts' => ['11end on one', '11between two and four', '11five and more']]);
        echo "<pre>";
        print_r($result);
        die("DIED by A Department at debug3.php get_clt_variable_ending() on 17 мар. 2021 г. 15:45:09");
    }

    public function reservation_info($hms_hotel_id='', $hms_reservation_id='', $pincode_md5=''){
        $this->session->unset_userdata('confirmation_data');
        if($pincode_md5 == md5($this->config->item('reservation_pincode_phrase').$hms_hotel_id.$hms_reservation_id)){
            $this->load->view ( '/booking/reservation_info_view.php', $this->reservation->get_reservation_info(['hms_res_id'=>$hms_reservation_id]) );
        } else {
            /* echo "<pre>";
            die("ERROR reservation_pincode_phrase!");
            die ( "<meta http-equiv='refresh' content='0;url=/booking/{$this->home_page_url}'>" ); */
        }
    }

    public function ggl() {// booking/ggl?checkin=2021-11-04&checkout=2021-11-11&adults=2&children=1&age_1=12&currency=USD
        $get = $this->input->get();
        if (!empty($get)) {
            $datein = date('Y-m-d', strtotime($get['checkin']));
            $dateout = date('Y-m-d', strtotime($get['checkout']));
            $peoples = $get['adults'];
            $children_ages = [];
            if (isset($get['children'])) {
                for ($i = 1; $i <= $get['children']; $i++) {
                    if (isset($get['age_'.$i])){
                        array_push($children_ages, $get['age_'.$i]);
                        $peoples ++;
                    }

                }
            }
            $this->session->set_userdata([
                'booking_data' => [
                    'dc_id' => 31,//Google
                    'date_in' => $datein,
                    'date_out' => $dateout,
                    'parties' => [
                        [
                            'adults' => $get['adults'],
                            'children' => $children_ages
                        ]
                    ],
                    'duration' => date_diff(date_create($datein), date_create($dateout))->days,
                    'peoples' => $peoples
                ]
            ]);
            if (isset($get['currency'])){
                $_SESSION ["interface_currency"] = $get['currency'];
            }
        }
        die ( "<meta http-equiv='refresh' content='0;url=/booking/{$this->home_page_url}'>" );
    }

    public function pay($hms_reservation_id = 0, $amount = 0, $arg_signature = "")
    {
  
        $acquiring_is_available = $this->acquiring->is_available();
        if (!$acquiring_is_available){
            die ( "<meta http-equiv='refresh' content='0;url=/booking/payment_failed'>" );
        }else {
            $hms_hotel_id = $this->personal->hotel_id;
            $pay_signature = md5($this->config->item('reservation_pincode_phrase') . $hms_hotel_id . $hms_reservation_id);
            if ($arg_signature == $pay_signature) {
                $reservation_info = $this->reservation->get_reservation_info(['hms_res_id'=>$hms_reservation_id]);
                $reservation_info->custom_amount = $amount;
                $reservation_info->hms_res_id = $hms_reservation_id;
                
                $this->session->set_userdata(['reservation_info' => $reservation_info]);//for pay_processor
                $this->load->view ( '/booking/pay_custom_view.php',  $reservation_info);
            } else {
                die ( "<meta http-equiv='refresh' content='0;url=/booking/rooms'>" );
            }
        }
    }

    public function cancel_reservation($hms_reservation_id) {
        $this->reservation->cancel_reservation($hms_reservation_id);
        $hms_hotel_id = $this->personal->hotel_id;
        $pincode_md5 = md5($this->config->item('reservation_pincode_phrase').$hms_hotel_id.$hms_reservation_id);
        die ( "<meta http-equiv='refresh' content='0;url=/booking/reservation_info/$hms_hotel_id/$hms_reservation_id/$pincode_md5'>" );
    }
    
    public function cancel_order($dc_order_id) {
        $hms_reservation_id = $this->reservation->cancel_order($dc_order_id);
        $hms_hotel_id = $this->personal->hotel_id;
        $pincode_md5 = md5($this->config->item('reservation_pincode_phrase').$hms_hotel_id.$hms_reservation_id);
        die ( "<meta http-equiv='refresh' content='0;url=/booking/reservation_info/$hms_hotel_id/$hms_reservation_id/$pincode_md5'>" );
    }

    public function fail() {
        $data = [];
        $data['error_description'] = '{clt_order_failed}';
        $this->load->view ( '/booking/error_view.php', $data );
    }

    public function payment_failed() {
        $data = [];
        $data['error_description'] = '{clt_title_fail_payment}';
        $this->load->view ( '/booking/error_view.php', $data );
    }

    public function mandarin_cashback_promotion_info() {
        if ($this->pay_processor->get_mandarin_cashback_common_allowing_state()) {
            $this->load->view ( '/promotions/mandarin_cashback_promotion_info.php' );
        }else {
            die ( "<meta http-equiv='refresh' content='0;url=/booking/{$this->home_page_url}'>" );
        }
    }
    
    public function proprooms()
    {
        $get = $this->input->get();
        if (isset($get['debug']) && $get['debug'] === 'true'){
            $this->debug_mode = true;
        }
        $booking_data = $this->session->userdata('booking_data');
        if (isset($get['id']) && $get['id'] != 0){
            $booking_data['checked_prop_id'] = $get['id'];
        }else {
            if (isset($booking_data['checked_prop_id'])) {
                unset($booking_data['checked_prop_id']);
            }
        }
        $this->session->set_userdata([
            'booking_data' => $booking_data
        ]);
        $this->load->view ( '/booking/proprooms_view.php' );
    }
    
    public function propguests()
    {
        $post = $this->input->post();
        
        $booking_data = $this->session->userdata('booking_data');
        $parties = [];
        $peoples = 0;
        $rooms_amount = 0;
        $payment_required = ['ccforce' => 0];
        if (isset($post['result'])) {
            $result = json_decode($post['result']);
            $occupancies = $result->occupancies;
            foreach ($occupancies as $pary_set) {
                $metadata = json_decode(base64_decode($pary_set->metadata));
                if ($metadata->payment_required->ccforce) {
                    $payment_required['ccforce'] = true;
                }
                $occ_set = explode('_', $pary_set->occ);
                for ($i = 0; $i < $pary_set->qtty; $i++) {
                    array_push($parties, array_merge([
                        'adults' => $occ_set[3],
                        'children' => [],
                        'selected_category' => $occ_set[1],
                        'selected_rate' => $occ_set[2],
                    ], (array)$metadata));
                    $peoples += $occ_set[3];
                    $rooms_amount += $metadata->price;
                }
            }
        }
        $booking_data['parties'] = $parties;
        $booking_data['peoples'] = $peoples;
        $booking_data['rooms_amount'] = $rooms_amount;
        $booking_data['payment_required'] = $payment_required;
        $booking_data['payment_required']['occupancy_way'] = true;
        $booking_data['promo']['promoted'] = false;
        
        
        
        $this->session->set_userdata(['booking_data' => $booking_data]);
        $this->session->set_userdata(['completed_steps' => ['booking_data' => true]]);
        
        $next_page = 'services';//by default
        $available_servicesList = $this->content->check_services_availability();
        if (sizeof($available_servicesList) == 0) {
            $next_page = 'guests';//no services
        }
        die ( "<meta http-equiv='refresh' content='0;url=/booking/$next_page'>" );
   }
   
   public function ajax_get_booking_result_div_tmplt() {
       $data = [];
       $this->mlanguages->getdictionary("pmv3", "", $data);
       $this->mlanguages->getdictionary("words_endings", "", $data);
       $data['clt_room_s'] = mb_strtolower($data['clt_room_s']);
       $data['clt_room_s_p'] = mb_strtolower($data['clt_room_s_p']);
       $data['clt_room_s_pp'] = mb_strtolower($data['clt_room_s_pp']);
       $tpmlt = $this->parser->parse ( 'templates/booking/booking_result_div_block.html', $data, true );
       echo $tpmlt;
   }
   
   public function set_Header_template() {
       $get = $this->input->get();
       if (isset($get['id']) && $get['id']) {
           $this->session->set_userdata(['header_template_id' => $get['id']]);
           echo 'session var "header_template_id" setted to : ', $get['id'];
       }else {
           $this->session->unset_userdata('header_template_id');
           echo 'session var "header_template_id" was setted to default.';
       }
   }
}