<?php
//https://api.bog.ge/docs/en/payments/introduction
defined('BASEPATH') or exit('No direct scripts');
class Bog extends CI_Controller
{
    const LOGINNG_API_REQ_RES = TRUE;
    const API_VERSION = 'v1/';
    const API_EP = 'https://api.bog.ge/payments/';

    private $orders_tbl = 'booking_otelms.bog_order2dc_order';
    private $api_logs_tbl = 'booking_otelms.bog_api_logs';

    private $api_order_request_url = self::API_EP . self::API_VERSION . 'ecommerce/orders';
    private $api_payment_details_url = self::API_EP . self::API_VERSION . 'receipt/';//{order_id}
    
    private $token = null;
    //нема тестового режииму, це креди живого благодійного))
    private $client_id = null;//64075;//test dev
    private $client_secret = null;// 'K1lqbXUW7BWV';//test dev
    
    public $host_url;

    public function __construct()
    {
        parent::__construct();
        $this->load->model ( 'personal' );//must be first! coz: public function mount_personal_data()
        $this->load->model ( 'pay_processor' );
        $this->load->model ( 'mcurrency' );
        $this->load->model ( 'curl_model' );
        $this->load->model ( 'reservation' );
        $this->load->model ( 'mlanguages' );
        
        $this->host_url = $this->personal->pmv3_host;
        if ($_SERVER['REMOTE_ADDR'] == "109.70.24.230") {
            $this->host_url = str_replace("otelms.com", "agast.ru", $this->host_url );
        }

        $bog_sync_data = $this->pay_processor->get_bog_sync_data();
        $this->client_id = $bog_sync_data->clientId;
        $this->client_secret = $bog_sync_data->secretKey;
        
        $this->token = $this->set_token();
        if (is_null($this->token)) {
            echo '<pre>';
            die("Fatal Error. No token!");
        }
    }
    
    public function test() {
        echo '<pre>';
        print_r($this->mlanguages->hotel_lang);
        print_r();
        die("Died by Andrew at Bog.php on 21 лип. 2023 р.  08:09:27");;
    }

    public function create_order_and_book()
    {
        $amount = $this->pay_processor->calculate_ccforce_rooms_amount();
        $amount = round($amount, 0);
        $dc_order_id = $this->session->userdata('dc_order_id');
        $pay_params = [
            'amount' => $amount,
            'reason' => [
                'type' => '',// empty is booking by default
                'hms_res_id' => 0,
                'dc_order_id' => $dc_order_id
            ]
        ];
        
        $this->do_payment_routine($pay_params);
        
    }

    public function create_order_custom_pay()
    {
        $pay_custom_session_data = $this->session->userdata('reservation_info');
        $hms_res_id = $pay_custom_session_data->hms_res_id;
        $amount = $pay_custom_session_data->custom_amount;

        $pay_params = [
            'amount' => $amount,
            'reason' => [
                'type' => 'custom_pay',
                'hms_res_id' => $hms_res_id,
                'dc_order_id' => 0
            ]
        ];

        $this->do_payment_routine($pay_params);
    }

    public function do_payment_routine($p = ['amount', 'reason'=>['type'=>'', 'hms_res_id'=>0, 'dc_order_id'=>0]])
    {//'type'=>'' ''-booking, 'custom_pay'
        $hms_id = $this->personal->hotel_id;
        $amount = $p['amount'];
        $currency = 'GEL';//$this->mcurrency->hotel_currency->name;//
        
        /* The currency in which payment is made:

GEL - Georgian Lari (default)
USD - US dollar
EUR - Euro
GBP - British pound. */

        switch ($p['reason']['type']) {
            case 'custom_pay':
                $dc_order_id = 0;
                $hms_res_id = $p['reason']['hms_res_id'];
                $buy_order = "$hms_id-$hms_res_id-custom_pay-".time();
                break;
            default://type === '' is booking by def
                $dc_order_id = $p['reason']['dc_order_id'];
                $hms_res_id = 0;
                $buy_order = "$hms_id-$dc_order_id-book";
                break;
        }
        $this->session->set_userdata(['bog_buy_order' => $buy_order]);
        $params = [
            'post_data' => [
                'callback_url' => "https://{$this->host_url}/bog/callback",
                'external_order_id' => $buy_order,
                'purchase_units' => [
                    'currency' => $currency,
                    'total_amount' => $amount,
                    'basket' => [
                        [
                            'quantity' => 1,
                            'unit_price' => $amount,
                            'product_id' => 1
                        ]
                    ]
                ],
                'redirect_urls' => [
                    'fail' => "https://{$this->host_url}/bog/return",
                    'success' => "https://{$this->host_url}/bog/return/$buy_order"
                ]
            ],
            'api_url' => $this->api_order_request_url
        ];
        
        $log_data = [
            'pmv' => 3,
            'buy_order' => $buy_order,
            'hotel_id' => $this->personal->hotel_id,
            'dc_order_id' => $dc_order_id,
            'hms_res_id' => $hms_res_id,
            'amount' => $amount,
            'currency' => $this->mcurrency->hotel_currency->name,
            'hms_booking_response' => '',
            'hms_payment_response' => '',
        ];
        $this->db->insert($this->orders_tbl, $log_data);
        
        
        $response = $this->request_api($params);
        $result = json_decode($response);
        
        /* stdClass Object
         (
         [id] => ff309513-0e50-4434-a2e7-1c5069529731
         [_links] => stdClass Object
         (
         [details] => stdClass Object
         (
         [href] => https://api.bog.ge/payments/v1/receipt/ff309513-0e50-4434-a2e7-1c5069529731
         )
         
         [redirect] => stdClass Object
         (
         [href] => https://payment.bog.ge?order_id=ff309513-0e50-4434-a2e7-1c5069529731
         )
         
         )
         
         ) */
        if (isset($result->id) && isset($result->_links->redirect->href)) {
            $redirect_url = $result->_links->redirect->href;
            if ($dc_order_id) {//booking
                $creation_reservation_resp = $this->reservation->create_reservation($dc_order_id); // this delete session userdata booking_data !!!
                $whr_arr = [
                    'hotel_id' => $this->personal->hotel_id,
                    'buy_order' => $buy_order,
                    'dc_order_id' => $dc_order_id,
                ];
                $upd_arr = [
                    'hms_booking_response' => isset($creation_reservation_resp['response']) ? $creation_reservation_resp['response'] : json_encode($creation_reservation_resp),
                    'bog_order_id' => $result->id,
                ];
                $this->db->update($this->orders_tbl, $upd_arr, $whr_arr);
                if ($creation_reservation_resp['result'] == 'ok') {
                    header("Location: $redirect_url");
                    exit();
                } else {
                    die ( "<meta http-equiv='refresh' content='0;url=/booking/fail'>" );
                }
            }else{//custom_pay
                $whr_arr = [
                    'hotel_id' => $this->personal->hotel_id,
                    'buy_order' => $buy_order,
                ];
                $upd_arr = [
                    'bog_order_id' => $result->id,
                ];
                $this->db->update($this->orders_tbl, $upd_arr, $whr_arr);
                header("Location: $redirect_url");
                exit();
            }            
        }else{
            die ( "<meta http-equiv='refresh' content='0;url=/booking/payment_failed'>" );//!!!!!!!!!!!!!! Payment init failed!
        }
    }

    public function callback() {
        /* "event": "order_payment",
  "request_time": "2023-07-25T14:44:58.385579",
  "body": {
    "order_id": "aaa2f833-b726-4801-a0ed-f1816bb5fefe",
    "external_order_id": "92-242141-book",
    "client": {
      "id": "64075",
      "brand_ka": "სიცოცხლის ხე",
      "brand_en": "Tree of Life",
      "url": "https://www.donate.ge"
    },
    "create_date": "2023-07-25T14:44:43.725910",
    "expire_date": "2023-07-25T14:59:43.725910",
    "order_status": {
      "key": "rejected",
      "value": "წარუმატებელი"
    },
    "redirect_links": {
      "success": "https://booking-dev-ul2.otelms.com/bog/return/92-242141-book",
      "fail": "https://booking-dev-ul2.otelms.com/bog/return_false"
    },
    "payment_detail": {
      "transfer_method": {
        "key": "card",
        "value": "ბარათით გადახდა"
      },
      "transaction_id": null,
      "payer_identifier": null,
      "payment_option": "direct_debit",
      "card_type": "visa",
      "card_expiry_date": null
    },
    "lang": "en",
    "reject_reason": "unknown",
    "industry": "ecommerce",
    "capture": "automatic",
    "purchase_units": {
      "request_amount": "330.0",
      "currency_code": "GEL",
      "items": [
        {
          "external_item_id": "1",
          "description": null,
          "quantity": "1",
          "unit_price": "330.0"
        }
      ]
    }
  }
} */
        $body_json = file_get_contents('php://input');
        $body = json_decode($body_json);
        
        if (isset($body->body->external_order_id) && isset($body->body->order_id)) {
            $upd_arr = [
                'data_callback' => $body_json,
                'status' => isset($body->body->order_status->key) ? $body->body->order_status->key : 'undefined',
            ];
            $whr_arr = [
                'hotel_id' => $this->personal->hotel_id,
                'buy_order' => $body->body->external_order_id,
            ];
            
            $this->db->update($this->orders_tbl, $upd_arr, $whr_arr);
            
            if ($upd_arr['status'] == 'completed') {//$body->body->order_status->key === 'completed'???
                $this->save_payment_to_hms(['buy_order' => $body->body->external_order_id]);
            }
        }
    }
    
    
    public function return($buy_order = 0)
    {
        
        if ($buy_order) {//success payment
            $whr_arr = [
                'hotel_id' => $this->personal->hotel_id,
                'buy_order' => $buy_order
            ];
            $orderInfo = $this->db->get_where($this->orders_tbl, $whr_arr)->row();
            if ($orderInfo && $orderInfo->bog_order_id) {
                $api_res = $this->request_api([
                    'api_url' => $this->api_payment_details_url . $orderInfo->bog_order_id
                ], 'GET');
                $upd_arr = ['data_return' => $api_res];
                $response = json_decode($api_res);
                if (isset($response->order_status->key)) {
                    $upd_arr['status'] = $response->order_status->key;
                }
                $this->db->update($this->orders_tbl, $upd_arr, $whr_arr);
                if ($response->order_status->key === 'completed') {
                    $this->save_payment_to_hms(['buy_order' => $buy_order]);
                    $this->rout_after_return(['buy_order' => $buy_order]);
                }else {
                    die ( "<meta http-equiv='refresh' content='0;url=/booking/payment_failed'>" );
                }
            }else {
                die ( "<meta http-equiv='refresh' content='0;url=/booking/payment_failed'>" );
            }
        }else {
            die ( "<meta http-equiv='refresh' content='0;url=/booking/payment_failed'>" );
        }
    }

    private function rout_after_return($p) {
        if (isset($p['buy_order']) && $p['buy_order']) {
            $pay_for = explode('-', $p['buy_order']);
            switch ($pay_for[2]) {
                case 'book':
                    die("<meta http-equiv='refresh' content='0;url=/booking/confirmation'>");
                    break;
                case 'custom_pay':
                    $hms_hotel_id = $this->personal->hotel_id;
                    $whr_arr = [
                        'hotel_id' => $hms_hotel_id,
                        'buy_order' => $p['buy_order']
                    ];
                    $orderInfo = $this->db->get_where($this->orders_tbl, $whr_arr)->row();
                    $hms_res_id = $orderInfo->hms_res_id;
                    $pincode_md5 = md5($this->config->item('reservation_pincode_phrase') . $hms_hotel_id . $hms_res_id);
                    die("<meta http-equiv='refresh' content='0;url=/booking/reservation_info/$hms_hotel_id/$hms_res_id/$pincode_md5'>");
                    break;
                default:
                    echo "Some critical error with buy_order.";
                    die("DIED rout_after_return()");
                    break;
            }
        } else {
            echo "Some critical error. buy_order not setted";
            die("DIED rout_after_return()");
        }
    }

    public function save_payment_to_hms($param)
    {
        $whr_arr = [
            'hotel_id' => $this->personal->hotel_id,
            'buy_order' => $param['buy_order'],
        ];
        $orderInfo = $this->db->get_where($this->orders_tbl, $whr_arr)->row();
        if ($orderInfo) {
            $url = "https://{$this->personal->hms_host}/gateway/bog_payment_update";
            $pay_curl_data = array();
            $pay_curl_data ['hms_id'] = $this->personal->hotel_id;
            $pay_curl_data ['dc_reservationid'] = $pay_curl_data ['order_id'] = $orderInfo->dc_order_id;
            $pay_curl_data ['hms_res_id'] = $orderInfo->hms_res_id;
            $pay_curl_data ['currency'] = $orderInfo->currency ? $orderInfo->currency : $this->mcurrency->hotel_currency->name;
            $pay_curl_data ['amount'] = $orderInfo->amount;
            $pay_curl_data ['transID'] = $orderInfo->buy_order;
            $pay_curl_data ['cc_processor'] = $this->personal->cc_processor;
            $pay_curl_data ['bog_order_id'] = $orderInfo->bog_order_id;

            $hms_payment_insert_result = $this->curl_model->curl_plug_json($pay_curl_data, $url);

            $upd_arr = [
                'hms_payment_response' => $hms_payment_insert_result
            ];
            $this->db->update($this->orders_tbl, $upd_arr, $whr_arr);
        }
    }

    private function request_api($p, $method='POST') {

        $headers = array(
            'Authorization: Bearer ' . $this->token,
            'Content-Type: application/json',
            'Accept-Language: en'//for testing, nixt nipaniatno in ka
        );
        $url = $p['api_url'];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_ENCODING, '');
        curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 0);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        switch (strtoupper($method)) {
            case 'POST':
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($p['post_data']));
                break;
        }
        $curl_response = curl_exec($ch);
//         $curl_info = curl_getinfo($ch);
        curl_close($ch);

        if (self::LOGINNG_API_REQ_RES) {
            $req_resp_log_data = [
                'hotel_id' => $this->personal->hotel_id,
                'buy_order' => $this->session->userdata('bog_buy_order') ?? 'No buy_order?',
                'request' => json_encode($p),
                'response' => $curl_response,
                'method' => $method,
                'creds' => json_encode([
                    'token' => $this->token,
                    'client_id' => $this->client_id,
                    'client_secret' => $this->client_secret
                ]),
            ];
            $this->db->insert($this->api_logs_tbl, $req_resp_log_data);
        }
        return $curl_response;
    }
    
    private function set_token()
    {
        $token_data = $this->get_api_access_token_data();
        return isset($token_data->access_token) ? $token_data->access_token : null;
    }
    
    private function get_api_access_token_data()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://oauth2.bog.ge/auth/realms/bog/protocol/openid-connect/token',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'grant_type=client_credentials',
            CURLOPT_USERPWD => $this->client_id . ':' . $this->client_secret,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded',
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        
        return json_decode($response);
    }
}