<?php
$booking_data = $this->session->userdata('booking_page_data');
$parties = $booking_data['parties'];

$parsing_arr = array();
foreach ($parties as $room_num => $party) {
    $room_number = $room_num + 1;
    $room_guests = array();
    $room_guests['adults'] = array_fill(1, $party['adults'], array());
    foreach ($room_guests['adults'] as  $adult_num => &$adult) {
        $adult['adult_number'] = $adult_num;
        $adult['room_number'] = $room_number;
        $adult['collapse_room_guests_class'] = ($adult_num == 1)? '': "collapse multi-collapse$room_number";
        $adult['div_collapse_adults_id'] = ($adult_num == 1)? '': "collapse_adults_$room_number";
    }
    $room_guests['children'] = array();
    $count_children = isset($party['children'])? count($party['children']) : 0;
    if ($count_children){
        foreach ($party['children'] as $child_num => $child_age) {
            $room_guests['children'][$child_num + 1] = array(
                'age' => $child_age,
                'room_number' => $room_number,
                'collapse_room_guests_class' => "collapse multi-collapse$room_number",
                'div_collapse_children_id' => "collapse_children_$room_number",
            );
        }
    }
    array_push($parsing_arr, array(
        'room_number' => $room_number,
        'collapse_room_guests_class' => "collapse multi-collapse$room_number",
        'div_collapse_adults_id' => "collapse_adults_$room_number",
        'div_collapse_children_id' => "collapse_children_$room_number",
        'adults' => $room_guests['adults'],
        'children' => $room_guests['children'],
        'children_hide_class' => $count_children!=0 ? "":"d0"
    ));
}
$data = array();
$data['header'] = $this->htmltpl->GetHeader_v2();
$data['footer'] = $this->htmltpl->GetFooter_v2();
$data['parsing_arr'] = $parsing_arr;
$this->mlanguages->getdictionary("bookit_c2_step3", "", $data);
$this->mlanguages->getdictionary("bookit_c2_step1", "", $data);
$this->mlanguages->getdictionary("tbl_roomscategories_views", "", $data);
$this->mlanguages->getdictionary("guests", "", $data);
$template = $this->parser->parse ( 'templates/ta/guests_view.html', $data, TRUE);
$this->parser->parse_string ( $template, $data);
?>