<?php
class Reviews_model extends CI_model {
    function construct() {
        parent::_construct();
    }

    function get_dcs_arr() {
        $arr = [
            '0' => [
                'id' => 0,
                'name' => 'otelms'
            ],
            '1' => [
                'id' => 1,
                'name' => 'booking'
            ],
            '22' => [
                'id' => 22,
                'name' => 'airbnb'
            ]
        ];
        return $arr;
    }

    function get_parsed_rw_block_1_booking($rw) {
        $body = json_decode($rw->body);
        $rw->country = isset($body->reviewer->country_code)? $body->reviewer->country_code :'';
        $rw->headline = isset($body->content->headline)?$body->content->headline : '';
        if (isset($body->content->positive)) {
            $rw->positive = $body->content->positive;
        }else{
            $rw->positive = "";
            $rw->hide_positive_div_class = "d0";
        }
        if (isset($body->content->negative)) {
            $rw->negative = $body->content->negative;
        }else{
            $rw->negative = "";
            $rw->hide_negative_div_class = "d0";
        }
        $rw->room = '';
        if (isset($body->reply->text)) {
            $rw->reply_text = $body->reply->text;
        }else{
            $rw->reply_text = "";
            $rw->hide_reply_div_class = "d0";
        }
        $rw->reviewer = isset($body->reviewer->name) && $body->reviewer->name != '' ? $body->reviewer->name : 'Anonymous';
        return $this->parser->parse ( 'templates/reviews/block_1_tmpls/booking.html', $rw, true );
    }

    function get_parsed_rw_block_2_booking($rw) {
        $body = json_decode($rw->body);
        $rw->country = isset($body->reviewer->country_code)? $body->reviewer->country_code :'';
        $rw->headline = isset($body->content->headline)?$body->content->headline : '';
        if (isset($body->content->positive)) {
            $rw->positive = $body->content->positive;
        }else{
            $rw->positive = "";
            $rw->hide_positive_div_class = "d0";
        }
        if (isset($body->content->negative)) {
            $rw->negative = $body->content->negative;
        }else{
            $rw->negative = "";
            $rw->hide_negative_div_class = "d0";
        }
        $rw->room = '';
        if (isset($body->reply->text)) {
            $rw->reply_text = $body->reply->text;
        }else{
            $rw->reply_text = "";
            $rw->hide_reply_div_class = "d0";
        }
        $rw->reviewer = isset($body->reviewer->name) && $body->reviewer->name != '' ? $body->reviewer->name : 'Anonymous';
        return $this->parser->parse ( 'templates/reviews/block_2_tmpls/booking.html', $rw, true );
    }

    function get_parsed_rw_block_1_airbnb($rw) {
        $body = json_decode($rw->body);
        $rw->reviewer = '';
        $rw->public_review = $body->public_review;
        $rw->private_feedback = $body->private_feedback;
        $rw->hide_public_review_div_class = ($body->public_review == "") ? 'd0':'';
        $rw->hide_private_feedback_div_class = ($body->private_feedback == "") ? 'd0':'';
        $rw->category_ratings = $body->category_ratings;
        $rw->hide_reply_div_class = "d0";
        return $this->parser->parse ( 'templates/reviews/block_1_tmpls/airbnb.html', $rw, true );
    }

    function get_parsed_rw_block_2_airbnb($rw) {
        $body = json_decode($rw->body);
        $rw->reviewer = '';
        $rw->public_review = $body->public_review;
        $rw->private_feedback = $body->private_feedback;
        $rw->hide_public_review_div_class = ($body->public_review == "") ? 'd0':'';
        $rw->hide_private_feedback_div_class = ($body->private_feedback == "") ? 'd0':'';
        $rw->category_ratings = $body->category_ratings;
        $rw->hide_reply_div_class = "d0";
        return $this->parser->parse ( 'templates/reviews/block_2_tmpls/airbnb.html', $rw, true );
    }

    function get_parsed_rw_block_1_otelms($rw) {
        $body = json_decode($rw->body);
        $rw->reviewer = '';
        $rw->positive = $body->hotel_positive;
        $rw->negative = $body->hotel_not_positive;
        $rw->hide_positive_div_class = ($rw->positive == "") ? 'd0':'';
        $rw->hide_negative_div_class = ($rw->negative == "") ? 'd0':'';
        $rw->hide_reply_div_class = "d0";
        return $this->parser->parse ( 'templates/reviews/block_1_tmpls/otelms.html', $rw, true );
    }

    function get_parsed_rw_block_2_otelms($rw) {
        $body = json_decode($rw->body);
        $rw->reviewer = '';
        $rw->positive = $body->hotel_positive;
        $rw->negative = $body->hotel_not_positive;
        $rw->hide_positive_div_class = ($rw->positive == "") ? 'd0':'';
        $rw->hide_negative_div_class = ($rw->negative == "") ? 'd0':'';
        $rw->hide_reply_div_class = "d0";
        return $this->parser->parse ( 'templates/reviews/block_2_tmpls/otelms.html', $rw, true );
    }

}