<?php
class Htmltpl extends CI_Model {
	function __construct() {
		parent::__construct ();
		$this->load->model ( 'Crmmodels' );
		$this->load->model ( 'Navigation' );
		$this->load->model ( 'Acquiring' );
		$this->load->model ( 'Hms_config' );
	}

	function GetHeader_v2()
    {
	    
        //echo session_id();
        $data = array();
        $data["hotel_logo"] = $this->htmltpl->get_hotel_logo();
        $data["hotel_name"] = "";
        $data["hotel_addr_line1"] = "";
        $data["hotel_addr_line2"] = "";
        $data["hotel_addr_line3"] = "";
        $data["hotel_phone"] = "";
        $data["hotel_email"] = "";
        $data["hotel_post_code"] = "";
        
        $data["website_class"] = "d0";
        if($this->personal_data["url_to_website"] != ""){
            $data["website_class"] = "";
        }
        
        $data["url_to_website"] = $this->personal_data["url_to_website"];
        $pos = strpos($this->personal_data["url_to_website"], "http");
        if ($pos === false) {
            $data["url_to_website"] = "https://".$data["url_to_website"];
        }

        $inteface_language_data = $this->Mlanguages->get_inteface_language_data($this->personal_data["hotel_id"]);
        $interface_language_code = $inteface_language_data["language_code"];
        if (isset($_SESSION["interface_language_code"])) {
            if ($_SESSION["interface_language_code"] != 0) {
                $interface_language_code = $_SESSION["interface_language_code"];
            }
        }

        $sql = "SELECT * FROM property_information WHERE hotel_id = " . $this->personal_data["hotel_id"] . " LIMIT 0, 1";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $property_name = $this->Crmmodels->get_property_name($this->personal_data["hotel_id"], $row->property_id, $interface_language_code);
                if ($property_name == "") {
                    $property_name = $row->property_name;
                }
                $data["hotel_name"] = $property_name;
                $data["hotel_addr_line1"] = $row->country;
                $data["hotel_addr_line2"] = $row->city;
                $data["hotel_addr_line3"] = $row->street;
                $data["hotel_phone"] = $row->reception_phone;
                $data["hotel_email"] = $row->email;
                if ($row->post_code != "") {
                    $data["hotel_post_code"] = ", " . $row->post_code;
                }

                $sql_country = "SELECT NAME_LAT, native_name FROM dic_country WHERE id LIKE '" . strtolower($row->country) . "'";
                $query2 = $this->db->query($sql_country);
                if ($query2->num_rows() > 0) {
                    $row2 = $query2->row();
                    $data["hotel_addr_line1"] = $row2->native_name !='' ? $row2->native_name : $row2->NAME_LAT;
                }
            }
        }

        $header = $this->parser->parse('templates/header_v2.html', $data, TRUE);
        return $header;
    }

	function GetFooter_v2(){
	    $remote_adr = $_SERVER['REMOTE_ADDR'];
	    $company_name = 'OTELMS.COM';
	    $company_site_link = 'OTELMS.COM';
	    if ($remote_adr === "109.70.24.230") {
	        $company_name = 'Agast Technologies';
	        $company_site_link = 'agast.ru';
	    }
	    
	    
	    $data = array(
	        "current_year" => date("Y"),
	        "company_name" => $company_name,
	        "company_site_link" => $company_site_link,
	    );
	    $footer = $this->parser->parse ( 'templates/footer_v2.html', $data, TRUE );
	    return $footer;
	}

	function GetHeader() {
		$data = array ();

		if (isset ( $this->personal_data ["hotel_id"] )) {
			$hotel_id = $this->personal_data ["hotel_id"];
		} else {
			$hotel_id = 0;
			$host = $_SERVER ["HTTP_HOST"];
			$sql = "SELECT hotel_id, host, group_id FROM booking_otelms.personal WHERE host LIKE '" . $host . "'";
			// echo $sql;
			$query = $this->db->query ( $sql );

			if ($query->num_rows () > 0) {
				$row = $query->row ();
				$hotel_id = $row->hotel_id;
			}
		}


		if (isset ( $this->personal_data ["hotel_name"] )) {
			$data ["hotel_name"] = $this->personal_data ["hotel_name"];
		} else {
			$data ["hotel_name"] = "";
		}
		if (isset ( $this->personal_data ["email"] )) {
			$data ["email"] = $this->personal_data ["email"];
		} else {
			$data ["email"] = "";
		}
		if (isset ( $this->personal_data ["id"] )) {
			$data ["id"] = $this->personal_data ["id"];
		} else {
			$data ["id"] = "";
		}
		if (isset ( $this->personal_data ["phone"] )) {
			$phone_arr = explode ( ",", $this->personal_data ["phone"] );
			$data ["phone"] = "";
			if (isset ( $_SESSION ["set_view_style"] )) {
				switch ($_SESSION ["set_view_style"]) {
					case "default" :
						for($i = 0; $i < count ( $phone_arr ); $i ++) {
							$data ["phone"] .= "".$phone_arr [$i] . "<br>";
						}
						break;
					case "mobile" :
						for($i = 0; $i < count ( $phone_arr ); $i ++) {
							$data ["phone"] .= "<a href=\"tel: ".$phone_arr [$i] . "\"><span class=\"phone-item\">".$phone_arr [$i] . "</span></a>";
						}
						break;
				}
			}else{
				for($i = 0; $i < count ( $phone_arr ); $i ++) {
					$data ["phone"] .= "".$phone_arr [$i] . "<br>";
				}
			}

		} else {
			$data ["phone"] = "";
		}
		// $data ["hotel_name"] = $this->personal_data ["hotel_name"];
		// $data ["email"] = $this->personal_data ["email"];
		// $data ["id"] = $this->personal_data ["hotel_id"];
		// $phone_arr = explode ( ",", $this->personal_data ["phone"] );
		// $data ["phone"] = "";
		// for($i = 0; $i < count ( $phone_arr ); $i ++) {
		// $data ["phone"] .= $phone_arr [$i] . "<br>";
		// }
		$data ["img"] = "";
		$query = $this->db->query ( "SELECT * FROM hotel_images WHERE hotel_id = " . $hotel_id . " AND classic_img = 1" );

		if ($query->num_rows () > 0) {
			$row = $query->row ();

			$data ["img"] = '<img alt="' . $data ["hotel_name"] . ', 1" title="' . $data ["hotel_name"] . ', 1" src="http://img.guestbe.com/himages/' . $hotel_id . '_main0_small_100.jpg"/>';
		}

		$personal_style = "/css/personal_default.css";

		$inlinestyle = 0;
		$group_id = 0;
		$home_logo = "";
		//$analitycs = "";
		$host = $_SERVER ["HTTP_HOST"];
		$sql = "SELECT  logo_link, logo_link_type, header_name, templatetype, css, home_logo, inlinestyle, group_id FROM personal WHERE host = '" . $host . "'";
		//echo $sql;
		$query = $this->db->query ( $sql );
		$var_inline = "";
		$var_group = "";
		if ($query->num_rows () > 0) {
			$row = $query->row ();

			if (trim ( $row->logo_link ) != "") {
				$data ["logo_link"] = $row->logo_link;
			} else {
				$data ["logo_link"] = "/";
			}
			if ($row->logo_link_type == 1) {
				$data ["logo_link_type"] = ' target="_blank"';
			} else {
				$data ["logo_link_type"] = "/";
			}

			$id_header = $row->templatetype;
			$inlinestyle = $row->inlinestyle;
			//$analitycs = $row->analitycs;
			$group_id = $row->group_id;
			if ($group_id == 0) {
				if ($inlinestyle) {
					$var_inline = "-inline";
				}

				if (isset ( $_GET ["inline"] )) {
					if ($_GET ["inline"] == 'true' || $_GET ["inline"] == 1) {
						$var_inline = "-inline";
						$this->session->set_userdata ( 'inline_style', true );
					}
					if ($_GET ["inline"] == 'false') {
						$var_inline = "";
						$this->session->set_userdata ( 'inline_style', false );
					}
				} else {
					if (($this->session->userdata ( 'inline_style' ))) {
						$var_inline = "-inline";
					} else {
					}
				}
			} else {
				$var_group = "_" . $group_id;
			}

			if (isset ( $_GET ["settemplatetype"] )) {
				$templatetype = $_GET ["settemplatetype"];
			} else {
				$templatetype = $row->templatetype;
			}

			switch ($templatetype) {
				case 1 :
					$header = "header_1";
					break;
				case 2 :
					$header = "header_2";
					break;
				case 3 :
					$header = "header_3";
					break;
				case 5 :
					$header = "header_5";

					if ($row->css != "") {
						$personal_style = $row->css;
					} else {
						$personal_style = "/css/personal_default.css";
					}
					$home_logo = $row->home_logo;

					break;
				case 6 :
					$header = "header_6";
					if ($row->css != "") {
						$personal_style = $row->css;
					} else {
						$personal_style = "/css/personal_default.css";
					}
					$home_logo = $row->home_logo;

					break;
				case 10 :
					$header = $row->header_name;
					if ($row->css != "") {
						$personal_style = $row->css;
					} else {
						$personal_style = "/css/personal_default.css";
					}
					$home_logo = $row->home_logo;

					break;
				case "default" :
					$header = "header_1";
					if ($row->css != "") {
						$personal_style = $row->css;
					} else {
						$personal_style = "/css/personal_default.css";
					}
					$home_logo = $row->home_logo;

					break;
				default :
					$header = "header_1";
					$personal_style = "/css/personal_default.css";
					$home_logo = "";
					break;
			}
		} else {

			$header = "";
		}
		//echo $header;
		// echo "<pre>";
		// print_r($_SERVER);
		$data ["id"] = $hotel_id;

		$query = $this->db->query ( "SELECT logo_web_url FROM hotels_personal WHERE hotel_id = " . $hotel_id );

		if ($query->num_rows () > 0) {
			$row = $query->row ();

			$data ["logo_web_url"] = $row->logo_web_url;
		} else {
			$data ["logo_web_url"] = "/";
		}
		if ($this->session->userdata ( 'agent_id' ) != "") {
			$dealer_div = '<div class="i-email"><a href="/agent/details" class="fs2">' . $this->session->userdata ( 'agent_name' ) . '</a></div>';
		} else {
			$dealer_div = '';
		}

		// echo $personal_style;

		$data ["dealer_div"] = $dealer_div;
		$data ["personal_style"] = $personal_style;
		$data ["home_logo"] = $home_logo;
		//$data ["analitycs"] = $analitycs;
		// print_r($_SESSION);
		if (isset ( $_SESSION ["global_template_name"] )) {
			$data ["personal_style"] = "/themes/" . $_SESSION ["global_template_name"] . "-style.css";
			$data ["home_logo"] = "/themes/" . $_SESSION ["global_template_name"] . "-logo.png";
		}

		if (isset ( $_SESSION ["global_headername"] )) {
		    $header = "headers/" . $_SESSION ["global_headername"] . "";
		}

		$REQUEST_URI = explode ( "?", $_SERVER ["REQUEST_URI"] );
		$data ["REQUEST_URI"] = $REQUEST_URI [0];
		// echo $header;
		// print_r($data);
		//echo $header . $var_inline . $var_group;
		if (isset ( $_SESSION ["set_view_style"] )) {
			switch ($_SESSION ["set_view_style"]) {
				case "default" :
					$header = $this->parser->parse ( 'templates/' . $header . $var_inline . $var_group . '.html', $data, TRUE );
					break;
				case "mobile" :
					$header = $this->parser->parse ( 'templates/header_mobile'.$var_inline.'.html', $data, TRUE );
					break;
			}
		}else{
			$header = $this->parser->parse ( 'templates/' . $header . $var_inline . $var_group . '.html', $data, TRUE );
		}


		return $header;
	}
	function GetFavicon() {
		$host = $_SERVER ["HTTP_HOST"];
		$sql = "SELECT favicon FROM personal WHERE host = '" . $host . "'";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$favicon = trim ( $row->favicon );
			if ($favicon == "") {
				$favicon = "/images/hotel-styles/2084-ludmila/favicon.ico";
			}
		} else {
			$favicon = "/images/hotel-styles/2084-ludmila/favicon.ico";
		}
		return $favicon;
	}
	function GetFooter() {
		$data = array ();

		$personal_style = "/css/personal_default.css";

		$inlinestyle = 0;
		$group_id = 0;
		$analitycs = "";
		$host = $_SERVER ["HTTP_HOST"];
		$sql = "SELECT analitycs, footer_name, templatetype, css, inlinestyle, group_id FROM personal WHERE host = '" . $host . "'";
		$query = $this->db->query ( $sql );
		$var_inline = "";
		$var_group = "";
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$id_header = $row->templatetype;
			$inlinestyle = $row->inlinestyle;
			$group_id = $row->group_id;
			$analitycs = $row->analitycs;

			if ($inlinestyle) {
				$var_inline = "-inline";
			}
			if ($group_id == 0) {
				if (isset ( $_GET ["inline"] )) {
					if ($_GET ["inline"] == 'true' || $_GET ["inline"] == 1) {
						$var_inline = "-inline";
						$this->session->set_userdata ( 'inline_style', true );
					}
					if ($_GET ["inline"] == 'false') {
						$var_inline = "";
						$this->session->set_userdata ( 'inline_style', false );
					}
				} else {
					if (($this->session->userdata ( 'inline_style' ))) {
						$var_inline = "-inline";
					} else {
					}
				}
			} else {
				$var_group = "_" . $group_id;
			}

			switch ($row->templatetype) {
				case 1 :
					$footer = "footer_1";
					break;
				case 2 :
					$footer = "footer_2";
					break;
				case 3 :
					$footer = "footer_3";
					break;
				case 5 :
					$footer = "footer_5";

					if ($row->css != "") {
						$personal_style = $row->css;
					} else {
						$personal_style = "/css/personal_default.css";
					}
					break;
				case 6 :
					$footer = "footer_6";
					break;
				case 10 :
					$footer = $row->footer_name;
					break;
				default :
					$footer = "footer";
					$personal_style = "/css/personal_default.css";
					break;
			}
		} else {
			$footer = "footer";
		}


		if (isset ( $_SESSION ["global_footername"] )) {
		    $footer = "headers/" . $_SESSION ["global_footername"] . "";
		}

		// echo $footer;
		$lang_data = $this->Crmmodels->get_language_array ( "footer" );
		$data ["personal_style"] = $personal_style;
		$data ["analitycs"] = $analitycs;
		$data = array_merge ( $data, $lang_data );

		if (isset ( $_SESSION ["set_view_style"] )) {
			switch ($_SESSION ["set_view_style"]) {
				case "default" :
					$footer = $this->parser->parse ( 'templates/' . $footer . $var_inline . $var_group . '.html', $data, TRUE );
					break;
				case "mobile" :
					$footer = $this->parser->parse ( 'templates/footer_mobile'.$var_inline.'.html', $data, TRUE );
					break;
			}
		}else{
			$footer = $this->parser->parse ( 'templates/' . $footer . $var_inline . $var_group . '.html', $data, TRUE );
		}


		// echo "++".$footer."++";
		return $footer;
	}
	function Get_agent_menu() {
		$data = array ();
		$data ["agent_menu"] = $this->Navigation->get_agent_menu ();
		$footer = $this->parser->parse ( 'templates/agent_menu_header.html', $data, TRUE );
		return $footer;
	}

	function get_hotel_logo(){
	    /*
	     *
	     * ==== GET HOTEL LOGO =============
	     *
	     */
	    if(isset($this->personal_data ["hotel_id"])){
	        $hotel_id = $this->personal_data ["hotel_id"];
	    }else{
	        $hotel_id = $this->Crmmodels->get_hotel_id();
	    }
	    //echo "<pre>";
	    //print_r($_SESSION);
	    //die();
	    //echo $hotel_id;
	    //die();
	    $property_id = 0;
	    $sql = "SELECT property_id FROM property_information WHERE hotel_id = ".$hotel_id." ORDER BY property_id ASC LIMIT 0, 1";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row();
	        $property_id = $row->property_id;
	    }
	    $hotel_logo = $this->config->item ( 'foto_web_path' ) . $hotel_id . '_' . $property_id . '_logo_original.jpg';
	    return $hotel_logo;
	}

	function get_step4dopay_appex_block($dc_order_id){
// 	    echo "<pre>";
// 	    print_r($_SESSION);
// 	    die();
	    /*
	     *
	     * ==== GET CCFORCE BOOL VALUE =====
	     * ==== get_ccforce_value ====
	     */
	    $ccforce_val = $this->Order->get_ccforce_value();
// 	    echo $ccforce_val;
// 	    die();
	    $amount_full = number_format($_SESSION["amount"], 2, '.', '');
	    $amountcurr = "RUB";
	    $currency = "MBC";

	    $authparam = $this->Acquiring->get_appex_authparam();
//         print_r($authparam);
//         die();
	    $account = $authparam["account"];
	    $key1 = $authparam["key1"];
	    $key2 = $authparam["key2"];
	    $url = $authparam["url"];

	    $timestamp = time();
	    $Order_IDP = $this->personal_data["hotel_id"] . "-" . $dc_order_id . "-ibm-" . $timestamp;
	    ;
	    $number = $Order_IDP;
	    $description = urlencode("Оплата за проживание на $amount_full $amountcurr");
	    //$backURL = "https://" . $_SERVER["HTTP_HOST"] . "/bookit_c2/step5";
	    $online_module_v = 2;
	    $backURL = "https://xml.otelms.com/api_appex/gate_online_module/".$this->personal_data["hotel_id"]."/".$online_module_v;
	    
	    $trtype = "1";

	    $signature = "$amount_full:$amountcurr:$currency:$number:$description:";
	    $signature .= "$trtype:$account:$backURL:$key1:$key2";
	    $signature = strtoupper(md5($signature));

	    $data = array();
	    $data['signature'] = $signature;
	    $data['amountcurr'] = $amountcurr;
	    $data['currency'] = $currency;
	    // $data['number'] = $Order_IDP;
	    $data['number'] = $number;
	    $data['trtype'] = $trtype;
	    $data['account'] = $account;
	    $data['backURL'] = $backURL;
	    $data['description'] = $description;
	    $data['server_url'] = $url;
	    $data['amount'] = $amount_full;

	    if ($ccforce_val != 1) {
            // $amount = $_SESSION ["amount"];

            //save paid amount in session
            //$_SESSION["paid_amount"] = $amount_full;


            $this->mlanguages->getdictionary("bookit_c2_step4", "", $data);
            $appex_allowordertype = $this->parser->parse('templates/bookit_c2_step4dopay_appex_allowordertype.html', $data, true);
        } else {
            $appex_allowordertype = "";
        }

	    // =========== daily ================================

	    //$daycount = round((strtotime($_SESSION['dateout']) - strtotime($_SESSION['datein'])) / (24 * 60 * 60) + 1) - 1;
	    //$data['amount'] = number_format($amount / $daycount);

	    //$amount = number_format(($amount / $daycount), 2, '.', '');

        $acquiring_valid = $this->Order->get_acquiring_valid();
         
        if($ccforce_val == 1 && $acquiring_valid == 1){
	        /*
	         *
	         * ======= CCFORCE calculate AMOUNT =============
	         *
	         * function calculate_ccforce_rooms_amount: get data from SESSION and calculate ccforce amount
	         *
	         */
	        $ccforce_amount = $this->Order->calculate_ccforce_rooms_amount();
	        $ccforce_amount = number_format($ccforce_amount, 2, '.', '');
	        //save paid amount in session
	        //$_SESSION["paid_amount"] = $ccforce_amount;
// 	        echo $amount_full." == ". $ccforce_amount;
// 	        die();
            if ($amount_full == $ccforce_amount && FALSE) {

                $appex_daily_prepayment = "";
            } else {

                $data['amount'] = $ccforce_amount;
                $signature = "$ccforce_amount:$amountcurr:$currency:$number:$description:";
                $signature .= "$trtype:$account:$backURL:$key1:$key2";
                $signature = strtoupper(md5($signature));
                $data['signature'] = $signature;
                $data['amount_str'] = $this->Mcurrency->fullvalue($ccforce_amount, 2);

                $appex_daily_prepayment = $this->parser->parse('templates/bookit_c2_step4dopay_appex_daily_prepayment.html', $data, true);
            }
	    }else{
	        $appex_daily_prepayment = "";
	    }

	    $return_data = array();
	    $return_data["appex_allowordertype"] = $appex_allowordertype;
	    $return_data["appex_daily_prepayment"] = $appex_daily_prepayment;
	    return $return_data;
	}
	
	function get_step4dopay_mandarin_alternative_block_NOT_USE($dc_order_id){
	    $currency = "RUB";
	    $pmv = 2;
	    $hms_id = $this->personal_data["hotel_id"];
	    $ccforce_val = $this->Order->get_ccforce_value();
	    
	    $amount_full = number_format($_SESSION["amount"], 2, '.', '');
	    $_SESSION["paid_amount"] = $_SESSION["amount"];
	    
	    $authparam = $this->Acquiring->get_mandarin_authparam();
	    //print_r($authparam);
	    // die();
	    $request = array();
	    $request['payment']['action'] = "pay";
	    $request['payment']['orderId'] = "$hms_id-$dc_order_id-book";
	    $request['payment']['price'] = $amount_full;
	    $request['payment']['orderActualTill'] = date('Y-m-d H:i:s', strtotime('+15 minutes'));
	    
	    // ======== SUBACCOUNT ===========
	    $mandarin_account_id = $this->Hms_config->get_record('mandarin_account_id', $hms_id);
	    if($mandarin_account_id != ""){
	        $request['routing']['destination'][0]['accountId'] = $mandarin_account_id;
	        $request['routing']['destination'][0]['amount']['value'] = $amount_full;
	        $request['routing']['destination'][0]['amount']['currency'] = "RUB";
	        $request['routing']['destination'][0]['platformFeeAmount']['value'] = ($amount_full / 100) * $this->config->item('mandarin_fee_percent');
	        $request['routing']['destination'][0]['platformFeeAmount']['currency'] = "RUB";
	        $request['routing']['destination'][0]['description'] = "null";
	    }
	    
	    
	    if($_SESSION["main_guest"]["email"] == ""){
	        $request['customerInfo']['email'] = "test@mail.com";
	    }else{
	        $request['customerInfo']['email'] = $_SESSION["main_guest"]["email"];
	    }
	    // $request ['customerInfo']['phone'] = $_SESSION ["main_guest"] ["phone"];
	    $request['customValues'][0]['name'] = "hmsID";
	    $request['customValues'][0]['value'] = $this->personal_data["hotel_id"];
	    $request['urls']['callback'] = "https://" . $this->personal_data["host"] . "/bookit_c2/mandarin_payment_update";
	    
	    $request['urls']['return'] = "https://" . $this->personal_data["host"] . "/bookit_c2/mandarin_return";
	    
	    $request['fiscalInformation']['taxationSystem'] = $this->Hms_config->get_record('mandarin_taxation_system', $hms_id);
	    $request['fiscalInformation']['items'][0]['quantity'] = 1;
	    $request['fiscalInformation']['items'][0]['vat'] = "None";
	    $request['fiscalInformation']['items'][0]['description'] = "Dwelling";
	    $request['fiscalInformation']['items'][0]['totalPrice'] = $amount_full;
	    $request['fiscalInformation']['items'][0]['shipper']['name'] = $this->Hms_config->get_record('mandarin_hotel_name', $hms_id);
	    $request['fiscalInformation']['items'][0]['shipper']['inn'] = $this->Hms_config->get_record('mandarin_hotel_inn', $hms_id);
	    $request['fiscalInformation']['items'][0]['shipper']['phones'] = $this->Hms_config->get_record('mandarin_hotel_phone', $hms_id);
	    
	    //$returnURL = 'https://'. $this->personal_data["host"] . "/bookit_c2/step5";
	    if ($_SERVER['REMOTE_ADDR'] == "109.70.24.230") {
	        $returnURL = str_replace("otelms.com", "agast.ru", $this->personal_data["host"] );
	        $returnURL = 'https://'. $returnURL . "/bookit_c2/mandarin_return";
	    }
	    $request['urls']['return'] = $returnURL;
	    
	    $token = $this->Acquiring->get_mandarin_AuthToken();
	    
	    //if ($ccforce_val != 1) {
	        $curl_data = array();
	        $curl_data['url'] = $authparam['url'];
	        $curl_data['token'] = $token;
	        $curl_data['body'] = $request;
	        //             echo "<pre>";
	        //             print_r($curl_data);
	        //             die();
	        $result = $this->curl_model->CurlMandarin($curl_data);
	    
	        $result_data = json_decode($result, true);
	        $_SESSION["mandarin_id"] = $result_data['id'];
	        //echo $result;
	        //print_r($result_data);
	        //die();
	        $html_data = array();
	        $html_data ['url'] = $result_data['userWebLink'];
	        $html_data ['amount'] = $amount_full;
	        $this->mlanguages->getdictionary("bookit_c2_step4", "", $html_data);
	        $mandarin_alternative_payment = $this->parser->parse('templates/bookit_c2_mandarin_alternative_payment.html', $html_data, true);
	    //} else {
	    //    $mandarin_alternative_payment = "";
	    //}
	    
	    // ======= LOG ====================
	    $data = array();
	    $data ['pmv'] = $pmv;
	    $data ['hotel_id'] = $this->personal_data ["hotel_id"];
	    $data ['mandarin_id'] = $result_data['id'];
	    $data ['dc_order_id'] = $dc_order_id;
	    $data ['hms_res_id'] = 0;
	    $data ['amount'] = $_SESSION["paid_amount"];
	    $data ['currency'] = $currency;
	    $data ['data_callback'] = "";
	    $data ['data_return'] = "";
	    $data ['hms_payment_response'] = "";
	    $data ['hms_response'] = "";
	    $data ['status'] = "";
	     
	    $this->db->insert('mandarin_order2dc_order', $data);
	    $mandarin_pm_id = $this->db->insert_id();
	    $_SESSION["mandarin_pm_id"] = $mandarin_pm_id;

	    return $mandarin_alternative_payment;
	}
	
	function get_step4dopay_mandarin_block($dc_order_id)
    {
//         echo "<pre>";
//         print_r($_SESSION);
//         die();
        /*
         *
         * ==== GET CCFORCE BOOL VALUE =====
         * ==== get_ccforce_value ====
         */
        $currency = "RUB";
        $pmv = 2;
        $hms_id = $this->personal_data["hotel_id"];
        $ccforce_val = $this->Order->get_ccforce_value();
        
        $amount_full = number_format($_SESSION["amount"], 2, '.', '');
        $_SESSION["paid_amount"] = $_SESSION["amount"];
        
        $authparam = $this->Acquiring->get_mandarin_authparam();
        //print_r($authparam);
        // die();
        $request = array();
        $request['payment']['action'] = "pay";
        $request['payment']['orderId'] = "$hms_id-$dc_order_id-book";
        $request['payment']['price'] = $amount_full;
        $request['payment']['orderActualTill'] = date('Y-m-d H:i:s', strtotime('+15 minutes'));
        
        // ======== SUBACCOUNT ===========
        $mandarin_account_id = $this->Hms_config->get_record('mandarin_account_id', $hms_id);
        if($mandarin_account_id != ""){
            $request['routing']['destination'][0]['accountId'] = $mandarin_account_id;
            $request['routing']['destination'][0]['amount']['value'] = $amount_full;
            $request['routing']['destination'][0]['amount']['currency'] = "RUB";
            $request['routing']['destination'][0]['platformFeeAmount']['value'] = ($amount_full / 100) * $this->config->item('mandarin_fee_percent');
            $request['routing']['destination'][0]['platformFeeAmount']['currency'] = "RUB";
            $request['routing']['destination'][0]['description'] = "null";
        }
        
        
	    if($_SESSION["main_guest"]["email"] == ""){
            $request['customerInfo']['email'] = "test@mail.com";
        }else{
            $request['customerInfo']['email'] = $_SESSION["main_guest"]["email"];
        }
        // $request ['customerInfo']['phone'] = $_SESSION ["main_guest"] ["phone"];
        $request['customValues'][0]['name'] = "hmsID";
        $request['customValues'][0]['value'] = $this->personal_data["hotel_id"];
        $request['urls']['callback'] = "https://" . $this->personal_data["host"] . "/bookit_c2/mandarin_payment_update";
        
        $request['urls']['return'] = "https://" . $this->personal_data["host"] . "/bookit_c2/mandarin_return";
        
        $inn = $this->Hms_config->get_record('mandarin_hotel_inn', $hms_id);
        $taxation_system = $this->Hms_config->get_record('mandarin_taxation_system', $hms_id);
        $mandarin_vat_value = $this->Hms_config->get_record('mandarin_vat_value', $hms_id);
        
        //echo $inn." --- ".$mandarin_vat_value." --- ".$mandarin_account_id." --- ".$taxation_system;
        if ($inn != "" && $mandarin_account_id != "" && $taxation_system != "npd") {
            $request['fiscalInformation']['taxationSystem'] = $this->Hms_config->get_record('mandarin_taxation_system', $hms_id);
            $request['fiscalInformation']['items'][0]['quantity'] = 1;
            $request['fiscalInformation']['items'][0]['vat'] = $mandarin_vat_value;
            //$request['fiscalInformation']['items'][0]['description'] = iconv ( "utf-8", "windows-1251", "Проживание" );
            //$request['fiscalInformation']['items'][0]['description'] = utf8_encode("Проживание";
            $request['fiscalInformation']['items'][0]['description'] = iconv(mb_detect_encoding("Проживание", mb_detect_order(), true), "UTF-8", "Проживание");
            $request['fiscalInformation']['items'][0]['totalPrice'] = $amount_full;
            $request['fiscalInformation']['items'][0]['shipper']['name'] = $this->Hms_config->get_record('mandarin_hotel_name', $hms_id);
            $request['fiscalInformation']['items'][0]['shipper']['inn'] = $this->Hms_config->get_record('mandarin_hotel_inn', $hms_id);
            $request['fiscalInformation']['items'][0]['shipper']['phones'] = array( $this->Hms_config->get_record('mandarin_hotel_phone', $hms_id));
        }
        
        //$returnURL = 'https://'. $this->personal_data["host"] . "/bookit_c2/step5";
        
        $returnURL = 'https://'. $this->personal_data["host"] . "/bookit_c2/mandarin_return";
        if ($_SERVER['REMOTE_ADDR'] == "109.70.24.230") {
            $returnURL = str_replace("otelms.com", "agast.ru", $this->personal_data["host"] );
            $returnURL = 'https://'. $returnURL . "/bookit_c2/mandarin_return";
        }        
        $request['urls']['return'] = $returnURL;

        $cashback_bool = 0;
        if (isset($_SESSION['cashback'])) {
            if ($_SESSION['cashback'] == 1) {
                $mandarin_cashback = $this->Hms_config->get_record('mandarin_cashback', $hms_id);
                if ($this->releases->get_mandarin_cashback_config() == 1 && $mandarin_cashback == 1) {
                    $mandarin_conditions = $this->Acquiring->get_mandarin_conditions();
                    list ($year, $month, $day) = explode("-", $_SESSION["datein"]);
                    $intdatein = round(mktime(0, 0, 0, $month, $day, $year) / 86400);
                    list ($year, $month, $day) = explode("-", $_SESSION["dateout"]);
                    $intdateout = round(mktime(0, 0, 0, $month, $day, $year) / 86400);
                    
                    list ($year, $month, $day) = explode("-", $mandarin_conditions['range_date_start']);
                    $range_date_start_intdate = round(mktime(0, 0, 0, $month, $day, $year) / 86400);
                    list ($year, $month, $day) = explode("-", $mandarin_conditions['range_date_end']);
                    $range_date_end_intdate = round(mktime(0, 0, 0, $month, $day, $year) / 86400);
                    
                    $bookings_amount = $_SESSION['amount'];
                    // echo $intdatein . " >= " . $range_date_start_intdate . " || " . $intdateout . " <= " . $range_date_end_intdate . "==" . $check_amount . " >= " . $bookings_amount;
                    if ($intdatein >= $range_date_start_intdate && $intdateout <= $range_date_end_intdate && $mandarin_conditions['amount'] <= $bookings_amount) {
                        $matrchantid = 3; // cashback
                        $cashback_bool = 1;
                        $token = $this->Acquiring->get_mandarin_AuthToken($matrchantid);
                    }
                }
            }else{
                if($mandarin_account_id != ""){
                    $matrchantid = 2; // split
                    $token = $this->Acquiring->get_mandarin_AuthToken($matrchantid);
                }else{
                    $matrchantid = 1; // simple
                    $token = $this->Acquiring->get_mandarin_AuthToken($matrchantid);
                }
            }
        } else {
            if ($mandarin_account_id != "") {
                $matrchantid = 2; // split
                $token = $this->Acquiring->get_mandarin_AuthToken($matrchantid);
            } else {
                $matrchantid = 1; // simple
                $token = $this->Acquiring->get_mandarin_AuthToken($matrchantid);
            }
        }
        
        //$token = $this->Acquiring->get_mandarin_AuthToken();
        // echo $token;
//         die();

        if ($ccforce_val != 1 && FALSE) { 
            $curl_data = array();
            $curl_data['url'] = $authparam['url'];
            $curl_data['token'] = $token;
            $curl_data['body'] = $request;
//             echo "<pre>";
//             print_r($curl_data);
//             die();
            $result = $this->curl_model->CurlMandarin($curl_data);
            
            $result_data = json_decode($result, true);
            $_SESSION["mandarin_id"] = $result_data['id'];
            //echo $result;
            //print_r($result_data);
            //die();
            $html_data = array();
            $html_data ['url'] = $result_data['userWebLink'];
            $html_data ['amount'] = $amount_full;
            $this->mlanguages->getdictionary("bookit_c2_step4", "", $html_data);
            $mandarin_allowordertype = $this->parser->parse('templates/bookit_c2_step4dopay_mandarin_allowordertype.html', $html_data, true);
        } else {
            $mandarin_allowordertype = "";
        }
        
        // =========== daily ================================
        $request_data = array();
        $acquiring_valid = $this->Order->get_acquiring_valid();
         
        if($ccforce_val == 1 && $acquiring_valid == 1){
            $ccforce_amount = $this->Order->calculate_ccforce_rooms_amount();
            $ccforce_amount = ($cashback_bool == 1) ? $amount_full : $ccforce_amount;
            
            $_SESSION["paid_amount"] = $ccforce_amount;
            $ccforce_amount = number_format($ccforce_amount, 2, '.', '');
            
            if ($amount_full == $ccforce_amount && FALSE) {
                $mandarin_daily_prepayment = "";
            } else {
                
                $request['payment']['price'] = $ccforce_amount;
                if($mandarin_account_id != ""){
                    $request['routing']['destination'][0]['amount']['value'] = $ccforce_amount;
                    $request['routing']['destination'][0]['platformFeeAmount']['value'] = ($ccforce_amount / 100) * $this->config->item('mandarin_fee_percent');
                }
                if ($inn != "" && $mandarin_account_id != "") {
                    $request['fiscalInformation']['items'][0]['totalPrice'] = $ccforce_amount;
                }
                
                $curl_data = array();
                $curl_data['url'] = $authparam['url'];
                $curl_data['token'] = $token;
                $curl_data['body'] = $request;
//                 echo "<pre>";
//                 print_r($curl_data);
                
                $result = $this->curl_model->CurlMandarin($curl_data);
//                 echo $result;
//                 die();
                $result_data = json_decode($result, true);
                
                switch ($matrchantid) {
                    case 1: // simple
                        $secret = $authparam['secret'];
                        break;
                    case 2: // split
                        $secret = $authparam['split_secret'];
                        break;
                    case 3: // cashback
                        $secret = $authparam['cashback_secret'];
                        break;
                }
                
                $request_data = $curl_data;
                $request_data['response'] = $result_data;
                $request_data['creds']['token'] = $token;
                $request_data['creds']['secret'] = $secret;
                
                $_SESSION["mandarin_id"] = $result_data['id'];
//                 echo $result;
//               print_r($result_data);
               //die();

                $html_data = array();
                $html_data ['url'] = $result_data['userWebLink'];
                $html_data ['amount'] = $ccforce_amount;
                $html_data ['amount_str'] = $this->Mcurrency->fullvalue($ccforce_amount, 2);
                $mandarin_daily_prepayment = $this->parser->parse('templates/bookit_c2_step4dopay_mandarin_daily_prepayment.html', $html_data, true);
            }
        } else {
            $mandarin_daily_prepayment = "";
        }
        
//         $mandarin_cashback = $this->Hms_config->get_record('mandarin_cashback', $hms_id);
//         if ($this->releases->get_mandarin_cashback_config() == 1 && $mandarin_cashback == 1) {
//             $mandarin_conditions = $this->Acquiring->get_mandarin_conditions();
//             list ( $year, $month, $day ) = explode ( "-", $_SESSION ["datein"] );
//             $intdatein = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
//             list ( $year, $month, $day ) = explode ( "-", $_SESSION ["dateout"] );
//             $intdateout = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        
//             list ($year, $month, $day) = explode("-", $mandarin_conditions ['range_date_start']);
//             $range_date_start_intdate = round(mktime(0, 0, 0, $month, $day, $year) / 86400);
//             list ($year, $month, $day) = explode("-", $mandarin_conditions ['range_date_end']);
//             $range_date_end_intdate = round(mktime(0, 0, 0, $month, $day, $year) / 86400);
        
//             $bookings_amount = $_SESSION['amount'];
//             //echo $intdatein . " >= " . $range_date_start_intdate . " || " . $intdateout . " <= " . $range_date_end_intdate . "==" . $check_amount . " >= " . $bookings_amount;
//             if ($intdatein >= $range_date_start_intdate && $intdateout <= $range_date_end_intdate && $mandarin_conditions ['amount'] <= $bookings_amount) {
//                 $alternative_merchantId = 1;
//                 $alternative_token = $this->Acquiring->get_mandarin_AuthToken( $alternative_merchantId );
//                 $curl_data = array();
//                 $curl_data['url'] = $authparam['url'];
//                 $curl_data['token'] = $alternative_token;
//                 $curl_data['body'] = $request;
//                             //echo "<pre>";
//                             //print_r($curl_data);
//                             //die();
//                 $result = $this->curl_model->CurlMandarin($curl_data);
        
//                 $result_data = json_decode($result, true);
//                 $_SESSION["mandarin_id"] = $result_data['id'];
// //                 echo $result;
// //                 print_r($result_data);
// //                 die();
//                 $html_data = array();
//                 $html_data ['url'] = $result_data['userWebLink'];
//                 $html_data ['amount'] = $amount_full;
//                 $this->mlanguages->getdictionary("bookit_c2_step4", "", $html_data);
//                 $mandarin_alternative_prepayment = $this->parser->parse('templates/bookit_c2_mandarin_alternative_payment.html', $html_data, true);
//             }else{
//                 $mandarin_alternative_prepayment = "";
//             }
//         }else{
//             $mandarin_alternative_prepayment = "";
//         }
        
        // ======= LOG ====================
        $data = array();
        $data ['pmv'] = $pmv;
        $data ['hotel_id'] = $this->personal_data ["hotel_id"];
        $data ['mandarin_id'] = $result_data['id'];
        $data ['dc_order_id'] = $dc_order_id;
        $data ['hms_res_id'] = 0;
        $data ['amount'] = $_SESSION["paid_amount"];
        $data ['currency'] = $currency;
        $data ['data_callback'] = "";
        $data ['data_return'] = "";
        $data ['hms_payment_response'] = "";
        $data ['hms_response'] = "";
        $data ['request'] = json_encode($request_data, JSON_UNESCAPED_UNICODE);
        $data ['status'] = "";
         
        $this->db->insert('mandarin_order2dc_order', $data);
        $mandarin_pm_id = $this->db->insert_id();
        $_SESSION["mandarin_pm_id"] = $mandarin_pm_id;
        
        $return_data = array();
        $return_data["mandarin_allowordertype"] = $mandarin_allowordertype;
        $return_data["mandarin_daily_prepayment"] = $mandarin_daily_prepayment;
        //$return_data["mandarin_alternative_prepayment"] = $mandarin_alternative_prepayment;
        return $return_data;
    }

    function get_step4dopay_ipay_block($dc_order_id)
    {
        $currency = "GEL";
        $lang = 'en-US';
        $quantyty = 1;
        $pmv = 2;
        $hms_id = $this->personal_data["hotel_id"];
        $ccforce_val = $this->Order->get_ccforce_value();
        
        $amount_full = number_format($_SESSION["amount"], 2, '.', '');
        $_SESSION["paid_amount"] = $_SESSION["amount"];
//         echo $hms_id;
//         die();
        $authparam = $this->Acquiring->get_ipay_authparam($hms_id);
//         echo "<pre>";
//         print_r($authparam);
        $token_data = $this->Acquiring->get_ipay_token($hms_id);
        $token = $token_data['access_token'];
        $redirect_url = "https://" . $this->personal_data["host"] . "/bookit_c2/ipay_payment_update?dc_order_id=$dc_order_id";

        $request = array(
            'intent' => 'CAPTURE',
            'shop_order_id' => "$hms_id-$dc_order_id-book",
            'locale' => $lang,
            'capture_method' => 'AUTOMATIC',
            'items' => array(
                array(
                    'amount' => $amount_full,
                    'description' => "",
                    'quantity' => $quantyty,
                    'product_id' => "$hms_id-$dc_order_id-book"
                )
            ),
            'redirect_url' => $redirect_url,
            'purchase_units' => array(
                array(
                    'amount' => array(
                        'currency_code' => $currency,
                        'value' => $amount_full
                    ),
                    'industry_type' => 'tourism'
                )
            )
        );
        
//         echo $ccforce_val;
//         die();
        if ($ccforce_val != 1) {
           
            
            $curl_data = array();
            $curl_data['endpoint'] = $authparam['endpoint'];
            $curl_data['token'] = $token;
            $curl_data['body'] = $request;
            //  echo "<pre>";
            // print_r($curl_data);
            $result = $this->curl_model->CurlIpay($curl_data);
    
            $result_data = json_decode($result, true);
            
            //echo $result."<pre>";
            //print_r($result_data);
            //die();
            $_SESSION["ipay_id"] = $result_data['order_id'];
            
            $html_data = array();
            $html_data ['url'] = $result_data['links'][1]['href'];
            $html_data ['amount'] = $amount_full;
            $this->mlanguages->getdictionary("bookit_c2_step4", "", $html_data);
            $ipay_allowordertype = $this->parser->parse('templates/bookit_c2_step4dopay_ipay_allowordertype.html', $html_data, true);
        } else {
            $ipay_allowordertype = "";
        }
    
        // =========== daily ================================
    
        $acquiring_valid = $this->Order->get_acquiring_valid();
        if($ccforce_val == 1 && $acquiring_valid == 1){
            $ccforce_amount = $this->Order->calculate_ccforce_rooms_amount();
            $_SESSION["paid_amount"] = $ccforce_amount;
            $ccforce_amount = number_format($ccforce_amount, 2, '.', '');
    
            if ($amount_full == $ccforce_amount && FALSE) {
                $ipay_daily_prepayment = "";
            } else {
                 $curl_data = array();
            $curl_data['endpoint'] = $authparam['endpoint'];
            $curl_data['token'] = $token;
            $curl_data['body'] = $request;
            //  echo "<pre>";
            // print_r($curl_data);
            $result = $this->curl_model->CurlIpay($curl_data);
    
            $result_data = json_decode($result, true);
            
           //echo $result."<pre>";
            //print_r($result_data);
            //die();
                $_SESSION["ipay_id"] = $result_data['order_id'];

    
                $html_data = array();
                $html_data ['url'] = $result_data['links'][1]['href'];
                $html_data ['amount'] = $ccforce_amount;
                $html_data ['amount_str'] = $this->Mcurrency->fullvalue($ccforce_amount, 2);
                $ipay_daily_prepayment = $this->parser->parse('templates/bookit_c2_step4dopay_ipay_daily_prepayment.html', $html_data, true);
            }
        } else {
            $ipay_daily_prepayment = "";
        }
    
        // ======= LOG ====================
        $data = array();
        $data ['pmv'] = $pmv;
        $data ['hotel_id'] = $this->personal_data ["hotel_id"];
        $data ['ipay_id'] = $result_data['order_id'];
        $data ['dc_order_id'] = $dc_order_id;
        $data ['hms_res_id'] = 0;
        $data ['amount'] = $_SESSION["paid_amount"];
        $data ['currency'] = $currency;
        $data ['data_callback'] = "";
        $data ['data_return'] = "";
        $data ['hms_payment_response'] = "";
        $data ['hms_response'] = "";
        $data ['status'] = "";
         
        $this->db->insert('ipay_order2dc_order', $data);
        $ipay_pm_id = $this->db->insert_id();
        $_SESSION["ipay_pm_id"] = $ipay_pm_id;
    
        $return_data = array();
        $return_data["ipay_allowordertype"] = $ipay_allowordertype;
        $return_data["ipay_daily_prepayment"] = $ipay_daily_prepayment;
        return $return_data;
    }
    
    function get_step4dopay_paypal_v2_block($dc_order_id){
        $return_data = array();
    
        $amount_full = number_format($_SESSION["amount"], 2, '.', '');
    
        //save paid amount in session
        //$_SESSION["paid_amount"] = $amount_full;
    
        $data = array ();
        $data['paid_amount'] = $_SESSION["amount"];
        $data['dc_order_id'] = $dc_order_id;
        $this->mlanguages->getdictionary("bookit_c2_step4", "", $data);
        $paypal_allowordertype = $this->parser->parse ( 'templates/bookit_c2_paypal_v2_prepayment.html', $data, true );
    
        $ccforce_val = $this->Order->get_ccforce_value();
        $acquiring_valid = $this->Order->get_acquiring_valid();
         
        if($ccforce_val == 1 && $acquiring_valid == 1){
            /*
             *
             * ======= CCFORCE calculate AMOUNT =============
             *
             * function calculate_ccforce_rooms_amount: get data from SESSION and calculate ccforce amount
             *
             */
            $ccforce_amount = $this->Order->calculate_ccforce_rooms_amount();
    
            //save paid amount in session
            //$_SESSION["paid_amount"] = $ccforce_amount;
            //$_SESSION["stripe_paid_ccforce_amount"] = $ccforce_amount;
            if ($amount_full == $ccforce_amount) {
                $paypal_daily_prepayment = "";
            } else {
                $data['amount_str'] = $this->Mcurrency->fullvalue($ccforce_amount, 2);
                $data['paid_amount'] = $ccforce_amount;
                $paypal_daily_prepayment = $this->parser->parse ( 'templates/bookit_c2_paypal_v2_daily_prepayment.html', $data, true );
            }
        }else{
            $paypal_daily_prepayment = "";
        }
    
    
        $return_data["paypal_allowordertype"] = $paypal_allowordertype;
        $return_data["paypal_daily_prepayment"] = $paypal_daily_prepayment;
        return $return_data;
    }
    
    function get_step4dopay_paypal_v2_block_test($dc_order_id){
        $currency = "USD";
        $pmv = 2;
        $hms_id = $this->personal_data["hotel_id"];
        $ccforce_val = $this->Order->get_ccforce_value();
        
        $amount_full = number_format($_SESSION["amount"], 2, '.', '');
        
        
        $_SESSION["paid_amount"] = $_SESSION["amount"];
        $log_paid_amount = $_SESSION["paid_amount"];
        
        $paypal_client_id = $this->Hms_config->get_record('paypal_client_id', $hms_id);
        
        $success_url = "https://" . $this->personal_data["host"] . "/bookit_c2/paypal_v2_payment_update";
        $error_url = "https://" . $this->personal_data["host"] . "/bookit_c2/paypal_v2_payment_error";
        
        if ($ccforce_val != 1) {
            $html_data = array();
            $html_data ['url'] = $result_data['links'][1]['href'];
            //$html_data ['amount'] = $amount_full;
            $html_data ['amount'] = 2;
            $html_data ['paypal_client_id'] = $paypal_client_id;
            $html_data ['dc_order_id'] = $dc_order_id;
            $html_data ['success_url'] = $success_url;
            $html_data ['error_url'] = $error_url;
            $html_data ['currency'] = $currency;
            $this->mlanguages->getdictionary("bookit_c2_step4", "", $html_data);
            $paypal_allowordertype = $this->parser->parse('templates/bookit_c2_step4dopay_paypal_allowordertype.html', $html_data, true);
        } else {
            $paypal_allowordertype = "";
        }
        
        // =========== daily ================================
        
        if ($ccforce_val == 1) {
            $ccforce_amount = $this->Order->calculate_ccforce_rooms_amount();
            $_SESSION["paid_amount"] = $ccforce_amount;
            $ccforce_amount = number_format($ccforce_amount, 2, '.', '');
            $log_paid_amount = $ccforce_amount;
            if ($amount_full == $ccforce_amount && FALSE) {
                $paypal_daily_prepayment = "";
            } else {
                $html_data = array();
                $html_data ['url'] = $result_data['links'][1]['href'];
                //$html_data ['amount'] = $ccforce_amount;
                $html_data ['amount'] = 1;
                $html_data ['paypal_client_id'] = $paypal_client_id;
                $html_data ['dc_order_id'] = $dc_order_id;
                $html_data ['success_url'] = $success_url;
                $html_data ['error_url'] = $error_url;
                $html_data ['currency'] = $currency;
                $html_data ['amount_str'] = $this->Mcurrency->fullvalue($ccforce_amount, 2);
                $paypal_daily_prepayment = $this->parser->parse('templates/bookit_c2_step4dopay_paypal_daily_prepayment.html', $html_data, true);
            }
        } else {
            $paypal_daily_prepayment = "";
        }
        
        // ======= LOG ====================
        $data = array();
        $data ['pmv'] = $pmv;
        $data ['hotel_id'] = $this->personal_data ["hotel_id"];
        $data ['dc_order_id'] = $dc_order_id;
        $data ['hms_res_id'] = 0;
        $data ['amount'] = $log_paid_amount;
         
        $this->db->insert('paypal_v2_odrder2dc_order', $data);
        

        $return_data = array();
        $return_data["paypal_allowordertype"] = $paypal_allowordertype;
        $return_data["paypal_daily_prepayment"] = $paypal_daily_prepayment;
        return $return_data;
    }
    
    function get_step4dopay_monobank_block($dc_order_id)
    {
        $currency = "UAH";
        $pmv = 2;
        $hms_id = $this->personal_data["hotel_id"];
        $ccforce_val = $this->Order->get_ccforce_value();
    
        $amount_full = $_SESSION["amount"];
        $_SESSION["paid_amount"] = $_SESSION["amount"];
    
        $authparam = $this->Acquiring->get_monobank_authparam( $hms_id );

        $reference = 'A0001';
        $destination = 'pay for book';
        $goodName = 'Hotel Otelms';
        $goodQty = 1;
        $goodIcon = 'https://i1.sndcdn.com/artworks-1W1ucUu0AroJKisi-8sy04w-t500x500.jpg';
        
        $redirect_url = "https://" . $this->personal_data["host"] . "/bookit_c2/monobank_payment_update?dc_order_id=$dc_order_id";
        
        $webhook_url = "https://" . $this->personal_data["host"] . "/bookit_c2/monobank_return";
        
    
//                  echo $ccforce_val;
//                  die();
        if ($ccforce_val != 1) {
            $request = array(
                'amount' => (int)($amount_full * 100),
                'merchantPaymInfo' => array(
                    'reference' => $reference,
                    'destination' => $destination,
                    'basketOrder' => array(
                        array(
                            'name' => $goodName,
                            'qty' => $goodQty,
                            'sum' => (int)($amount_full * 100),
                            'icon' => $goodIcon
                        )
                    )
                ),
                'redirectUrl' => $redirect_url,
                'webHookUrl' => $webhook_url
            );

    
            $curl_data = array();
            $curl_data['endpoint'] = $authparam['endpoint'];
            $curl_data['token'] = $authparam['token'];
            $curl_data['body'] = $request;
            // echo "<pre>";
            //print_r($curl_data);
            $result = $this->curl_model->CurlMonobank($curl_data);
    
            $result_data = json_decode($result, true);
    
            //echo $result."<pre>";
            //print_r($result_data);
            //die();
            $_SESSION["monobank_id"] = $result_data['invoiceId'];
    
            $html_data = array();
            $html_data ['url'] = $result_data['pageUrl'];
            $html_data ['amount'] = $amount_full;
            $this->mlanguages->getdictionary("bookit_c2_step4", "", $html_data);
            $monobank_allowordertype = $this->parser->parse('templates/bookit_c2_step4dopay_monobank_allowordertype.html', $html_data, true);
        } else {
            $monobank_allowordertype = "";
        }
    
        // =========== daily ================================
    
        $acquiring_valid = $this->Order->get_acquiring_valid();
	    
	    if($ccforce_val == 1 && $acquiring_valid == 1){
            $ccforce_amount = $this->Order->calculate_ccforce_rooms_amount();
            $_SESSION["paid_amount"] = $ccforce_amount;
            $ccforce_amount = $ccforce_amount;
    
            if ($amount_full == $ccforce_amount && FALSE) {
                $monobank_daily_prepayment = "";
            } else {
                $request = array(
                    'amount' => (int)($ccforce_amount * 100),
                    'merchantPaymInfo' => array(
                        'reference' => $reference,
                        'destination' => $destination,
                        'basketOrder' => array(
                            array(
                                'name' => $goodName,
                                'qty' => $goodQty,
                                'sum' => (int)($ccforce_amount * 100),
                                'icon' => $goodIcon
                            )
                        )
                    ),
                    'redirectUrl' => $redirect_url,
                    'webHookUrl' => $webhook_url
                );
//                             print_r($request);
//                             die();
                $curl_data = array();
                $curl_data['endpoint'] = $authparam['endpoint'];
                $curl_data['token'] = $authparam['token'];;
                $curl_data['body'] = $request;
                // echo "<pre>";
                //print_r($curl_data);
                $result = $this->curl_model->CurlMonobank($curl_data);
    
                $result_data = json_decode($result, true);
    
                //echo $result."<pre>";
                //print_r($result_data);
                
                //die();
                $_SESSION["monobank_id"] = $result_data['invoiceId'];
                $html_data = array();
                $html_data ['url'] = $result_data['pageUrl'];;
                $html_data ['amount'] = $ccforce_amount;
                $html_data ['amount_str'] = $this->Mcurrency->fullvalue($ccforce_amount, 2);
                $monobank_daily_prepayment = $this->parser->parse('templates/bookit_c2_step4dopay_monobank_daily_prepayment.html', $html_data, true);
            }
        } else {
            $monobank_daily_prepayment = "";
        }

        // ======= LOG ====================
        $data = array();
        $data ['pmv'] = $pmv;
        $data ['hotel_id'] = $this->personal_data ["hotel_id"];
        $data ['invoice_id'] = $result_data['invoiceId'];
        $data ['dc_order_id'] = $dc_order_id;
        $data ['hms_res_id'] = 0;
        $data ['amount'] = $_SESSION["paid_amount"];
        $data ['currency'] = $currency;
        $data ['data_callback'] = "";
        $data ['data_return'] = "";
        $data ['hms_payment_response'] = "";
        $data ['hms_response'] = "";
        $data ['status'] = "";
        $data ['buy_order'] = "";
        
        $this->db->insert('monobank_order2dc_order', $data);
        $monobank_pm_id = $this->db->insert_id();
        $_SESSION["monobank_pm_id"] = $monobank_pm_id;

        $return_data = array();
        $return_data["monobank_allowordertype"] = $monobank_allowordertype;
        $return_data["monobank_daily_prepayment"] = $monobank_daily_prepayment;
        return $return_data;
    }

	function get_step4dopay_stripe_block(){
	    $return_data = array();

	    $amount_full = number_format($_SESSION["amount"], 2, '.', '');

	    //save paid amount in session
	    //$_SESSION["paid_amount"] = $amount_full;

	    $data = array ();
	    $data['paid_amount'] = $_SESSION["amount"];

	    $this->mlanguages->getdictionary("bookit_c2_step4", "", $data);
	    $stripe_allowordertype = $this->parser->parse ( 'templates/bookit_c2_stripe_prepayment.html', $data, true );

	    $ccforce_val = $this->Order->get_ccforce_value();
	    $acquiring_valid = $this->Order->get_acquiring_valid();
	    
	    if($ccforce_val == 1 && $acquiring_valid == 1){
	        /*
	         *
	         * ======= CCFORCE calculate AMOUNT =============
	         *
	         * function calculate_ccforce_rooms_amount: get data from SESSION and calculate ccforce amount
	         *
	         */
	        $ccforce_amount = $this->Order->calculate_ccforce_rooms_amount();

	        //save paid amount in session
	        //$_SESSION["paid_amount"] = $ccforce_amount;
	        //$_SESSION["stripe_paid_ccforce_amount"] = $ccforce_amount;
	        if ($amount_full == $ccforce_amount) {
	            $stripe_daily_prepayment = "";
	        } else {
	            $data['amount_str'] = $this->Mcurrency->fullvalue($ccforce_amount, 2);
	            $data['paid_amount'] = $ccforce_amount;
	            $stripe_daily_prepayment = $this->parser->parse ( 'templates/bookit_c2_stripe_daily_prepayment.html', $data, true );
	        }
	    }else{
	        $stripe_daily_prepayment = "";
	    }


	    $return_data["stripe_allowordertype"] = $stripe_allowordertype;
	    $return_data["stripe_daily_prepayment"] = $stripe_daily_prepayment;
	    return $return_data;
	}

	function get_step4dopay_liqpay_block($dc_order_id){
	    $Order_IDP = $dc_order_id;
	    $amount_full = $_SESSION ["amount"];

	    $ccforce_val = $this->Order->get_ccforce_value();


	    $data = array();
	    $data['version'] = 3;
	    $data['result_url'] = "https://" . $_SERVER["HTTP_HOST"]."/bookit_c2/step5";

	    //echo $_SERVER["HTTP_HOST"];
	    $authparam = $this->Acquiring->get_liqpay_authparam();

	    //echo "<pre>";
	    //print_r($authparam);
	    //die();


	    $data['server_url'] = "https://xml.otelms.com/api_liqpay/push/999";
	    $data['sandbox'] = 0;
	    //$data['sandbox'] = $this->personal_data ["ligpay_test_mode"];
	    $data['sandbox'] = $authparam['sandbox'];
	    // TECH acc
	    $data['public_key'] = "i89691670268";
	    $data['public_key'] = $this->personal_data ["publickey"];
	    $private_key = "ElvlYDqHToLIboCdjxx9Uk6LCYHKcHOt0KRuMeTu";
	    $private_key = $this->personal_data ["liqpay_privat_key"];
	    $data['action'] = "pay";
	    $data['amount'] = $amount_full;
	    $data['currency'] = "UAH";
	    $data['description'] = "liqpay payment";
	    $data['order_id'] = "hms-liqpay-" . $this->personal_data ["hotel_id"] . "-" . $Order_IDP . "-ibm";
	    //echo "<pre>";
	    //print_r($data);
	    $datastr = base64_encode(json_encode($data, true));
	    $signature = base64_encode(sha1($private_key . $datastr . $private_key, 1));


	    $data_html = array(
	        "liqpay_datastr" => $datastr,
	        "liqpay_signature" => $signature,
	        "amount" => $amount_full,
	    );

	    $this->mlanguages->getdictionary("bookit_c2_step4", "", $data_html);

// 	    $ligpay_prepayment = "";
//         $query = $this->db->query("SELECT ligpay_test_mode, publickey, allowordertype3 FROM hotels_personal WHERE hotel_id = " . $this->personal_data["hotel_id"]);
//         if ($query->num_rows() > 0) {
//             $row = $query->row();
//             if ($row->allowordertype3 == 1 and 1) {
//                 $ligpay_prepayment = $this->parser->parse('templates/bookit_c2_step4dopay_ligpay_prepayment.html', $data, true);
//             }
//         }

        $ligpay_prepayment = $this->parser->parse('templates/bookit_c2_step4dopay_ligpay_prepayment.html', $data_html, true);

//         $liqpay_daily_prepayment = "";
//         $sql = "SELECT liqpay_daily_prepayment FROM hotels_personal WHERE hotel_id = " . $this->personal_data["hotel_id"];
//         $query = $this->db->query($sql);

//         if ($query->num_rows() > 0) {
//             $row = $query->row();
//             if ($row->liqpay_daily_prepayment == 1 and $this->personal_data["liqpay_daily_prepayment"] == 1) {
//                 $liqpay_daily_prepayment = $this->parser->parse('templates/bookit_c2_step4dopay_ligpay_daily_prepayment.html', $data, true);
//             }
//         }
        //echo "<pre>";
        //print_r($data);
//        die();
        $acquiring_valid = $this->Order->get_acquiring_valid();
        if($ccforce_val == 1 && $acquiring_valid == 1){
            $ccforce_amount = $this->Order->calculate_ccforce_rooms_amount();

            if ($amount_full == $ccforce_amount) {
                $liqpay_daily_prepayment = "";
            } else {
                $data['amount'] = $ccforce_amount;
                 //echo "<pre>";
                 //print_r($data);
                 //die();
                $datastr = "";
                $signature = "";
                $datastr = base64_encode(json_encode($data, true));
                $signature = base64_encode(sha1($private_key . $datastr . $private_key, 1));


                $data_html = array(
                    "liqpay_datastr" => $datastr,
                    "liqpay_signature" => $signature,
                    "amount" => $ccforce_amount,
                    "amount_str" => $this->Mcurrency->fullvalue($ccforce_amount, 2),
                );
                $liqpay_daily_prepayment = $this->parser->parse('templates/bookit_c2_step4dopay_ligpay_daily_prepayment.html', $data_html, true);
            }

        }else{
            $liqpay_daily_prepayment = "";
        }

	    $return_data = array();
	    $return_data["ligpay_prepayment"] = $ligpay_prepayment;
	    $return_data["liqpay_daily_prepayment"] = $liqpay_daily_prepayment;
	    return $return_data;
	}
}
?>