<?php
class Debug_model extends CI_Model {

	function __construct() {
		// Call the Model constructor
		parent::__construct ();
	}

	function parsing_free_rooms_TFV($incoming_data) {
	    $hotel_id = $incoming_data['hotel_id'];
	    $lang_code = $incoming_data['lang_code'];
        if (!empty($incoming_data['hms_free_rooms'])){
            $categories = $incoming_data['hms_free_rooms'];
            $requested_categories = $requested_rates = [];
            foreach ($categories as $category) {
                array_push($requested_categories, $category['category_id']);
                foreach ($category['rates'] as $rate) {
                    if (!in_array($rate['rate_id'], $requested_rates)){
                        array_push($requested_rates, $rate['rate_id']);
                    }
                }
            }
            $requested_categories = implode (', ', $requested_categories);
            $requested_rates = implode (', ', $requested_rates);

            $category_images_dbrecords = array ();
            $sql = " SELECT id_position, category_id, id FROM `categories_images_c2` WHERE hotel_id = $hotel_id";
            $query = $this->db->query ( $sql );
            foreach ( $query->result () as $row ) {
                $category_images_dbrecords [$row->category_id]["images"][$row->id]["category_id"] = $row->category_id;
                $category_images_dbrecords [$row->category_id]["images"][$row->id]["id_position"] = $row->id_position;
            }
            $category_images_fototags_dbrecords = array ();
            $sql = "SELECT category_fototags.*, fototags.name
            FROM `category_fototags`
            INNER JOIN fototags ON fototags.id = category_fototags.tag_id
            WHERE category_fototags.hotel_id = $hotel_id";
            $query = $this->db->query ( $sql );
            foreach ( $query->result () as $row ) {
                if(!isset($category_images_fototags_dbrecords [$row->category_id][$row->foto_id]))
                    $category_images_fototags_dbrecords [$row->category_id][$row->foto_id]["tag_name"] = "{-".$row->name."-}";
            }
            $meal_policies_array = array();
            $sql = "SELECT id, name FROM meal_policies";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    $meal_policies_array[$row->id]["name"] = $row->name;
                }
            }
            $dc_cancelationpolicy_array = array();
            $sql = "SELECT id, name, description, caption FROM dc_cancelationpolicy_list";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    $dc_cancelationpolicy_array[$row->id]["name"] = $row->name;
                    $dc_cancelationpolicy_array[$row->id]["description"] = "{-".$row->name."_txt}";//$row->description;
                    $dc_cancelationpolicy_array[$row->id]["caption"] = "{-".$row->name."_txt}";//$row->caption;
                }
            }
            $main_amenity_value = 5;
            $first_amenities_array = array();
            $category_amenities = array();
            $sql = "SELECT category2amenities.category_id, category_amenety_type.id as amenity_type_id,
                        category_amenety_type.name as amenity_type_name, category_ameneties.class_name as amenity_class_name,
                        category_ameneties.id as amenity_id, category_ameneties.name as amenity_name, category_ameneties.img_name as amenity_img
                FROM category2amenities
                INNER JOIN category_ameneties ON category_ameneties.id = category2amenities.amenity_id
                INNER JOIN category_amenety_type ON category_amenety_type.id = category_ameneties.type_id
                WHERE category2amenities.hotel_id = ".$hotel_id;
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    $category_amenities [$row->category_id]["category_amenity_types"][$row->amenity_type_id]["amenity_type_id"] = $row->amenity_type_id;
                    $category_amenities [$row->category_id]["category_amenity_types"][$row->amenity_type_id]["amenity_type_name"] = $row->amenity_type_name;
                    //$category_amenities [$row->category_id]["category_amenity_types"][$row->amenity_type_id]["amenity_class_name"] = $row->amenity_class_name;
                    $category_amenities [$row->category_id]["category_amenity_types"][$row->amenity_type_id]["category_amenities"][$row->amenity_id]["amenity_img"] = $row->amenity_img;
                    $category_amenities [$row->category_id]["category_amenity_types"][$row->amenity_type_id]["category_amenities"][$row->amenity_id]["amenity_id"] = $row->amenity_id;
                    $category_amenities [$row->category_id]["category_amenity_types"][$row->amenity_type_id]["category_amenities"][$row->amenity_id]["amenity_name"] = "{-".$row->amenity_name."-}";
                    if(isset($first_amenities_array[$row->category_id])){
                        $first_amenities_array_count = count($first_amenities_array[$row->category_id]);
                    }else{
                        $first_amenities_array[$row->category_id] = array();
                        $first_amenities_array_count = 0;
                    }
                    if($main_amenity_value > $first_amenities_array_count){
                        array_push($first_amenities_array[$row->category_id], array(
                            "amenity_icon_class" => $row->amenity_class_name,
                            "category_id" => $row->category_id

                        ));
                    }
                }
            }
            //======== GET RATES FROM PERSONAL ==============
            $rate_data = array ();
            $sql = "SELECT rate_descriptions.rate_id, rate_descriptions.value, rate_descriptions.name as international_type_name,
                        rate_details.cancellation_policy_id, rate_details.meal_policy_id, rate_details.ccforce
                FROM rate_descriptions
                LEFT JOIN rate_details ON rate_details.rate_id = rate_descriptions.rate_id AND rate_details.hotel_id = ".$hotel_id."
                WHERE rate_descriptions.rate_id IN ($requested_rates) AND rate_descriptions.hotel_id = ".$hotel_id." AND rate_descriptions.language_id = " . $lang_code;
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    $rate_data [$row->rate_id] ["cancellation_policy_id"] = $row->cancellation_policy_id;
                    $rate_data [$row->rate_id] ["meal_policy_id"] = $row->meal_policy_id;
                    $rate_data [$row->rate_id] ["ccforce"] = $row->ccforce;
                    switch ($row->international_type_name) {
                        case "international_name" :
                            if ($row->value != "") {
                                $rate_data [$row->rate_id] ["rate_name"] = $row->value;
                            } else {
                                $rate_data [$row->rate_id] ["rate_name"] = "???";
                            }
                            break;
                        case "international_description" :
                            if ($row->value != "") {
                                $rate_data [$row->rate_id] ["description"] = $row->value;
                            } else {
                                $rate_data [$row->rate_id] ["description"] = "???";
                            }
                            break;
                    }
                }
            }
            //======== GET CATEGORIES FROM PERSONAL ==============
            $sql = "SELECT category_descriptions.category_id, category_descriptions.value, category_descriptions.name as international_type_name,
                        category_details.places, category_details.add_places, category_details.size, category_details.size_type
                FROM category_descriptions
                LEFT JOIN category_details ON category_details.category_id = category_descriptions.category_id AND category_details.hotel_id = $hotel_id
                WHERE category_descriptions.category_id IN ($requested_categories) AND category_descriptions.hotel_id = $hotel_id AND category_descriptions.language_id = $lang_code";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    if(isset($categories[$row->category_id])){
                        switch($row->size_type){
                            case 1:
                                $clt_size_str = "{clt_sq_m}";
                                break;
                            case 2:
                                $clt_size_str = "{clt_sq_ft}";
                                break;
                            default:
                                $clt_size_str = "{clt_sq_m}";
                                break;
                        }
                        $categories[$row->category_id]["clt_size_str"] = $clt_size_str;
                        $categories[$row->category_id]["category_size"] = $row->size;
                        $categories[$row->category_id]["base_places"] = $row->places;
                        $categories[$row->category_id]["add_places"] = $row->add_places;
                        $places_diff = $row->add_places - $row->places;
                        if($places_diff > 0){
                            $categories[$row->category_id]["additional_places_str"] = "+ ".($row->add_places - $row->places)." {clt_on_extra_bed}";
                        }else{
                            $categories[$row->category_id]["additional_places_str"] = "";
                        }
                        switch ($row->international_type_name) {
                            case "international_name" :
                                if($row->value != ""){
                                    $categories[$row->category_id]["name"] = $row->value;
                                }else{
                                    $categories[$row->category_id]["name"] = "???";
                                }
                                break;
                            case "international_comment" :
                                if($row->value != ""){
                                    $categories[$row->category_id]["description"] = $row->value;
                                }else{
                                    $categories[$row->category_id]["description"] = "???";
                                }
                                break;
                        }
                    }
                }
            }
            foreach ( $categories as $category_id => $category_data ) {
                if(isset($category_amenities[$category_id])){
                    $categories[$category_id]["category_amenity_types"] = $category_amenities[$category_id]["category_amenity_types"];
                }else{
                    $categories[$category_id]["category_amenity_types"] = array();
                }
                if(isset($first_amenities_array[$category_id])){
                    $categories[$category_id]["first_amenities_array"] = $first_amenities_array[$category_id];
                }else{
                    $categories[$category_id]["first_amenities_array"] = array();
                }
                $imgSmall_list = array ();
                $img_list = array();
                $carousel_indicators = array ();
                if (isset ( $category_images_dbrecords [$category_id] ["images"] )) {
                    $i = 0;
                    foreach ( $category_images_dbrecords [$category_id] ["images"] as $foto_id => $cell) {
                        $filename = $this->config->item ( 'foto_path' ) . '/' . $hotel_id . '_' . $category_id . '_' . $cell["id_position"] . '_100.jpg';
                        $img = $this->config->item ( 'foto_web_path' ) . $hotel_id . '_' . $category_id . '_' . $cell["id_position"] . '_500.jpg';
                        $imgSmall = $this->config->item ( 'foto_web_path' ) . $hotel_id . '_' . $category_id . '_' . $cell["id_position"] . '_100.jpg';
                        if ($img != "/images/pixel.jpg") {
                            if($i == 0){
                                $img_class_active = "active";
                            }else{
                                $img_class_active = "";
                            }
                            $tag_name = "";
                            if(isset($category_images_fototags_dbrecords[$category_id][$foto_id])){
                                $tag_name = $category_images_fototags_dbrecords[$category_id][$foto_id]["tag_name"];
                            }
                            array_push($img_list, array(
                                "img" => $img,
                                "category_id" => $category_id,
                                "small_img" => $imgSmall,
                                "image_id_position" => $cell["id_position"],
                                "image_inc" => $i,
                                "img_class_active" => $img_class_active,
                                "tag_name" => $tag_name
                            ));
                            array_push ( $carousel_indicators, array (
                                "image_inc" => $i,
                                "img_class_active" => $img_class_active
                            ) );
                        }
                        $i++;
                    }
                }
                $categories [$category_id] ["img_list"] = $img_list;
                $categories [$category_id] ["hidden_empty_foto_class"] = "";
                if(count($img_list) == 0){
                    $categories [$category_id] ["hidden_empty_foto_class"] = "d0";
                }
                $categories [$category_id] ["carousel_indicators"] = $carousel_indicators;
                foreach ( $category_data ["rates"] as $rate_id => $rate_set ) {
                    if (isset ( $rate_data [$rate_id] )) {
                        $cancellation_policy_id = $rate_data [$rate_id] ["cancellation_policy_id"];
                        $meal_policy_id = $rate_data [$rate_id] ["meal_policy_id"];
                        $categories [$category_id] ["rates"] [$rate_id] ["category_id"] = $category_id;
                        $categories [$category_id] ["rates"] [$rate_id] ["rate_name"] = $rate_data [$rate_id] ["rate_name"];
                        $categories [$category_id] ["rates"] [$rate_id] ["description"] = $rate_data [$rate_id] ["description"];
                        $categories [$category_id] ["rates"] [$rate_id] ["amount"] = $this->Mcurrency->fullvalue($rate_set ['price']);
                        $url_get_str = http_build_query(array(
                            'amount' => $rate_set ['price'],
                            'selected_category' => $category_id,
                            'selected_rate' => $rate_id,
                        ));
                        $categories [$category_id] ["rates"] [$rate_id] ["url_get_str"] = $url_get_str;
                        if($rate_data [$rate_id] ["ccforce"] == 1){
                            $ccforce_text = "{clt_payment_required}";
                        }else{
                            $ccforce_text = "{clt_pay_upon_arrival}";
                        }
                        $categories [$category_id] ["rates"] [$rate_id] ["ccforce_text"] = $ccforce_text;
                        if (isset ( $dc_cancelationpolicy_array [$cancellation_policy_id] )) {
                            $categories [$category_id] ["rates"] [$rate_id] ["cancellation_policy_description"] = $dc_cancelationpolicy_array [$cancellation_policy_id] ["caption"];
                        } else {
                            $categories [$category_id] ["rates"] [$rate_id] ["cancellation_policy_description"] = "{clt_no_cancellation_policy_desc}";
                        }
                        if (isset ( $meal_policies_array [$meal_policy_id] )) {
                            if($meal_policy_id == 1){
                                $categories [$category_id] ["rates"] [$rate_id] ["meal_policy_name"] = "{clt_no_meal_policy_name}";
                            }else{
                                $categories [$category_id] ["rates"] [$rate_id] ["meal_policy_name"] = $meal_policies_array [$meal_policy_id] ["name"];
                            }
                        } else {
                            $categories [$category_id] ["rates"] [$rate_id] ["meal_policy_name"] = "{clt_no_meal_policy_name}";
                        }
                    } else {
                        $categories [$category_id] ["rates"] [$rate_id] ["rate_name"] = "???";
                        $categories [$category_id] ["rates"] [$rate_id] ["description"] = "???";
                        $categories [$category_id] ["rates"] [$rate_id] ["cancellation_policy_description"] = "{clt_no_cancellation_policy_desc}";
                        $categories [$category_id] ["rates"] [$rate_id] ["meal_policy_name"] = "{clt_no_meal_policy_name}";
                        $categories [$category_id] ["rates"] [$rate_id] ["ccforce_text"] = "???";
                    }
                }
            }
        }

        return $categories;
	}
	
	/*
	 * = GET PARTIES HTML = 
	 * 
	 */
	function get_parties_html($parties){
	    $data = array();
	    $html_parties = array();
	    foreach($parties as $cell){
	        $plus_icon = array();
	        $adults_count = $cell['adults'];
	        $a_c = 1;
	        
	        $adults_arr = array();
	        do{
	            array_push($adults_arr, array('icon'=>'icon'));
	            $a_c++;
	        }while($a_c <= $adults_count);
	        
	        $children_arr = array();
            if (isset($cell['children'])) {
                $children_count = count($cell['children']);
                $c_c = 1;
                
                if ($children_count > 0) {
                     array_push($plus_icon, array('icon'=>'icon'));
                    do {
                        array_push($children_arr, array(
                            'icon' => 'icon'
                        ));
                        $c_c ++;
                    } while ($c_c <= $children_count);
                }
            }
            
            array_push($html_parties, array(
                'adults' => $adults_arr,
                'children' => $children_arr,
                'plus_icon' => $plus_icon
            ));
	    }
	    echo "<pre>";
	    print_r($html_parties);
	    $data['parties'] = $html_parties;
	    
	    return $this->parser->parse ( 'templates/pmv3/parties_block.html', $data, TRUE );
	}
}
?>