<?php 
class Bookroom extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model ( 'Curl_model' );
		$this->load->model ( 'Order' );
	}
	
	function guestinfo(){
		//echo "<pre>";
		$post = $this->input->post ();
		//print_r($post);
		//print_r($_POST);
		//die();

		$List = array();
		$arr_keys = array_keys($post ["room"]);
		foreach ( $arr_keys as $hotel_id ) {
			$hotel_bool = 0;
			foreach ( $post ["room"] [$hotel_id] as $category_id => $cell ) {
				if ($cell ["count"] != 0) {
					if($hotel_bool == 0){
						$List[$hotel_id] = array();
						$hotel_bool = 1;
					}
					for($i = 1; $i <= $cell ["count"]; $i ++) {
						array_push ( $List[$hotel_id], array (
								'hotel_id' => $hotel_id,
								'category_name' => $cell ["name"],
								'category_id' => $cell ["category_id"],
								'rate_id' => $cell ["rate_id"],
								'add_places' => $cell ["add_places"] 
						) );
					}
				}
			}
		}
		
		//print_r($List);
		//die();
		$this->session->unset_userdata('list_rooms');
		$newdata = array (
				'list_rooms' => $List
		);
		$this->session->set_userdata ( $newdata );
				
		$data = array();
		$this->load->library ( 'parser' );
		$this->load->view ( 'bookroom_guestinfo_view.php', $data );
	}
	
	function reservation_status(){
		//echo "<pre>";
		//print_r($_POST);
		//print_r($this->session->userdata('list_rooms'));
		//die();
		$guest_data = $_POST;
		$list_hotel_rooms = $this->session->userdata('list_rooms');
		$session_hosts = $this->session->userdata('session_hosts');
		
		//echo "<pre>";
		//print_r($list_hotel_rooms);
		//print_r($session_hosts);
		//die();
		$html_data_result = array();
		foreach ( $list_hotel_rooms as $hotel_id => $hotel_rooms ) {
			$mass = array ();
			
			$mass ["order"] ["guest"] ["firstname"] = urlencode ( $guest_data ["firstname"] );
			$mass ["order"] ["guest"] ["lastname"] = urlencode ( $guest_data ["lastname"] );
			$mass ["order"] ["guest"] ["email"] = "";
			$mass ["order"] ["guest"] ["address"] = "";
			$mass ["order"] ["guest"] ["city"] = "";
			$mass ["order"] ["guest"] ["index"] = "";
			$mass ["order"] ["guest"] ["country"] = "";
			$mass ["order"] ["guest"] ["phone"] = urlencode ( $guest_data ["phonenumber"] );
			$mass ["order"] ["description"] = "";
			$mass ["order"] ["currencyID"] = 840;
			
			$mass ["order"] ["discountpromocode"] = "";
			$i = 0;
			foreach ( $hotel_rooms as $cell ) {
				$mass ["order"] ["rooms"] [$i] ["firstname"] = urlencode ( $guest_data ["firstname"] );
				$mass ["order"] ["rooms"] [$i] ["lastname"] = urlencode ( $guest_data ["lastname"] );
				
				$mass ["order"] ["rooms"] [$i] ["dateout"] = urlencode ( $this->session->userdata ( 'dateout' ) );
				$mass ["order"] ["rooms"] [$i] ["datein"] = urlencode ( $this->session->userdata ( 'datein' ) );
				$mass ["order"] ["rooms"] [$i] ["add_places"] = urlencode ( $cell ["add_places"] );
				$mass ["order"] ["rooms"] [$i] ["id_category"] = urlencode ( $cell ["category_id"] );
				$mass ["order"] ["rooms"] [$i] ["rate_id"] = urlencode ( $cell ["rate_id"] );
				$mass ["order"] ["rooms"] [$i] ["groupid"] = "";
				$i++;
			}
			
			$mass ["card"] ["number"] = 0;
			$mass ["card"] ["XID"] = 0;
			$mass ["card"] ["Rrn"] = 0;
			$mass ["card"] ["TotalAmount"] = 0;
			
			$mass ["upc"] = 0;
			 //echo "<pre>";
			 //print_r($mass);
			// die();
			$output = json_encode ( $mass );
			$hotel_id = $cell ["hotel_id"];
			
			$sql = "SELECT host FROM  hotels_personal WHERE hotel_id = ".$hotel_id;
			//echo $sql;
			$query = $this->db->query ( $sql );
				
			$host = "";
			$session_hosts = array();
			if ($query->num_rows () > 0) {
				$row = $query->row();
				$host = $row->host;
			}
			
			if ($host <> "") {
				$url = "https://" . $host . "/gateway/SaveReservations_2/0/2";
				$result = $this->Curl_model->CurlPlugMass ( $output, $url );
				
				//echo "$result<pre>";
				$array = json_decode ( $result, true );
				//print_r ( $array );
				$html_data_result [$hotel_id]["hotel_id"] = $hotel_id;
				$html_data_result [$hotel_id]["host"] = $host;
				$html_data_result [$hotel_id]["reservations"] = $array;
				$html_data_result [$hotel_id]["firstname"] = $guest_data ["firstname"];
				$html_data_result [$hotel_id]["lastname"] = $guest_data ["lastname"];
				
				$to = $this->config->item ( 'addaddress_mail' );
				$theme = "New Order in hotel (".$hotel_id.")";
				$theme = iconv ( "utf-8", "windows-1251", $theme );
				$addaddress_mail = $this->config->item ( 'addaddress_mail' );
				$setfrom_mail = "volodimir@cellreload.com";
				$username_mail = $this->config->item ( 'username_mail' );
				$password_mail = $this->config->item ( 'password_mail' );
				$config_email_host = $this->config->item ( 'email_host' );
				$email = $guest_data ["email"];
				
				$subject = htmlspecialchars ( urldecode ( "Уведомление №1 о принятии заявки." ) );
				$subject = iconv ( "utf-8", "windows-1251", $subject );
				
				$message = $this->Order->get_email_html_bookroom ( $array, $hotel_id );
				$message = iconv ( "utf-8", "windows-1251", $message );
				//echo $message;
				require_once ($this->config->item ( 'phpmailer_path' ) . 'class.phpmailer.php');
				
				$mail = new PHPMailer ( true );
				
				$mail->IsSMTP ();
				
				try {
					$mail->SMTPDebug = 2; // enables SMTP debug information (for testing)
					$mail->SMTPAuth = true; // enable SMTP authentication
					$mail->SMTPSecure = "ssl"; // sets the prefix to the servier
					$mail->Host = $config_email_host; // sets GMAIL as the SMTP server
					$mail->Port = 465; // set the SMTP port for the GMAIL server
					$mail->Username = $username_mail; // GMAIL username
					$mail->Password = $password_mail; // GMAIL password
					$mail->AddAddress ( $email, '' );
					$mail->SetFrom ( $setfrom_mail, $theme );
					$mail->Subject = $subject;
					$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; // optional
					
					$path_img = "";
					
					$mail->MsgHTML ( $message, $path_img );
					
					$mail->Send ();
				} catch ( phpmailerException $e ) {
					echo "Error 1 ";
					echo $email;
					echo $e->errorMessage ();
				} catch ( Exception $e ) {
					echo "Error 2 ";
					echo $email;
					echo $e->getMessage (); // Boring error messages from anything else!
				}
			} else {
				echo "NO HOTEL!<br>";
			}
		}
		
		$data = array("html_data_result" => $html_data_result);
		$this->load->library ( 'parser' );
		$this->load->view ( 'bookroom_reservation_status_view.php', $data );
	}
}
?>