<?php
class Payment extends CI_Controller {
    public $personal_data = array ();
	public function __construct()
	{
		parent::__construct();
		$this->load->model ( 'htmltpl' );
		$this->load->model ( 'mlanguages' );
		$this->load->model ( 'Acquiring' );
		$this->load->model ( 'Pay_loger' );
		$this->load->model ( 'Stripe' );
		
		if (! isset ( $this->personal_data ["hotel_id"] )) {
		    $this->get_personal_data ();
		} else {
		    if ($this->personal_data ["hotel_id"] == "") {
		        $this->get_personal_data ();
		    }
		}
	}
	
	function get_personal_data() {
	    
	    $id = $this->pmv2_system->get_hms_id();
	    
	    if ($id != 0) {
	      
	        $sql = "SELECT * FROM booking_otelms.hotels_personal_v2 WHERE hotel_id = " . $id;
	        // echo $sql;
	        $query = $this->db->query ( $sql );
	
	        if ($query->num_rows () > 0) {
	            $row = $query->row_array ();
	            $this->personal_data = $row;
	        }
	
	        	
	    }
	}
	
	function payment_form(){
	    $oid = "";
	    if(isset($_GET ["oid"])){
	        $oid = $_GET ["oid"];
	    }
	     
	    $total_amount = 0;
	    if(isset($_GET ["total"])){
	        $total_amount = $_GET ["total"];
	    }
	    
	    $cc_processor = $this->personal_data ["cc_processor"];
	    switch($cc_processor){
	        case 1:
	            //============ LIQPAY ====================
	             
	            die ( "<meta http-equiv='refresh' content='0;url=/payment/makepay_liqpay?oid=".$oid."&total=".$total_amount."'>" );
	             
	            break;
	        case 2:
	            //============ APPEX ====================
	             
	            die ( "<meta http-equiv='refresh' content='0;url=/payment/makepay_appex?oid=".$oid."&total=".$total_amount."'>" );
	             
	            break;
	        case 3:
	            //============= STRIPE ==============================
	            die ( "<meta http-equiv='refresh' content='0;url=/payment/makepay_stripe?oid=".$oid."&total=".$total_amount."'>" );
	             
	            break;
	        case 0:
	            die ( "<meta http-equiv='refresh' content='0;url=/payment/makepay_liqpay?oid=".$oid."&total=".$total_amount."'>" );
	            break;
	             
	    }
	}
	
	function payment_form_post() {

	    $amount = $_SESSION ["amount"];
	    $cc_processor = $this->personal_data ["cc_processor"];
	    echo $amount."<br>";
	    echo $cc_processor;
	    //die();
	    $ligpay_prepayment = "";
	    $liqpay_daily_prepayment = "";
	    
	    $appex_allowordertype = "";
	    $appex_daily_prepayment = "";
	    //echo $cc_processor;
	    //die();
	    switch($cc_processor){
	        case 1:
	            //============ LIQPAY ====================
	    
	            die ( "<meta http-equiv='refresh' content='0;url=/bookit_c2/step5_stripe'>" );
	    
	            break;
	        case 2:
	            //============ APPEX ====================
	    
	            die ( "<meta http-equiv='refresh' content='0;url=/bookit_c2/step5_stripe'>" );
	    
	            break;
	        case 3:
	            //============= STRIPE ==============================
	            die ( "<meta http-equiv='refresh' content='0;url=/bookit_c2/step5_stripe'>" );
	    
	            break;
	        case 0:
	            die ( "<meta http-equiv='refresh' content='0;url=/bookit_c2/step5_stripe'>" );
	            break;
	    
	    }
	    die();
	    $data = array();
	    $this->load->library('parser');
	    $this->load->view('payment_payment_form_view.php', $data);
	}
	
	function makepay_appex(){
	    $oid = "";
	    if(isset($_GET ["oid"])){
	        $oid = $_GET ["oid"];
	    }
	    
	    $total_amount = 0;
	    if(isset($_GET ["total"])){
	        $total_amount = $_GET ["total"];
	    }
	    
	    $data = array (
	        "oid" => $oid,
	        "total_amount" => $total_amount
	    );
	    $this->load->library ( 'parser' );
	    $this->load->view ( 'payment_makepay_appex_view.php', $data );
	}
	
	function makepay_liqpay(){
	    $oid = "";
	    if(isset($_GET ["oid"])){
	        $oid = $_GET ["oid"];
	    }
	     
	    $total_amount = 0;
	    if(isset($_GET ["total"])){
	        $total_amount = $_GET ["total"];
	    }
	     
	    $data = array (
	        "oid" => $oid,
	        "total_amount" => $total_amount
	    );
	    $this->load->library ( 'parser' );
	    $this->load->view ( 'payment_makepay_liqpay_view.php', $data );
	}
	
	function makepay_stripe(){
	    $oid = "";
	    if(isset($_GET ["oid"])){
	        $oid = $_GET ["oid"];
	    }
	
	    $total_amount = 0;
	    if(isset($_GET ["total"])){
	        $total_amount = $_GET ["total"];
	    }
	
	    $data = array (
	        "oid" => $oid,
	        "total_amount" => $total_amount
	    );
	    $this->load->library ( 'parser' );
	    $this->load->view ( 'payment_makepay_stripe_view.php', $data );
	}
	
	function makepay_stripe_post($stripe_account){
	    //echo "<pre>";
	    //print_r($_POST);
	    //die();
	    // require_once(APPPATH.'libraries/stripe/Stripe.php');
	    require_once (APPPATH . 'libraries/stripe/init.php');
	
	    switch ($stripe_account) {
	        case "us":
	            $stripe = $this->Stripe->get_param_hms_billing();
	            break;
	        case "uk":
	            $stripe = $this->Stripe->get_param_hms_billing_uk();
	            break;
	        default:
	            die("Bill error");
	            break;
	    }
	
	    \Stripe\Stripe::setApiKey($stripe['secret_key']);
	
	    $amount = $_POST['amount'];
	    $currency = $_POST['currency'];
	
	    	
	    $hotel_id = $_POST['hotel_id'];
	    $reservation_id = $_POST['reservation_id'];
	
	    $invoice = $hotel_id . "-" . $reservation_id . "-" . time();
	    $charge = \Stripe\Charge::create(array(
	        'amount' => $amount * 100,
	        'currency' => $currency,
	        'description' => "hms-" . $invoice,
	        'metadata' => array(
	            'order_id' => $invoice
	        ),
	        'source' => $_POST['stripeToken'],
	        'capture' => false,
	        'statement_descriptor' => 'Custom descriptor',
	        'metadata' => array('order_id' => "6735")
	    ));
	
	    //
	    //echo "++";
	    $LastResponse = $charge->getLastResponse();
	    $response = $LastResponse->json;
	    //print_r($response);
	    //die();
	
	
	    if ($response["paid"] == 1) {
	        /*
	         * ========= CAPTURE CHARGE ========
	         *
	         */
	        	
	        $charge_capture = \Stripe\Charge::retrieve($response["id"]);
	        $charge_capture->capture();
	        	
	        $LastResponse_capture = $charge_capture->getLastResponse();
	        $response_capture = $LastResponse_capture->json;
	        //print_r($response_capture);
	        //die();
	        	
	        //==========================================================
	        	
	        // insert payment in hms system
	        if ($reservation_id > 0 && $hotel_id > 0) {
	            $hms_host = "";
	            $sql = "SELECT hms_host FROM hotels_personal_v2 WHERE hotel_id = ".$hotel_id;
	            $query = $this->db->query ( $sql );
	            if ($query->num_rows () > 0) {
	                $row = $query->row ();
	                $hms_host = $row->hms_host;
	            }
	            
                $output = array();
                $output["reservation_id"] = $reservation_id;
                $output["oid"] = $reservation_id;
                $output["order_id"] = $reservation_id;
                $output["amount"] = $response["amount"] / 100;
                $output["hms_id"] = $hotel_id;
                $output["currency"] = $response["currency"];
                
                $url = "https://" . $hms_host . "/gateway/stripe_payment_update/";
                //echo $url."<br>";
                $result = $this->Curl_model->CurlPlugMass(json_encode($output), $url);
                
                //echo "<br><br><br><br>" . $result;
                $result_data = json_decode($result, true);
                print_r($result_data);
            }
	        die("<meta http-equiv='refresh' content='0;url=/stripe_personal/response_page_ok'>");
	    } else {
	        //echo "<pre>";
	        //print_r($_POST);
	
	        //echo "Payment error";
	
	        //print_r($response);
	        $response_str = json_encode($response);
	        $newdata = array (
	            'stripe_pay_response' => $response_str
	        );
	        $this->session->set_userdata ( $newdata );
	        die("<meta http-equiv='refresh' content='0;url=/stripe_personal/response_page_fail'>");
	    }
	}
}
?>